/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.plugin;

import java.util.ArrayList;
import java.util.Map;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.dataanalysis.executor.plugin.ScriptIOWorker;
import org.gcube.dataanalysis.executor.scripts.GetExecuteScript;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class ExecutorScriptPlugin
extends GCUBEHandler<TaskRuntime>
implements ExecutorTask {
    static int locked;

    public void stop() throws UnsupportedOperationException, Exception {
        this.getLogger().trace((Object)"ExecuteScript Plugin: Stopped");
    }

    public void run() throws Exception {
        this.setState((State)State.Running.INSTANCE);
        this.getLogger().trace((Object)"ExecuteScript: Start");
        TaskRuntime runtime = (TaskRuntime)this.getHandled();
        GetExecuteScript scripter = new GetExecuteScript(this.getLogger());
        if (locked > 0) {
            this.getLogger().trace((Object)"ExecuteScript: LOCKED!");
            this.setState((State)State.Done.INSTANCE);
        } else {
            locked = 1;
            Map inputs = runtime.getInputs();
            this.getLogger().trace((Object)("ExecuteScript Inputs: " + inputs));
            try {
                Object[] filesnamesObj = (Object[])inputs.get("FILE_NAMES");
                ArrayList<String> filenames = new ArrayList<String>();
                int filenamesL = filesnamesObj.length;
                for (int i = 0; i < filenamesL; ++i) {
                    filenames.add((String)filesnamesObj[i]);
                }
                Object[] fileurlsObj = (Object[])inputs.get("FILE_URLS");
                ArrayList<String> fileurls = new ArrayList<String>();
                int fileurlsL = fileurlsObj.length;
                for (int i = 0; i < fileurlsL; ++i) {
                    fileurls.add((String)fileurlsObj[i]);
                }
                String outputDir = ScriptIOWorker.getString((String)((String)inputs.get("OUTPUTDIR")));
                String script = ScriptIOWorker.getString((String)((String)inputs.get("SCRIPT")));
                String arguments = ScriptIOWorker.getString((String)((String)inputs.get("ARGUMENTS")));
                String identifier = ScriptIOWorker.getString((String)((String)inputs.get("NODE_IDENTIFIER")));
                String scope = ScriptIOWorker.getString((String)((String)inputs.get("SCOPE")));
                String serviceClass = ScriptIOWorker.getString((String)((String)inputs.get("SERVICE_CLASS")));
                String serviceName = ScriptIOWorker.getString((String)((String)inputs.get("SERVICE_NAME")));
                String owner = ScriptIOWorker.getString((String)((String)inputs.get("OWNER")));
                String remoteDir = ScriptIOWorker.getString((String)((String)inputs.get("REMOTEDIR")));
                String session = ScriptIOWorker.getString((String)((String)inputs.get("SESSION")));
                String delFiles = ScriptIOWorker.getString((String)((String)inputs.get("CLEAN_CACHE")));
                boolean deletefiles = delFiles == null ? true : Boolean.parseBoolean(delFiles);
                scripter.executeScript(filenames, fileurls, outputDir, script, arguments, identifier, scope, serviceClass, serviceName, owner, remoteDir, session, deletefiles);
                this.getLogger().trace((Object)"ExecuteScript: End");
                this.stop();
                this.getLogger().trace((Object)"ExecuteScript: Completely Finished");
                this.setState((State)State.Done.INSTANCE);
                locked = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getLogger().error((Object)("ExecuteScript: Error " + e.getLocalizedMessage()));
                this.getLogger().trace((Object)"ExecuteScript: End");
                this.stop();
                this.getLogger().trace((Object)"ExecuteScript: Completely Finished");
                this.setState((State)State.Failed.INSTANCE);
                locked = 0;
            }
        }
    }
}

