/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.PropertyDocument;
import org.n52.wps.RepositoryDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.IAlgorithmRepository;
import org.n52.wps.server.ProcessIDRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManager {
    private static RepositoryManager instance;
    private static Logger LOGGER;
    private List<IAlgorithmRepository> repositories;
    private ProcessIDRegistry globalProcessIDs = ProcessIDRegistry.getInstance();
    private UpdateThread updateThread;

    private RepositoryManager() {
        this.globalProcessIDs.clearRegistry();
        this.loadAllRepositories();
        WPSConfig.getInstance().addPropertyChangeListener("WPSConfigUpdate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LOGGER.info("Received Property Change Event: {}", (Object)propertyChangeEvent.getPropertyName());
                RepositoryManager.this.loadAllRepositories();
            }
        });
        Double updateHours = WPSConfig.getInstance().getWPSConfig().getServer().getRepoReloadInterval();
        if (updateHours != 0.0) {
            LOGGER.info("Setting repository update period to {} hours.", (Object)updateHours);
            updateHours = updateHours * 3600.0 * 1000.0;
            long updateInterval = updateHours.longValue();
            this.updateThread = new UpdateThread(updateInterval);
            this.updateThread.start();
        }
    }

    private void loadAllRepositories() {
        RepositoryDocument.Repository[] repositoryList;
        this.repositories = new ArrayList<IAlgorithmRepository>();
        LOGGER.debug("Loading all repositories: {} (doing a gc beforehand...)", this.repositories);
        System.gc();
        for (RepositoryDocument.Repository repository : repositoryList = WPSConfig.getInstance().getRegisterdAlgorithmRepositories()) {
            if (!repository.getActive()) continue;
            String repositoryClassName = repository.getClassName();
            try {
                Constructor<?>[] constructors;
                IAlgorithmRepository algorithmRepository = null;
                Class<?> repositoryClass = RepositoryManager.class.getClassLoader().loadClass(repositoryClassName);
                for (Constructor<?> constructor : constructors = repositoryClass.getConstructors()) {
                    if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].equals(String.class)) {
                        PropertyDocument.Property[] properties = repository.getPropertyArray();
                        PropertyDocument.Property formatProperty = WPSConfig.getInstance().getPropertyForKey(properties, "supportedFormat");
                        String format = formatProperty.getStringValue();
                        algorithmRepository = (IAlgorithmRepository)repositoryClass.getConstructor(String.class).newInstance(format);
                        continue;
                    }
                    algorithmRepository = (IAlgorithmRepository)repositoryClass.newInstance();
                }
                this.repositories.add(algorithmRepository);
                LOGGER.info("Algorithm Repository {} initialized", (Object)repositoryClassName);
            }
            catch (InstantiationException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName, (Object)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName, (Object)e.getMessage());
            }
            catch (SecurityException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName, (Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName, (Object)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("An error occured while registering AlgorithmRepository: {}", (Object)repositoryClassName, (Object)e.getMessage());
            }
        }
    }

    public static RepositoryManager getInstance() {
        if (instance == null) {
            instance = new RepositoryManager();
        }
        return instance;
    }

    public static void reInitialize() {
        instance = new RepositoryManager();
    }

    protected void reloadRepositories() {
        this.loadAllRepositories();
    }

    public IAlgorithm getAlgorithm(String className) {
        for (IAlgorithmRepository repository : this.repositories) {
            if (!repository.containsAlgorithm(className)) continue;
            return repository.getAlgorithm(className);
        }
        return null;
    }

    public List<String> getAlgorithms() {
        ArrayList<String> allAlgorithmNamesCollection = new ArrayList<String>();
        for (IAlgorithmRepository repository : this.repositories) {
            allAlgorithmNamesCollection.addAll(repository.getAlgorithmNames());
        }
        return allAlgorithmNamesCollection;
    }

    public boolean containsAlgorithm(String algorithmName) {
        for (IAlgorithmRepository repository : this.repositories) {
            if (!repository.containsAlgorithm(algorithmName)) continue;
            return true;
        }
        return false;
    }

    public IAlgorithmRepository getRepositoryForAlgorithm(String algorithmName) {
        for (IAlgorithmRepository repository : this.repositories) {
            if (!repository.containsAlgorithm(algorithmName)) continue;
            return repository;
        }
        return null;
    }

    public Class getInputDataTypeForAlgorithm(String algorithmIdentifier, String inputIdentifier) {
        IAlgorithm algorithm = this.getAlgorithm(algorithmIdentifier);
        return algorithm.getInputDataType(inputIdentifier);
    }

    public Class getOutputDataTypeForAlgorithm(String algorithmIdentifier, String inputIdentifier) {
        IAlgorithm algorithm = this.getAlgorithm(algorithmIdentifier);
        return algorithm.getOutputDataType(inputIdentifier);
    }

    public boolean registerAlgorithm(String id, IAlgorithmRepository repository) {
        return this.globalProcessIDs.addID(id);
    }

    public boolean unregisterAlgorithm(String id) {
        return this.globalProcessIDs.removeID(id);
    }

    public IAlgorithmRepository getAlgorithmRepository(String name) {
        for (IAlgorithmRepository repo : this.repositories) {
            if (!repo.getClass().getName().equals(name)) continue;
            return repo;
        }
        return null;
    }

    public IAlgorithmRepository getRepositoryForClassName(String className) {
        for (IAlgorithmRepository repository : this.repositories) {
            if (!repository.getClass().getName().equals(className)) continue;
            return repository;
        }
        return null;
    }

    public ProcessDescriptionType getProcessDescription(String processClassName) {
        for (IAlgorithmRepository repository : this.repositories) {
            if (!repository.containsAlgorithm(processClassName)) continue;
            return repository.getProcessDescription(processClassName);
        }
        return null;
    }

    public void finalize() {
        if (this.updateThread != null) {
            this.updateThread.interrupt();
        }
    }

    public void shutdown() {
        LOGGER.debug("Shutting down all repositories..");
        for (IAlgorithmRepository repo : this.repositories) {
            repo.shutdown();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(RepositoryManager.class);
    }

    static class UpdateThread
    extends Thread {
        private final long interval;
        private boolean firstrun = true;

        public UpdateThread(long interval) {
            this.interval = interval;
        }

        @Override
        public void run() {
            LOGGER.debug("UpdateThread started");
            try {
                while (true) {
                    if (!this.firstrun) {
                        LOGGER.info("Reloading repositories - this might take a while ...");
                        long timestamp = System.currentTimeMillis();
                        RepositoryManager.getInstance().reloadRepositories();
                        LOGGER.info("Repositories reloaded - going to sleep. Took {} seconds.", (Object)((System.currentTimeMillis() - timestamp) / 1000L));
                    } else {
                        this.firstrun = false;
                    }
                    UpdateThread.sleep(this.interval);
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug("Interrupt received - Terminating the UpdateThread.");
                return;
            }
        }
    }
}

