/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request.strategy;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import net.opengis.wps.x100.InputType;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.request.strategy.IReferenceStrategy;
import org.n52.wps.server.request.strategy.ReferenceInputStream;

public class WCS111XMLEmbeddedBase64OutputReferenceStrategy
implements IReferenceStrategy {
    private String fetchedMimeType;
    private String fetchedEncoding;

    @Override
    public boolean isApplicable(InputType input) {
        if (input.getReference().isSetBody()) {
            XmlObject xo = input.getReference().getBody();
            return xo.toString().contains("http://www.opengis.net/wcs/1.1.1");
        }
        String dataURLString = input.getReference().getHref();
        return dataURLString.contains("=GetCoverage") && dataURLString.contains("=1.1.1");
    }

    @Override
    public ReferenceInputStream fetchData(InputType input) throws ExceptionReport {
        String dataURLString = input.getReference().getHref();
        String schema = input.getReference().getSchema();
        String encoding = input.getReference().getEncoding();
        String mimeType = input.getReference().getMimeType();
        try {
            URL dataURL = new URL(dataURLString);
            URLConnection conn = dataURL.openConnection();
            conn.setRequestProperty("Accept-Encoding", "gzip");
            conn.setRequestProperty("Content-type", "multipart/mixed");
            if (input.getReference().isSetBodyReference()) {
                String bodyReference = input.getReference().getBodyReference().getHref();
                URL bodyReferenceURL = new URL(bodyReference);
                URLConnection bodyReferenceConn = bodyReferenceURL.openConnection();
                bodyReferenceConn.setRequestProperty("Accept-Encoding", "gzip");
                InputStream referenceInputStream = this.retrievingZippedContent(bodyReferenceConn);
                IOUtils.copy((InputStream)referenceInputStream, (OutputStream)conn.getOutputStream());
            } else if (input.getReference().isSetBody()) {
                conn.setDoOutput(true);
                input.getReference().getBody().save(conn.getOutputStream());
            }
            InputStream inputStream = this.retrievingZippedContent(conn);
            BufferedReader bRead = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            String boundary = "";
            boolean boundaryFound = false;
            boolean encodedImagepart = false;
            String encodedImage = "";
            String contentTransferEncoding = "";
            String imageContentType = "";
            int boundaryCount = 0;
            while ((line = bRead.readLine()) != null) {
                if (line.contains("boundary")) {
                    boundary = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                    boundaryFound = true;
                    continue;
                }
                if (boundaryFound && line.contains(boundary)) {
                    ++boundaryCount;
                    continue;
                }
                if (encodedImagepart) {
                    encodedImage = encodedImage.concat(line);
                    continue;
                }
                if (boundaryCount != 2) continue;
                if (line.contains("Content-Type")) {
                    imageContentType = line.substring(line.indexOf(":") + 1).trim();
                    continue;
                }
                if (line.contains("Content-Transfer-Encoding")) {
                    contentTransferEncoding = line.substring(line.indexOf(":") + 1).trim();
                    continue;
                }
                if (!line.contains("Content-ID")) continue;
                line = bRead.readLine();
                encodedImagepart = true;
            }
            return new ReferenceInputStream((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(encodedImage.getBytes())), imageContentType, null);
        }
        catch (RuntimeException e) {
            throw new ExceptionReport("Error occured while parsing XML", "NoApplicableCode", (Throwable)e);
        }
        catch (MalformedURLException e) {
            String inputID = input.getIdentifier().getStringValue();
            throw new ExceptionReport("The inputURL of the execute is wrong: inputID: " + inputID + " | dataURL: " + dataURLString, "InvalidParameterValue");
        }
        catch (IOException e) {
            String inputID = input.getIdentifier().getStringValue();
            throw new ExceptionReport("Error occured while receiving the complexReferenceURL: inputID: " + inputID + " | dataURL: " + dataURLString, "InvalidParameterValue");
        }
    }

    private InputStream retrievingZippedContent(URLConnection conn) throws IOException {
        String contentType = conn.getContentEncoding();
        if (contentType != null && contentType.equals("gzip")) {
            return new GZIPInputStream(conn.getInputStream());
        }
        return conn.getInputStream();
    }
}

