/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request.strategy;

import java.util.ArrayList;
import java.util.List;
import net.opengis.wps.x100.InputType;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.request.strategy.DefaultReferenceStrategy;
import org.n52.wps.server.request.strategy.IReferenceStrategy;
import org.n52.wps.server.request.strategy.ReferenceInputStream;
import org.n52.wps.server.request.strategy.WCS111XMLEmbeddedBase64OutputReferenceStrategy;

public class ReferenceStrategyRegister {
    protected List<IReferenceStrategy> registeredStrategies = new ArrayList<IReferenceStrategy>();
    private static ReferenceStrategyRegister instance;

    public static synchronized ReferenceStrategyRegister getInstance() {
        if (instance == null) {
            instance = new ReferenceStrategyRegister();
        }
        return instance;
    }

    private ReferenceStrategyRegister() {
        this.registeredStrategies.add(new WCS111XMLEmbeddedBase64OutputReferenceStrategy());
    }

    protected void registerStrategy(IReferenceStrategy strategy) {
        this.registeredStrategies.add(strategy);
    }

    public ReferenceInputStream resolveReference(InputType input) throws ExceptionReport {
        IReferenceStrategy foundStrategy = new DefaultReferenceStrategy();
        for (IReferenceStrategy strategy : this.registeredStrategies) {
            if (!strategy.isApplicable(input)) continue;
            foundStrategy = strategy;
            break;
        }
        return foundStrategy.fetchData(input);
    }
}

