/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.WebProcessingService;
import org.n52.wps.server.handler.RequestExecutor;
import org.n52.wps.server.request.CapabilitiesRequest;
import org.n52.wps.server.request.DescribeProcessRequest;
import org.n52.wps.server.request.ExecuteRequest;
import org.n52.wps.server.request.Request;
import org.n52.wps.server.request.RetrieveResultRequest;
import org.n52.wps.server.response.ExecuteResponse;
import org.n52.wps.server.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RequestHandler {
    public static final String VERSION_ATTRIBUTE_NAME = "version";
    protected static RequestExecutor pool = new RequestExecutor();
    protected OutputStream os;
    private static Logger LOGGER = LoggerFactory.getLogger(RequestHandler.class);
    protected String responseMimeType;
    protected Request req;

    protected RequestHandler() {
    }

    public RequestHandler(Map<String, String[]> params, OutputStream os) throws ExceptionReport {
        Request req;
        String requestType;
        this.os = os;
        CaseInsensitiveMap ciMap = new CaseInsensitiveMap(params);
        String serviceType = Request.getMapValue("service", ciMap, true);
        if (!serviceType.equalsIgnoreCase("WPS")) {
            throw new ExceptionReport("Parameter <service> is not correct, expected: WPS, got: " + serviceType, "InvalidParameterValue", "service");
        }
        String language = Request.getMapValue("language", ciMap, false);
        if (language != null) {
            Request.checkLanguageSupported(language);
        }
        if ((requestType = Request.getMapValue("request", ciMap, true)).equalsIgnoreCase("GetCapabilities")) {
            req = new CapabilitiesRequest(ciMap);
        } else if (requestType.equalsIgnoreCase("DescribeProcess")) {
            req = new DescribeProcessRequest(ciMap);
        } else if (requestType.equalsIgnoreCase("Execute")) {
            req = new ExecuteRequest(ciMap);
            this.setResponseMimeType((ExecuteRequest)req);
        } else if (requestType.equalsIgnoreCase("RetrieveResult")) {
            req = new RetrieveResultRequest(ciMap);
        } else {
            throw new ExceptionReport("The requested Operation is not supported or not applicable to the specification: " + requestType, "OperationNotSupported", requestType);
        }
        this.req = req;
    }

    public RequestHandler(InputStream is, OutputStream os) throws ExceptionReport {
        String nodeURI;
        String localName;
        String nodeName;
        Document doc;
        String version = null;
        this.os = os;
        boolean isCapabilitiesNode = false;
        try {
            Node languageNode;
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            doc = fac.newDocumentBuilder().parse(is);
            Node child = doc.getFirstChild();
            while (child.getNodeName().compareTo("#comment") == 0) {
                child = child.getNextSibling();
            }
            nodeName = child.getNodeName();
            localName = child.getLocalName();
            nodeURI = child.getNamespaceURI();
            Node versionNode = child.getAttributes().getNamedItem(VERSION_ATTRIBUTE_NAME);
            Node serviceNode = child.getAttributes().getNamedItem("service");
            if (serviceNode == null) {
                throw new ExceptionReport("Parameter <service> not specified.", "MissingParameterValue", "service");
            }
            if (!serviceNode.getNodeValue().equalsIgnoreCase("WPS")) {
                throw new ExceptionReport("Parameter <service> not specified.", "InvalidParameterValue", "service");
            }
            isCapabilitiesNode = nodeName.toLowerCase().contains("capabilities");
            if (versionNode == null && !isCapabilitiesNode) {
                throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", VERSION_ATTRIBUTE_NAME);
            }
            if (!isCapabilitiesNode) {
                version = child.getAttributes().getNamedItem(VERSION_ATTRIBUTE_NAME).getNodeValue();
            }
            if ((languageNode = child.getAttributes().getNamedItem("language")) != null) {
                String language = languageNode.getNodeValue();
                Request.checkLanguageSupported(language);
            }
        }
        catch (SAXException e) {
            throw new ExceptionReport("There went something wrong with parsing the POST data: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
        }
        catch (IOException e) {
            throw new ExceptionReport("There went something wrong with the network connection.", "NoApplicableCode", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionReport("There is a internal parser configuration error", "NoApplicableCode", (Throwable)e);
        }
        if (!isCapabilitiesNode && version == null) {
            throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", VERSION_ATTRIBUTE_NAME);
        }
        if (!isCapabilitiesNode && !version.equals("1.0.0")) {
            throw new ExceptionReport("Version not supported.", "InvalidParameterValue", VERSION_ATTRIBUTE_NAME);
        }
        if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("Execute")) {
            this.req = new ExecuteRequest(doc);
            this.setResponseMimeType((ExecuteRequest)this.req);
        } else if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("GetCapabilities")) {
            this.req = new CapabilitiesRequest(doc);
            this.responseMimeType = "text/xml";
        } else if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("DescribeProcess")) {
            this.req = new DescribeProcessRequest(doc);
            this.responseMimeType = "text/xml";
        } else {
            if (!localName.equals("Execute")) {
                throw new ExceptionReport("The requested Operation not supported or not applicable to the specification: " + nodeName, "OperationNotSupported", localName);
            }
            if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE)) {
                throw new ExceptionReport("specified namespace is not supported: " + nodeURI, "InvalidParameterValue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws ExceptionReport {
        Response resp = null;
        if (this.req == null) {
            throw new ExceptionReport("Internal Error", "");
        }
        if (this.req instanceof ExecuteRequest) {
            ExecuteRequest execReq = (ExecuteRequest)this.req;
            execReq.updateStatusAccepted();
            ExceptionReport exceptionReport = null;
            try {
                if (execReq.isStoreResponse()) {
                    resp = new ExecuteResponse(execReq);
                    InputStream is = resp.getAsStream();
                    IOUtils.copy((InputStream)is, (OutputStream)this.os);
                    is.close();
                    pool.submit(execReq);
                    return;
                }
                try {
                    try {
                        resp = pool.submit(execReq).get();
                    }
                    catch (ExecutionException ee) {
                        LOGGER.warn("exception while handling ExecuteRequest.");
                        if (ee.getCause() instanceof ExceptionReport) {
                            exceptionReport = (ExceptionReport)ee.getCause();
                        }
                        exceptionReport = new ExceptionReport("An error occurred in the computation: " + ee.getMessage(), "NoApplicableCode");
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn("interrupted while handling ExecuteRequest.");
                        exceptionReport = new ExceptionReport("The computation in the process was interrupted.", "NoApplicableCode");
                    }
                }
                finally {
                    if (exceptionReport != null) {
                        LOGGER.debug("ExceptionReport not null: " + exceptionReport.getMessage());
                        throw exceptionReport;
                    }
                    if (resp == null) {
                        LOGGER.warn("null response handling ExecuteRequest.");
                        throw new ExceptionReport("Problem with handling threads in RequestHandler", "NoApplicableCode");
                    }
                    if (!execReq.isStoreResponse()) {
                        InputStream is = resp.getAsStream();
                        IOUtils.copy((InputStream)is, (OutputStream)this.os);
                        is.close();
                        LOGGER.info("Served ExecuteRequest.");
                    }
                }
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("exception handling ExecuteRequest.", (Throwable)ree);
                throw new ExceptionReport("The requested process was rejected. Maybe the server is flooded with requests.", "ServerBusy");
            }
            catch (Exception e) {
                LOGGER.error("exception handling ExecuteRequest.", (Throwable)e);
                if (e instanceof ExceptionReport) {
                    throw (ExceptionReport)((Object)e);
                }
                throw new ExceptionReport("Could not read from response stream.", "NoApplicableCode");
            }
        } else {
            resp = this.req.call();
            try {
                InputStream is = resp.getAsStream();
                IOUtils.copy((InputStream)is, (OutputStream)this.os);
                is.close();
            }
            catch (IOException e) {
                throw new ExceptionReport("Could not read from response stream.", "NoApplicableCode");
            }
        }
    }

    protected void setResponseMimeType(ExecuteRequest req) {
        this.responseMimeType = req.isRawData() ? req.getExecuteResponseBuilder().getMimeType() : "text/xml";
    }

    public String getResponseMimeType() {
        if (this.responseMimeType == null) {
            return "text/xml";
        }
        return this.responseMimeType.toLowerCase();
    }
}

