/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.n52.wps.server.RequestSizeInfoStream;
import org.n52.wps.server.RequestSizeInfoWrapper;
import org.n52.wps.server.ResponseSizeInfoStream;
import org.n52.wps.server.ResponseSizeInfoWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommunicationSizeLogFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(CommunicationSizeLogFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestSizeInfoWrapper myWrappedReq = new RequestSizeInfoWrapper(request);
        ResponseSizeInfoWrapper myWrappedResp = new ResponseSizeInfoWrapper(response);
        chain.doFilter((ServletRequest)myWrappedReq, (ServletResponse)myWrappedResp);
        myWrappedReq.getInputStream().close();
        myWrappedResp.getOutputStream().close();
        long requestSize = ((RequestSizeInfoStream)myWrappedReq.getInputStream()).getSize();
        long responseSize = ((ResponseSizeInfoStream)myWrappedResp.getOutputStream()).getSize();
        if (requestSize == 0L) {
            return;
        }
        BigDecimal result = new BigDecimal((double)responseSize / (double)requestSize).setScale(4, 4);
        result = result.movePointRight(2);
        LOGGER.info("Simplification ratio " + result);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }
}

