/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.IAlgorithmRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderAlgorithmRepository
implements IAlgorithmRepository {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoaderAlgorithmRepository.class);
    private Map<String, Class<? extends IAlgorithm>> currentAlgorithms = this.loadAlgorithms();

    private Map<String, Class<? extends IAlgorithm>> loadAlgorithms() {
        HashMap<String, Class<? extends IAlgorithm>> result = new HashMap<String, Class<? extends IAlgorithm>>();
        ServiceLoader<IAlgorithm> loader = ServiceLoader.load(IAlgorithm.class);
        for (IAlgorithm ia : loader) {
            logger.debug("Adding algorithm with identifier {} and class {}", (Object)ia.getWellKnownName(), (Object)ia.getClass().getCanonicalName());
            result.put(ia.getWellKnownName(), ia.getClass());
        }
        return result;
    }

    @Override
    public Collection<String> getAlgorithmNames() {
        return this.currentAlgorithms.keySet();
    }

    @Override
    public IAlgorithm getAlgorithm(String processID) {
        Class<? extends IAlgorithm> clazz = this.currentAlgorithms.get(processID);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public ProcessDescriptionType getProcessDescription(String processID) {
        IAlgorithm algo = this.getAlgorithm(processID);
        if (algo != null) {
            return algo.getDescription();
        }
        return null;
    }

    @Override
    public boolean containsAlgorithm(String processID) {
        return this.currentAlgorithms.containsKey(processID);
    }

    @Override
    public void shutdown() {
    }
}

