/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.common.ProviderSet;

public class Builders {
    public static void buildUnique(CloseableIterator<String> values, ProviderSet set) throws IOException {
        String outputFileName = set.getResourceName();
        String zipEntryName = outputFileName.replace(".zip", "");
        Builders.buildUnique(values, outputFileName, zipEntryName);
    }

    public static void buildUnique(CloseableIterator<String> values, String outputFileName, String zipEntryName) throws IOException {
        List<String> sortedUniqueValues = Builders.uniqueSorted(values);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream("src/main/resources/" + outputFileName));
        zos.putNextEntry(new ZipEntry(zipEntryName));
        OutputStreamWriter writer = new OutputStreamWriter(zos);
        for (String value : sortedUniqueValues) {
            ((Writer)writer).append(value);
            writer.append('\n');
        }
        ((Writer)writer).close();
    }

    public static void buildUniqueSized(CloseableIterator<String> values, ProviderSet set, SizeType sizeType, int size) throws IOException {
        String outputFileName = set.getResourceName();
        String zipEntryName = outputFileName.replace(".zip", "");
        Builders.buildUniqueSized(values, outputFileName, zipEntryName, sizeType, size);
    }

    public static void buildUniqueSized(CloseableIterator<String> values, String outputFileName, String zipEntryName, SizeType sizeType, int size) throws IOException {
        List<String> sortedUniqueValues = Builders.uniqueSorted(values);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream("src/main/resources/" + outputFileName));
        zos.putNextEntry(new ZipEntry(zipEntryName));
        OutputStreamWriter writer = new OutputStreamWriter(zos);
        int total = sortedUniqueValues.size();
        System.out.println(String.valueOf(total) + " sorted values");
        int i = 0;
        int generated = 0;
        int delta = sizeType == SizeType.DELTA ? size : (sizeType == SizeType.SIZE ? total / size : 1);
        for (String value : sortedUniqueValues) {
            if (i % delta == 0) {
                ((Writer)writer).append(value);
                writer.append('\n');
                ++generated;
            }
            ++i;
        }
        System.out.println(String.valueOf(generated) + " generated values");
        ((Writer)writer).close();
    }

    protected static List<String> uniqueSorted(CloseableIterator<String> values) {
        HashSet<String> uniqueValues = new HashSet<String>();
        while (values.hasNext()) {
            String value = (String)values.next();
            if (value.isEmpty()) continue;
            uniqueValues.add(value);
        }
        ArrayList<String> sortedUniqueValues = new ArrayList<String>(uniqueValues);
        Collections.sort(sortedUniqueValues);
        return sortedUniqueValues;
    }

    public static enum SizeType {
        DELTA,
        SIZE;

    }
}

