/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.searchable;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.ResultElement;
import org.gcube.data.spd.plugin.fwk.Searchable;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.test.AbstractTest;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.TestType;
import org.gcube.data.spd.testsuite.test.common.ObjectWriterCounter;
import org.gcube.data.spd.testsuite.test.scan.searchable.SearchableMethodCall;

public abstract class SearchableScanTest<T extends ResultElement>
extends AbstractTest {
    protected Logger logger = Logger.getLogger(SearchableScanTest.class);
    protected SearchableMethodCall callMethod;

    public SearchableScanTest(String name, String description, SearchableMethodCall callMethod) {
        super(name, description, TestType.SCAN);
        this.callMethod = callMethod;
    }

    public Result scanSearchableMethod(Searchable<T> searchable, CloseableIterator<String> valuesProvider) {
        int valuesCounter = 0;
        int success = 0;
        this.logger.trace((Object)"starting");
        while (valuesProvider.hasNext()) {
            String sn = (String)valuesProvider.next();
            ++valuesCounter;
            Result result = this.test(searchable, sn);
            if (result != Result.SUCCESS) continue;
            ++success;
        }
        try {
            valuesProvider.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"Failed closing the values stream", (Throwable)e);
        }
        int failed = valuesCounter - success;
        this.logger.info((Object)("Tested " + valuesCounter + " values, " + success + " successfully and " + failed + " failed"));
        return failed == 0 ? Result.SUCCESS : Result.FAILED;
    }

    protected Result test(Searchable<T> searchable, String value) {
        this.logger.trace((Object)("testing value \"" + value + "\""));
        ObjectWriterCounter counter = new ObjectWriterCounter();
        try {
            this.callMethod.call(searchable, value, counter, new Property[0]);
        }
        catch (Throwable throwable) {
            this.logger.info((Object)("Failed call to " + this.callMethod.getMethodName() + " method with value \"" + value + "\""), throwable);
            return Result.FAILED;
        }
        this.logger.debug((Object)("Tested value \"" + value + "\" found " + counter.getElements() + " elements and " + counter.getExceptions() + " exceptions"));
        return Result.SUCCESS;
    }
}

