/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.Test;
import org.gcube.data.spd.testsuite.test.TestType;

public class TestSuite {
    protected Logger logger = Logger.getLogger(TestSuite.class);
    protected AbstractPlugin plugin;
    protected ServiceEndpoint runtimeResource;
    protected List<Test> tests;

    public TestSuite(AbstractPlugin plugin, ServiceEndpoint runtimeResource, List<Test> tests) {
        this.plugin = plugin;
        this.runtimeResource = runtimeResource;
        this.tests = tests;
    }

    public void run() throws Exception {
        this.logger.info((Object)"STARTING TEST SUITE");
        this.initPlugin();
        long start = System.currentTimeMillis();
        Result result = this.runTests();
        long time = System.currentTimeMillis() - start;
        this.logger.info((Object)("total time: " + time + "ms"));
        if (result == Result.SUCCESS) {
            this.logger.info((Object)"TEST SUITE COMPLETED SUCCESSFULL");
        } else {
            this.logger.info((Object)"TEST SUITE COMPLETED WITH ERRORS");
        }
    }

    protected void initPlugin() throws Exception {
        this.logger.info((Object)("Initizializing plugin " + this.plugin.getRepositoryName() + "..."));
        try {
            this.plugin.initialize(this.runtimeResource);
        }
        catch (Exception e) {
            this.logger.error((Object)"Plugin initialization failed, aborting", (Throwable)e);
            throw new Exception("Plugin initialization failed, aborting", e);
        }
        this.logger.info((Object)"initialization complete.");
    }

    protected Result runTests() {
        Map<TestType, List<Test>> groups = this.groupTests();
        this.logger.info((Object)("Executing " + groups.size() + " test groups"));
        int success = 0;
        for (Map.Entry<TestType, List<Test>> group : groups.entrySet()) {
            Result result = this.runtTestGroup(group.getKey(), group.getValue());
            if (result != Result.SUCCESS) continue;
            ++success;
        }
        int failed = groups.size() - success;
        this.logger.info((Object)("Test group execution terminated with " + success + " group successfull executed and " + failed + " failed"));
        return failed != 0 ? Result.FAILED : Result.SUCCESS;
    }

    protected Map<TestType, List<Test>> groupTests() {
        EnumMap<TestType, List<Test>> groups = new EnumMap<TestType, List<Test>>(TestType.class);
        for (Test test : this.tests) {
            TestType type = test.getType();
            ArrayList<Test> group = (ArrayList<Test>)groups.get((Object)type);
            if (group == null) {
                group = new ArrayList<Test>();
                groups.put(type, group);
            }
            group.add(test);
        }
        return groups;
    }

    protected Result runtTestGroup(TestType type, List<Test> tests) {
        this.logger.info((Object)("Executing test group " + (Object)((Object)type) + " with " + tests.size() + " tests"));
        this.logger.info((Object)"");
        int success = 0;
        for (Test test : tests) {
            Result result = this.runTest(test);
            if (result != Result.SUCCESS) continue;
            ++success;
        }
        int failed = tests.size() - success;
        this.logger.info((Object)("Tests in group " + (Object)((Object)type) + " executed with " + success + " success and " + failed + " failed"));
        return failed == 0 ? Result.SUCCESS : Result.FAILED;
    }

    protected Result runTest(Test test) {
        this.logger.info((Object)"***************************************************");
        this.logger.info((Object)("Running test [" + test.getName() + "]"));
        this.logger.trace((Object)test.getDescription());
        long start = System.currentTimeMillis();
        Result result = test.run(this.plugin);
        long time = System.currentTimeMillis() - start;
        this.logger.info((Object)("Test " + test.getName() + " complete with result " + (Object)((Object)result) + " in " + time + " ms"));
        this.logger.info((Object)"***************************************************");
        this.logger.info((Object)"");
        return result;
    }
}

