/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.occurrences;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.CloseableIterators;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.provider.common.Transformators;
import org.gcube.data.spd.testsuite.test.AbstractTest;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.TestType;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesMethodCall;

public abstract class OccurrencesScanTest
extends AbstractTest {
    protected Logger logger = Logger.getLogger(OccurrencesScanTest.class);
    protected OccurrencesMethodCall callMethod;

    public OccurrencesScanTest(String name, String description, OccurrencesMethodCall callMethod) {
        super(name, description, TestType.SCAN);
        this.callMethod = callMethod;
    }

    protected CloseableIterator<String> getValueProviderFromProductKey(CloseableIterator<String> input, Transformator<String, CloseableIterator<ResultItem>> generator) {
        return this.getValueProvider(input, generator, Transformators.extractProductKey(Capabilities.Occurences));
    }

    protected CloseableIterator<String> getValueProviderFromOccurrences(CloseableIterator<String> input, Transformator<String, CloseableIterator<OccurrencePoint>> generator) {
        return this.getValueProvider(input, generator, Transformators.OP_ID_EXTRACTOR);
    }

    protected <I> CloseableIterator<String> getValueProvider(CloseableIterator<String> input, Transformator<String, CloseableIterator<I>> generator, Transformator<I, String> extractor) {
        CloseableIterator providers = CloseableIterators.transform(input, generator);
        CloseableIterator source = CloseableIterators.merge(providers);
        CloseableIterator<String> valuesProvider = CloseableIterators.transform(source, extractor);
        return valuesProvider;
    }

    protected Result scanOccurrencesMethod(OccurrencesCapability occurrences, CloseableIterator<String> valuesProvider) {
        this.logger.trace((Object)"starting");
        try {
            this.callMethod.call(occurrences, valuesProvider);
            try {
                valuesProvider.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Failed closing the values stream", (Throwable)e);
            }
            return Result.SUCCESS;
        }
        catch (Throwable throwable) {
            this.logger.info((Object)("Failed call to " + this.callMethod.getMethodName() + " method"), throwable);
            return Result.FAILED;
        }
    }
}

