/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.occurrences;

import java.io.IOException;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.provider.common.Transformators;
import org.gcube.data.spd.testsuite.provider.sn.ScientificNameProvider;
import org.gcube.data.spd.testsuite.test.NeedsScientificNameProvider;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesMethodCall;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesScanTest;

public class OccurrencesSNScanTest
extends OccurrencesScanTest
implements NeedsScientificNameProvider {
    protected ScientificNameProvider scientificNameProvider;

    public OccurrencesSNScanTest(String name, String description, OccurrencesMethodCall method) {
        super(name, description, method);
    }

    @Override
    public void setScientificNameProvider(ScientificNameProvider scientificNameProvider) {
        this.scientificNameProvider = scientificNameProvider;
    }

    @Override
    public Result run(AbstractPlugin plugin) {
        OccurrencesCapability occurrences = plugin.getOccurrencesInterface();
        CloseableIterator<String> input = this.getScientificNames();
        CloseableIterator<String> provider = this.getValueProvider(plugin, input);
        return this.scanOccurrencesMethod(occurrences, provider);
    }

    protected CloseableIterator<String> getValueProvider(AbstractPlugin plugin, CloseableIterator<String> input) {
        switch (this.callMethod) {
            case OCCURRENCE_BY_PRODUCT_KEYS: {
                Transformator<String, CloseableIterator<ResultItem>> generator = Transformators.fromSearchableWithScientificName(plugin);
                return this.getValueProviderFromProductKey(input, generator);
            }
            case OCCURRENCE_BY_IDS: {
                Transformator<String, CloseableIterator<OccurrencePoint>> generator = Transformators.fromSearchableWithScientificName(plugin.getOccurrencesInterface());
                return this.getValueProviderFromOccurrences(input, generator);
            }
        }
        return input;
    }

    protected CloseableIterator<String> getScientificNames() {
        try {
            return this.scientificNameProvider.getScientificNames();
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Error occurred getting the scientific names", (Throwable)e);
            throw new RuntimeException("Error occurred getting the scientific names", e);
        }
    }
}

