/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.occurrences;

import java.io.IOException;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.provider.cn.CommonNameProvider;
import org.gcube.data.spd.testsuite.provider.common.Transformators;
import org.gcube.data.spd.testsuite.test.NeedsCommonNameProvider;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesMethodCall;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesScanTest;

public class OccurrencesCNScanTest
extends OccurrencesScanTest
implements NeedsCommonNameProvider {
    protected CommonNameProvider commonNameProvider;

    public OccurrencesCNScanTest(String name, String description, OccurrencesMethodCall method) {
        super(name, description, method);
    }

    @Override
    public void setCommonNameProvider(CommonNameProvider scientificNameProvider) {
        this.commonNameProvider = scientificNameProvider;
    }

    @Override
    public Result run(AbstractPlugin plugin) {
        OccurrencesCapability occurrences = plugin.getOccurrencesInterface();
        CloseableIterator<String> input = this.getScientificNames();
        CloseableIterator<String> provider = this.getValueProvider(plugin, input);
        return this.scanOccurrencesMethod(occurrences, provider);
    }

    protected CloseableIterator<String> getValueProvider(AbstractPlugin plugin, CloseableIterator<String> input) {
        switch (this.callMethod) {
            case OCCURRENCE_BY_PRODUCT_KEYS: {
                Transformator<String, CloseableIterator<ResultItem>> generator = Transformators.fromSearchableWithCommonName(plugin);
                return this.getValueProviderFromProductKey(input, generator);
            }
            case OCCURRENCE_BY_IDS: {
                Transformator<String, CloseableIterator<OccurrencePoint>> generator = Transformators.fromSearchableWithCommonName(plugin.getOccurrencesInterface());
                return this.getValueProviderFromOccurrences(input, generator);
            }
        }
        return input;
    }

    protected CloseableIterator<String> getScientificNames() {
        try {
            return this.commonNameProvider.getCommonNames();
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Error occurred getting the common names", (Throwable)e);
            throw new RuntimeException("Error occurred getting the common names", e);
        }
    }
}

