/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.classification;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.testsuite.provider.CloseableIterator;
import org.gcube.data.spd.testsuite.provider.CloseableIterators;
import org.gcube.data.spd.testsuite.provider.Transformator;
import org.gcube.data.spd.testsuite.provider.common.Transformators;
import org.gcube.data.spd.testsuite.test.AbstractTest;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.TestType;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationMethodCall;

public abstract class ClassificationScanTest
extends AbstractTest {
    protected Logger logger = Logger.getLogger(ClassificationScanTest.class);
    protected ClassificationMethodCall callMethod;

    public ClassificationScanTest(String name, String description, ClassificationMethodCall callMethod) {
        super(name, description, TestType.SCAN);
        this.callMethod = callMethod;
    }

    protected Result run(ClassificationCapability classification, CloseableIterator<String> provider, Transformator<String, CloseableIterator<TaxonomyItem>> generator) {
        CloseableIterator<String> valuesProvider = this.getValueProvider(provider, generator);
        return this.scanClassificationMethod(classification, valuesProvider);
    }

    protected CloseableIterator<String> getValueProvider(CloseableIterator<String> input, Transformator<String, CloseableIterator<TaxonomyItem>> generator) {
        try {
            CloseableIterator taxonomyProviders = CloseableIterators.transform(input, generator);
            CloseableIterator source = CloseableIterators.merge(taxonomyProviders);
            CloseableIterator<String> valuesProvider = CloseableIterators.transform(source, Transformators.ID_EXTRACTOR);
            return valuesProvider;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed creating value provider", e);
        }
    }

    protected Result scanClassificationMethod(ClassificationCapability classification, CloseableIterator<String> valuesProvider) {
        int valuesCounter = 0;
        int success = 0;
        this.logger.trace((Object)"starting");
        while (valuesProvider.hasNext()) {
            String value = (String)valuesProvider.next();
            ++valuesCounter;
            Result result = this.test(classification, value);
            if (result != Result.SUCCESS) continue;
            ++success;
        }
        try {
            valuesProvider.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"Failed closing the values stream", (Throwable)e);
        }
        int failed = valuesCounter - success;
        this.logger.info((Object)("Tested " + valuesCounter + " values, " + success + " successfully and " + failed + " failed"));
        return failed == 0 ? Result.SUCCESS : Result.FAILED;
    }

    protected Result test(ClassificationCapability classification, String value) {
        this.logger.trace((Object)("testing value \"" + value + "\""));
        try {
            this.callMethod.call(classification, value);
            return Result.SUCCESS;
        }
        catch (Throwable throwable) {
            this.logger.info((Object)("Failed call to " + this.callMethod.getMethodName() + " method with value \"" + value + "\""), throwable);
            return Result.FAILED;
        }
    }
}

