/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan;

import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.testsuite.test.Result;
import org.gcube.data.spd.testsuite.test.Test;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationCNScanTest;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationMethodCall;
import org.gcube.data.spd.testsuite.test.scan.classification.ClassificationSNScanTest;
import org.gcube.data.spd.testsuite.test.scan.namemapping.NamesMappingCNScanTest;
import org.gcube.data.spd.testsuite.test.scan.namemapping.NamesMappingSNScanTest;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesCNScanTest;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesMethodCall;
import org.gcube.data.spd.testsuite.test.scan.occurrences.OccurrencesSNScanTest;
import org.gcube.data.spd.testsuite.test.scan.searchable.SearchableCNScanTest;
import org.gcube.data.spd.testsuite.test.scan.searchable.SearchableSNScanTest;

public enum ScanTest {
    PLUGIN_SCIENTIFIC_NAME(new SearchableSNScanTest<ResultItem>("Plugin Scientific Name Test", "Test the searchByScientificName method in AbstractPlugin class using the Scientic Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            return this.testSearchable(plugin);
        }
    }),
    PLUGIN_COMMON_NAME(new SearchableCNScanTest<ResultItem>("Plugin Common Name Test", "Test the searchByCommonName method in AbstractPlugin class using the Common Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            return this.testSearchable(plugin);
        }
    }),
    CLASSIFICATION_SCIENTIFIC_NAME(Capabilities.Classification, new SearchableSNScanTest<TaxonomyItem>("Classification Scientific Name Test", "Test the searchByScientificName method in Classification capability using the Scientic Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            ClassificationCapability classification = plugin.getClassificationInterface();
            return this.testSearchable(classification);
        }
    }),
    CLASSIFICATION_COMMON_NAME(Capabilities.Classification, new SearchableCNScanTest<TaxonomyItem>("Classification Common Name Test", "Test the searchByCommonName method in Classification capability using the Scientic Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            ClassificationCapability classification = plugin.getClassificationInterface();
            return this.testSearchable(classification);
        }
    }),
    OCCURRENCES_SCIENTIFIC_NAME(Capabilities.Occurences, new SearchableSNScanTest<OccurrencePoint>("Classification Scientific Name Test", "Test the searchByScientificName method in Occurrence capability using the Scientic Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            OccurrencesCapability occurrence = plugin.getOccurrencesInterface();
            return this.testSearchable(occurrence);
        }
    }),
    OCCURRENCES_COMMON_NAME(Capabilities.Occurences, new SearchableCNScanTest<OccurrencePoint>("Classification Common Name Test", "Test the searchByCommonName method in Occurrence capability using the Scientic Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            OccurrencesCapability occurrence = plugin.getOccurrencesInterface();
            return this.testSearchable(occurrence);
        }
    }),
    NAMES_MAPPING_SCIENTIFIC_NAME(Capabilities.NamesMapping, new NamesMappingSNScanTest("Names Mapping Scientific Name Test", "Test the scientificNameToCommonNamesMapping method in NamesMapping capability using the Scientic Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            NamesMappingCapability namesMapping = plugin.getNamesMappingInterface();
            return this.testNamesMappingCapability(namesMapping);
        }
    }),
    NAMES_MAPPING_COMMON_NAME(Capabilities.NamesMapping, new NamesMappingCNScanTest("Names Mapping Common Name Test", "Test the commonNameToScientificNamesMapping method in NamesMapping capability using the Common Name provider"){

        @Override
        public Result run(AbstractPlugin plugin) {
            NamesMappingCapability namesMapping = plugin.getNamesMappingInterface();
            return this.testNamesMappingCapability(namesMapping);
        }
    }),
    CLASSIFICATION_SN_RETRIEVE_TAXON_BY_ID(Capabilities.Classification, new ClassificationSNScanTest("Classification Test retrieveTaxonById SN", "Test the retrieveTaxonById method in Classification capability using the Scientific Name provider", ClassificationMethodCall.TAXON_BY_ID)),
    CLASSIFICATION_CN_RETRIEVE_TAXON_BY_ID(Capabilities.Classification, new ClassificationCNScanTest("Classification Test retrieveTaxonById CN", "Test the retrieveTaxonById method in Classification capability using the Scientific Name provider", ClassificationMethodCall.TAXON_BY_ID)),
    CLASSIFICATION_SN_RETRIEVE_TAXON_CHILDS_BY_ID(Capabilities.Classification, new ClassificationSNScanTest("Classification Test retrieveTaxonChildsByTaxonId SN", "Test the retrieveTaxonChildsByTaxonId method in Classification capability using the Scientific Name provider", ClassificationMethodCall.TAXON_CHILDS)),
    CLASSIFICATION_CN_RETRIEVE_TAXON_CHILDS_BY_ID(Capabilities.Classification, new ClassificationCNScanTest("Classification Test retrieveTaxonChildsByTaxonId CN", "Test the retrieveTaxonChildsByTaxonId method in Classification capability using the Scientific Name provider", ClassificationMethodCall.TAXON_CHILDS)),
    CLASSIFICATION_SN_RETRIEVE_TAXON_BY_IDS(Capabilities.Classification, new ClassificationSNScanTest("Classification Test retrieveTaxonByIds SN", "Test the retrieveTaxonByIds method in Classification capability using the Scientific Name provider", ClassificationMethodCall.TAXON_BY_IDS)),
    CLASSIFICATION_CN_RETRIEVE_TAXON_BY_IDS(Capabilities.Classification, new ClassificationCNScanTest("Classification Test retrieveTaxonByIds CN", "Test the retrieveTaxonByIds method in Classification capability using the Scientific Name provider", ClassificationMethodCall.TAXON_BY_IDS)),
    OCCURRENCES_SN_GET_OCCURRENCES_BY_PRODUCT_KEYS(Capabilities.Occurences, new OccurrencesSNScanTest("Occurrences Test getOccurrencesByProductKeys SN", "Test the getOccurrencesByProductKeys method in Occurrence capability using the Scientific Name provider", OccurrencesMethodCall.OCCURRENCE_BY_PRODUCT_KEYS)),
    OCCURRENCES_CN_GET_OCCURRENCES_BY_PRODUCT_KEYS(Capabilities.Occurences, new OccurrencesCNScanTest("Occurrences Test getOccurrencesByProductKeys CN", "Test the getOccurrencesByProductKeys method in Occurrence capability using the Common Name provider", OccurrencesMethodCall.OCCURRENCE_BY_PRODUCT_KEYS)),
    OCCURRENCES_SN_GET_OCCURRENCES_BY_IDS(Capabilities.Occurences, new OccurrencesSNScanTest("Occurrences Test getOccurrencesByIds SN", "Test the getOccurrencesByIds method in Occurrence capability using the Scientific Name provider", OccurrencesMethodCall.OCCURRENCE_BY_IDS)),
    OCCURRENCES_CN_GET_OCCURRENCES_BY_IDS(Capabilities.Occurences, new OccurrencesCNScanTest("Occurrences Test getOccurrencesByIds CN", "Test the getOccurrencesByIds method in Occurrence capability using the Common Name provider", OccurrencesMethodCall.OCCURRENCE_BY_IDS));

    protected Test test;
    protected Capabilities requiredCapability;

    private ScanTest(Test test) {
        this(null, test);
    }

    private ScanTest(Capabilities requiredCapability, Test test) {
        this.requiredCapability = requiredCapability;
        this.test = test;
    }

    public Test getTest() {
        return this.test;
    }

    public Capabilities getRequiredCapability() {
        return this.requiredCapability;
    }
}

