/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.sampler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.sampler.RowScore;
import org.gcube.dataaccess.databases.utils.ConnectionManager;
import org.hibernate.SessionFactory;

public class Sampler {
    private static final String queryForSampleOnTablePostgres = "select %1$s from %2$s limit 100";
    private static final String queryForSampleOnTableMysql = "select %1$s from %2$s limit 100";
    private static final String queryForSmartSampleOnTablePostgres = "select %1$s from %2$s order by random() limit 200";
    private static final String queryForSmartSampleOnTableMysql = "select %1$s from %2$s order by rand() limit 200";
    private static final String queryForSmartSampleWithThresholdOnTablePostgres = "select %1$s from %2$s limit 200 offset %3$s";
    private static final String queryForSmartSampleWithThresholdOnTableMysql = "select %1$s from %2$s limit 200 offset %3$s";
    private static final String queryForRandomSampleWithThresholdOnTablePostgres = "select %1$s from %2$s limit 100 offset %3$s";
    private static final String queryForRandomSampleWithThresholdOnTableMysql = "select %1$s from %2$s limit 100 offset %3$s";
    private static final String queryForRandomSampleOnTableMysql = "select %1$s from %2$s order by rand() limit 100";
    private static final String queryForRandomSampleOnTablePostgres = "select %1$s from %2$s order by random() limit 100";
    private static final String queryForColumnsPostgres = "SELECT column_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc";
    private static final String queryForColumnsMysql = "SELECT column_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s'order by ordinal_position asc";
    private static final String MYSQL = "MySQL";
    private static final String POSTGRES = "Postgres";
    private List<String> listColumns = null;

    public List<Object> sampleOnTable(ConnectionManager connection, SessionFactory dbSession, String DBType, String tableName, String schemaName, List<String> DataTypeColumns) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Sampler->starting the Sample on table operation");
        AnalysisLogger.getLogger().debug((Object)"Sampler->retrieving the first 100 rows");
        List<Object> resultSet = null;
        String querySampleOnTable = null;
        String listAttributes = null;
        listAttributes = this.getQuery(connection, dbSession, DBType, tableName, schemaName, DataTypeColumns);
        if (DBType.equals(POSTGRES)) {
            tableName = schemaName + ".\"" + tableName + "\"";
            querySampleOnTable = String.format("select %1$s from %2$s limit 100", listAttributes, tableName);
        }
        if (DBType.equals(MYSQL)) {
            tableName = schemaName + "." + tableName;
            querySampleOnTable = String.format("select %1$s from %2$s limit 100", listAttributes, tableName);
        }
        AnalysisLogger.getLogger().debug((Object)("Sampler->preparing to submit the query: " + querySampleOnTable));
        resultSet = connection.executeQuery(querySampleOnTable, dbSession);
        AnalysisLogger.getLogger().debug((Object)"Sampler->query submitted successfully");
        if (resultSet == null) {
            AnalysisLogger.getLogger().debug((Object)"Sampler->Error: The table has not rows. Sample operation not possible");
            throw new Exception("The resulting table has not rows. Sample operation not possible");
        }
        return resultSet;
    }

    private String getQuery(ConnectionManager connection, SessionFactory dbSession, String DBType, String tableName, String schemaName, List<String> DataTypeColumns) throws Exception {
        this.listColumns = this.getListColumns(connection, dbSession, DBType, tableName, schemaName);
        String listAttributes = null;
        if (this.listColumns != null) {
            listAttributes = "";
            String attribute = null;
            for (int i = 0; i < this.listColumns.size(); ++i) {
                if (DBType.equals(POSTGRES)) {
                    if (DataTypeColumns.get(i).equals("geometry") || DataTypeColumns.get(i).equals("geography")) {
                        attribute = "st_astext(" + this.listColumns.get(i) + ") as " + this.listColumns.get(i) + ", ";
                        if (i == this.listColumns.size() - 1) {
                            attribute = "st_astext(" + this.listColumns.get(i) + ") as " + this.listColumns.get(i);
                        }
                    } else {
                        attribute = "CAST(\"" + this.listColumns.get(i) + "\" as character varying), ";
                        if (i == this.listColumns.size() - 1) {
                            attribute = "CAST(\"" + this.listColumns.get(i) + "\" as character varying)";
                        }
                    }
                }
                if (DBType.equals(MYSQL)) {
                    if (DataTypeColumns.get(i).contains("char")) {
                        attribute = "CAST(`" + this.listColumns.get(i) + "` as CHAR CHARACTER SET utf8), ";
                        if (i == this.listColumns.size() - 1) {
                            attribute = "CAST(`" + this.listColumns.get(i) + "` as CHAR CHARACTER SET utf8)";
                        }
                    } else {
                        attribute = "CAST(CAST(`" + this.listColumns.get(i) + "` as BINARY) as CHAR CHARACTER SET utf8), ";
                        if (i == this.listColumns.size() - 1) {
                            attribute = "CAST(CAST(`" + this.listColumns.get(i) + "` as BINARY) as CHAR CHARACTER SET utf8)";
                        }
                    }
                }
                listAttributes = listAttributes + attribute;
            }
        }
        return listAttributes;
    }

    private List<String> getListColumns(ConnectionManager connection, SessionFactory dbSession, String DBType, String tableName, String schemaName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Sampler->retrieving column names");
        String queryColumns = null;
        if (DBType.equals(POSTGRES)) {
            queryColumns = String.format(queryForColumnsPostgres, tableName, schemaName);
        }
        if (DBType.equals(MYSQL)) {
            queryColumns = String.format(queryForColumnsMysql, tableName, schemaName);
        }
        List<Object> columnsSet = null;
        ArrayList<String> listColumns = null;
        columnsSet = connection.executeQuery(queryColumns, dbSession);
        AnalysisLogger.getLogger().debug((Object)("Sampler->query submitted successfully: " + queryColumns));
        if (columnsSet != null) {
            listColumns = new ArrayList<String>();
            for (int i = 0; i < columnsSet.size(); ++i) {
                Object element = columnsSet.get(i);
                ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                listColumns.add((String)listvalues.get(0));
            }
        }
        return listColumns;
    }

    public List<Object> smartSampleOnTable(ConnectionManager connection, SessionFactory dbSession, String DBType, String tableName, String schemaName, long NumRows, List<String> DataTypeColumns) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Sampler->starting the Smart Sample on table operation");
        if (NumRows == 0L) {
            throw new Exception("The table has 0 rows");
        }
        List<Object> rows = null;
        if (NumRows > 700000L) {
            rows = this.computeSmartSampleWithThreshold(connection, dbSession, DBType, tableName, schemaName, NumRows, DataTypeColumns);
        } else {
            int NIterations = this.computeNumberIterations(NumRows);
            AnalysisLogger.getLogger().debug((Object)("Sampler->Iterations number: " + NIterations));
            AnalysisLogger.getLogger().debug((Object)"Sampler->retrieving rows");
            rows = this.computeSmartSample(connection, dbSession, DBType, tableName, schemaName, NIterations, DataTypeColumns, DataTypeColumns.size());
        }
        if (rows == null) {
            AnalysisLogger.getLogger().debug((Object)"Sampler->Error: the Smart Sample operation on table  has not returned rows");
            throw new Exception("The Smart Sample operation on table has not returned rows");
        }
        AnalysisLogger.getLogger().debug((Object)"Sampler->rows retrieved");
        return rows;
    }

    private int computeNumberIterations(long NumRows) {
        AnalysisLogger.getLogger().debug((Object)"Sampler->processing iterations number");
        AnalysisLogger.getLogger().debug((Object)("Sampler->rows number: " + NumRows));
        double k = -0.8 * (double)NumRows / 10000.0 + 1.0;
        double paramK = 0.0;
        paramK = Double.compare(k, 0.0) < 0 ? k * -1.0 : k;
        AnalysisLogger.getLogger().debug((Object)("Sampler->parameter K value: " + paramK));
        long NumElements = Math.min(NumRows, 10000L);
        AnalysisLogger.getLogger().debug((Object)("Sampler->choosing the min value of elements: " + NumElements));
        double NumIterations = paramK / 200.0 * (double)NumElements;
        AnalysisLogger.getLogger().debug((Object)("Sampler->iterations number: " + NumIterations));
        double Iterations = Math.max(Math.round(NumIterations), 1L);
        AnalysisLogger.getLogger().debug((Object)("Sampler-> choosing the max value of iterations: " + Iterations));
        double NumIts = Math.min(Iterations, 2.0);
        AnalysisLogger.getLogger().debug((Object)("Sampler-> choosing the min value of iterations: " + NumIts));
        return (int)Math.rint(NumIts);
    }

    private List<Object> computeSmartSample(ConnectionManager connection, SessionFactory dbSession, String DBType, String tablename, String schemaName, int NIterations, List<String> DataTypeColumns, int ColumnSize) throws Exception {
        List<Object> resultSet = null;
        String query = null;
        boolean removal = false;
        ArrayList<RowScore> listRows = new ArrayList<RowScore>();
        String listAttributes = null;
        listAttributes = this.getQuery(connection, dbSession, DBType, tablename, schemaName, DataTypeColumns);
        if (DBType.equals(POSTGRES)) {
            tablename = schemaName + ".\"" + tablename + "\"";
            query = String.format(queryForSmartSampleOnTablePostgres, listAttributes, tablename);
        }
        if (DBType.equals(MYSQL)) {
            tablename = schemaName + "." + tablename;
            query = String.format(queryForSmartSampleOnTableMysql, listAttributes, tablename);
        }
        AnalysisLogger.getLogger().debug((Object)"Sampler->building the query extracting 200 rows randomly");
        Object[] columnArray = null;
        AnalysisLogger.getLogger().debug((Object)("Sampler-> column array dimension: " + ColumnSize));
        double thresholdRank = ColumnSize * 80;
        double valCeil = Math.round(thresholdRank /= 100.0);
        AnalysisLogger.getLogger().debug((Object)("Sampler-> number column generated by the threshold: " + thresholdRank + " rounded value: " + valCeil));
        block0: for (int i = 0; i < NIterations; ++i) {
            AnalysisLogger.getLogger().debug((Object)("Sampler->executing the query: " + query));
            resultSet = connection.executeQuery(query, dbSession);
            if (resultSet != null) {
                int numrows = resultSet.size();
                AnalysisLogger.getLogger().debug((Object)("Sampler->rows number: " + numrows));
                AnalysisLogger.getLogger().debug((Object)"Sampler->computing the score and sort the row list in a reverse natural order");
                for (int j = 0; j < numrows; ++j) {
                    int numElemToDelete;
                    int value;
                    Object element = resultSet.get(j);
                    ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                    columnArray = listvalues.toArray();
                    int score = this.computeColumnScore(columnArray);
                    RowScore rs = new RowScore(element, score);
                    listRows.add(rs);
                    Collections.sort(listRows, Collections.reverseOrder());
                    if (listRows.size() < 100 || (value = ((RowScore)listRows.get(99)).getScore()) < (int)valCeil) continue;
                    removal = true;
                    AnalysisLogger.getLogger().debug((Object)("Sampler->row 100 with score: " + value));
                    AnalysisLogger.getLogger().debug((Object)"Sampler->starting the removal operation");
                    if (listRows.size() <= 100) break block0;
                    AnalysisLogger.getLogger().debug((Object)("Sampler->number of rows to delete: " + numElemToDelete));
                    for (numElemToDelete = listRows.size() - 100; numElemToDelete != 0; --numElemToDelete) {
                        listRows.remove(100);
                    }
                    break block0;
                }
                continue;
            }
            return null;
        }
        if (listRows.size() > 100 && !removal) {
            int numElemToDelete;
            AnalysisLogger.getLogger().debug((Object)"Sampler->starting the removal operation");
            AnalysisLogger.getLogger().debug((Object)("Sampler->number of rows to delete: " + numElemToDelete));
            for (numElemToDelete = listRows.size() - 100; numElemToDelete != 0; --numElemToDelete) {
                RowScore row = (RowScore)listRows.remove(100);
            }
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        AnalysisLogger.getLogger().debug((Object)"Sampler->preparing the result (the row list): ");
        for (int i = 0; i < listRows.size(); ++i) {
            rows.add(((RowScore)listRows.get(i)).getRow());
        }
        return rows;
    }

    private List<Object> computeSmartSampleWithThreshold(ConnectionManager connection, SessionFactory dbSession, String DBType, String tablename, String schemaName, long NumRows, List<String> DataTypeColumns) throws Exception {
        int Y;
        int X;
        int threshold = 700000;
        Random rn = new Random();
        if ((long)(threshold + 200) <= NumRows) {
            int a;
            AnalysisLogger.getLogger().debug((Object)"Sampler-> 700000+200 <= rows number");
            X = rn.nextInt(threshold + 1) + 200;
            AnalysisLogger.getLogger().debug((Object)("Sampler->X index: " + X));
            int LI = X - 200;
            int UI = X + 200;
            AnalysisLogger.getLogger().debug((Object)("Sampler->Lower Index of the range: " + LI));
            AnalysisLogger.getLogger().debug((Object)("Sampler->Upper Index of the range: " + UI));
            while ((a = rn.nextInt(threshold + 1) + 0) >= UI && a <= LI) {
            }
            Y = a;
            AnalysisLogger.getLogger().debug((Object)("Sampler->Y index: " + Y));
        } else {
            int a;
            AnalysisLogger.getLogger().debug((Object)"Sampler-> 700000+200 > rows number");
            int offset = (int)NumRows - threshold;
            int valForUpperIndex = 200 - offset;
            int UpperIndex = threshold - valForUpperIndex;
            X = rn.nextInt(UpperIndex + 1) + 200;
            AnalysisLogger.getLogger().debug((Object)("Sampler->X index: " + X));
            int LI = X - 200;
            int UI = X + 200;
            AnalysisLogger.getLogger().debug((Object)("Sampler->Lower Index of the range: " + LI));
            AnalysisLogger.getLogger().debug((Object)("Sampler->Upper Index of the range: " + UI));
            while ((a = rn.nextInt(UpperIndex + 1) + 0) >= UI && a <= LI) {
            }
            Y = a;
        }
        int[] indexes = new int[]{X, Y};
        List<Object> resultSet = null;
        String query = null;
        boolean removal = false;
        ArrayList<RowScore> listRows = new ArrayList<RowScore>();
        String listAttributes = null;
        listAttributes = this.getQuery(connection, dbSession, DBType, tablename, schemaName, DataTypeColumns);
        AnalysisLogger.getLogger().debug((Object)"Sampler->building the query extracting 200 rows randomly");
        Object[] columnArray = null;
        block2: for (int i = 0; i < 2; ++i) {
            String tableName;
            if (DBType.equals(POSTGRES)) {
                tableName = "";
                tableName = schemaName + ".\"" + tablename + "\"";
                query = String.format("select %1$s from %2$s limit 200 offset %3$s", listAttributes, tableName, indexes[i]);
            }
            if (DBType.equals(MYSQL)) {
                tableName = "";
                tableName = schemaName + "." + tablename;
                query = String.format("select %1$s from %2$s limit 200 offset %3$s", listAttributes, tableName, indexes[i]);
            }
            AnalysisLogger.getLogger().debug((Object)("Sampler->executing the query: " + query));
            resultSet = connection.executeQuery(query, dbSession);
            if (resultSet != null) {
                int numrows = resultSet.size();
                AnalysisLogger.getLogger().debug((Object)("Sampler->rows number: " + numrows));
                AnalysisLogger.getLogger().debug((Object)"Sampler->computing the score and sorting the row list in a reverse natural order");
                for (int j = 0; j < numrows; ++j) {
                    int numElemToDelete;
                    Object element = resultSet.get(j);
                    ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                    columnArray = listvalues.toArray();
                    int score = this.computeColumnScore(columnArray);
                    RowScore rs = new RowScore(element, score);
                    listRows.add(rs);
                    Collections.sort(listRows, Collections.reverseOrder());
                    if (listRows.size() < 100) continue;
                    int value = ((RowScore)listRows.get(99)).getScore();
                    double thresholdRank = columnArray.length * 80;
                    double valCeil = Math.round(thresholdRank /= 100.0);
                    if (value < (int)valCeil) continue;
                    removal = true;
                    AnalysisLogger.getLogger().debug((Object)("Sampler->row 100 with score: " + value));
                    AnalysisLogger.getLogger().debug((Object)"Sampler->starting the removal operation");
                    if (listRows.size() <= 100) break block2;
                    AnalysisLogger.getLogger().debug((Object)("Sampler->number of rows to delete: " + numElemToDelete));
                    for (numElemToDelete = listRows.size() - 100; numElemToDelete != 0; --numElemToDelete) {
                        listRows.remove(100);
                    }
                    break block2;
                }
                continue;
            }
            return null;
        }
        if (listRows.size() > 100 && !removal) {
            int numElemToDelete;
            AnalysisLogger.getLogger().debug((Object)"Sampler->starting the removal operation");
            AnalysisLogger.getLogger().debug((Object)("Sampler->number of rows to delete: " + numElemToDelete));
            for (numElemToDelete = listRows.size() - 100; numElemToDelete != 0; --numElemToDelete) {
                RowScore row = (RowScore)listRows.remove(100);
            }
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        AnalysisLogger.getLogger().debug((Object)"Sampler->preparing the result (the row list): ");
        for (int i = 0; i < listRows.size(); ++i) {
            rows.add(((RowScore)listRows.get(i)).getRow());
        }
        return rows;
    }

    private int computeColumnScore(Object[] columnArray) {
        int score = 0;
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i] == null || columnArray[i].toString().equals("")) continue;
            ++score;
        }
        return score;
    }

    public List<Object> randomSampleOnTable(ConnectionManager connection, SessionFactory dbSession, String DBType, String tableName, String schemaName, long NumRows, List<String> DataTypeColumns) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Sampler->starting the Random Sample on table operation");
        AnalysisLogger.getLogger().debug((Object)"Sampler->retrieving the 100 rows");
        List<Object> resultSet = null;
        String querySampleOnTable = null;
        String listAttributes = null;
        listAttributes = this.getQuery(connection, dbSession, DBType, tableName, schemaName, DataTypeColumns);
        if (NumRows <= 700000L) {
            if (DBType.equals(POSTGRES)) {
                tableName = schemaName + ".\"" + tableName + "\"";
                querySampleOnTable = String.format(queryForRandomSampleOnTablePostgres, listAttributes, tableName);
            }
            if (DBType.equals(MYSQL)) {
                tableName = schemaName + "." + tableName;
                querySampleOnTable = String.format(queryForRandomSampleOnTableMysql, listAttributes, tableName);
            }
        }
        if (NumRows > 700000L) {
            int X;
            int threshold = 700000;
            Random rn = new Random();
            if ((long)(threshold + 100) <= NumRows) {
                X = rn.nextInt(threshold + 1) + 100;
                AnalysisLogger.getLogger().debug((Object)("Sampler->X index: " + X));
            } else {
                AnalysisLogger.getLogger().debug((Object)"Sampler-> 700000+100 > rows number");
                int offset = (int)NumRows - threshold;
                int valForUpperIndex = 100 - offset;
                int UpperIndex = threshold - valForUpperIndex;
                X = rn.nextInt(UpperIndex + 1) + 100;
                AnalysisLogger.getLogger().debug((Object)("Sampler->X index: " + X));
            }
            if (DBType.equals(POSTGRES)) {
                tableName = schemaName + ".\"" + tableName + "\"";
                querySampleOnTable = String.format("select %1$s from %2$s limit 100 offset %3$s", listAttributes, tableName, X);
            }
            if (DBType.equals(MYSQL)) {
                tableName = schemaName + "." + tableName;
                querySampleOnTable = String.format("select %1$s from %2$s limit 100 offset %3$s", listAttributes, tableName, X);
            }
        }
        AnalysisLogger.getLogger().debug((Object)("Sampler->preparing to submit the query: " + querySampleOnTable));
        resultSet = connection.executeQuery(querySampleOnTable, dbSession);
        AnalysisLogger.getLogger().debug((Object)"Sampler->query submitted successfully");
        if (resultSet == null) {
            AnalysisLogger.getLogger().debug((Object)"Sampler->Error: The resulting table has not rows. Sample operation not possible");
            throw new Exception("The resulting table has not rows. Sample operation not possible");
        }
        return resultSet;
    }

    public List<String> getListColumns() {
        return this.listColumns;
    }
}

