/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.ckanutillibrary;

import eu.trentorise.opendata.jackan.model.CkanOrganization;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.dataaccess.ckanutillibrary.CKanUtilsFactory;
import org.gcube.dataaccess.ckanutillibrary.CKanUtilsImpl;
import org.gcube.dataaccess.ckanutillibrary.models.CKanUserWrapper;
import org.gcube.dataaccess.ckanutillibrary.models.ROLES_IN_ORGANIZATION;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCKanLib {
    private static final Logger logger = LoggerFactory.getLogger(TestCKanLib.class);
    CKanUtilsImpl instance;

    public void before() throws Exception {
        this.instance = new CKanUtilsImpl("/gcube");
    }

    public void testgetApiKeyFromUser() {
        logger.debug("Testing getApiKeyFromUser");
        String username = "francescomangiacrapa";
        String key = this.instance.getApiKeyFromUser(username);
        System.out.println("key for " + username + " is " + key);
    }

    public void testgetUserFromApiKey() {
        logger.debug("Testing getApiKeyFromUser");
        String key = "put-your-key-here";
        CKanUserWrapper user = this.instance.getUserFromApiKey(key);
        System.out.println("user for " + key + " is " + user);
    }

    public void getOrganizationsByUser() {
        System.out.println("Testing getOrganizationsByUser");
        String username = "francescomangiacrapa";
        List organizations = this.instance.getOrganizationsByUser(username);
        System.out.println("organizations for user " + username + " are: ");
        for (CkanOrganization ckanOrganization : organizations) {
            System.out.println("-" + ckanOrganization.getName());
        }
    }

    public void getGroupsAndRolesByUser() {
        logger.debug("Testing getGroupsAndRolesByUser");
        String username = "francescomangiacrapa";
        ArrayList<ROLES_IN_ORGANIZATION> rolesToMatch = new ArrayList<ROLES_IN_ORGANIZATION>();
        rolesToMatch.add(ROLES_IN_ORGANIZATION.admin);
        rolesToMatch.add(ROLES_IN_ORGANIZATION.member);
        rolesToMatch.add(ROLES_IN_ORGANIZATION.editor);
        Map map = this.instance.getGroupsAndRolesByUser(username, rolesToMatch);
        System.out.println("organizations for user " + username + " are " + map);
    }

    public void testFactory() throws Exception {
        System.out.println("Creating factory object");
        CKanUtilsImpl obj = CKanUtilsFactory.getInstance().getCkanUtilsForScope("/gcube");
        System.out.println("Object created " + obj.getCatalogueUrl());
    }
}

