/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.Configuration;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;
import org.gcube.dataanalysis.dataminer.poolmanager.util.CheckMethod;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SVNRepositoryManager;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.GenericException;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.SVNCommitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SVNUpdater {
    private SVNRepository svnRepository;
    private Configuration configuration;
    private Logger logger;

    public SVNUpdater(Configuration configuration) throws SVNException {
        this.configuration = configuration;
        this.svnRepository = SVNRepositoryManager.getInstance((Configuration)configuration).getSvnRepository();
        this.logger = LoggerFactory.getLogger(SVNUpdater.class);
    }

    public String getDependencyFile(String language) {
        return this.getDependencyFile(this.configuration, language);
    }

    private String getDependencyFile(Configuration configuration, String language) {
        this.logger.debug("Getting dependency file for language " + language);
        switch (language) {
            case "R": {
                return configuration.getSVNCRANDepsList();
            }
            case "R-blackbox": {
                return configuration.getSVNRBDepsList();
            }
            case "Java": {
                return configuration.getSVNJavaDepsList();
            }
            case "Knime-Workflow": {
                return configuration.getSVNKWDepsList();
            }
            case "Linux-compiled": {
                return configuration.getSVNLinuxCompiledDepsList();
            }
            case "Octave": {
                return configuration.getSVNOctaveDepsList();
            }
            case "Python": {
                return configuration.getSVNPythonDepsList();
            }
            case "Pre-Installed": {
                return configuration.getSVNPreInstalledDepsList();
            }
            case "Windows-compiled": {
                return configuration.getSVNWCDepsList();
            }
        }
        return null;
    }

    public boolean updateSVNAlgorithmList(Algorithm algorithm, String targetVRE, String category, String algorithm_type, String user) {
        return this.updateSVNAlgorithmList(this.configuration.getSVNAlgorithmsList(), algorithm, targetVRE, category, algorithm_type, user);
    }

    public void updateAlgorithmFiles(File a) throws SVNException, SVNCommitException {
        this.updateAlgorithmList(this.configuration.getRepository(), a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAlgorithmList(String svnMainAlgoRepo, File algorithmsFile) throws SVNException, SVNCommitException {
        this.logger.debug("Adding .jar file: " + algorithmsFile + " to repository " + svnMainAlgoRepo);
        try {
            if (this.fileExists(svnMainAlgoRepo + File.separator + algorithmsFile.getName(), -1L)) {
                this.updateFile(new FileInputStream(algorithmsFile), svnMainAlgoRepo, algorithmsFile.getName());
            } else {
                this.putFile(new FileInputStream(algorithmsFile), svnMainAlgoRepo, algorithmsFile.getName());
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Temporary algorithm file not found: this exception should not happen", (Throwable)e);
        }
        finally {
            this.svnRepository.closeSession();
        }
    }

    public void putFile(FileInputStream fileInputSreeam, String destinationFolder, String fileName) throws SVNException, SVNCommitException {
        this.logger.debug("Putting new file on the SVN repository");
        ISVNEditor commitEditor = this.svnRepository.getCommitEditor("Add algorithm to list", null);
        commitEditor.openRoot(-1L);
        commitEditor.openDir(destinationFolder, -1L);
        String filePath = destinationFolder + "/" + fileName;
        commitEditor.addFile(filePath, null, -1L);
        commitEditor.applyTextDelta(filePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(filePath, (InputStream)fileInputSreeam, (ISVNDeltaConsumer)commitEditor, true);
        commitEditor.closeFile(filePath, checksum);
        commitEditor.closeDir();
        commitEditor.closeDir();
        SVNCommitInfo info = commitEditor.closeEdit();
        SVNErrorMessage errorMessage = info.getErrorMessage();
        if (errorMessage != null) {
            this.logger.error("Operation failed: " + errorMessage.getFullMessage());
            throw new SVNCommitException(errorMessage, fileName);
        }
        this.logger.debug("Operation completed");
    }

    public void updateFile(FileInputStream fileInputStream, String destinationFolder, String fileName) throws SVNException, SVNCommitException {
        this.logger.debug("Updating existing file on the SVN repository");
        ISVNEditor commitEditor = this.svnRepository.getCommitEditor("Updating algorithm", null);
        commitEditor.openRoot(-1L);
        commitEditor.openDir(destinationFolder, -1L);
        String filePath = destinationFolder + "/" + fileName;
        commitEditor.openFile(filePath, -1L);
        commitEditor.applyTextDelta(filePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(filePath, (InputStream)fileInputStream, (ISVNDeltaConsumer)commitEditor, true);
        commitEditor.closeFile(filePath, checksum);
        commitEditor.closeDir();
        commitEditor.closeDir();
        SVNCommitInfo info = commitEditor.closeEdit();
        SVNErrorMessage errorMessage = info.getErrorMessage();
        if (errorMessage != null) {
            this.logger.error("Operation failed: " + errorMessage.getFullMessage());
            throw new SVNCommitException(errorMessage, fileName + " to be updated");
        }
        this.logger.debug("Operation completed");
    }

    public boolean fileExists(String path, long revision) throws SVNException {
        SVNNodeKind kind = this.svnRepository.checkPath(path, revision);
        return kind == SVNNodeKind.FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSVNAlgorithmList(String file, Algorithm algorithm, String targetVRE, String category, String algorithm_type, String user) {
        boolean response = false;
        try {
            this.logger.debug("Updating algorithm list: " + file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            LinkedList<String> newContent = new LinkedList<String>(Arrays.asList(lines));
            for (String l : lines) {
                if (!l.contains(algorithm.getClazz())) continue;
                newContent.remove(l);
            }
            newContent.add(this.generateAlgorithmEntry(algorithm, targetVRE, category, algorithm_type));
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            byte[] originalContents = byteArrayOutputStream.toByteArray();
            ISVNEditor commitEditor = this.svnRepository.getCommitEditor("update algorithm list", null);
            commitEditor.openRoot(-1L);
            commitEditor.openFile(file, -1L);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String line : newContent) {
                baos.write(line.getBytes());
                baos.write("\n".getBytes());
            }
            byte[] bytes = baos.toByteArray();
            commitEditor.applyTextDelta(file, SVNUpdater.md5((byte[])originalContents));
            String checksum = deltaGenerator.sendDelta(file, (InputStream)new ByteArrayInputStream(originalContents), 0L, (InputStream)new ByteArrayInputStream(bytes), (ISVNDeltaConsumer)commitEditor, true);
            commitEditor.closeFile(file, checksum);
            SVNCommitInfo info = commitEditor.closeEdit();
            SVNErrorMessage errorMessage = info.getErrorMessage();
            if (errorMessage != null) {
                this.logger.error("Operation failed: " + errorMessage.getFullMessage());
                response = false;
            } else {
                response = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Unable to commit algorithm list", (Throwable)ex);
            response = false;
        }
        finally {
            this.svnRepository.closeSession();
        }
        return response;
    }

    public String generateAlgorithmEntry(Algorithm algorithm, String targetVRE, String category, String algorithm_type) throws ParseException {
        StringBuffer sb = new StringBuffer("| ");
        sb.append(algorithm.getName() + " | ");
        sb.append(algorithm.getFullname() + " | ");
        sb.append(category + " | ");
        sb.append("DataMinerPoolManager | ");
        sb.append("<notextile>./addAlgorithm.sh " + algorithm.getName() + " " + algorithm.getCategory() + " " + algorithm.getClazz() + " " + targetVRE + " " + algorithm_type + " N " + algorithm.getPackageURL() + " \"" + algorithm.getDescription() + "\" </notextile> | ");
        sb.append("none | ");
        sb.append(this.getTimeZone() + " | ");
        this.logger.info("Algo details: " + sb.toString());
        return sb.toString();
    }

    public Collection<String> getUndefinedDependencies(String file, Collection<Dependency> deps) throws GenericException {
        try {
            LinkedList<String> undefined = new LinkedList<String>();
            if (file.isEmpty()) {
                return undefined;
            }
            this.logger.debug("Checking dependencies list: " + file);
            LinkedList<String> validDependencies = new LinkedList<String>();
            for (String singlefile : CheckMethod.getFiles((String)file)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.svnRepository.getFile(singlefile, -1L, null, (OutputStream)byteArrayOutputStream);
                for (String l : byteArrayOutputStream.toString().split("\\r?\\n")) {
                    validDependencies.add(l.trim());
                }
            }
            this.logger.debug("Valid dependencies are: " + validDependencies);
            for (Dependency d : deps) {
                String depName = d.getName();
                if (validDependencies.contains(depName)) continue;
                undefined.add(depName);
            }
            return undefined;
        }
        catch (SVNException e) {
            throw new GenericException((Throwable)e);
        }
    }

    public boolean checkIfAvaialable(String file, Collection<Dependency> deps) throws SVNException {
        boolean check = false;
        try {
            this.logger.info("Checking dependencies list: " + file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            LinkedList<String> ldep = new LinkedList<String>();
            for (Dependency d : deps) {
                ldep.add(d.getName());
            }
            for (String a : lines) {
                for (String b : ldep) {
                    if (b.equals(a)) {
                        System.out.println("The following dependency is correctly written: " + b);
                        check = true;
                        continue;
                    }
                    check = false;
                }
            }
        }
        catch (Exception a) {
            this.logger.error(a.getMessage(), (Throwable)a);
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSVN(String file, Collection<Dependency> deps) {
        try {
            this.logger.info("Updating dependencies list: " + file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            LinkedList<String> ldep = new LinkedList<String>();
            for (Dependency d : deps) {
                ldep.add(d.getName());
            }
            List aa = this.checkMatch(lines, ldep);
            Collections.sort(aa);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            byte[] originalContents = byteArrayOutputStream.toByteArray();
            ISVNEditor commitEditor = this.svnRepository.getCommitEditor("update dependencies", null);
            commitEditor.openRoot(-1L);
            commitEditor.openFile(file, -1L);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String line : aa) {
                baos.write(line.getBytes());
                baos.write("\n".getBytes());
            }
            byte[] bytes = baos.toByteArray();
            commitEditor.applyTextDelta(file, SVNUpdater.md5((byte[])originalContents));
            String checksum = deltaGenerator.sendDelta(file, (InputStream)new ByteArrayInputStream(originalContents), 0L, (InputStream)new ByteArrayInputStream(bytes), (ISVNDeltaConsumer)commitEditor, true);
            commitEditor.closeFile(file, checksum);
            commitEditor.closeEdit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.svnRepository.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(byte[] contents) {
        byte[] tmp = new byte[1024];
        SVNChecksumInputStream checksumStream = new SVNChecksumInputStream((InputStream)new ByteArrayInputStream(contents), "md5");
        try {
            while (checksumStream.read(tmp) > 0) {
            }
            String string = checksumStream.getDigest();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            SVNFileUtil.closeFile((InputStream)checksumStream);
        }
    }

    public List<String> checkMatch(String[] lines, List<String> ls) {
        HashSet<String> ss = new HashSet<String>(ls);
        ss.addAll(Arrays.asList(lines));
        return new ArrayList<String>(ss);
    }

    public String getTimeZone() throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        Date fromDate = formatter.parse(cal.getTime().toString());
        TimeZone central = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(central);
        this.logger.info(formatter.format(fromDate));
        return formatter.format(fromDate);
    }

    public static void main(String[] args) throws SVNException, ParseException {
        Calendar cal = Calendar.getInstance();
        cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        Date fromDate = formatter.parse(cal.getTime().toString());
        TimeZone central = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(central);
        System.out.println(formatter.format(fromDate));
    }
}

