/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.service.DMPMJob;
import org.gcube.dataanalysis.dataminer.poolmanager.util.NotificationHelper;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SVNUpdater;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SendMail;

public class ProductionPublishingJob
extends DMPMJob {
    private Algorithm algorithm;
    private String targetVREName;
    private String category;
    private String algorithm_type;
    private String env;

    public ProductionPublishingJob(SVNUpdater svnUpdater, Algorithm algorithm, String targetVREName, String category, String algorithm_type, String env) throws FileNotFoundException, UnsupportedEncodingException {
        super(svnUpdater);
        this.algorithm = algorithm;
        this.targetVREName = targetVREName;
        this.category = category;
        this.algorithm_type = algorithm_type;
        this.env = env;
        this.jobLogs = new File(System.getProperty("user.home") + File.separator + "dataminer-pool-manager" + File.separator + "jobs");
        this.jobLogs.mkdirs();
    }

    protected void execute() {
        SendMail sm = new SendMail();
        NotificationHelper nh = new NotificationHelper();
        try {
            this.svnUpdater.updateSVNAlgorithmList(this.algorithm, this.targetVREName, this.category, this.algorithm_type, this.algorithm.getFullname(), this.env);
            this.getStatus(9);
            sm.sendNotification(nh.getSuccessSubjectRelease() + " for " + this.algorithm.getName() + " algorithm", nh.getSuccessBodyRelease("\n\n" + this.buildInfo()));
            return;
        }
        catch (Exception e) {
            try {
                this.getStatus(0);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return;
        }
    }

    public String getStatus(int exitstatus) throws FileNotFoundException, UnsupportedEncodingException {
        File m = new File(this.jobLogs + File.separator + this.id + "_exitStatus");
        PrintWriter writer = new PrintWriter(m, "UTF-8");
        String response = "";
        if (exitstatus == 9) {
            response = "COMPLETED";
            writer.println(response);
        }
        if (exitstatus == 0) {
            response = "FAILED";
            writer.println(response);
        }
        writer.close();
        return response;
    }

    public String buildInfo() {
        return "\nAlgorithm details:\n\nUser: " + this.algorithm.getFullname() + "\nAlgorithm name: " + this.algorithm.getName() + "\nCaller VRE: " + ScopeProvider.instance.get() + "\nTarget VRE: " + this.targetVREName + "\n";
    }
}

