package org.gcube.dataanalysis.dataminer.poolmanager.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.service.DataminerPoolManager;
import org.gcube.dataanalysis.dataminer.poolmanager.util.AlgorithmBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;

@Path("/")
public class RestPoolManager implements PoolManager {

	private static final Logger LOGGER = LoggerFactory.getLogger(RestPoolManager.class);

	private DataminerPoolManager service = new DataminerPoolManager();

	//TODO: for all methods accept also a callback url to send the log.

	@GET
	@Path("/algorithm/stage")
	@Produces("text/plain")
	public String stageAlgorithm(
			@QueryParam("algorithmPackageURL") String algorithmPackageURL,
			@QueryParam("category") String category) throws IOException, InterruptedException {
		Algorithm algo = AlgorithmBuilder.create(algorithmPackageURL, category);
		return this.service.stageAlgorithm(algo);
	}


	@GET
	@Path("/algorithm/add")
	@Produces("text/plain")
	public String publishAlgorithm(
			@QueryParam("algorithmPackageURL") String algorithmPackageURL,
			@QueryParam("targetVREToken") String targetVREToken,
			@QueryParam("targetVRE") String targetVRE,
			@QueryParam("category") String category) throws IOException, InterruptedException {
		Algorithm algo = AlgorithmBuilder.create(algorithmPackageURL, category);
		return this.service.publishAlgorithm(algo, targetVREToken, targetVRE);
	}

	/*
	 * /scopes/<scope> POST // add an algorithm to all dataminers in the scope
	 * /hosts/<hostname> POST // add an algorithm to the given host
	 */

	@GET
	@Path("/log")
	@Produces("text/plain")
	public String getLogById(@QueryParam("logUrl") String logUrl) throws IOException {
		// TODO Auto-generated method stub
		LOGGER.debug("Returning Log =" + logUrl);
		return service.getLogById(logUrl);
	}

	
		@Override
	public Algorithm extractAlgorithm(String url) throws IOException {
		// TODO Auto-generated method stub
		return null;
	}

	public static void main(String[] args) throws IOException, InterruptedException, SVNException {
//		// System.out.println(System.getProperty("user.home")+File.separator+"/gcube/dataminer-pool-manager");
//		// ProxySelector.setDefault(new
//		// PropertiesBasedProxySelector("/home/ngalante/.proxy-settings"));
//
//		ScopeProvider.instance.set("/d4science.research-infrastructures.eu/gCubeApps/RPrototypingLab");
//		//SecurityTokenProvider.instance.set("3a23bfa4-4dfe-44fc-988f-194b91071dd2-843339462");
//		RestPoolManager a = new RestPoolManager();
//		a.stageAlgorithm("http://data.d4science.org/MnovRjZIdGV5WlB0WXE5NVNaZnRoRVg0SU8xZWpWQlFHbWJQNStIS0N6Yz0", category);
//		//a.publishAlgorithm("http://data.d4science.org/MnovRjZIdGV5WlB0WXE5NVNaZnRoRVg0SU8xZWpWQlFHbWJQNStIS0N6Yz0", "708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548","/gcube/devNext/NextNext");
//		// PoolManager aa = new DataminerPoolManager();
//

	}
	
	
	
	//Production Testing
	/*
	stageAlgorithm(Rproto caller token,pacchetto, category)
	http://node2-d-d4s.d4science.org:8080/dataminer-pool-manager-1.0.0-SNAPSHOT/rest/algorithm/stage?gcube-token=3a23bfa4-4dfe-44fc-988f-194b91071dd2-843339462&algorithmPackageURL=http://data.d4science.org/dENQTTMxdjNZcGRpK0NHd2pvU0owMFFzN0VWemw3Zy9HbWJQNStIS0N6Yz0&category=ICHTHYOP_MODEL
	
	
	publishAlgorithm(Rproto caller token, pacchetto, category, target token, target prod vre)
	http://node2-d-d4s.d4science.org:8080/dataminer-pool-manager-1.0.0-SNAPSHOT/rest/algorithm/stage/add?gcube-token=3a23bfa4-4dfe-44fc-988f-194b91071dd2-843339462&algorithmPackageURL=http://data.d4science.org/dENQTTMxdjNZcGRpK0NHd2pvU0owMFFzN0VWemw3Zy9HbWJQNStIS0N6Yz0&category=ICHTHYOP_MODEL&targetVREToken=708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548&targetVRE=/gcube/devNext/NextNext
	
	
	getLogById(Rproto caller token, logid)
	http://node2-d-d4s.d4science.org:8080/dataminer-pool-manager-1.0.0-SNAPSHOT/rest/log?gcube-token=3a23bfa4-4dfe-44fc-988f-194b91071dd2-843339462&logUrl=
	*/
	
	
	//dev Testing
	/*
	stageAlgorithm(dev caller token,pacchetto, category)
	http://node2-d-d4s.d4science.org:8080/dataminer-pool-manager-1.0.0-SNAPSHOT/rest/algorithm/stage?gcube-token=708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548&algorithmPackageURL=http://data.d4science.org/dENQTTMxdjNZcGRpK0NHd2pvU0owMFFzN0VWemw3Zy9HbWJQNStIS0N6Yz0&category=ICHTHYOP_MODEL
		
		
	publishAlgorithm(dev caller token, pacchetto, category, target token, target prod vre)
	http://node2-d-d4s.d4science.org:8080/dataminer-pool-manager-1.0.0-SNAPSHOT/rest/algorithm/stage/add?gcube-token=708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548&algorithmPackageURL=http://data.d4science.org/dENQTTMxdjNZcGRpK0NHd2pvU0owMFFzN0VWemw3Zy9HbWJQNStIS0N6Yz0&category=ICHTHYOP_MODEL&targetVREToken=3a23bfa4-4dfe-44fc-988f-194b91071dd2-843339462&targetVRE=/d4science.research-infrastructures.eu/gCubeApps/RPrototypingLab
		
	
	getLogById(dev caller token, logid)
	http://node2-d-d4s.d4science.org:8080/dataminer-pool-manager-1.0.0-SNAPSHOT/rest/log?gcube-token=708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548&logUrl=a79a5b5f-ed31-4bf6-8749-94160c3bf0fc
	*/
	

	@Override
	public void getLogId(Algorithm algo, String vre) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getScriptFromURL(URL logId) throws IOException {
		// TODO Auto-generated method stub
		return null;
	}



	@Override
	public URL getURLfromWorkerLog(String logUrl) throws MalformedURLException, UnknownHostException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void addAlgToIs(Algorithm algo) {
		// TODO Auto-generated method stub

	}

	@Override
	public Set<Algorithm> getAlgoFromIs() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public List<String> updateSVN(String file, List<String> ldep) throws SVNException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public String addAlgorithmToHost(Algorithm algo, String host,  boolean test)
			throws IOException, InterruptedException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public String addAlgorithmToVRE(Algorithm algo, String vre, boolean test)
			throws IOException, InterruptedException {
		// TODO Auto-generated method stub
		return null;
	}


	
}
