/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.service.ProductionPublishingJob;
import org.gcube.dataanalysis.dataminer.poolmanager.service.StagingJob;
import org.gcube.dataanalysis.dataminer.poolmanager.util.ClusterBuilder;
import org.gcube.dataanalysis.dataminer.poolmanager.util.Props;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SVNUpdater;
import org.tmatesoft.svn.core.SVNException;

public class DataminerPoolManager {
    private SVNUpdater svnUpdater;

    public DataminerPoolManager() {
        try {
            this.svnUpdater = new SVNUpdater(new Props().getSVNrepo());
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
    }

    public String stageAlgorithm(Algorithm algo) throws IOException, InterruptedException {
        Cluster stagingCluster = ClusterBuilder.getStagingDataminerCluster();
        Cluster rProtoCluster = ClusterBuilder.getRProtoCluster();
        StagingJob job = new StagingJob(this.svnUpdater, algo, stagingCluster, rProtoCluster);
        String id = job.start();
        return id;
    }

    public String publishAlgorithm(Algorithm algo, String targetVREToken, String targetVRE) throws IOException, InterruptedException {
        Cluster prodCluster = ClusterBuilder.getVRECluster((String)targetVREToken, (String)targetVRE);
        ProductionPublishingJob job = new ProductionPublishingJob(this.svnUpdater, algo, prodCluster);
        String id = job.start();
        return id;
    }

    public String getLogById(String id) throws FileNotFoundException {
        File path = new File(System.getProperty("user.home") + File.separator + "dataminer-pool-manager/jobs/" + id);
        return new Scanner(path).useDelimiter("\\Z").next();
    }
}

