package org.gcube.datatransfer.resolver.geoportal.exporter;

public class Geoportal_HTML_Page {
	
	/**
	 * Sets the HTML message.
	 *
	 * @param action  the action
	 * @param message the message
	 * @param waiting the waiting
	 * @return the string
	 */
	public static String entityHTMLMessage(String action, String message, boolean waiting, String viewPdfURL) {

		//NB the images are located at https://data.d4science.net/qLix
		String newHTML = "<html>\n"
				+ "\n"
				+ "  <head>\n"
				+ "    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n"
				+ "    <style>\n"
				+ "      html,\n"
				+ "      body {\n"
				+ "        margin: 10px;\n"
				+ "        width: 100%;\n"
				+ "        height: 100%;\n"
				+ "        display: table\n"
				+ "      }\n"
				+ "\n"
				+ "      #content {\n"
				+ "        position: absolute;\n"
				+ "        left: 50%;\n"
				+ "        top: 50%;\n"
				+ "        -webkit-transform: translate(-50%, -50%);\n"
				+ "        transform: translate(-50%, -50%);\n"
				+ "        text-align: center;\n"
				+ "      }\n"
				+ "\n"
				+ "      #title-geo {\n"
				+ "        font-weight: bold;\n"
				+ "        color: black;\n"
				+ "        font-size: 26px;\n"
				+ "      }\n"
				+ "\n"
				+ "      #message {\n"
				+ "        color: gray;\n"
				+ "        font-size: 24px;\n"
				+ "      }\n"
				+ "\n"
				+ "    </style>\n"
				+ "    <script type=\"text/javascript\">\n"
				+ "      async function fetchPDF_URL() {\n"
				+ "        try {\n"
				+ "\n"
				+ "          const response = await fetch('"+viewPdfURL+"');\n"
				+ "          console.log(\"polling response\");\n"
				+ "          return response.json();\n"
				+ "        } catch (error) {\n"
				+ "          console.error(\"polling error: \" + error);\n"
				+ "          showError(\"Error when exporting PDF :-(\");\n"
				+ "        }\n"
				+ "      }\n"
				+ "      async function playPDFPoll() {\n"
				+ "        const response_object = await fetchPDF_URL();\n"
				+ "        try {\n"
				+ "          console.log(\"json response \" + response_object);\n"
				+ "          if (response_object.state === \"OK\") {\n"
				+ "            if (!(response_object.url === null) && !(response_object.url === undefined)) {\n"
				+ "              window.location.replace(response_object.url);\n"
				+ "            } else {\n"
				+ "              setTimeout(() => {\n"
				+ "                playPDFPoll();\n"
				+ "              }, 1000);\n"
				+ "            }\n"
				+ "          } else {\n"
				+ "            showError(response_object.message);\n"
				+ "          }\n"
				+ "        } catch (error) {\n"
				+ "          console.log(\"no json response \" + response_object);\n"
				+ "          //console.log(\"error \" + error);\n"
				+ "          showError(\"Error when exporting PDF :-(\");\n"
				+ "        }\n"
				+ "\n"
				+ "      }\n"
				+ "\n"
				+ "      function showError(error_msg) {\n"
				+ "        let inner_div = document.getElementById(\"inner-content\");\n"
				+ "        inner_div.innerHTML = error_msg;\n"
				+ "      }\n"
				+ "\n"
				+ "    </script>\n"
				+ "    <title>D4Science Geoportal - Action</title>\n"
				+ "  </head>\n"
				+ "\n"
				+ " <body onload=\"playPDFPoll()\">";
		
		newHTML += "<img alt=\"D4Science Logo\" src=\"https://services.d4science.org/image/layout_set_logo?img_id=32727\"><br />";

		newHTML += "<div id=\"content\">";
		newHTML += "<p id=\"title-geo\">Geoportal</p><br />";
		newHTML += "<div id=\"inner-content\">";
		newHTML += "<p style=\"font-size: 18px;\">" + action + "</p>";

		if (waiting) {
			newHTML += "<img alt=\"D4Science Geoportal Loading Icon\" src=\"https://data.d4science.org/shub/E_a2Y1N2ZIaUhCVlE5R0JXNjJhVXVsTlNyNVJta2ZKZVFMaG52N2gxZm05VWJOb2RFTVBpa0pyV1hsUlg2WXJSTw==\"><br />";
		}
		
		newHTML += "<br/><p id=\"message\">" + message + "</p>";
		newHTML += "</div></div></body></html>";

		return newHTML;
	}
	
	
	/**
	 * Sets the HTML message.
	 *
	 * @param action  the action
	 * @param message the message
	 * @param waiting the waiting
	 * @return the string
	 */
	public static String getErrorPage(String action, String message) {

		String newHTML = "<html>\n"
				+ "\n"
				+ "  <head>\n"
				+ "    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n"
				+ "    <style>\n"
				+ "      html,\n"
				+ "      body {\n"
				+ "        margin: 10px;\n"
				+ "        width: 100%;\n"
				+ "        height: 100%;\n"
				+ "        display: table\n"
				+ "      }\n"
				+ "\n"
				+ "      #content {\n"
				+ "        position: absolute;\n"
				+ "        left: 50%;\n"
				+ "        top: 50%;\n"
				+ "        -webkit-transform: translate(-50%, -50%);\n"
				+ "        transform: translate(-50%, -50%);\n"
				+ "        text-align: center;\n"
				+ "      }\n"
				+ "\n"
				+ "      #title-geo {\n"
				+ "        font-weight: bold;\n"
				+ "        color: black;\n"
				+ "        font-size: 26px;\n"
				+ "      }\n"
				+ "\n"
				+ "      #message {\n"
				+ "        color: gray;\n"
				+ "        font-size: 24px;\n"
				+ "      }\n"
				+ "\n"
				+ "    </style>\n"
				+ "</head>";
		
		newHTML += "<img alt=\"D4Science Logo\" src=\"https://services.d4science.org/image/layout_set_logo?img_id=32727\"><br />";

		newHTML += "<div id=\"content\">";
		newHTML += "<p id=\"title-geo\">Geoportal Exporter</p><br />";
		newHTML += "<p style=\"font-size: 18px;\">" + action + "</p>";
		newHTML += "<br/><p id=\"message\">" + message + "</p>";
		newHTML += "</div></body></html>";

		return newHTML;
	}

}
