/**
 *
 */

package org.gcube.datatransfer.resolver.gis.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * The Class GetResponseRecordFilter.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it Jun 16, 2016
 */
public class GetResponseRecordFilter {

	public static Logger logger = LoggerFactory.getLogger(GetResponseRecordFilter.class);

	/**
	 * Delete summary record.
	 *
	 * @param doc            the doc
	 * @param identifier            the identifier
	 * @return true, if successful
	 */
	private static boolean deleteSummaryRecord(Document doc, String identifier) {

		// <csw:SummaryRecord> list
		NodeList nodes = doc.getElementsByTagName("csw:SummaryRecord");
		logger.trace("SummaryRecord are: " + nodes.getLength());
		for (int i = 0; i < nodes.getLength(); i++) {
			Element summaryRecord = (Element) nodes.item(i);
			// <dc:identifier>
			Element id = (Element) summaryRecord.getElementsByTagName("dc:identifier").item(0);
			String idValue = id.getTextContent();
			logger.trace("Summary dc:identifier is: " + idValue);
			if (idValue.equals(identifier)) {
				summaryRecord.getParentNode().removeChild(summaryRecord);
				logger.trace("Removed child " + idValue);
				return true;
			}
		}
		return false;
	}


	/**
	 * Removes the summary ids by list ids.
	 *
	 * @param getRecordsResponse the get records response
	 * @param idsToRemove the ids to remove
	 * @return the input stream
	 * @throws IOException Signals that an I/O exception has occurred.
	 */
	public static InputStream removeSummaryIdsByListIds(InputStream getRecordsResponse, List<String> idsToRemove) throws IOException {

		try {
			// logger.trace("getRecordsResponse is: "+IOUtils.toString(getRecordsResponse));
			BufferedInputStream bis = new BufferedInputStream(getRecordsResponse);
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setValidating(false);
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(bis);
			int removed = 0;
			for (String identifier : idsToRemove) {
				if(deleteSummaryRecord(doc, identifier))
					removed++;
			}
			logger.debug("Removed "+removed +" node/s");

			NodeList nodeList = doc.getElementsByTagName("csw:SearchResults");
			if(nodeList!=null && nodeList.item(0)!=null){
				Node nd = nodeList.item(0);
				// update staff attribute
				NamedNodeMap attr = nd.getAttributes();
				Node numberOfRecordsMatched = attr.getNamedItem("numberOfRecordsMatched");
				Node numberOfRecordsReturned = attr.getNamedItem("numberOfRecordsReturned");
				logger.trace("Old numberOfRecordsMatched: "+numberOfRecordsMatched.getTextContent());
				logger.trace("Old numberOfRecordsReturned: "+numberOfRecordsReturned.getTextContent());
				try{
					int oldValueM = Integer.parseInt(numberOfRecordsMatched.getTextContent());
					int oldValueR = Integer.parseInt(numberOfRecordsReturned.getTextContent());
					int newValueM = oldValueM-removed;
					int newValueR = oldValueR-removed;
					logger.trace("Updating numberOfRecordsMatched at: "+newValueM);
					logger.trace("Updating numberOfRecordsReturned at: "+newValueR);
					numberOfRecordsMatched.setTextContent(newValueM+"");
					numberOfRecordsReturned.setTextContent(newValueR+"");
				}catch (Exception e) {
					logger.warn("An error occurred during attribe numberOfRecordsMatched updating, skipping operation");
				}
			}

			return documentToInputStream(doc);
		}
		catch (Exception e) {
			logger.error("An error occurred during removing IDS by List: ", e);
			return getRecordsResponse;
		}
	}


	/**
	 * Document to input stream.
	 *
	 * @param xml the xml
	 * @return the input stream
	 * @throws Exception the exception
	 */
	private static final InputStream documentToInputStream(Document xml) throws Exception {
		Transformer tf = TransformerFactory.newInstance().newTransformer();
		tf.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		tf.setOutputProperty(OutputKeys.INDENT, "yes");
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		StreamResult outputTarget = new StreamResult(outputStream);
		tf.transform(new DOMSource(xml), outputTarget);
		return new ByteArrayInputStream(outputStream.toByteArray());
//		return out.toString();
	}


	public static void main(String[] args) {

		File file = new File("GetResponseRecords.xml");
		List<String> idsToRemove = new ArrayList<String>();
		idsToRemove.add("fao-species-map-hef");
		idsToRemove.add("fao-species-map-hea");
		idsToRemove.add("fao-species-map-crb");
		idsToRemove.add("fao-fsa-map-41.1.2");
		try {
			InputStream is = GetResponseRecordFilter.removeSummaryIdsByListIds(new FileInputStream(file), idsToRemove);

			System.out.println(IOUtils.toString(is));
		}
		catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
