/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.thredds;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.data.transfer.plugins.thredds.ApplicationConfigurationRetriever;
import org.gcube.data.transfer.plugins.thredds.LocalConfiguration;
import org.gcube.data.transfer.plugins.thredds.TomcatSecurityHandler;
import org.gcube.data.transfer.plugins.thredds.XMLCatalogHandler;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ThreddsInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(ThreddsInstanceManager.class);
    private static final Object $LOCK = new Object[0];
    private final Object $lock = new Object[0];
    protected static ThreddsInstanceManager instance = null;
    protected static final ConcurrentSkipListSet<String> checkedTokens = new ConcurrentSkipListSet();
    protected ThreddsInfo cachedInfo = null;
    protected ExecutorService executor = Executors.newSingleThreadExecutor();
    protected DataTransferContext ctx = null;
    protected ApplicationConfiguration threddsConfig = null;
    protected String threddsAdminUser;
    protected String threddsAdminPassword;
    protected String threddsPersistenceLocation;
    protected String threddsVersionString;
    protected String currentHostname;
    protected String currentGHNId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreddsInstanceManager get(DataTransferContext ctx) {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new ThreddsInstanceManager(ctx);
            }
            return instance;
        }
    }

    protected ThreddsInstanceManager(DataTransferContext context) {
        log.warn("Instance Creation. Should happen only once. Loading information from context..");
        this.ctx = context;
        try {
            log.info("Loading proxy configuration..");
            this.currentHostname = this.ctx.getCtx().configuration().proxyAddress().hostname();
            if (this.currentHostname == null || this.currentHostname.isEmpty()) {
                throw new Exception("Proxy is : " + this.currentHostname);
            }
        }
        catch (Exception e) {
            log.info("Unable to get proxy..", (Throwable)e);
            this.currentHostname = this.ctx.getCtx().container().configuration().hostname();
        }
        log.info("Hostname to be used is " + this.currentHostname);
        this.currentGHNId = this.ctx.getCtx().container().id();
        String tomcatSecurityPath = System.getenv("WEB_CONTAINER_HOME") + "/conf/tomcat-users.xml";
        log.info("Loading security from {} ", (Object)tomcatSecurityPath);
        try {
            TomcatSecurityHandler tomcatHandler = new TomcatSecurityHandler(tomcatSecurityPath);
            this.threddsAdminUser = tomcatHandler.getThreddsAdminUser();
            this.threddsAdminPassword = tomcatHandler.getThreddsAdminPassword();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse security file " + tomcatSecurityPath, e);
        }
        log.info("Looking for Thredds Application Configuration.. ");
        Future<ApplicationConfiguration> future = this.executor.submit(new ApplicationConfigurationRetriever(this.ctx));
        try {
            this.threddsConfig = future.get();
            if (this.threddsConfig == null) {
                throw new Exception("Returned Application Configuration is null");
            }
            this.threddsPersistenceLocation = this.threddsConfig.persistence().location();
            this.threddsVersionString = this.threddsConfig.version();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find Application Configuration for thredds.", e);
        }
    }

    public synchronized ThreddsInfo getInfo() throws SAXException, IOException {
        if (this.cachedInfo == null) {
            log.info("Loading ThreddsInfo..");
            String threddsContentRoot = this.getContentRoot();
            log.debug("Found content root at {} ", (Object)threddsContentRoot);
            ThreddsInfo info = new ThreddsInfo();
            info.setHostname(this.currentHostname);
            info.setGhnId(this.currentGHNId);
            info.setLocalBasePath(this.threddsPersistenceLocation);
            info.setInstanceBaseUrl("http://" + info.getHostname() + "/thredds");
            String mainCatalogPath = threddsContentRoot + "/catalog.xml";
            log.info("Loading catalog information from {} ", (Object)mainCatalogPath);
            XMLCatalogHandler handler = new XMLCatalogHandler(new File(mainCatalogPath));
            info.setCatalog(handler.getCatalogDescriptor());
            info.setAdminPassword(this.threddsAdminPassword);
            info.setAdminUser(this.threddsAdminUser);
            String[] splittedVersion = this.threddsVersionString.split("\\.");
            info.setVersion(Integer.parseInt(splittedVersion[0]));
            info.setMinor(Integer.parseInt(splittedVersion[1]));
            info.setRevision(Integer.parseInt(splittedVersion[2]));
            log.info("Loaded ThreddsInfo is {} ", (Object)info);
            this.cachedInfo = info;
        }
        return this.cachedInfo;
    }

    public synchronized void clearCache() {
        log.debug("Clearing cache..");
        this.cachedInfo = null;
    }

    public String getCurrentHostname() {
        return this.currentHostname;
    }

    public String getMainCatalogFile() {
        return this.getContentRoot() + "/catalog.xml";
    }

    public String getContentRoot() {
        return this.threddsPersistenceLocation;
    }

    public XMLCatalogHandler mainCatalogHandler() throws SAXException, IOException, Exception {
        return new XMLCatalogHandler(new File(this.getMainCatalogFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePublishedInfo() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            String token = SecurityTokenProvider.instance.get();
            log.info("Checking IS with token {} ", (Object)token);
            if (!checkedTokens.contains(token)) {
                checkedTokens.add(token);
                this.getInfo();
                String currentHostname = this.cachedInfo.getHostname();
                log.info("Checking IS Information, host is {}", (Object)currentHostname);
                List<ServiceEndpoint> currentEndpoints = ThreddsInstanceManager.queryForServiceEndpoints(LocalConfiguration.getProperty("th.se.category"), LocalConfiguration.getProperty("th.se.platform"));
                ServiceEndpoint toCheck = null;
                log.debug("Found {} Service Endpoints, checking by hostname {} ", (Object)currentEndpoints.size());
                for (ServiceEndpoint se : currentEndpoints) {
                    String host = se.profile().runtime().hostedOn();
                    try {
                        if (!ThreddsInstanceManager.isSameHost(host, currentHostname)) continue;
                        toCheck = se;
                        break;
                    }
                    catch (Throwable t) {
                        log.warn("Unable to check Host {} ", (Object)host, (Object)t);
                    }
                }
                if (toCheck == null) {
                    log.info("ServiceEndpoint not found, going to create one..");
                    ServiceEndpoint newSE = this.getNewServiceEndpoint();
                    ThreddsInstanceManager.updateAndWait(newSE, true);
                } else {
                    boolean updateSE = true;
                    String adminAPName = LocalConfiguration.getProperty("th.se.remoteManagement.access");
                    log.debug("Looking for Access Point {} ", (Object)adminAPName);
                    Group existentAP = toCheck.profile().accessPoints();
                    boolean addAccessPoint = true;
                    for (ServiceEndpoint.AccessPoint ap : existentAP) {
                        if (!ap.name().equals(adminAPName)) continue;
                        addAccessPoint = false;
                        String pwd = ThreddsInstanceManager.decryptString(ap.password());
                        if (ap.username().equalsIgnoreCase(this.threddsAdminUser) && pwd.equalsIgnoreCase(this.threddsAdminPassword)) {
                            log.info("ServiceEndopint is up to date.");
                            updateSE = false;
                            continue;
                        }
                        ap.credentials(this.threddsAdminPassword, this.threddsAdminUser);
                    }
                    if (updateSE) {
                        log.debug("Need to update SE... ");
                        if (addAccessPoint) {
                            log.debug("Access point {} not found. Adding it.. ", (Object)adminAPName);
                            existentAP.add((Object)this.getNewAccessPoint());
                        }
                        ServiceEndpoint updated = ThreddsInstanceManager.updateAndWait(toCheck, false);
                        log.info("Updated {} ", (Object)updated);
                    }
                }
            } else {
                log.info("Skipping token {}, already checked.", (Object)token);
            }
        }
    }

    private static String registerServiceEndpoint(ServiceEndpoint toRegister) {
        RegistryPublisher rp = RegistryPublisherFactory.create();
        Resource r = rp.create((Resource)toRegister);
        return r.id();
    }

    public static ServiceEndpoint update(ServiceEndpoint toUpdate) {
        RegistryPublisher rp = RegistryPublisherFactory.create();
        return (ServiceEndpoint)rp.update((Resource)toUpdate);
    }

    private ServiceEndpoint getNewServiceEndpoint() {
        ServiceEndpoint toReturn = new ServiceEndpoint();
        ServiceEndpoint.Profile profile = toReturn.newProfile();
        profile.category(LocalConfiguration.getProperty("th.se.category"));
        profile.name("Thredds on " + this.cachedInfo.getHostname());
        profile.description("Thredds on " + this.cachedInfo.getHostname());
        Platform platform = profile.newPlatform();
        platform.version((short)this.cachedInfo.getVersion());
        platform.minorVersion((short)this.cachedInfo.getMinor());
        platform.revisionVersion((short)this.cachedInfo.getRevision());
        platform.buildVersion((short)this.cachedInfo.getBuild());
        platform.name(LocalConfiguration.getProperty("th.se.platform"));
        ServiceEndpoint.Runtime runtime = profile.newRuntime();
        runtime.ghnId(this.cachedInfo.getGhnId());
        runtime.hostedOn(this.cachedInfo.getHostname());
        runtime.status("READY");
        profile.accessPoints().add((Object)this.getNewAccessPoint());
        return toReturn;
    }

    private static ServiceEndpoint updateAndWait(ServiceEndpoint toUpdate, boolean isNew) {
        boolean equals = true;
        boolean timeoutReached = false;
        long timeout = LocalConfiguration.getTTL("is.registration.timeout");
        log.info("Going to register {}. Timeout is {} ", (Object)toUpdate.id(), (Object)timeout);
        String toUpdateString = ThreddsInstanceManager.marshal((Resource)toUpdate);
        log.debug("Serialized resource is {} ", (Object)toUpdateString);
        if (isNew) {
            ThreddsInstanceManager.registerServiceEndpoint(toUpdate);
        } else {
            ThreddsInstanceManager.update(toUpdate);
        }
        long updateTime = System.currentTimeMillis();
        String updatedString = null;
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List<String> byIdResults = ThreddsInstanceManager.queryById(toUpdate.id());
            if (byIdResults.isEmpty()) {
                equals = false;
            } else {
                updatedString = byIdResults.get(0);
                equals = toUpdateString.equals(updatedString);
            }
            boolean bl = timeoutReached = System.currentTimeMillis() - updateTime > timeout;
        } while (equals && !timeoutReached);
        if (timeoutReached) {
            log.warn("Timeout reached. Check if {} is updated ", (Object)toUpdate.id());
        }
        return ThreddsInstanceManager.querySEById(toUpdate.id());
    }

    public static List<String> queryById(String id) {
        DiscoveryClient client = ICFactory.client();
        String queryString = "declare namespace ic = 'http://gcube-system.org/namespaces/informationsystem/registry'; for $profiles in collection('/db/Profiles')//Document/Data/ic:Profile/Resource where $profiles/ID/text() eq '" + id + "' return $profiles";
        return client.submit((Query)new QueryBox(queryString));
    }

    public static ServiceEndpoint querySEById(String id) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/ID/text() eq '" + id + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return (ServiceEndpoint)client.submit((Query)query).get(0);
    }

    public static String marshal(Resource res) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Resources.marshal((Object)res, (OutputStream)stream);
        return stream.toString();
    }

    private ServiceEndpoint.AccessPoint getNewAccessPoint() {
        ServiceEndpoint.AccessPoint toReturn = new ServiceEndpoint.AccessPoint();
        toReturn.credentials(ThreddsInstanceManager.encrypt(this.threddsAdminPassword), this.threddsAdminUser);
        toReturn.description("Thredds Remote Management credentials");
        toReturn.name(LocalConfiguration.getProperty("th.se.remoteManagement.access"));
        toReturn.address("https://" + this.getCurrentHostname() + "/thredds/admin/debug?catalogs/reinit");
        return toReturn;
    }

    static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt.", e);
        }
    }

    static String encrypt(String toEncrypt) {
        try {
            return StringEncrypter.getEncrypter().encrypt(toEncrypt, new Key[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to Encrypt.", e);
        }
    }

    static List<ServiceEndpoint> queryForServiceEndpoints(String category, String platformName) {
        log.debug("Querying for Service Endpoints [category : {} , platformName : {}]", (Object)category, (Object)platformName);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platformName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    static boolean isSameHost(String toTestHost, String toLookForHost) throws UnknownHostException {
        log.debug("Checking same hosts {},{}", (Object)toTestHost, (Object)toLookForHost);
        if (toTestHost.equalsIgnoreCase(toLookForHost)) {
            return true;
        }
        InetAddress[] toTestHostIPs = InetAddress.getAllByName(toTestHost);
        InetAddress[] toLookForHostIPs = InetAddress.getAllByName(toLookForHost);
        log.debug("Checking IPs. ToTestIPs {}, ToLookForIPs {} ", (Object)toTestHostIPs, (Object)toLookForHostIPs);
        for (InetAddress toTestIP : toTestHostIPs) {
            for (InetAddress toLookForIP : toLookForHostIPs) {
                if (!toTestIP.equals(toLookForIP)) continue;
                return true;
            }
        }
        log.debug("HOSTS are different.");
        return false;
    }
}

