/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.shared;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.scheduler.library.BinderLibrary;
import org.gcube.datatransfer.scheduler.library.ManagementLibrary;
import org.gcube.datatransfer.scheduler.library.SchedulerLibrary;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.gcube.datatransfer.scheduler.library.proxies.Proxies;
import org.w3c.dom.Element;

public class SchedulerProxy {
    SchedulerLibrary schedulerLibrary = null;

    public void retrieveSchedulerLibrary(String scope, String ResourceName) {
        ScopeProvider.instance.set(scope);
        BinderLibrary binderLibrary = null;
        try {
            binderLibrary = (BinderLibrary)Proxies.transferSchedulerBinder().at("pcitgt1012.cern.ch", 8080).withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerBinder(..).at(..)\n" + e);
        }
        EndpointReferenceType schedulerEpr = null;
        try {
            schedulerEpr = binderLibrary.bind(ResourceName);
        }
        catch (Exception e) {
            System.err.print("exception when calling binderLibrary.bind(..).. \n" + e);
        }
        W3CEndpointReferenceBuilder w3cenpointBuilder = new W3CEndpointReferenceBuilder();
        try {
            w3cenpointBuilder.address(schedulerEpr.getAddress().toString());
            w3cenpointBuilder.referenceParameter((Element)schedulerEpr.getProperties().get(0));
        }
        catch (Exception e) {
            System.err.print("exception when creating the W3CEndpointReferenceBuilder\n" + e);
        }
        try {
            this.schedulerLibrary = (SchedulerLibrary)Proxies.transferScheduler().at(w3cenpointBuilder.build()).withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferScheduler(..).at(..)\n" + e);
        }
    }

    public CallingSchedulerResult cancel(String transferId, boolean force) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.cancelTransfer(transferId, force);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.cancelTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public CallingSchedulerResult monitor(String transferId) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.monitorTransfer(transferId);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.monitorTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public CallingSchedulerResult getOutcomes(String transferId) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.getOutcomesOfTransfer(transferId);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.getOutcomesOfTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public String schedule(SchedulerObj schedulerObj, String scope, String resourceName) {
        Calendar tmpCalendar;
        Date tmpDate;
        SimpleDateFormat formatter;
        if (schedulerObj.getDataSourceId() != null) {
            String[] sourcesArray;
            String name = null;
            String description = null;
            String host = null;
            String user = null;
            String pass = null;
            String result = this.getObjectsFromIS("DataSource", resourceName, scope);
            if (result == null) {
                System.out.println("SchedulerProxy - schedule - getObjectsFromIS(DataSources) - result=null");
                return null;
            }
            String[] stringArray = sourcesArray = result.split("\n");
            int n = sourcesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tmp = stringArray[n2];
                String[] partsOfInfo = tmp.split("--");
                if (partsOfInfo[0].compareTo(schedulerObj.getDataSourceId()) == 0) {
                    name = partsOfInfo[1];
                    description = partsOfInfo[2];
                    host = partsOfInfo[3];
                    user = partsOfInfo[4];
                    pass = partsOfInfo[5];
                    break;
                }
                ++n2;
            }
            if (host == null || name == null) {
                System.out.println("SchedulerProxy - schedule - cannot find the datasource in IS");
                return null;
            }
            String[] inputURIS = schedulerObj.getInputUrls();
            String header = "";
            if (name.startsWith("FTP")) {
                if (user == null || pass == null) {
                    System.out.println("GET FILE LIST OF DATASOURCE - FTP datasource does not have 'username' or/and 'password' in IS");
                    return null;
                }
                String[] partsOfEndpoint = host.split("//");
                if (partsOfEndpoint.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                header = String.valueOf(partsOfEndpoint[0]) + "//" + user + ":" + pass + "@" + partsOfEndpoint[1];
                if (!header.endsWith("/")) {
                    header = String.valueOf(header) + "/";
                }
            } else if (name.startsWith("HTTP") || name.startsWith("HTTPS")) {
                if (user == null || pass == null) {
                    header = host;
                    if (!header.endsWith("/")) {
                        header = String.valueOf(header) + "/";
                    }
                } else {
                    String[] partsOfEndpoint = host.split("//");
                    if (partsOfEndpoint.length < 2) {
                        System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                        return null;
                    }
                    header = String.valueOf(partsOfEndpoint[0]) + "//" + user + ":" + pass + "@" + partsOfEndpoint[1];
                    if (!header.endsWith("/")) {
                        header = String.valueOf(header) + "/";
                    }
                }
            }
            int num = 0;
            String[] stringArray2 = inputURIS;
            int n3 = inputURIS.length;
            int n4 = 0;
            while (n4 < n3) {
                String tmp = stringArray2[n4];
                inputURIS[num] = String.valueOf(header) + tmp + "/";
                ++num;
                ++n4;
            }
            schedulerObj.setInputUrls(inputURIS);
        }
        if (schedulerObj.getTypeOfSchedule().getManuallyScheduled() != null) {
            formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            tmpDate = null;
            String instanceString = schedulerObj.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
            try {
                tmpDate = formatter.parse(instanceString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tmpCalendar = Calendar.getInstance();
            tmpCalendar.setTime(tmpDate);
            schedulerObj.getTypeOfSchedule().getManuallyScheduled().setCalendar(tmpCalendar);
        } else if (schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
            formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            tmpDate = null;
            String startInstanceString = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
            tmpCalendar = Calendar.getInstance();
            if (startInstanceString.compareToIgnoreCase("now") != 0) {
                try {
                    tmpDate = formatter.parse(startInstanceString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmpCalendar.setTime(tmpDate);
            }
            schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstance(tmpCalendar);
        }
        String transferId = null;
        try {
            transferId = this.schedulerLibrary.scheduleTransfer(schedulerObj);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.localFileBasedTransfer(..) \n" + e);
        }
        return transferId;
    }

    public CallingManagementResult getTransfers(String resourceName, String scope) {
        ScopeProvider.instance.set(scope);
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        CallingManagementResult callingManagementResult = null;
        try {
            callingManagementResult = managementLibrary.getAllTransfersInfo(resourceName);
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n" + e);
        }
        return callingManagementResult;
    }

    public String getObjectsFromIS(String type, String resourceName, String scope) {
        ScopeProvider.instance.set(scope);
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        String typeOfObj = type;
        String result = null;
        try {
            result = managementLibrary.getObjectsFromIS(typeOfObj);
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n" + e);
        }
        return result;
    }
}

