package org.gcube.datatransfer.portlets.user.shared;

import static org.gcube.datatransfer.scheduler.library.proxies.Proxies.transferScheduler;
import static org.gcube.datatransfer.scheduler.library.proxies.Proxies.transferSchedulerBinder;
import static org.gcube.datatransfer.scheduler.library.proxies.Proxies.transferSchedulerManagement;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.scheduler.library.BinderLibrary;
import org.gcube.datatransfer.scheduler.library.ManagementLibrary;
import org.gcube.datatransfer.scheduler.library.SchedulerLibrary;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.w3c.dom.Element;


public class SchedulerProxy {

	SchedulerLibrary schedulerLibrary = null;
	
	public void retrieveSchedulerLibrary(String scope, String ResourceName){
		ScopeProvider.instance.set(scope);
		//in case of first visit .. 
		//binderLibrary
		BinderLibrary binderLibrary = null;		
		try {		
			binderLibrary = transferSchedulerBinder().at("pcitgt1012.cern.ch", 8080).withTimeout(10, TimeUnit.SECONDS).build();		 
		}catch (Exception e) {
			System.err.print("exception when calling transferSchedulerBinder(..).at(..)\n"+e);
		}
		//Getting Scheduler EndpointReferenceType
		EndpointReferenceType schedulerEpr = null;
		try{
			schedulerEpr=binderLibrary.bind(ResourceName);
		}catch (Exception e) {
			System.err.print("exception when calling binderLibrary.bind(..).. \n"+e);
		}
		//in case of having visited before we go directly to the stateful by taking the epr from IS
		
		//schedulerLibrary		
		@SuppressWarnings("restriction")
		W3CEndpointReferenceBuilder w3cenpointBuilder = new W3CEndpointReferenceBuilder();
		try{
			w3cenpointBuilder.address(schedulerEpr.getAddress().toString());
			w3cenpointBuilder.referenceParameter((Element)schedulerEpr.getProperties().get(0));
		}catch (Exception e){
			System.err.print("exception when creating the W3CEndpointReferenceBuilder\n"+e);
		}		
		try {
			schedulerLibrary = transferScheduler().at(w3cenpointBuilder.build()).withTimeout(10, TimeUnit.SECONDS).build();
		}catch (Exception e) {
			System.err.print("exception when calling transferScheduler(..).at(..)\n"+e);
		}
	}
	
	
	//Cancel
	public CallingSchedulerResult cancel(String transferId, boolean force){
		CallingSchedulerResult callingSchedulerResult=new CallingSchedulerResult();

		try{
			callingSchedulerResult = schedulerLibrary.cancelTransfer(transferId, force);
		}catch (Exception e) {
			System.err.print("exception when calling schedulerLibrary.cancelTransfer(..) \n"+e);
		}
		return callingSchedulerResult;

	}

	//Monitor
	public CallingSchedulerResult monitor(String transferId){
		CallingSchedulerResult callingSchedulerResult=new CallingSchedulerResult();

		try{
			callingSchedulerResult = schedulerLibrary.monitorTransfer(transferId);
		}catch (Exception e) {
			System.err.print("exception when calling schedulerLibrary.monitorTransfer(..) \n"+e);
		}
		return callingSchedulerResult;
	}


	//GetOutcomes
	public CallingSchedulerResult getOutcomes(String transferId){
		CallingSchedulerResult callingSchedulerResult=new CallingSchedulerResult();
		try{
			callingSchedulerResult = schedulerLibrary.getOutcomesOfTransfer(transferId);
		}catch (Exception e) {
			System.err.print("exception when calling schedulerLibrary.getOutcomesOfTransfer(..) \n"+e);
		}
		return callingSchedulerResult;
	}

	//schedule
	public String schedule(SchedulerObj schedulerObj, String scope, String resourceName){
		//we check if there is a need for adding the credentials in the URIS
		//it is not a safe way for now ... !!
		// ALTHOUGH WE DO HAVE safety between client - portlet.. 
		// from portlet to scheduler and from scheduler to agent we need security .. 
		if(schedulerObj.getDataSourceId()!=null){
			String name=null;
			String description=null;
			String host=null;
			String user=null;
			String pass=null;
			
			String result=getObjectsFromIS("DataSource", resourceName,scope);
			if (result==null) {
				System.out.println("SchedulerProxy - schedule - getObjectsFromIS(DataSources) - result=null");
				return null;
			}
			String[] sourcesArray=result.split("\n");
			for(String tmp:sourcesArray){
				//tmp contains: resultIdOfIS--name--description--endpoint--username--password--propertyFolders
				String[] partsOfInfo=tmp.split("--");
				if(partsOfInfo[0].compareTo(schedulerObj.getDataSourceId())==0){
					name=partsOfInfo[1];
					description = partsOfInfo[2];
					host=partsOfInfo[3];
					user=partsOfInfo[4];
					pass=partsOfInfo[5];
					break;
				}
			}
			if(host==null|| name==null){
				System.out.println("SchedulerProxy - schedule - cannot find the datasource in IS");
				return null;
			}
						
			String[] inputURIS = schedulerObj.getInputUrls();
			String header="";
			if(name.startsWith("FTP")){
				if(user==null || pass==null){
					System.out.println("GET FILE LIST OF DATASOURCE - FTP datasource does not have 'username' or/and 'password' in IS");
					return null;
				}
				String[] partsOfEndpoint=host.split("//");
				if(partsOfEndpoint.length<2){
					System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
					return null;
				}
				//header = "ftp://andrea:bilico1980@pcd4science3.cern.ch/";
				header=partsOfEndpoint[0]+"//"+user+":"+pass+"@"+partsOfEndpoint[1];
				if(!header.endsWith("/"))header=header+"/";
			}
			else if(name.startsWith("HTTP")||name.startsWith("HTTPS")){
				if(user==null || pass==null){
					header=host;
					if(!header.endsWith("/"))header=header+"/";
				}
				else {
					String[] partsOfEndpoint=host.split("//");
					if(partsOfEndpoint.length<2){
						System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
						return null;
					}
					//header = "http://username:password@hostname/";
					header=partsOfEndpoint[0]+"//"+user+":"+pass+"@"+partsOfEndpoint[1];
					if(!header.endsWith("/"))header=header+"/";
				}		
			}
			
			int num=0;
			for(String tmp:inputURIS){				
				inputURIS[num]=header+tmp+"/";
				num++;
			}
			schedulerObj.setInputUrls(inputURIS);
		}

		if(schedulerObj.getTypeOfSchedule().getManuallyScheduled()!=null){
			DateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
			Date tmpDate=null;
			String instanceString= schedulerObj.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
			//System.out.println("given string:\n"+instanceString);
			try {
				tmpDate = formatter.parse(instanceString);
			} catch (Exception e) {
				e.printStackTrace();
			}
			Calendar tmpCalendar = Calendar.getInstance();
			tmpCalendar.setTime(tmpDate);
			//System.out.println("given date:\nYEAR="+tmpCalendar.get(Calendar.YEAR)+"\nMONTH="+tmpCalendar.get(Calendar.MONTH)+"\nDAY_OF_MONTH="+tmpCalendar.get(Calendar.DAY_OF_MONTH)+"\nHOUR="+tmpCalendar.get(Calendar.HOUR_OF_DAY)+"\nMINUTE="+tmpCalendar.get(Calendar.MINUTE));

			schedulerObj.getTypeOfSchedule().getManuallyScheduled().setCalendar(tmpCalendar);
		}
		else if(schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled()!=null){
			DateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
			Date tmpDate=null;
			String startInstanceString= schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
			//System.out.println("given startInstanceString:\n"+startInstanceString);

			Calendar tmpCalendar = Calendar.getInstance();
			if(startInstanceString.compareToIgnoreCase("now")!=0){
				try {
					tmpDate = formatter.parse(startInstanceString);
				} catch (Exception e) {
					e.printStackTrace();
				}
				tmpCalendar.setTime(tmpDate);
				//System.out.println("given startInstance:\nYEAR="+tmpCalendar.get(Calendar.YEAR)+"\nMONTH="+tmpCalendar.get(Calendar.MONTH)+"\nDAY_OF_MONTH="+tmpCalendar.get(Calendar.DAY_OF_MONTH)+"\nHOUR="+tmpCalendar.get(Calendar.HOUR_OF_DAY)+"\nMINUTE="+tmpCalendar.get(Calendar.MINUTE));
			}
			else{
				//System.out.println("given startInstance:\nYEAR="+tmpCalendar.get(Calendar.YEAR)+"\nMONTH="+tmpCalendar.get(Calendar.MONTH)+"\nDAY_OF_MONTH="+tmpCalendar.get(Calendar.DAY_OF_MONTH)+"\nHOUR="+tmpCalendar.get(Calendar.HOUR_OF_DAY)+"\nMINUTE="+tmpCalendar.get(Calendar.MINUTE));
			}
			schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstance(tmpCalendar);
		}

		String transferId=null;
		try{
			transferId = schedulerLibrary.scheduleTransfer(schedulerObj);
		}catch (Exception e) {
			System.err.print("exception when calling schedulerLibrary.localFileBasedTransfer(..) \n"+e);
		}
	
		return transferId;
	}

	public CallingManagementResult getTransfers(String resourceName, String scope){
		ScopeProvider.instance.set(scope);
		//Management Library
		ManagementLibrary managementLibrary = null;		
		try {		
			managementLibrary = transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();		 
		}catch (Exception e) {
			System.err.print("exception when calling transferSchedulerManagement().build()\n"+e);
		}
		
		CallingManagementResult callingManagementResult= null;
		try{
			callingManagementResult=managementLibrary.getAllTransfersInfo(resourceName); 
		}catch (Exception e) {
			System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n"+e);
		}
		return callingManagementResult;
	}	
	
	public String getObjectsFromIS(String type , String resourceName, String scope){
		ScopeProvider.instance.set(scope);
		//Management Library
		ManagementLibrary managementLibrary = null;		
		try {		
			managementLibrary = transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();		 
		}catch (Exception e) {
			System.err.print("exception when calling transferSchedulerManagement().build()\n"+e);
		}
		
		final String typeOfObj=type;
		String result= null;
		try{
			result=managementLibrary.getObjectsFromIS(typeOfObj); 
		}catch (Exception e) {
			System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n"+e);
		}
		return result;
	}
}
