/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.check;

import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.handler.TransferHandler;
import org.gcube.datatransfer.scheduler.impl.newhandler.ProduceTransfer;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.impl.utils.Utils;

public class CheckDBForTransfers {
    public DataTransferDBManager dbManager = null;
    public SchedulerResource resource = null;
    public long checkForTransfersIntervalMS;
    public List<Transfer> transfers = null;
    GCUBELog logger = new GCUBELog(CheckDBForTransfers.class);
    private boolean isMessagingEnabled;

    public CheckDBForTransfers(GCUBEWSResource ws, List<Transfer> transfers) {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.resource = (SchedulerResource)ws;
        this.transfers = transfers;
        this.isMessagingEnabled = ServiceContext.getContext().isMessagingEnabled();
    }

    public void check() {
        for (Transfer obj : this.transfers) {
            TransferHandler transferHandler;
            ProduceTransfer produceTransfer;
            long leftMillis;
            Calendar calendarComp;
            TypeOfSchedule typeOfSchedule = null;
            String idTypeOfSchedule = null;
            try {
                idTypeOfSchedule = obj.getTypeOfScheduleId();
                typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
            }
            catch (Exception e) {
                this.logger.error((Object)"CheckForTransfers -- Exception in retrieving the typeOfSchedule");
                e.printStackTrace();
            }
            String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
            String idManuallyScheduled = typeOfSchedule.getManuallyScheduledId();
            if (typeOfSchedule.isDirectedScheduled()) {
                this.logger.debug((Object)("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Direct Transfer) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus()));
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                }
                catch (Exception e) {
                    this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId()));
                    e.printStackTrace();
                }
                if (this.isMessagingEnabled) {
                    ProduceTransfer produceTransfer2 = new ProduceTransfer(obj.getTransferId(), this.resource, false);
                    produceTransfer2.start();
                    continue;
                }
                TransferHandler transferHandler2 = new TransferHandler(obj.getTransferId(), this.resource, false);
                transferHandler2.start();
                continue;
            }
            if (idManuallyScheduled != null) {
                ManuallyScheduled manuallyScheduled = (ManuallyScheduled)this.dbManager.getPersistenceManager().getObjectById(ManuallyScheduled.class, (Object)idManuallyScheduled);
                Calendar calendarTmp = Utils.getCalendarBasedOnStringDate(manuallyScheduled.getCalendarString());
                if (calendarTmp == null) {
                    this.logger.debug((Object)("\nCheckForTransfers - calendarTmp(from String Format) is null - we skip this transfer with id=" + obj.getTransferId() + " and we turn its status to FAILED"));
                    try {
                        this.dbManager.updateTransferStatus(obj.getTransferId(), "FAILED");
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"CheckDBForTransfers - Exception in changing the transfer status\n");
                        e.printStackTrace();
                    }
                    continue;
                }
                calendarComp = Utils.setCalendarComp(calendarTmp);
                leftMillis = calendarTmp.getTimeInMillis() - calendarComp.getTimeInMillis();
                if (leftMillis >= 60000L) continue;
                this.logger.debug((Object)("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Manually Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus()));
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                }
                catch (Exception e) {
                    this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId()));
                    e.printStackTrace();
                }
                if (this.isMessagingEnabled) {
                    produceTransfer = new ProduceTransfer(obj.getTransferId(), this.resource, false);
                    produceTransfer.start();
                    continue;
                }
                transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                transferHandler.start();
                continue;
            }
            if (periodicallyScheduledId == null) continue;
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId);
            Calendar startInstance = Utils.getCalendarBasedOnStringDate(periodicallyScheduled.getStartInstanceString());
            if (startInstance == null) {
                this.logger.debug((Object)("\nCheckForTransfers - startInstance(from String Format) is null - we skip this transfer with id=" + obj.getTransferId() + " and we turn its status to FAILED"));
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "FAILED");
                }
                catch (Exception e) {
                    this.logger.error((Object)"CheckDBForTransfers - Exception in changing the transfer status\n");
                    e.printStackTrace();
                }
                continue;
            }
            calendarComp = Utils.setCalendarComp(startInstance);
            leftMillis = startInstance.getTimeInMillis() - calendarComp.getTimeInMillis();
            if (leftMillis >= 60000L) continue;
            if (leftMillis < 0L) {
                try {
                    this.dbManager.updateTransferStartInstanceString(obj.getTransferId(), Utils.getFormattedCalendarString(calendarComp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the start instance (was old)- id=" + obj.getTransferId()));
                    e.printStackTrace();
                }
            }
            this.logger.debug((Object)("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Periodically Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus()));
            try {
                this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                Transfer t = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)obj.getTransferId());
                if (t.getNum_updates() > 0) {
                    this.logger.debug((Object)("\nCheckForTransfers(Periodically Scheduled) -- status=" + obj.getStatus() + " .. reloading progress..."));
                    this.dbManager.resetProgressInTransfer(t.getTransferId());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId()));
                e.printStackTrace();
            }
            if (this.isMessagingEnabled) {
                produceTransfer = new ProduceTransfer(obj.getTransferId(), this.resource, false);
                produceTransfer.start();
                continue;
            }
            transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
            transferHandler.start();
        }
    }
}

