/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.check;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.Query;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.impl.check.CheckDBForTransfers;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.newhandler.SchedulerUtils;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class CheckDBForTransfersThread
extends Thread {
    public DataTransferDBManager dbManager = null;
    public SchedulerResource resource = null;
    public long checkForTransfersIntervalMS;
    public boolean immediateCheck;
    public boolean isMessagingEnabled;
    public long timeForSettingInactive;
    GCUBELog logger = new GCUBELog(CheckDBForTransfersThread.class);

    public CheckDBForTransfersThread(GCUBEWSResource ws) {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.resource = (SchedulerResource)ws;
        this.checkForTransfersIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkForTransfersIntervalInSeconds", new boolean[]{true}));
        this.immediateCheck = true;
        this.isMessagingEnabled = ServiceContext.getContext().isMessagingEnabled();
        this.timeForSettingInactive = ServiceContext.getContext().getMaxTimeToSetInactiveAnOngoingTransferInMS();
    }

    @Override
    public void run() {
        int runs = 0;
        long initialInterval = 0L;
        long tempInterval = 0L;
        this.logger.debug((Object)("\nCheckDBForTransfersThread - " + this.resource.getName() + " -- Thread has started"));
        do {
            if (++runs == 1) {
                this.sleepFiveSec();
            }
            initialInterval = this.checkForTransfersIntervalMS;
            tempInterval = this.checkForTransfersIntervalMS;
            do {
                this.sleepFiveSec();
            } while ((tempInterval -= 5000L) > 0L && initialInterval == this.checkForTransfersIntervalMS && !this.immediateCheck);
            if (this.immediateCheck) {
                this.sleepFiveSec();
                this.logger.debug((Object)"\nCheckDBForTransfersThread -- immediate check");
                this.immediateCheck = false;
            } else if (initialInterval != this.checkForTransfersIntervalMS) {
                this.logger.debug((Object)("\nCheckDBForTransfersThread -- interval has been changed from " + initialInterval + " MS to " + this.checkForTransfersIntervalMS + " MS"));
            }
            this.checkLongTimeOngoing();
            Query query = null;
            List list = null;
            query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
            try {
                query.setFilter("status == \"STANDBY\" && submitter == \"" + this.resource.getName() + "\"");
            }
            catch (Exception e) {
                this.logger.error((Object)"\nCheckDBForTransfersThread -- Exception in retrieving all the activated transfers by query");
                e.printStackTrace();
            }
            list = (List)query.execute();
            CheckDBForTransfers checkDBForTransfers = new CheckDBForTransfers(this.resource, list);
            checkDBForTransfers.check();
        } while (!Thread.interrupted());
    }

    public void sleepFiveSec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"\nCheckDBForTransfersThread (sleepFiveSec)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }

    public long getCheckForTransfersIntervalMS() {
        return this.checkForTransfersIntervalMS;
    }

    public void setCheckForTransfersIntervalMS(long checkForTransfersIntervalMS) {
        this.checkForTransfersIntervalMS = checkForTransfersIntervalMS;
    }

    public boolean isImmediateCheck() {
        return this.immediateCheck;
    }

    public void setImmediateCheck(boolean immediateCheck) {
        this.immediateCheck = immediateCheck;
    }

    public void resetCheckForTransfersInterval() {
        this.checkForTransfersIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkForTransfersIntervalInSeconds", new boolean[]{true}));
    }

    public void checkLongTimeOngoing() {
        Query query = null;
        List list = null;
        query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
        try {
            query.setFilter("status == \"ONGOING\" && submitter == \"" + this.resource.getName() + "\"");
        }
        catch (Exception e) {
            this.logger.error((Object)"\nCheckDBForTransfersThread -- Exception in retrieving the ONGOING transfers by query");
            e.printStackTrace();
        }
        list = (List)query.execute();
        for (Transfer transf : list) {
            long totalTime;
            long currentTime = System.currentTimeMillis();
            long startTime = 0L;
            try {
                startTime = transf.getStartTime();
                if (startTime == -1L) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                startTime = 0L;
            }
            if ((totalTime = currentTime - startTime) <= this.timeForSettingInactive) continue;
            String msg = "CheckDBForTransfersThread(checkLongTimeOngoing) -- Transfer with id=" + transf.getTransferId() + " has been expired. It is ongoing more than 30 minutes..";
            String agentId = transf.getAgentId();
            Agent agent = null;
            boolean flagExists = false;
            if (agentId != null) {
                Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                for (Agent obj : resultExtent) {
                    if (obj.getAgentId().compareTo(agentId) != 0) continue;
                    agent = obj;
                    flagExists = true;
                    break;
                }
            }
            if (!flagExists) {
                ISManager isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
                String checkResultFromDB = null;
                String hostnameOfAgent = transf.getAgentHostname();
                checkResultFromDB = isManagerForAgents.checkIfObjExistsInDB_ByHostname(hostnameOfAgent);
                if (checkResultFromDB != null) {
                    try {
                        this.dbManager.updateAgentInTransfer(transf.getTransferId(), checkResultFromDB);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    agent = null;
                    Extent resultExtent2 = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                    Iterator iter2 = resultExtent2.iterator();
                    flagExists = false;
                    while (iter2.hasNext()) {
                        Agent obj = (Agent)iter2.next();
                        if (obj.getAgentId().compareTo(agentId) != 0) continue;
                        agent = obj;
                        flagExists = true;
                        break;
                    }
                    if (!flagExists) {
                        msg = msg + "\nbut we cannot turn it failed because its agent does not exist " + "in the DB anymore and as a result we cannot update the statistics of that agent";
                        this.logger.debug((Object)msg);
                        return;
                    }
                } else {
                    msg = msg + "\nbut we cannot turn it failed because its agent does not exist " + "in the DB anymore and as a result we cannot update the statistics of that agent";
                    this.logger.debug((Object)msg);
                    return;
                }
            }
            this.logger.debug((Object)msg);
            ArrayList<String> errorsInTransfer = new ArrayList<String>();
            errorsInTransfer.add(msg);
            SchedulerUtils.updateStatusAndErrors(transf.getTransferId(), agent, "FAILED", errorsInTransfer);
        }
    }
}

