/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.check;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class CheckIS
extends Thread {
    public DataTransferDBManager dbManager = null;
    public ISManager isManagerForAgents = null;
    public ISManager isManagerForSources = null;
    public ISManager isManagerForStorages = null;
    public static int checkISIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkISIntervalInSeconds", new boolean[]{true}));
    GCUBELog logger = new GCUBELog(CheckIS.class);

    public CheckIS() {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        this.isManagerForSources = ServiceContext.getContext().getIsManagerForSources();
        this.isManagerForStorages = ServiceContext.getContext().getIsManagerForStorages();
    }

    @Override
    public void run() {
        int runs = 0;
        this.logger.debug((Object)"\nCheckIS -- Thread has started --");
        do {
            ++runs;
            try {
                this.isManagerForAgents.updateObjsInDB();
                this.isManagerForSources.updateObjsInDB();
                this.isManagerForStorages.updateObjsInDB();
            }
            catch (Exception e) {
                this.logger.error((Object)"nCheckIS -- Exception in updating the agents-sources-storages");
                e.printStackTrace();
            }
            if (runs <= 6) {
                this.sleep10Sec();
                continue;
            }
            try {
                Thread.sleep(checkISIntervalMS);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("nCheckIS -- InterruptedException - Unable to sleep - circle of thread=" + runs));
                e.printStackTrace();
            }
        } while (!Thread.interrupted());
    }

    public void sleep10Sec() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"\nCheckIS (sleep10Sec)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }
}

