/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.newhandler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.Query;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.messaging.MessageChecker;
import org.gcube.datatransfer.common.messaging.messages.TransferResponseMessage;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TransferOutcome;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.newhandler.SchedulerUtils;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class TransferResponseChecker
extends MessageChecker<TransferResponseMessage> {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    private GCUBELog logger = new GCUBELog(TransferResponseChecker.class);
    private DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
    private List<String> objectFailedIDs;
    private List<String> objectTrasferredIDs;
    List<String> errorsInTransfer;

    public TransferResponseChecker(GCUBEScope scope, String subscriberEndpoint) {
        super(scope, subscriberEndpoint);
    }

    public void check(TransferResponseMessage message) {
        String destEndpoint = message.getDestEndpoint();
        if (destEndpoint == null) {
            return;
        }
        if (destEndpoint.compareTo(this.subscriberEndpoint) == 0) {
            String transferIdToServe = message.getTransferId();
            Query query = this.dbManager.getPersistenceManager().newQuery(Transfer.class);
            query.setFilter("transferId == \"" + transferIdToServe + "\"");
            List list = (List)query.execute();
            if (list == null || list.size() == 0) {
                this.logger.debug((Object)("TransferResponseChecker - source(agent):" + message.getSourceEndpoint() + "\n" + "Warn: transferId=" + transferIdToServe + " does not exists in the db.."));
                return;
            }
            String status = ((Transfer)list.get(0)).getStatus();
            if (status == null || status.compareTo("ONGOING") != 0) {
                this.logger.debug((Object)("TransferResponseChecker - source(agent):" + message.getSourceEndpoint() + "\n" + "Warn: transfer with transferId=" + transferIdToServe + " is not ONGOING anymore!!"));
                return;
            }
            this.logger.debug((Object)("TransferResponseChecker - source(agent):" + message.getSourceEndpoint() + "\n" + "transferId: " + transferIdToServe));
            this.handleResult(message);
        }
    }

    public void handleResult(TransferResponseMessage message) {
        this.errorsInTransfer = new ArrayList<String>();
        String status = message.getTransferStatus();
        String transferId = message.getTransferId();
        if (transferId == null) {
            this.logger.debug((Object)"TransferResponseChecker - handleResult() - transferId=null");
            return;
        }
        Transfer transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String agentId = transfer.getAgentId();
        Agent agent = null;
        if (agentId == null) {
            this.logger.debug((Object)"TransferResponseChecker - handleResult() - agentId=null");
            return;
        }
        Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            Agent obj = (Agent)iter.next();
            if (obj.getAgentId().compareTo(agentId) != 0) continue;
            agent = obj;
            flagExists = true;
            break;
        }
        if (!flagExists) {
            ISManager isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
            String checkResultFromDB = null;
            String hostnameOfAgent = transfer.getAgentHostname();
            checkResultFromDB = isManagerForAgents.checkIfObjExistsInDB_ByHostname(hostnameOfAgent);
            if (checkResultFromDB != null) {
                try {
                    this.dbManager.updateAgentInTransfer(transferId, checkResultFromDB);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                agent = null;
                Extent resultExtent2 = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                Iterator iter2 = resultExtent2.iterator();
                flagExists = false;
                while (iter2.hasNext()) {
                    Agent obj = (Agent)iter2.next();
                    if (obj.getAgentId().compareTo(agentId) != 0) continue;
                    agent = obj;
                    flagExists = true;
                    break;
                }
                if (!flagExists) {
                    this.logger.debug((Object)("TransferResponseChecker - handleResult() - agent with hostname=" + hostnameOfAgent + " does not exist in DB anymore"));
                    return;
                }
            } else {
                this.logger.debug((Object)("TransferResponseChecker - handleResult() - agent with hostname=" + hostnameOfAgent + " does not exist in DB anymore"));
                return;
            }
        }
        if (status.compareTo("STARTED") == 0 || status.compareTo("QUEUED") == 0) {
            Types.MonitorTransferReportMessage result = message.getMonitorResponse();
            this.logger.debug((Object)("TransferResponseChecker -- Ongoing (" + status + " in agent)- id=" + transferId + " - bytesTransferred=" + result.bytesTransferred));
            long total_size = result.getTotalBytes();
            long transferredBytes = result.getBytesTransferred();
            try {
                this.dbManager.updateTransferBytes(transferId, total_size, transferredBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String retrievedStatus = transfer.getStatus();
            if (retrievedStatus.compareTo("CANCELED") == 0 || status.compareTo("CANCEL") == 0) {
                this.logger.debug((Object)("TransferResponseChecker -- Canceled - id=" + transferId));
                SchedulerUtils.updateStatusAndErrors(transferId, agent, "CANCELED", null);
                return;
            }
            ArrayList outcomes = message.getOutcomesResponse();
            this.getAndStoreOutcomes(transfer, outcomes);
            if (status.compareTo("DONE") == 0 || status.compareTo("DONE_WITH_ERRORS") == 0) {
                String statusToBeStored = null;
                statusToBeStored = status.compareTo("DONE") == 0 ? "COMPLETED" : "COMPLETED_WITH_ERRORS";
                SchedulerUtils.updateStatusAndErrors(transferId, agent, statusToBeStored, null);
                this.logger.debug((Object)("TransferResponseChecker -- " + statusToBeStored + " - " + transfer.getSubmitter() + " - id=" + transferId));
                if (transfer.getSourceId() == null) {
                    String[] objectFailedIDsarray = this.objectFailedIDs.toArray(new String[this.objectFailedIDs.size()]);
                    String[] objectTrasferredIDsarray = this.objectTrasferredIDs.toArray(new String[this.objectTrasferredIDs.size()]);
                    try {
                        this.dbManager.updateObjectTrasferredIDs(transferId, objectTrasferredIDsarray);
                        this.dbManager.updateObjectFailedIDs(transferId, objectFailedIDsarray);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"TransferResponseChecker - Exception when call dbManager.storeTransferOutcomes ");
                        this.errorsInTransfer.add(e.getMessage());
                        e.printStackTrace();
                    }
                }
                SchedulerUtils.refreshPeriodicallyScheduledTransfer(transferId, transfer.getSubmitter(), agent);
            } else {
                SchedulerUtils.updateStatusAndErrors(transferId, agent, "FAILED", this.errorsInTransfer);
                this.logger.debug((Object)("TransferHandler -- Failed - " + transfer.getSubmitter() + " - id=" + transferId));
                SchedulerUtils.refreshPeriodicallyScheduledTransfer(transferId, transfer.getSubmitter(), agent);
            }
        }
    }

    public void getAndStoreOutcomes(Transfer transfer, ArrayList<FileTransferOutcome> outcomes) {
        ArrayList<TransferObject> objectsBeenTransferred = new ArrayList<TransferObject>();
        Query query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
        List list = (List)query.execute();
        for (TransferObject obj : list) {
            String transferIdOfSpecific = obj.getTransferid();
            if (transferIdOfSpecific.compareTo(transfer.getTransferId()) != 0) continue;
            objectsBeenTransferred.add(obj);
        }
        this.objectFailedIDs = new ArrayList<String>();
        this.objectTrasferredIDs = new ArrayList<String>();
        int numOfObj = 0;
        long total_size = 0L;
        long transferredBytes = 0L;
        ArrayList<String> tmpOutcomes = new ArrayList<String>();
        for (FileTransferOutcome outcome : outcomes) {
            TransferOutcome transferOutcome = new TransferOutcome();
            String outcomeId = uuidgen.nextUUID();
            transferOutcome.setTransferOutcomesId(outcomeId);
            transferOutcome.setTransferId(transfer.getTransferId());
            transferOutcome.setSubmittedDateOfTransfer(transfer.getSubmittedDate());
            transferOutcome.setFileName(outcome.getFilename());
            transferOutcome.setException(outcome.getException());
            transferOutcome.setFailure(outcome.isFailure());
            transferOutcome.setSuccess(outcome.isSuccess());
            transferOutcome.setDest(outcome.getDest());
            transferOutcome.setTransferTime(outcome.getTransferTime() + "");
            transferOutcome.setTransferredBytesOfObj(outcome.getTransferredBytes().toString());
            transferOutcome.setSize(outcome.getTotal_size().toString());
            if (outcome.getTotal_size() != null) {
                total_size += outcome.getTotal_size().longValue();
            }
            if (outcome.getTransferredBytes() != null) {
                transferredBytes += outcome.getTransferredBytes().longValue();
            }
            transferOutcome.setNumberOfOutcomeInThisTransfer(numOfObj);
            try {
                this.dbManager.storeTransferOutcomes(transferOutcome);
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferResponseChecker - Exception when call dbManager.storeTransferOutcomes ");
                this.errorsInTransfer.add(e.getMessage());
                e.printStackTrace();
            }
            if (numOfObj == 0) {
                this.logger.debug((Object)"TransferResponseChecker -- getAndStoreOutcomes:");
            }
            this.logger.debug((Object)("Exception: " + outcome.getException()));
            this.logger.debug((Object)("FileName: " + outcome.getFilename()));
            this.logger.debug((Object)("Success?: " + outcome.isSuccess()));
            this.logger.debug((Object)("Failure?: " + outcome.isFailure()));
            if (transfer.getSourceId() == null) {
                if (outcome.isFailure()) {
                    this.objectFailedIDs.add(((TransferObject)objectsBeenTransferred.get(numOfObj)).getObjectId());
                } else if (outcome.isSuccess()) {
                    this.objectTrasferredIDs.add(((TransferObject)objectsBeenTransferred.get(numOfObj)).getObjectId());
                }
            }
            tmpOutcomes.add(outcomeId);
            ++numOfObj;
        }
        try {
            this.dbManager.updateTransferBytes(transfer.getTransferId(), total_size, transferredBytes);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferResponseChecker - Exception when call dbManager.updateTransferBytes ");
            this.errorsInTransfer.add(e.getMessage());
            e.printStackTrace();
        }
        ArrayList listOfOutcomesToBeStored = transfer.getOutcomes();
        if (listOfOutcomesToBeStored == null) {
            listOfOutcomesToBeStored = new ArrayList();
        }
        listOfOutcomesToBeStored.addAll(tmpOutcomes);
        try {
            if (listOfOutcomesToBeStored != null) {
                this.dbManager.updateOutcomesInTransfer(transfer.getTransferId(), listOfOutcomesToBeStored);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferResponseChecker - Exception when call dbManager.updateOutcomesInTransfer ");
            this.errorsInTransfer.add(e.getMessage());
            e.printStackTrace();
        }
    }
}

