/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import com.thoughtworks.xstream.XStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.AgentStatistics;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TransferOutcome;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.check.CheckDBForTransfersThread;
import org.gcube.datatransfer.scheduler.impl.context.SchedulerContext;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.porttype.StoreTransferObjectThread;
import org.gcube.datatransfer.scheduler.impl.porttype.StoreTransferThread;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.is.ISManager;
import org.gcube.datatransfer.scheduler.library.obj.InfoCancelSchedulerMessage;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;
import org.globus.wsrf.ResourceException;

public class Scheduler
extends GCUBEPortType {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    GCUBELog logger = new GCUBELog((Object)this);
    public DataTransferDBManager dbManager;
    public ISManager isManagerForAgents;
    public ISManager isManagerForSources;
    public ISManager isManagerForStorages;
    static ThreadGroup rootThreadGroup = null;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String storeInfoScheduler(String msg) throws GCUBEFault {
        ServiceContext sctx = ServiceContext.getContext();
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        this.isManagerForSources = ServiceContext.getContext().getIsManagerForSources();
        this.isManagerForStorages = ServiceContext.getContext().getIsManagerForStorages();
        SchedulerResource resource = null;
        String nameOfCheckThread = null;
        try {
            resource = this.getResource();
            nameOfCheckThread = resource.getCheckDBThread();
            this.logger.debug((Object)("Stateful Service(storeInfoScheduler) - Thread name for checking DB:" + resource.getCheckDBThread()));
        }
        catch (Exception e) {
            throw sctx.getDefaultException(e).toFault(new String[0]);
        }
        SchedulerObj schedulerObj = new SchedulerObj();
        String transferId = uuidgen.nextUUID();
        Transfer t = new Transfer();
        t.setTransferId(transferId);
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        String tmpMsg = msg;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        schedulerObj = (SchedulerObj)xstream.fromXML(tmpMsg);
        String submitter = null;
        try {
            submitter = this.getResource().getName();
            t.setSubmitter(submitter);
        }
        catch (ResourceException e1) {
            this.logger.error((Object)"Stateful Service(storeInfoScheduler) - Exception in setting the submitter in Transfer:\n");
            e1.printStackTrace();
        }
        t.setStatus("STANDBY");
        try {
            String scope = schedulerObj.getScope();
            t.setScope(scope);
        }
        catch (Exception e) {
            this.logger.error((Object)"Stateful Service(storeInfoScheduler) - Exception in taking the scope:\n");
            e.printStackTrace();
        }
        t.setSubmittedDate(schedulerObj.getSubmittedDate());
        String hostnameOfAgent = schedulerObj.getAgentHostname();
        String checkResultFromDB = null;
        checkResultFromDB = this.isManagerForAgents.checkIfObjExistsInDB_ByHostname(hostnameOfAgent);
        boolean num = false;
        if (checkResultFromDB == null) {
            this.logger.debug((Object)("Stateful Service(storeInfoScheduler) - Error!! - there is no agent with hostname= '" + hostnameOfAgent + "' in DB now or it's not 'UP' yet\n"));
            return null;
        }
        this.logger.debug((Object)("Stateful Service ..- agent= '" + hostnameOfAgent + "'"));
        t.setAgentId(checkResultFromDB);
        TypeOfSchedule typeOfSchedule = new TypeOfSchedule();
        typeOfSchedule.setTypeOfScheduleId(transferId.concat("-typeOfSchedule"));
        if (schedulerObj.getTypeOfSchedule().isDirectedScheduled()) {
            typeOfSchedule.setDirectedScheduled(true);
            CheckDBForTransfersThread checkDBForTransfersThread = (CheckDBForTransfersThread)Scheduler.getThread(nameOfCheckThread);
            checkDBForTransfersThread.setImmediateCheck(true);
        } else if (schedulerObj.getTypeOfSchedule().getManuallyScheduled() != null) {
            ManuallyScheduled manuallyScheduled = new ManuallyScheduled();
            manuallyScheduled.setManuallyScheduledId(transferId.concat("-manuallyScheduled"));
            manuallyScheduled.setCalendar(schedulerObj.getTypeOfSchedule().getManuallyScheduled().getCalendar());
            CheckDBForTransfersThread checkDBForTransfersThread = (CheckDBForTransfersThread)Scheduler.getThread(nameOfCheckThread);
            long checkForTransfersIntervalMS = checkDBForTransfersThread.getCheckForTransfersIntervalMS();
            Calendar calendarTmp = schedulerObj.getTypeOfSchedule().getManuallyScheduled().getCalendar();
            Calendar calendarComp = this.setCalendarComp(calendarTmp);
            this.printDates(calendarTmp);
            long timeThatTransferWillHappen = calendarTmp.getTimeInMillis() - calendarComp.getTimeInMillis();
            this.logger.debug((Object)("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + checkForTransfersIntervalMS + " - timeThatTransferWillHappenMS=" + timeThatTransferWillHappen));
            if (timeThatTransferWillHappen > 0L && timeThatTransferWillHappen <= checkForTransfersIntervalMS) {
                checkDBForTransfersThread.setCheckForTransfersIntervalMS(timeThatTransferWillHappen);
                this.logger.debug((Object)("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + timeThatTransferWillHappen + " (CHANGED)"));
            } else if (timeThatTransferWillHappen < 0L) {
                checkDBForTransfersThread.setImmediateCheck(true);
            }
            try {
                typeOfSchedule.setManuallyScheduledId(transferId.concat("-manuallyScheduled"));
                ServiceContext.getContext().getDbManager().storeManuallyScheduled(manuallyScheduled);
            }
            catch (Exception e) {
                this.logger.error((Object)"Stateful Service(storeInfoScheduler) - Exception in storing the ManuallyScheduled:\n");
                e.printStackTrace();
            }
        } else if (schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
            PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
            periodicallyScheduled.setPeriodicallyScheduledId(transferId.concat("-periodicallyScheduled"));
            FrequencyType frequency = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency();
            if (frequency == FrequencyType.perMinute) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perMinute);
            } else if (frequency == FrequencyType.perHour) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perHour);
            } else if (frequency == FrequencyType.perDay) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perDay);
            } else if (frequency == FrequencyType.perWeek) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perWeek);
            } else if (frequency == FrequencyType.perMonth) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perMonth);
            } else if (frequency == FrequencyType.perYear) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perYear);
            }
            periodicallyScheduled.setStartInstance(schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance());
            CheckDBForTransfersThread checkDBForTransfersThread = (CheckDBForTransfersThread)Scheduler.getThread(nameOfCheckThread);
            long checkForTransfersIntervalMS = checkDBForTransfersThread.getCheckForTransfersIntervalMS();
            Calendar calendarTmp = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance();
            Calendar calendarComp = this.setCalendarComp(calendarTmp);
            this.printDates(calendarTmp);
            long timeThatTransferWillHappen = calendarTmp.getTimeInMillis() - calendarComp.getTimeInMillis();
            if (timeThatTransferWillHappen < 0L) {
                periodicallyScheduled.setStartInstance(calendarComp);
                checkDBForTransfersThread.setImmediateCheck(true);
            } else {
                periodicallyScheduled.setStartInstance(calendarTmp);
            }
            try {
                typeOfSchedule.setPeriodicallyScheduledId(transferId.concat("-periodicallyScheduled"));
                ServiceContext.getContext().getDbManager().storePeriodicallyScheduled(periodicallyScheduled);
            }
            catch (Exception e) {
                this.logger.error((Object)"Stateful Service(storeInfoScheduler) - Exception in storing the PeriodicallyScheduled:\n");
                e.printStackTrace();
            }
            long frequencyInMS = this.frequencyInMS(frequency);
            this.logger.debug((Object)("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + checkForTransfersIntervalMS + " - frequencyInMS=" + frequencyInMS));
            if (frequencyInMS > 0L && frequencyInMS < checkForTransfersIntervalMS) {
                checkDBForTransfersThread.setCheckForTransfersIntervalMS(frequencyInMS);
                this.logger.debug((Object)("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + frequencyInMS + " (CHANGED)"));
            }
        }
        try {
            t.setTypeOfScheduleId(transferId.concat("-typeOfSchedule"));
            ServiceContext.getContext().getDbManager().storeTypeOfSchedule(typeOfSchedule);
        }
        catch (Exception e) {
            this.logger.error((Object)"Stateful Service(storeInfoScheduler) - Exception in storing the TypeOfSchedule:\n");
            e.printStackTrace();
        }
        String transferType = schedulerObj.getTypeOfTransfer();
        t.setTransferType(transferType);
        String[] inputURIs = null;
        if (transferType.compareTo("FileBasedTransfer") != 0) {
            if (transferType.compareTo("TreeBasedTransfer") == 0) {
                // empty if block
            }
        } else {
            Types.storageType typeOfStorage = schedulerObj.getTypeOfStorage();
            String destinationFolder = schedulerObj.getDestinationFolder();
            boolean overwrite = schedulerObj.isOverwrite();
            boolean unzipFile = schedulerObj.isUnzipFile();
            inputURIs = schedulerObj.getInputUrls();
            if (inputURIs == null) {
                this.logger.error((Object)"Stateful Service - InputUrls variable is null:\n");
                return null;
            }
            TransferObject obj = null;
            for (String inputUri : inputURIs) {
                obj = new TransferObject();
                try {
                    obj.setSrcURI(new URI(inputUri));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                obj.setTransferid(transferId);
                transferObjects.add(obj);
            }
            this.logger.debug((Object)("Stateful Service(storeInfoScheduler) - inputURIs.length=" + inputURIs.length + " - transferObjects.size()=" + transferObjects.size()));
            t.setDestinationFolder(destinationFolder);
            t.setOverwrite(overwrite);
            t.setUnzipFile(unzipFile);
            if (typeOfStorage.name() == Types.storageType.LocalGHN.name()) {
                t.setTypeOfStorage(Types.storageType.LocalGHN.name());
            } else if (typeOfStorage.name() == Types.storageType.StorageManager.name()) {
                t.setTypeOfStorage(Types.storageType.StorageManager.name());
                if (schedulerObj.getSmDetails() == null) {
                    this.logger.error((Object)"Stateful Service - The Storage Type is 'Storage Manager' and thereis no smDetails \n");
                    return null;
                }
                String dataStorageId = null;
                boolean flagExists = false;
                Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
                for (DataStorage obj2 : resultExtent) {
                    if (obj2.getType().compareTo(Types.storageType.StorageManager.name()) != 0 || obj2.getServiceName().compareTo(schedulerObj.getSmDetails().getServiceName()) != 0 || obj2.getAccessType().compareTo(schedulerObj.getSmDetails().getAccessType().name()) != 0 || obj2.getOwner().compareTo(schedulerObj.getSmDetails().getOwner()) != 0 || obj2.getServiceClass().compareTo(schedulerObj.getSmDetails().getServiceClass()) != 0) continue;
                    flagExists = true;
                    dataStorageId = obj2.getDataStorageId();
                    break;
                }
                if (!flagExists) {
                    DataStorage datastorage = new DataStorage();
                    datastorage.setDataStorageId(transferId.concat("-datastorageSM"));
                    datastorage.setType(Types.storageType.StorageManager.name());
                    datastorage.setServiceClass(schedulerObj.getSmDetails().getServiceClass());
                    datastorage.setServiceName(schedulerObj.getSmDetails().getServiceName());
                    datastorage.setAccessType(schedulerObj.getSmDetails().getAccessType().name());
                    datastorage.setOwner(schedulerObj.getSmDetails().getOwner());
                    dataStorageId = transferId.concat("-datastorageSM");
                    try {
                        ServiceContext.getContext().getDbManager().storeStorage(datastorage);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Stateful Service - Exception in storing the DataStorage:\n");
                        e.printStackTrace();
                        return null;
                    }
                }
                t.setStorageId(dataStorageId);
            } else if (typeOfStorage.name() == Types.storageType.DataStorage.name()) {
                t.setTypeOfStorage(Types.storageType.DataStorage.name());
                if (schedulerObj.getOutputUrls() == null) {
                    this.logger.error((Object)"Stateful Service(storeStorage) - The Storage Type is 'DataStorage' and thereare no outputUrls in schedulerObj \n");
                    return null;
                }
                if (transferObjects.size() != schedulerObj.getOutputUrls().length) {
                    this.logger.error((Object)"Stateful Service(storeStorage) - The Storage Type is 'DataStorage' and the sizeof inputUrls does not match with the size of outputUrls\n");
                    return null;
                }
                int i = 0;
                for (TransferObject obj3 : transferObjects) {
                    obj3.setDestUri(schedulerObj.getOutputUrls()[i]);
                    ++i;
                }
            }
        }
        StoreTransferThread storeTransferThread = new StoreTransferThread(t);
        storeTransferThread.start();
        if (inputURIs != null && transferObjects != null) {
            StoreTransferObjectThread storeTransferObjectThread = new StoreTransferObjectThread(transferObjects, transferId);
            storeTransferObjectThread.start();
        }
        return transferId;
    }

    public String cancelScheduledTransfer(String msg) throws GCUBEFault {
        String msgStr;
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        ArrayList<String> errors = new ArrayList<String>();
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        String tmpMsg = msg;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        InfoCancelSchedulerMessage cancelObj = new InfoCancelSchedulerMessage();
        cancelObj = (InfoCancelSchedulerMessage)xstream.fromXML(tmpMsg);
        String transferId = cancelObj.getCancelTransferMessage().getTransferID();
        Boolean isForceCancel = cancelObj.getCancelTransferMessage().isForceStop();
        Transfer transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String typeOfScheduleId = transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)typeOfScheduleId);
        String agentId = transfer.getAgentId();
        Agent agent = null;
        if (agentId != null) {
            Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
            for (Agent obj : resultExtent) {
                if (obj.getAgentId().compareTo(agentId) != 0) continue;
                agent = obj;
                break;
            }
        }
        try {
            String msgStr2;
            String status = transfer.getStatus();
            this.logger.debug((Object)("Stateful Service(cancelScheduledTransfer) - status before Calling the cancelTransfer in Agent!! = " + status));
            if (status.compareTo("COMPLETED") == 0 || status.compareTo("FAILED") == 0) {
                if (typeOfSchedule.getPeriodicallyScheduledId() != null) {
                    try {
                        this.dbManager.updateTransferStatus(transferId, "CANCELED");
                        this.updateAgentStatistics("CANCELED", agent);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
                        errors.add("Stateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n" + e.getMessage());
                        callingSchedulerResult.setErrors(errors);
                        msgStr2 = callingSchedulerResult.toXML();
                        e.printStackTrace();
                        return msgStr2;
                    }
                    callingSchedulerResult.setCancelResult("DONE");
                    msgStr = callingSchedulerResult.toXML();
                    return msgStr;
                }
                callingSchedulerResult.setCancelResult("Transfer already done");
                msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            if (status.compareTo("CANCELED") == 0) {
                callingSchedulerResult.setCancelResult("CANCELED");
                msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            if (status.compareTo("STANDBY") == 0) {
                try {
                    this.dbManager.updateTransferStatus(transferId, "CANCELED");
                    this.updateAgentStatistics("CANCELED", agent);
                }
                catch (Exception e) {
                    this.logger.error((Object)"\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
                    errors.add("Stateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n" + e.getMessage());
                    callingSchedulerResult.setErrors(errors);
                    msgStr2 = callingSchedulerResult.toXML();
                    e.printStackTrace();
                    return msgStr2;
                }
                callingSchedulerResult.setCancelResult("DONE");
                msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            if (agentId == null) {
                this.logger.debug((Object)"Stateful Service(cancelScheduledTransfer) - Error - agentId=null");
                errors.add("Stateful Service(cancelScheduledTransfer) - Error - agentId=null");
                callingSchedulerResult.setErrors(errors);
                msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            if (agent == null) {
                this.logger.debug((Object)("Stateful Service(cancelScheduledTransfer) - Error - agent with id=" + agentId + " does not exist anymore in DB"));
                errors.add("Stateful Service(cancelScheduledTransfer) - Error - agent with id=" + agentId + " does not exist anymore in DB");
                callingSchedulerResult.setErrors(errors);
                msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            String hostAgent = agent.getHost();
            int portAgent = agent.getPort();
            String scope = transfer.getScope();
            AgentLibrary agentLibrary = null;
            ScopeProvider.instance.set(scope);
            agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
            String transferIdOfAgent = transfer.getTransferIdOfAgent();
            if (transferIdOfAgent == null) {
                this.logger.debug((Object)"Stateful Service(cancelScheduledTransfer) - Error - transferIdOfAgent=null");
                errors.add("Stateful Service(cancelScheduledTransfer) - Error - transferIdOfAgent=null");
                callingSchedulerResult.setErrors(errors);
                String msgStr3 = callingSchedulerResult.toXML();
                return msgStr3;
            }
            agentLibrary.cancelTransfer(transferIdOfAgent, isForceCancel.booleanValue());
        }
        catch (Exception e) {
            this.logger.error((Object)"\nStateful Service(cancelScheduledTransfer) - Exception in calling the cancelTransfer\n");
            errors.add("Stateful Service(cancelScheduledTransfer) - Exception in calling the cancelTransfer\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        try {
            this.dbManager.updateTransferStatus(transferId, "CANCELED");
            this.updateAgentStatistics("CANCELED", agent);
        }
        catch (Exception e) {
            this.logger.error((Object)"\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
            errors.add("Stateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        this.logger.debug((Object)("\nStateful Service(cancelScheduledTransfer) - status=" + transfer.getStatus()));
        callingSchedulerResult.setCancelResult("DONE");
        String msgStr4 = callingSchedulerResult.toXML();
        return msgStr4;
    }

    public String monitorScheduledTransfer(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        String transferId = msg;
        String status = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getStatus();
        return status;
    }

    public String getScheduledTransferOutcomes(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder outcomes = new StringBuilder();
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        String transferId = msg;
        Transfer transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        if (transfer.getOutcomes() != null) {
            List outcomeIds = transfer.getOutcomes();
            for (String outcomeId : outcomeIds) {
                TransferOutcome transferOutcome = (TransferOutcome)this.dbManager.getPersistenceManager().getObjectById(TransferOutcome.class, (Object)outcomeId);
                outcomes.append("Outcome-" + transferOutcome.getNumberOfOutcomeInThisTransfer() + "\n");
                outcomes.append("SubmittedDateOfTransfer: " + transferOutcome.getSubmittedDateOfTransfer() + "\n");
                outcomes.append("Exception: " + transferOutcome.getException() + "\n");
                outcomes.append("FileName: " + transferOutcome.getFileName() + "\n");
                outcomes.append("Dest: " + transferOutcome.getDest() + "\n");
                outcomes.append("TransferTime: " + transferOutcome.getTransferTime() + "\n");
                outcomes.append("Success?: " + transferOutcome.isSuccess() + "\n");
                outcomes.append("Failure?: " + transferOutcome.isFailure() + "\n");
            }
            callingSchedulerResult.setSchedulerOutcomes(outcomes.toString());
            String msgStr = callingSchedulerResult.toXML();
            return msgStr;
        }
        this.logger.debug((Object)"Stateful Service(getScheduledTransferOutcomes) - no outcomes are stored in the scheduler DB.. so we call agent service to retrive them");
        String transferIdOfAgent = transfer.getTransferIdOfAgent();
        if (transferIdOfAgent == null) {
            callingSchedulerResult.setSchedulerOutcomes("The Transfer has not started yet or It is a sync op.");
            String msgStr = callingSchedulerResult.toXML();
            return msgStr;
        }
        String agentId = transfer.getAgentId();
        if (agentId == null) {
            this.logger.debug((Object)"Stateful Service(getScheduledTransferOutcomes) - Error - agentId=null");
            errors.add("Stateful Service(getScheduledTransferOutcomes) - Error - agentId=null");
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            return msgStr;
        }
        Agent tmpAgent = null;
        Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            Agent obj = (Agent)iter.next();
            if (obj.getAgentId().compareTo(agentId) != 0) continue;
            tmpAgent = obj;
            flagExists = true;
            break;
        }
        if (!flagExists) {
            this.logger.debug((Object)("Stateful Service(getScheduledTransferOutcomes) -  Error - agent with id=" + agentId + " does not exist in DB anymore"));
            errors.add("Stateful Service(getScheduledTransferOutcomes) -  Error - agent with id=" + agentId + " does not exist in DB anymore");
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            return msgStr;
        }
        String hostAgent = tmpAgent.getHost();
        int portAgent = tmpAgent.getPort();
        String scope = transfer.getScope();
        AgentLibrary agentLibrary = null;
        try {
            ScopeProvider.instance.set(scope);
            agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
        }
        catch (Exception e) {
            this.logger.error((Object)"Stateful Service(getScheduledTransferOutcomes) - Exception when building agentLibrary");
            errors.add("Stateful Service(getScheduledTransferOutcomes) - Exception when building agentLibrary\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        ArrayList outcomesArray = null;
        try {
            outcomesArray = agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);
        }
        catch (Exception e) {
            this.logger.error((Object)"Stateful Service(getScheduledTransferOutcomes) - Exception when calling agentLibrary.getTransferOutcomes(..)");
            errors.add("Stateful Service(getScheduledTransferOutcomes) - Exception when calling agentLibrary.getTransferOutcomes(..)\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        List listOfOutcomesToBeStored = null;
        if (outcomes != null) {
            try {
                int numOfObj = 0;
                ArrayList<String> tmpOutcomes = new ArrayList<String>();
                for (FileTransferOutcome outcome : outcomesArray) {
                    TransferOutcome transferOutcome = new TransferOutcome();
                    String outcomeId = uuidgen.nextUUID();
                    transferOutcome.setTransferOutcomesId(outcomeId);
                    transferOutcome.setTransferId(transferId);
                    transferOutcome.setSubmittedDateOfTransfer(transfer.getSubmittedDate());
                    transferOutcome.setFileName(outcome.getFilename());
                    transferOutcome.setException(outcome.getException());
                    transferOutcome.setFailure(outcome.isFailure());
                    transferOutcome.setSuccess(outcome.isSuccess());
                    transferOutcome.setDest(outcome.getDest());
                    transferOutcome.setTransferTime(outcome.getTransferTime() + "");
                    transferOutcome.setNumberOfOutcomeInThisTransfer(numOfObj);
                    this.dbManager.storeTransferOutcomes(transferOutcome);
                    outcomes.append("Outcome-" + transferOutcome.getNumberOfOutcomeInThisTransfer() + "\n");
                    outcomes.append("SubmittedDateOfTransfer: " + transferOutcome.getSubmittedDateOfTransfer() + "\n");
                    outcomes.append("Exception: " + transferOutcome.getException() + "\n");
                    outcomes.append("FileName: " + transferOutcome.getFileName() + "\n");
                    outcomes.append("Dest: " + transferOutcome.getDest() + "\n");
                    outcomes.append("TransferTime: " + transferOutcome.getTransferTime() + "\n");
                    outcomes.append("Success?: " + transferOutcome.isSuccess() + "\n");
                    outcomes.append("Failure?: " + transferOutcome.isFailure() + "\n");
                    tmpOutcomes.add(outcomeId);
                    ++numOfObj;
                }
                listOfOutcomesToBeStored = transfer.getOutcomes();
                listOfOutcomesToBeStored.addAll(tmpOutcomes);
            }
            catch (Exception e) {
                this.logger.error((Object)"Stateful Service(getScheduledTransferOutcomes) - Exception when calling dbManager.storeTransferOutcomes");
                errors.add("Stateful Service(getScheduledTransferOutcomes) - Exception when calling dbManager.storeTransferOutcomes\n" + e.getMessage());
                callingSchedulerResult.setErrors(errors);
                String msgStr = callingSchedulerResult.toXML();
                e.printStackTrace();
                return msgStr;
            }
        }
        try {
            if (listOfOutcomesToBeStored != null) {
                this.dbManager.updateOutcomesInTransfer(transferId, listOfOutcomesToBeStored);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Stateful Service(getScheduledTransferOutcomes) - Exception when calling dbManager.updateOutcomesInTransfer");
            errors.add("Stateful Service(getScheduledTransferOutcomes) - Exception when calling dbManager.updateOutcomesInTransfer\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        callingSchedulerResult.setSchedulerOutcomes(outcomes.toString());
        String msgStr = callingSchedulerResult.toXML();
        return msgStr;
    }

    public void updateAgentStatistics(String status, Agent agent) {
        if (agent == null) {
            return;
        }
        String agentIdOfIS = agent.getAgentIdOfIS();
        AgentStatistics stats = null;
        Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(AgentStatistics.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            AgentStatistics obj = (AgentStatistics)iter.next();
            if (obj.getAgentIdOfIS().compareTo(agentIdOfIS) != 0) continue;
            stats = obj;
            flagExists = true;
            break;
        }
        if (!flagExists) {
            return;
        }
        String id = stats.getAgentStatisticsId();
        int ongoing = stats.getOngoingTransfers();
        int failed = stats.getFailedTransfers();
        int succeeded = stats.getSucceededTransfers();
        int canceled = stats.getCanceledTransfers();
        int total = stats.getTotalFinishedTransfers();
        if (status.compareTo("COMPLETED") == 0) {
            --ongoing;
            ++succeeded;
            ++total;
        } else if (status.compareTo("FAILED") == 0) {
            --ongoing;
            ++failed;
            ++total;
        } else if (status.compareTo("CANCELED") == 0) {
            --ongoing;
            ++canceled;
            ++total;
        } else if (status.compareTo("ONGOING") == 0) {
            ++ongoing;
        }
        try {
            this.dbManager.updateAgentStatistics(id, ongoing, failed, succeeded, canceled, total);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler - Exception in updating the agent Statistics\n");
            e.printStackTrace();
        }
    }

    static Thread getThread(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        for (Thread thread : threads = Scheduler.getAllThreads()) {
            if (!thread.getName().equals(name)) continue;
            return thread;
        }
        return null;
    }

    static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = Scheduler.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    public long frequencyInMS(FrequencyType frequency) {
        if (frequency == FrequencyType.perMinute) {
            return 60000L;
        }
        if (frequency == FrequencyType.perHour) {
            return 3600000L;
        }
        if (frequency == FrequencyType.perDay) {
            return 86400000L;
        }
        if (frequency == FrequencyType.perWeek) {
            return 604800000L;
        }
        if (frequency == FrequencyType.perMonth) {
            return 964130816L;
        }
        if (frequency == FrequencyType.perYear) {
            return -1315332096L;
        }
        return 0L;
    }

    private SchedulerResource getResource() throws ResourceException {
        return (SchedulerResource)SchedulerContext.getContext().getWSHome().find();
    }

    private Calendar setCalendarComp(Calendar transferCal) {
        Calendar calendarComp = (Calendar)transferCal.clone();
        calendarComp.set(1, Calendar.getInstance().get(1));
        calendarComp.set(2, Calendar.getInstance().get(2));
        calendarComp.set(5, Calendar.getInstance().get(5));
        calendarComp.set(11, Calendar.getInstance().get(11));
        calendarComp.set(12, Calendar.getInstance().get(12));
        return calendarComp;
    }

    private void printDates(Calendar calendarTmp) {
        String computerDate = "year:" + Calendar.getInstance().get(1) + ", " + "month:" + Calendar.getInstance().get(2) + ", " + "day:" + Calendar.getInstance().get(5) + " - " + Calendar.getInstance().get(11) + "." + Calendar.getInstance().get(12) + ".";
        String transferDate = "year:" + calendarTmp.get(1) + ", " + "month:" + calendarTmp.get(2) + ", " + "day:" + calendarTmp.get(5) + " - " + calendarTmp.get(11) + "." + calendarTmp.get(12) + ".";
        this.logger.debug((Object)("\nStateful Service(storeInfoScheduler) - dates:\ncomputerDate=" + computerDate + "\ntransferDate=" + transferDate));
    }
}

