/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.check;

import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.handler.TransferHandler;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;

public class CheckDBForTransfers {
    public DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
    public SchedulerResource resource = null;
    public long checkForTransfersIntervalMS;
    public List<Transfer> transfers = null;

    public CheckDBForTransfers(GCUBEWSResource ws, List<Transfer> transfers) {
        this.resource = (SchedulerResource)ws;
        this.transfers = transfers;
    }

    public void check() {
        for (Transfer obj : this.transfers) {
            PeriodicallyScheduled periodicallyScheduled;
            Calendar startInstance;
            TypeOfSchedule typeOfSchedule = null;
            String idTypeOfSchedule = null;
            try {
                idTypeOfSchedule = obj.getTypeOfScheduleId();
                typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
            }
            catch (Exception e) {
                System.out.println("CheckForTransfers -- Exception in retrieving the typeOfSchedule");
                e.printStackTrace();
            }
            String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
            String idManuallyScheduled = typeOfSchedule.getManuallyScheduledId();
            if (typeOfSchedule.isDirectedScheduled()) {
                System.out.println("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Direct Transfer) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus());
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                }
                catch (Exception e) {
                    System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId());
                    e.printStackTrace();
                }
                TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                transferHandler.start();
                continue;
            }
            if (idManuallyScheduled != null) {
                ManuallyScheduled manuallyScheduled = (ManuallyScheduled)this.dbManager.getPersistenceManager().getObjectById(ManuallyScheduled.class, (Object)idManuallyScheduled);
                Calendar calendarTmp = manuallyScheduled.getCalendar();
                if (calendarTmp.get(1) > Calendar.getInstance().get(1) || calendarTmp.get(2) > Calendar.getInstance().get(2) || calendarTmp.get(5) > Calendar.getInstance().get(5) || calendarTmp.get(11) > Calendar.getInstance().get(11) || calendarTmp.get(12) > Calendar.getInstance().get(12)) continue;
                System.out.println("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Manually Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus());
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                }
                catch (Exception e) {
                    System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId());
                    e.printStackTrace();
                }
                TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                transferHandler.start();
                continue;
            }
            if (periodicallyScheduledId == null || (startInstance = (periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId)).getStartInstance()).get(1) > Calendar.getInstance().get(1) || startInstance.get(2) > Calendar.getInstance().get(2) || startInstance.get(5) > Calendar.getInstance().get(5) || startInstance.get(11) > Calendar.getInstance().get(11) || startInstance.get(12) > Calendar.getInstance().get(12)) continue;
            System.out.println("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Periodically Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus());
            try {
                this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
            }
            catch (Exception e) {
                System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId());
                e.printStackTrace();
            }
            TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, true);
            transferHandler.start();
        }
    }
}

