/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import com.thoughtworks.xstream.XStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.check.CheckDBForTransfersThread;
import org.gcube.datatransfer.scheduler.impl.context.SchedulerContext;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.is.ISManager;
import org.gcube.datatransfer.scheduler.library.obj.InfoCancelSchedulerMessage;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageType;
import org.globus.wsrf.ResourceException;

public class Scheduler
extends GCUBEPortType {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    public DataTransferDBManager dbManager;
    public ISManager<Agent> isManagerForAgents;
    public ISManager<DataSource> isManagerForSources;
    public ISManager<DataStorage> isManagerForStorages;
    static ThreadGroup rootThreadGroup = null;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String storeInfoScheduler(String msg) throws GCUBEFault {
        ServiceContext sctx = ServiceContext.getContext();
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        this.isManagerForSources = ServiceContext.getContext().getIsManagerForSources();
        this.isManagerForStorages = ServiceContext.getContext().getIsManagerForStorages();
        SchedulerResource resource = null;
        String nameOfCheckThread = null;
        try {
            resource = this.getResource();
            nameOfCheckThread = resource.getCheckDBThread();
            System.out.println("Stateful Service(storeInfoScheduler) - Thread name for checking DB:" + resource.getCheckDBThread());
        }
        catch (Exception e) {
            throw sctx.getDefaultException(e).toFault(new String[0]);
        }
        SchedulerObj schedulerObj = new SchedulerObj();
        String transferId = uuidgen.nextUUID();
        Transfer t = new Transfer();
        t.setTransferId(transferId);
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        String tmpMsg = msg;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        schedulerObj = (SchedulerObj)xstream.fromXML(tmpMsg);
        String submitter = null;
        try {
            submitter = this.getResource().getName();
            t.setSubmitter(submitter);
        }
        catch (ResourceException e1) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in setting the submitter in Transfer:\n");
            e1.printStackTrace();
        }
        t.setStatus("STANDBY");
        try {
            String scope = schedulerObj.getScope();
            t.setScope(scope);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in taking the scope:\n");
            e.printStackTrace();
        }
        String hostnameOfAgent = schedulerObj.getAgentHostname();
        String checkResultFromIS = null;
        checkResultFromIS = this.isManagerForAgents.checkIfObjExistsInIS_ByHostname(hostnameOfAgent);
        int num = 0;
        while (checkResultFromIS == null) {
            if (num != 0) {
                checkResultFromIS = this.isManagerForAgents.checkIfObjExistsInIS_ByHostname(hostnameOfAgent);
            }
            System.out.println("Stateful Service(storeInfoScheduler) - Error!! - there is no agent with hostname= '" + hostnameOfAgent + "' in IS now\n");
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                System.out.println("Stateful Service ..- InterruptedException-Unable to sleep");
                e.printStackTrace();
            }
            ++num;
        }
        String checkResultFromDB = null;
        checkResultFromDB = this.isManagerForAgents.checkIfObjExistsInDB_ById(checkResultFromIS);
        num = 0;
        while (checkResultFromDB == null) {
            if (num != 0) {
                checkResultFromDB = this.isManagerForAgents.checkIfObjExistsInDB_ById(checkResultFromIS);
            }
            System.out.println("Stateful Service(storeInfoScheduler) - Error!! - there is no agent with hostname= '" + hostnameOfAgent + "' in DB now or it's not 'UP' yet\n");
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                System.out.println("Stateful Service ..- InterruptedException-Unable to sleep");
                e.printStackTrace();
            }
            ++num;
        }
        System.out.println("Stateful Service ..- agent= '" + hostnameOfAgent + "'");
        t.setAgentId(checkResultFromDB);
        TypeOfSchedule typeOfSchedule = new TypeOfSchedule();
        typeOfSchedule.setTypeOfScheduleId(transferId.concat("-typeOfSchedule"));
        if (schedulerObj.getTypeOfSchedule().isDirectedScheduled()) {
            typeOfSchedule.setDirectedScheduled(true);
            CheckDBForTransfersThread checkDBForTransfersThread = (CheckDBForTransfersThread)Scheduler.getThread(nameOfCheckThread);
            checkDBForTransfersThread.setImmediateCheck(true);
        } else if (schedulerObj.getTypeOfSchedule().getManuallyScheduled() != null) {
            ManuallyScheduled manuallyScheduled = new ManuallyScheduled();
            manuallyScheduled.setManuallyScheduledId(transferId.concat("-manuallyScheduled"));
            manuallyScheduled.setCalendar(schedulerObj.getTypeOfSchedule().getManuallyScheduled().getCalendar());
            CheckDBForTransfersThread checkDBForTransfersThread = (CheckDBForTransfersThread)Scheduler.getThread(nameOfCheckThread);
            long checkForTransfersIntervalMS = checkDBForTransfersThread.getCheckForTransfersIntervalMS();
            Calendar calendarTmp = schedulerObj.getTypeOfSchedule().getManuallyScheduled().getCalendar();
            long timeThatTransferWillHappen = calendarTmp.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
            System.out.println("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + checkForTransfersIntervalMS + " - timeThatTransferWillHappenMS=" + timeThatTransferWillHappen);
            if (timeThatTransferWillHappen > 0L && timeThatTransferWillHappen <= checkForTransfersIntervalMS) {
                checkDBForTransfersThread.setCheckForTransfersIntervalMS(timeThatTransferWillHappen);
                System.out.println("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + timeThatTransferWillHappen + " (CHANGED)");
            } else if (timeThatTransferWillHappen < 0L) {
                manuallyScheduled.setCalendar(Calendar.getInstance());
                checkDBForTransfersThread.setImmediateCheck(true);
            }
            try {
                typeOfSchedule.setManuallyScheduledId(transferId.concat("-manuallyScheduled"));
                ServiceContext.getContext().getDbManager().storeManuallyScheduled(manuallyScheduled);
            }
            catch (Exception e) {
                System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the ManuallyScheduled:\n");
                e.printStackTrace();
            }
        } else if (schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
            PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
            periodicallyScheduled.setPeriodicallyScheduledId(transferId.concat("-periodicallyScheduled"));
            FrequencyType frequency = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency();
            if (frequency == FrequencyType.perMinute) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perMinute);
            } else if (frequency == FrequencyType.perHour) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perHour);
            } else if (frequency == FrequencyType.perDay) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perDay);
            } else if (frequency == FrequencyType.perWeek) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perWeek);
            } else if (frequency == FrequencyType.perMonth) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perMonth);
            } else if (frequency == FrequencyType.perYear) {
                periodicallyScheduled.setFrequency(Utils.FrequencyType.perYear);
            }
            periodicallyScheduled.setStartInstance(schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance());
            CheckDBForTransfersThread checkDBForTransfersThread = (CheckDBForTransfersThread)Scheduler.getThread(nameOfCheckThread);
            long checkForTransfersIntervalMS = checkDBForTransfersThread.getCheckForTransfersIntervalMS();
            Calendar calendarTmp = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance();
            long timeThatTransferWillHappen = calendarTmp.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
            if (timeThatTransferWillHappen < 0L) {
                periodicallyScheduled.setStartInstance(Calendar.getInstance());
                checkDBForTransfersThread.setImmediateCheck(true);
            } else {
                periodicallyScheduled.setStartInstance(calendarTmp);
            }
            try {
                typeOfSchedule.setPeriodicallyScheduledId(transferId.concat("-periodicallyScheduled"));
                ServiceContext.getContext().getDbManager().storePeriodicallyScheduled(periodicallyScheduled);
            }
            catch (Exception e) {
                System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the PeriodicallyScheduled:\n");
                e.printStackTrace();
            }
            long frequencyInMS = this.frequencyInMS(frequency);
            System.out.println("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + checkForTransfersIntervalMS + " - frequencyInMS=" + frequencyInMS);
            if (frequencyInMS > 0L && frequencyInMS < checkForTransfersIntervalMS) {
                checkDBForTransfersThread.setCheckForTransfersIntervalMS(frequencyInMS);
                System.out.println("\nStateful Service(storeInfoScheduler) - checkForTransfersIntervalMS=" + frequencyInMS + " (CHANGED)");
            }
        }
        try {
            t.setTypeOfScheduleId(transferId.concat("-typeOfSchedule"));
            ServiceContext.getContext().getDbManager().storeTypeOfSchedule(typeOfSchedule);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the TypeOfSchedule:\n");
            e.printStackTrace();
        }
        String transferType = schedulerObj.getTypeOfTransfer();
        t.setTransferType(transferType);
        String[] inputURIs = null;
        if (transferType.compareTo("LocalFileBasedTransfer") == 0) {
            String destinationFolder = schedulerObj.getDestinationFolder();
            boolean overwrite = schedulerObj.isOverwrite();
            boolean unzipFile = schedulerObj.isUnzipFile();
            inputURIs = schedulerObj.getInputUrls();
            TransferObject obj = null;
            for (String inputUri : inputURIs) {
                obj = new TransferObject();
                try {
                    obj.setURI(new URI(inputUri));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                obj.setTransferid(transferId);
                transferObjects.add(obj);
            }
            t.setDestinationFolder(destinationFolder);
            t.setOverwrite(overwrite);
            t.setUnzipFile(unzipFile);
        } else if (transferType.compareTo("FileBasedTransfer") == 0) {
            StorageType storageType = schedulerObj.getStorageType();
            String destinationFolder = schedulerObj.getDestinationFolder();
            boolean overwrite = schedulerObj.isOverwrite();
            boolean unzipFile = schedulerObj.isUnzipFile();
            inputURIs = schedulerObj.getInputUrls();
            if (inputURIs != null) {
                TransferObject obj = null;
                for (String inputUri : inputURIs) {
                    obj = new TransferObject();
                    try {
                        obj.setURI(new URI(inputUri));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    obj.setTransferid(transferId);
                    transferObjects.add(obj);
                }
            } else {
                String sourceHostName = "";
                checkResultFromIS = null;
                checkResultFromIS = this.isManagerForSources.checkIfObjExistsInIS_ByHostname(sourceHostName);
                num = 0;
                while (checkResultFromIS == null) {
                    if (num != 0) {
                        checkResultFromIS = this.isManagerForSources.checkIfObjExistsInIS_ByHostname(sourceHostName);
                    }
                    System.out.println("Stateful Service(storeInfoScheduler) - Error!! - there is no dataSource node with hostname= '" + sourceHostName + "' in IS now\n");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Stateful Service ..- InterruptedException-Unable to sleep");
                        e.printStackTrace();
                    }
                    ++num;
                }
                checkResultFromDB = null;
                checkResultFromDB = this.isManagerForSources.checkIfObjExistsInDB_ById(checkResultFromIS);
                num = 0;
                while (checkResultFromDB == null) {
                    if (num != 0) {
                        checkResultFromDB = this.isManagerForSources.checkIfObjExistsInDB_ById(checkResultFromIS);
                    }
                    System.out.println("Stateful Service(storeInfoScheduler) - Error!! - there is no source with hostname= '" + sourceHostName + "' in DB now or it's not 'UP' yet\n");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Stateful Service ..- InterruptedException-Unable to sleep");
                        e.printStackTrace();
                    }
                }
                t.setSourceId(checkResultFromDB);
            }
            t.setDestinationFolder(destinationFolder);
            t.setOverwrite(overwrite);
            t.setUnzipFile(unzipFile);
            if (storageType.getValue() != StorageType.LocalGHN.getValue() && storageType.getValue() == StorageType.StorageManager.getValue()) {
                DataStorage datastorage = new DataStorage();
                datastorage.setDataStorageId(transferId.concat("-datastorage"));
                datastorage.setType(StorageType.StorageManager.getValue());
                try {
                    t.setStorageId(datastorage.getDataStorageId());
                    ServiceContext.getContext().getDbManager().storeStorage(datastorage);
                }
                catch (Exception e) {
                    System.out.println("Stateful Service(storeStorage) - Exception in storing the DataStorage:\n");
                    e.printStackTrace();
                }
            }
        } else if (transferType.compareTo("TreeBasedTransfer") == 0) {
            // empty if block
        }
        try {
            ServiceContext.getContext().getDbManager().storeTransfer(t);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the Transfer:\n");
            e.printStackTrace();
        }
        if (inputURIs != null && transferObjects != null) {
            try {
                ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
            }
            catch (Exception e) {
                System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the Set of Transfer Objects:\n");
                e.printStackTrace();
            }
            System.out.println("");
        }
        return transferId;
    }

    public String cancelScheduledTransfer(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        ArrayList<String> errors = new ArrayList<String>();
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        String tmpMsg = msg;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        InfoCancelSchedulerMessage cancelObj = new InfoCancelSchedulerMessage();
        cancelObj = (InfoCancelSchedulerMessage)xstream.fromXML(tmpMsg);
        String transferId = cancelObj.getCancelTransferMessage().getTransferID();
        Boolean isForceCancel = cancelObj.getCancelTransferMessage().isForceStop();
        Transfer transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String typeOfScheduleId = transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)typeOfScheduleId);
        try {
            String status = transfer.getStatus();
            System.out.println("Stateful Service(cancelScheduledTransfer) - status before Calling the cancelTransfer in Agent!! = " + status);
            if (status == "COMPLETED" || status == "FAILED") {
                if (typeOfSchedule.getPeriodicallyScheduledId() != null) {
                    try {
                        this.dbManager.updateTransferStatus(transferId, "CANCELED");
                    }
                    catch (Exception e) {
                        System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
                        errors.add("Stateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n" + e.getMessage());
                        callingSchedulerResult.setErrors(errors);
                        String msgStr = callingSchedulerResult.toXML();
                        e.printStackTrace();
                        return msgStr;
                    }
                    callingSchedulerResult.setCancelResult("DONE");
                    String msgStr = callingSchedulerResult.toXML();
                    return msgStr;
                }
                callingSchedulerResult.setCancelResult("Transfer already done");
                String msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            if (status == "CANCELED") {
                callingSchedulerResult.setCancelResult("CANCELED");
                String msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            if (status == "STANDBY") {
                try {
                    this.dbManager.updateTransferStatus(transferId, "CANCELED");
                }
                catch (Exception e) {
                    System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
                    errors.add("Stateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n" + e.getMessage());
                    callingSchedulerResult.setErrors(errors);
                    String msgStr = callingSchedulerResult.toXML();
                    e.printStackTrace();
                    return msgStr;
                }
                callingSchedulerResult.setCancelResult("DONE");
                String msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            String agentId = transfer.getAgentId();
            if (agentId == null) {
                System.out.println("Stateful Service(cancelScheduledTransfer) - Error - agentId=null");
                errors.add("Stateful Service(cancelScheduledTransfer) - Error - agentId=null");
                callingSchedulerResult.setErrors(errors);
                String msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            Agent tmpAgent = (Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId);
            String hostAgent = tmpAgent.getHost();
            int portAgent = tmpAgent.getPort();
            String scope = transfer.getScope();
            AgentLibrary agentLibrary = null;
            ScopeProvider.instance.set(scope);
            agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
            String transferIdOfAgent = transfer.getTransferIdOfAgent();
            if (transferIdOfAgent == null) {
                System.out.println("Stateful Service(cancelScheduledTransfer) - Error - transferIdOfAgent=null");
                errors.add("Stateful Service(cancelScheduledTransfer) - Error - transferIdOfAgent=null");
                callingSchedulerResult.setErrors(errors);
                String msgStr = callingSchedulerResult.toXML();
                return msgStr;
            }
            agentLibrary.cancelTransfer(transferIdOfAgent, isForceCancel.booleanValue());
        }
        catch (Exception e) {
            System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in calling the cancelTransfer\n");
            errors.add("Stateful Service(cancelScheduledTransfer) - Exception in calling the cancelTransfer\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        try {
            this.dbManager.updateTransferStatus(transferId, "CANCELED");
        }
        catch (Exception e) {
            System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
            errors.add("Stateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        System.out.println("\nStateful Service(cancelScheduledTransfer) - status=" + transfer.getStatus());
        callingSchedulerResult.setCancelResult("DONE");
        String msgStr = callingSchedulerResult.toXML();
        return msgStr;
    }

    public String monitorScheduledTransfer(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        String transferId = msg;
        String status = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getStatus();
        return status;
    }

    public String getScheduledTransferOutcomes(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder outcomes = new StringBuilder();
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        String transferId = msg;
        Transfer transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String transferIdOfAgent = transfer.getTransferIdOfAgent();
        if (transferIdOfAgent == null) {
            callingSchedulerResult.setSchedulerOutcomes("The Transfer has not started yet or It is a sync op.");
            String msgStr = callingSchedulerResult.toXML();
            return msgStr;
        }
        String agentId = transfer.getAgentId();
        if (agentId == null) {
            System.out.println("Stateful Service(monitorScheduledTransfer) - Error - agentId=null");
            errors.add("Stateful Service(monitorScheduledTransfer) - agentId=null");
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            return msgStr;
        }
        Agent tmpAgent = (Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId);
        String hostAgent = tmpAgent.getHost();
        int portAgent = tmpAgent.getPort();
        String scope = transfer.getScope();
        AgentLibrary agentLibrary = null;
        try {
            ScopeProvider.instance.set(scope);
            agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
        }
        catch (Exception e) {
            System.out.println("Stateful Service(monitorScheduledTransfer) - Exception when building agentLibrary");
            errors.add("Stateful Service(monitorScheduledTransfer) - Exception when building agentLibrary\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        try {
            ArrayList outcomesArray = agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);
            int numOfObj = 0;
            for (FileTransferOutcome outcome : outcomesArray) {
                outcomes.append("Outcome-" + numOfObj + "\n");
                outcomes.append("Exception: " + outcome.getException() + "\n");
                outcomes.append("FileName: " + outcome.getFilename() + "\n");
                outcomes.append("Success?: " + outcome.isSuccess() + "\n");
                outcomes.append("Failure?: " + outcome.isFailure() + "\n");
                ++numOfObj;
            }
        }
        catch (Exception e) {
            System.out.println("Stateful Service(monitorScheduledTransfer) - Exception when calling the getTransferOutcomes and read the outcomes");
            errors.add("Stateful Service(monitorScheduledTransfer) - Exception when calling the getTransferOutcomes and read the outcomes\n" + e.getMessage());
            callingSchedulerResult.setErrors(errors);
            String msgStr = callingSchedulerResult.toXML();
            e.printStackTrace();
            return msgStr;
        }
        callingSchedulerResult.setSchedulerOutcomes(outcomes.toString());
        String msgStr = callingSchedulerResult.toXML();
        return msgStr;
    }

    static Thread getThread(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        for (Thread thread : threads = Scheduler.getAllThreads()) {
            if (!thread.getName().equals(name)) continue;
            return thread;
        }
        return null;
    }

    static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = Scheduler.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    public long frequencyInMS(FrequencyType frequency) {
        if (frequency == FrequencyType.perMinute) {
            return 60000L;
        }
        if (frequency == FrequencyType.perHour) {
            return 3600000L;
        }
        if (frequency == FrequencyType.perDay) {
            return 86400000L;
        }
        if (frequency == FrequencyType.perWeek) {
            return 604800000L;
        }
        if (frequency == FrequencyType.perMonth) {
            return 964130816L;
        }
        if (frequency == FrequencyType.perYear) {
            return -1315332096L;
        }
        return 0L;
    }

    private SchedulerResource getResource() throws ResourceException {
        return (SchedulerResource)SchedulerContext.getContext().getWSHome().find();
    }
}

