/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.impl.check.CheckDBForTransfersThread;
import org.gcube.datatransfer.scheduler.impl.context.SchedulerContext;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.globus.wsrf.ResourceKey;

public class Factory
extends GCUBEPortType {
    GCUBELog logger = new GCUBELog((Object)this);

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public EndpointReferenceType create(String name) throws GCUBEFault {
        GCUBEStatefulPortTypeContext ptcxt = SchedulerContext.getContext();
        GCUBEWSHome home = ptcxt.getWSHome();
        try {
            if (home.find((ResourceKey)ptcxt.makeKey(name)) != null) {
                System.out.println("\nFactory - Name: '" + name + "' already exists. Retrieving ws");
                return home.find((ResourceKey)ptcxt.makeKey(name)).getEPR();
            }
        }
        catch (Exception e) {
            System.out.println("\nFactory - there is no name: '" + name + "'");
        }
        GCUBEWSResourceKey key = null;
        try {
            System.out.println("Factory - Creating a resource for name: '" + name + "'");
            key = ptcxt.makeKey(name);
        }
        catch (Exception e) {
            System.out.println("unable to make a new key because of:\n" + e + "\n");
        }
        GCUBEWSResource ws = null;
        System.out.println("created key:\n" + key.getValue() + "\n");
        try {
            ws = home.create(key, new Object[]{name});
        }
        catch (Exception e) {
            System.out.println("unable to create a new resource because of:\n" + e + "\n");
        }
        try {
            CheckDBForTransfersThread checkDBForTransfersThread = new CheckDBForTransfersThread(ws);
            checkDBForTransfersThread.start();
            ws.store();
            SchedulerResource resource = (SchedulerResource)ws;
            resource.setCheckDBThread(checkDBForTransfersThread.getName());
            resource.store();
            return ws.getEPR();
        }
        catch (Exception e) {
            System.out.println("unable to store and return the resource because of:\n" + e + "\n");
            return null;
        }
    }
}

