package org.gcube.datatransfer.scheduler.impl.context;

import static org.gcube.datatransfer.scheduler.impl.constants.Constants.*;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.resources.GCUBEResource.ResourceTopic;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerRIResourceConsumer;
import org.gcube.datatransfer.scheduler.is.ISManager;
//import org.gcube.datatransfer.scheduler.impl.db.DataTransferDBManager;
//import org.gcube.datatransfer.scheduler.impl.utils.Constants;



public class ServiceContext extends GCUBEServiceContext {

	/** Single context instance, created eagerly */
	private static ServiceContext cache = new ServiceContext();
	
	private DataTransferDBManager dbManager = null;
	private String dbConfigurationFileName = null;
	
	private ISManager<Agent> isManagerForAgents = null;
	private ISManager<DataSource> isManagerForSources = null;
	private ISManager<DataStorage> isManagerForStorages = null;
	
	@Override 
	protected void onInitialisation() throws Exception {
		//read from jndi
		this.dbConfigurationFileName = ((String)getProperty("dbConfigurationFile",true));
				
		this.dbManager = new DataTransferDBManager(this.dbConfigurationFileName, (String)getContext().getPersistenceRoot().getAbsolutePath(), (String)getContext().getProperty("configDir", true));
		getInstance().subscribeResourceEvents(new SchedulerRIResourceConsumer(), ResourceTopic.ADDSCOPE);
	}
	
	
	/** Returns cached instance */
	public static ServiceContext getContext() {return cache;}
	
	/** Prevents accidental creation of more instances */
	private ServiceContext(){};
		
	/** {@inheritDoc} */
	protected String getJNDIName() {return NAME;}
	
	public DataTransferDBManager getDbManager() {
		return dbManager;
	}

	public void setDbManager(DataTransferDBManager dbManager) {
		this.dbManager = dbManager;
	}

	public ISManager<Agent> getIsManagerForAgents() {
		return isManagerForAgents;
	}
	public void setIsManagerForAgents(ISManager<Agent> isManagerForAgents) {
		this.isManagerForAgents = isManagerForAgents;
	}

	public ISManager<DataSource> getIsManagerForSources() {
		return isManagerForSources;
	}
	public void setIsManagerForSources(ISManager<DataSource> isManagerForSources) {
		this.isManagerForSources = isManagerForSources;
	}

	public ISManager<DataStorage> getIsManagerForStorages() {
		return isManagerForStorages;
	}
	public void setIsManagerForStorages(ISManager<DataStorage> isManagerForStorages) {
		this.isManagerForStorages = isManagerForStorages;
	}

	public String getDbConfigurationFileName() {
		return dbConfigurationFileName;
	}
	public void setDbConfigurationFileName(String dbConfigurationFileName) {
		this.dbConfigurationFileName = dbConfigurationFileName;
	}

	
	
}
