/**
 * 
 */
package org.gcube.datatransfer.scheduler.impl.porttype;



import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SampleFault;
import org.gcube.common.core.contexts.GCUBEPortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * @author Fabio Simeoni
 *
 */




public class Stateless extends GCUBEPortType {

	private static GCUBELog logger = new GCUBELog(Stateless.class);
	
	public String about(String name) throws GCUBEFault, SampleFault {
		GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope("/gcube/devsec/"));

		StringBuilder output = new StringBuilder();		
		GHNContext nctx = GHNContext.getContext();
		ServiceContext sctx = ServiceContext.getContext();
		GCUBEPortTypeContext pctx = StatelessContext.getContext();
		try {
			output.append("Hello "+name).append(", you have invoked porttype ").
			append(pctx.getName()+" of service "+sctx.getName()).append(", which you found ").
			append (" on the GHN "+nctx.getGHNID()).
			append(" at "+pctx.getEPR()+" in the gCube infrastructure "+nctx.getGHN().getInfrastructure());
		}
		
		catch(GCUBEException e) {
			logger.error("Problem in about():",e);
			throw e.toFault();}
		catch(Exception e) {
			logger.error("Problem in about()",e);
			throw sctx.getDefaultException("Problem in about()", e).toFault();}

		return output.toString();
	}
	
	public String getAddr(String tmp) throws GCUBEFault, SampleFault {
		
		GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope("/gcube/devsec/"));

		ServiceContext sctx = ServiceContext.getContext();
		GCUBEPortTypeContext pctx = StatelessContext.getContext();
		try{
			return pctx.getEPR().toString().replaceFirst("Address: ", "").replaceAll("\n","");
		}
		catch(Exception e) {
			logger.error("Problem in about()",e);
			throw sctx.getDefaultException("Problem in about()", e).toFault();
		}

	}

	
	/**{@inheritDoc}*/
	@Override
	public GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}
}
