/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server.workers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;

public class ListFiles {
    int autoId;
    static int indentlvl;
    String rootPath;

    public ListFiles(String rootPath) {
        indentlvl = 0;
        this.autoId = 0;
        this.rootPath = rootPath;
    }

    public FolderDto process() {
        File dir = new File(this.rootPath);
        FolderDto folderToBeReturned = this.outFirstLevel(dir, indentlvl);
        return folderToBeReturned;
    }

    private FolderDto outFirstLevel(File dir, int indentlvl) {
        FolderDto empty = this.makeFolder("");
        FolderDto folder = this.makeFolder(dir.getAbsolutePath() + "/");
        if (dir.listFiles() == null) {
            System.out.println("empty folder: " + dir);
            folder.addChild(empty);
            return folder;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            FolderDto file = this.makeFolder(f.getAbsolutePath());
            folder.addChild(file);
        }
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            FolderDto childFolder = this.makeFolder(f.getAbsolutePath() + "/");
            childFolder.addChild(empty);
            folder.addChild(childFolder);
        }
        if (folder.getChildren().size() == 0) {
            folder.addChild(empty);
        }
        return folder;
    }

    private FolderDto out(File dir, int indentlvl) {
        FolderDto folder = this.makeFolder(dir.getAbsolutePath() + "/");
        if (dir.listFiles() == null) {
            System.out.println("empty folder: " + dir);
            FolderDto emptyFile = this.makeFolder("");
            folder.addChild(emptyFile);
            return folder;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            FolderDto file = this.makeFolder(f.getAbsolutePath());
            folder.addChild(file);
        }
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            FolderDto childFolder = this.out(f, indentlvl + 1);
            folder.addChild(childFolder);
        }
        if (folder.getChildren().size() == 0) {
            FolderDto emptyFile = this.makeFolder("");
            folder.addChild(emptyFile);
        }
        return folder;
    }

    private FolderDto makeFolder(String name) {
        FolderDto theReturn = new FolderDto(Integer.valueOf(++this.autoId), name);
        theReturn.setChildren(new ArrayList());
        return theReturn;
    }

    public void printFolder(FolderDto folder, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println("fold: name=" + folder.getName() + " - id=" + folder.getId());
        List tmpListOfChildren = folder.getChildren();
        if (tmpListOfChildren != null) {
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() > 0 || tmp.getName().compareTo("") == 0) continue;
                for (int i = 0; i < indent; ++i) {
                    System.out.print("\t");
                }
                String type = "";
                type = tmp.getName().substring(tmp.getName().length() - 1, tmp.getName().length()).compareTo("/") == 0 ? "fold" : "file";
                System.out.println(type + " : name=" + tmp.getName() + " - id=" + tmp.getId());
            }
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() <= 0) continue;
                this.printFolder(tmp, indent + 1);
            }
        }
    }
}

