/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server.workers;

import java.io.BufferedReader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.portlets.user.server.workers.CreateLocalSources;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;

public class ConnectionSMP {
    public int autoId;
    public String serviceClass;
    public String serviceName;
    public String owner;
    public String accessType;
    public GCUBEScope scope;
    public IClient client;
    public String rootPath;
    public URLConnection connection = null;
    public BufferedReader rd = null;
    public StringBuilder sb = null;
    List<String> errors = new ArrayList();

    public ConnectionSMP(String smServiceClassSource, String smServiceNameSource, String smOwnerSource, String smAccessTypeSource, String scope, String path) {
        this.serviceClass = smServiceClassSource;
        this.serviceName = smServiceNameSource;
        this.owner = smOwnerSource;
        this.accessType = smAccessTypeSource;
        this.scope = GCUBEScope.getScope((String)scope);
        this.rootPath = path;
        this.autoId = 0;
    }

    public FolderDto browse() {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            this.client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.valueOf((String)this.accessType.toUpperCase())).getClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.process();
    }

    public FolderDto process() {
        if (this.rootPath == null) {
            this.errors.add("ConnectionSMP(process) - rootPath is null");
            return null;
        }
        if (this.rootPath.startsWith(".")) {
            this.rootPath = this.rootPath.substring(1);
        }
        if (!this.rootPath.startsWith("/")) {
            this.rootPath = "/" + this.rootPath;
        }
        if (this.rootPath.endsWith(".")) {
            this.rootPath = this.rootPath.substring(0, this.rootPath.length() - 1);
        }
        if (!this.rootPath.endsWith("/")) {
            this.rootPath = this.rootPath + "/";
        }
        FolderDto empty = this.makeFolder("");
        FolderDto folder = this.makeFolder(this.rootPath);
        List result = this.client.showDir().RDir(this.rootPath);
        for (StorageObject obj : result) {
            if (!obj.isDirectory()) {
                FolderDto subf = this.makeFolder(this.rootPath + obj.getName());
                subf.setLink(this.client.getUrl().RFile(this.rootPath + obj.getName()));
                folder.addChild(subf);
                continue;
            }
            FolderDto subFolder = this.makeFolder(this.rootPath + obj.getName() + "/");
            subFolder.addChild(empty);
            folder.addChild(subFolder);
        }
        if (folder.getChildren().size() == 0) {
            folder.addChild(empty);
        }
        return folder;
    }

    public void printFolder(FolderDto folder, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println("fold : name=" + folder.getName() + " - id=" + folder.getId());
        List tmpListOfChildren = folder.getChildren();
        if (tmpListOfChildren != null) {
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() > 0 || tmp.getName().compareTo("") == 0) continue;
                for (int i = 0; i < indent; ++i) {
                    System.out.print("\t");
                }
                String type = "";
                type = tmp.getName().substring(tmp.getName().length() - 1, tmp.getName().length()).compareTo("/") == 0 ? "fold" : "file";
                System.out.println(type + " : name=" + tmp.getName() + " - id=" + tmp.getId());
            }
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() <= 0) continue;
                this.printFolder(tmp, indent + 1);
            }
        }
    }

    public FolderDto makeFolder(String name) {
        FolderDto theReturn = new FolderDto(Integer.valueOf(++this.autoId), name);
        theReturn.setChildren(new ArrayList());
        return theReturn;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public void storeNewFolder(String pathForNewFolder) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.valueOf((String)this.accessType.toUpperCase())).getClient();
            System.out.println("ConnectionSMP (storeNewFolder) - pathForNewFolder=" + pathForNewFolder);
            String localPath = new String(pathForNewFolder);
            if (localPath.startsWith("/")) {
                localPath = localPath.substring(1);
            }
            CreateLocalSources.createFile((String)(localPath + "empty"));
            this.client.put(true).LFile(localPath + "empty").RFile(pathForNewFolder + "empty");
            this.client.remove().RFile(pathForNewFolder + "empty");
            List result = this.client.showDir().RDir(pathForNewFolder);
            for (StorageObject obj : result) {
                if (obj.getName().compareTo("empty") != 0) continue;
                this.client.remove().RFile(pathForNewFolder + "empty");
            }
            CreateLocalSources.removeFileAndFolders((String)(localPath + "empty"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteFolder(String pathToDelete) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.valueOf((String)this.accessType.toUpperCase())).getClient();
            System.out.println("ConnectionSMP (storeNewFolder) - pathToDelete=" + pathToDelete);
            if (!pathToDelete.startsWith("/")) {
                pathToDelete = "/" + pathToDelete;
            }
            this.client.removeDir().RDir(pathToDelete);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sleepFiveSec() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("\nCheckDBForTransfersThread (sleepFiveSec)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }
}

