/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server.workers;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;
import org.gcube.datatransfer.portlets.user.shared.obj.WorkspaceInitializeInfo;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.RoleModel;

public class WorkspaceWorker
extends RemoteServiceServlet {
    private static final long serialVersionUID = 1L;
    public final String USERNAME_ATTRIBUTE = "username";
    public int autoId = 0;

    public ASLSession getASLSession(HttpSession httpSession) {
        String sessionID = httpSession.getId();
        String user = (String)httpSession.getAttribute("username");
        if (user == null) {
            user = (String)httpSession.getAttribute("user");
        }
        if (user == null) {
            System.out.println("WorkspaceWorker - getASLSession: user not found in session");
            return null;
        }
        System.out.println("WorkspaceWorker - getASLSession: user found in session " + user);
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getUserAndScopeAndRole(HttpServletRequest localRequest) {
        try {
            if (localRequest == null) {
                System.out.println("WorkspaceWorker - getUserAndScope: localRequest==null");
                return null;
            }
            HttpSession httpSession = localRequest.getSession();
            if (httpSession == null) {
                System.out.println("WorkspaceWorker - getUserAndScope: httpSession==null");
                return null;
            }
            ASLSession aslSession = this.getASLSession(httpSession);
            if (aslSession == null) {
                return null;
            }
            List roles = this.getUserRolesByGroup(aslSession);
            String res = "";
            for (String tmp : roles) {
                res = res + tmp + "\n";
            }
            System.out.println("WorkspaceWorker - getUserAndScope - roles:\n" + res);
            boolean isAdmin = this.checkAdminCase(roles);
            String name = aslSession.getUsername();
            String scope = aslSession.getScopeName();
            if (name == null || scope == null) {
                System.out.println("WorkspaceWorker - getUserAndScope: usern or scope is null");
                return null;
            }
            return name + "--" + scope + "--" + isAdmin;
        }
        catch (Exception e) {
            System.out.println("WorkspaceWorker - getUserAndScope: Exception ******");
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getUserRolesByGroup(ASLSession aslSession) {
        try {
            ArrayList<String> roles = new ArrayList<String>();
            LiferayRoleManager roleM = new LiferayRoleManager();
            LiferayGroupManager groupM = new LiferayGroupManager();
            LiferayUserManager userM = new LiferayUserManager();
            String userId = userM.getUserId(aslSession.getUsername());
            String groupId = groupM.getGroupId(aslSession.getGroupName());
            List userRolesByGroup = roleM.listRolesByUserAndGroup(groupId, userId);
            for (RoleModel tmp : userRolesByGroup) {
                roles.add(tmp.getRoleName());
            }
            return roles;
        }
        catch (UserManagementSystemException e) {
            e.printStackTrace();
            return null;
        }
        catch (GroupRetrievalFault e) {
            e.printStackTrace();
            return null;
        }
        catch (UserRetrievalFault e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean checkAdminCase(List<String> roles) {
        for (String role : roles) {
            if (role.compareTo("VO-Admin") != 0 && role.compareTo("VRE-Manager") != 0) continue;
            return true;
        }
        return false;
    }

    public String getWorkspace(HttpServletRequest localRequest) {
        try {
            ASLSession session = this.getASLSession(localRequest.getSession());
            if (session == null) {
                return null;
            }
            Workspace w = null;
            try {
                w = HomeLibrary.getUserWorkspace((ASLSession)session);
            }
            catch (WorkspaceFolderNotFoundException e) {
                e.printStackTrace();
            }
            catch (InternalErrorException e) {
                e.printStackTrace();
            }
            catch (HomeNotFoundException e) {
                e.printStackTrace();
            }
            if (w == null) {
                System.out.println("WorkspaceWorker - getWorkspace: workspace==null");
                return null;
            }
            WorkspaceInitializeInfo workspaceInfo = new WorkspaceInitializeInfo();
            workspaceInfo.setWorkspace(w);
            String serializedWorkspace = workspaceInfo.toXML();
            if (serializedWorkspace == null) {
                System.out.println("WorkspaceWorker - getWorkspace: serializedWorkspace==null");
                return null;
            }
            System.out.println("WorkspaceWorker - getWorkspace: serializedObj length=" + serializedWorkspace.length());
            return serializedWorkspace;
        }
        catch (Exception e) {
            System.out.println("WorkspaceWorker - getWorkspace: Exception ***");
            e.printStackTrace();
            return null;
        }
    }

    public Workspace getWorkspaceWithoutSerialization(HttpServletRequest localRequest) {
        try {
            ASLSession session = this.getASLSession(localRequest.getSession());
            if (session == null) {
                return null;
            }
            Workspace w = null;
            try {
                w = HomeLibrary.getUserWorkspace((ASLSession)session);
            }
            catch (WorkspaceFolderNotFoundException e) {
                e.printStackTrace();
            }
            catch (InternalErrorException e) {
                e.printStackTrace();
            }
            catch (HomeNotFoundException e) {
                e.printStackTrace();
            }
            if (w == null) {
                System.out.println("WorkspaceWorker - getWorkspaceWithoutSerialization: workspace==null");
                return null;
            }
            return w;
        }
        catch (Exception e) {
            System.out.println("WorkspaceWorker - getWorkspaceWithoutSerialization: Exception ***");
            e.printStackTrace();
            return null;
        }
    }

    public String fixPath(String workspaceWebDavLink, String path) {
        String tmpPath = path;
        if (path.startsWith("/")) {
            tmpPath = tmpPath.replaceFirst("/", "");
        }
        String[] partsOfPath = tmpPath.split("/");
        String[] partsOfwebdavUrl = workspaceWebDavLink.split("/");
        String fixedRootPath = "";
        if (partsOfwebdavUrl[partsOfwebdavUrl.length - 1].compareTo(partsOfPath[0]) == 0) {
            for (int i = 1; i <= partsOfPath.length - 1; ++i) {
                fixedRootPath = i < partsOfPath.length - 1 ? fixedRootPath + partsOfPath[i] + "/" : fixedRootPath + partsOfPath[i];
            }
            return fixedRootPath;
        }
        return tmpPath;
    }

    public FolderDto createTree(WorkspaceFolder root, String workspaceWebDavLink) throws InternalErrorException {
        if (root == null) {
            System.out.println("GET WORKSPACE MANUALLY - createTree - root is null");
            return null;
        }
        FolderDto empty = this.makeFolder("", null);
        FolderDto folder = null;
        List list = null;
        String rootPath = root.getPath();
        String fixedRootPath = this.fixPath(workspaceWebDavLink, rootPath);
        if (fixedRootPath.compareTo("") != 0 && !fixedRootPath.endsWith("/")) {
            fixedRootPath = fixedRootPath + "/";
        }
        folder = this.makeFolder(workspaceWebDavLink + "/" + fixedRootPath, root.getId());
        list = root.getChildren();
        if (list == null) {
            System.out.println("GET WORKSPACE MANUALLY - createTree - list is empty");
            return null;
        }
        if (list.size() < 1) {
            folder.addChild(empty);
            return folder;
        }
        for (WorkspaceItem tmp : list) {
            String fixedPath;
            String path;
            if (tmp.getType().toString().compareTo("FOLDER") == 0) {
                path = tmp.getPath();
                fixedPath = this.fixPath(workspaceWebDavLink, path);
                if (fixedPath.compareTo("") != 0 && !fixedPath.endsWith("/")) {
                    fixedPath = fixedPath + "/";
                }
                FolderDto subfolder = this.makeFolder(workspaceWebDavLink + "/" + fixedPath, tmp.getId());
                subfolder.addChild(empty);
                folder.addChild(subfolder);
                continue;
            }
            path = tmp.getPath();
            fixedPath = this.fixPath(workspaceWebDavLink, path);
            FolderDto child = this.makeFolder(workspaceWebDavLink + "/" + fixedPath, null);
            folder.addChild(child);
        }
        return folder;
    }

    public FolderDto makeFolder(String name, String idInWorkspace) {
        FolderDto theReturn = new FolderDto(Integer.valueOf(++this.autoId), name);
        if (idInWorkspace != null) {
            theReturn.setIdInWorkspace(idInWorkspace);
        }
        theReturn.setChildren(new ArrayList());
        return theReturn;
    }

    public void printFolder(FolderDto folder, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println("fold : name=" + folder.getName() + " - id=" + folder.getId() + " - idInWorkspace=" + folder.getIdInWorkspace());
        List tmpListOfChildren = folder.getChildren();
        if (tmpListOfChildren != null) {
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() > 0 || tmp.getName().compareTo("") == 0) continue;
                for (int i = 0; i < indent; ++i) {
                    System.out.print("\t");
                }
                String type = "";
                type = tmp.getName().substring(tmp.getName().length() - 1, tmp.getName().length()).compareTo("/") == 0 ? "fold" : "file";
                System.out.println(type + " : name=" + tmp.getName() + " - id=" + tmp.getId());
            }
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() <= 0) continue;
                this.printFolder(tmp, indent + 1);
            }
        }
    }

    public void getAttributes(HttpServletRequest localRequest) {
        if (localRequest == null) {
            System.out.println("WorkspaceWorker - getAttributes: localRequest==null");
            return;
        }
        HttpSession httpSession = localRequest.getSession();
        if (httpSession == null) {
            System.out.println("WorkspaceWorker - getAttributes: httpSession==null");
            return;
        }
        String sessionID = httpSession.getId();
        System.out.println("WorkspaceWorker - getAttributes: AttributeNames of session with id=" + sessionID + ":");
        Enumeration em = httpSession.getAttributeNames();
        while (em.hasMoreElements()) {
            String value = (String)em.nextElement();
            System.out.println("name=" + value + " - stringValue=" + httpSession.getAttribute(value).toString());
        }
    }
}

