/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server.workers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.gcube.data.trees.patterns.AnyPattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.scheduler.Types;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult;
import org.gcube.datatransfer.portlets.user.shared.obj.SchedulerObj;
import org.gcube.datatransfer.portlets.user.shared.obj.TransferInfo;
import org.gcube.datatransfer.portlets.user.shared.obj.TransferObjectInfo;
import org.gcube.datatransfer.scheduler.library.obj.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.library.obj.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.library.obj.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;

public class MappingWorker {
    public org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult mappedCallingSchedulerResult(CallingSchedulerResult result) {
        org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult mappedResult = new org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult();
        if (result.getCancelResult() != null) {
            mappedResult.setCancelResult(result.getCancelResult());
        }
        if (result.getErrors() != null) {
            mappedResult.setErrors(result.getErrors());
        }
        if (result.getMonitorResult() != null) {
            mappedResult.setMonitorResult(result.getMonitorResult());
        }
        if (result.getPrintResult() != null) {
            mappedResult.setPrintResult(result.getPrintResult());
        }
        if (result.getSchedulerOutcomes() != null) {
            mappedResult.setSchedulerOutcomes(result.getSchedulerOutcomes());
        }
        if (result.getStatus() != null) {
            mappedResult.setStatus(result.getStatus());
        }
        if (result.getTransferid() != null) {
            mappedResult.setTransferid(result.getTransferid());
        }
        return mappedResult;
    }

    public CallingManagementResult mappedcallingManagementResult(org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult result) {
        TransferInfo tmp;
        CallingManagementResult callingManagementResult = new CallingManagementResult();
        ArrayList<TransferInfo> allTheTransfers = new ArrayList<TransferInfo>();
        ArrayList<TransferInfo> allTheTransferObjects = new ArrayList<TransferInfo>();
        if (result == null) {
            System.out.println("'MappingWorker' - mappedcallingManagementResult: PROBLEM->given parameter 'result' was null ... ");
            return null;
        }
        if (result.getAllTheTransfersInDB() != null) {
            for (org.gcube.datatransfer.scheduler.library.outcome.TransferInfo transferInfo : result.getAllTheTransfersInDB()) {
                String stringDate;
                tmp = new TransferInfo();
                if (transferInfo.getTypeOfSchedule().isDirectedScheduled()) {
                    tmp.setTypeOfScheduleString("Direct");
                } else if (transferInfo.getTypeOfSchedule().getManuallyScheduled() != null) {
                    Calendar tmpCalendar = transferInfo.getTypeOfSchedule().getManuallyScheduled().getCalendar();
                    stringDate = transferInfo.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
                    if (stringDate != null) {
                        tmp.setTypeOfScheduleString("Manually Scheduled for: " + stringDate);
                    } else if (tmpCalendar != null) {
                        stringDate = this.getFormattedCalendarString(tmpCalendar);
                        tmp.setTypeOfScheduleString("Manually Scheduled for: " + stringDate);
                    } else {
                        tmpCalendar = Calendar.getInstance();
                        stringDate = this.getFormattedCalendarString(tmpCalendar);
                        tmp.setTypeOfScheduleString("Manually Scheduled for: " + stringDate);
                    }
                } else if (transferInfo.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
                    Calendar tmpCalendar = transferInfo.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance();
                    stringDate = transferInfo.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
                    String freq = "N_A";
                    if (transferInfo.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency() != null) {
                        freq = transferInfo.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency().getValue();
                    }
                    if (stringDate != null) {
                        tmp.setTypeOfScheduleString("Periodically Scheduled with frequency: " + freq + " - next transfer: " + stringDate);
                    } else if (tmpCalendar != null) {
                        stringDate = this.getFormattedCalendarString(tmpCalendar);
                        tmp.setTypeOfScheduleString("Periodically Scheduled with frequency: " + freq + " - next transfer: " + stringDate);
                    } else {
                        tmpCalendar = Calendar.getInstance();
                        stringDate = this.getFormattedCalendarString(tmpCalendar);
                        tmp.setTypeOfScheduleString("Periodically Scheduled with frequency: " + freq + " - next transfer: " + stringDate);
                    }
                } else {
                    tmp.setTypeOfScheduleString("");
                }
                if (transferInfo.getTransferIdOfAgent() != null) {
                    tmp.setTransferIdOfAgent(transferInfo.getTransferIdOfAgent());
                }
                if (transferInfo.getTransferId() != null) {
                    tmp.setTransferId(transferInfo.getTransferId());
                }
                if (transferInfo.getTransferError() != null) {
                    tmp.setTransferError(transferInfo.getTransferError());
                }
                if (transferInfo.getSubmitter() != null) {
                    tmp.setSubmitter(transferInfo.getSubmitter());
                }
                if (transferInfo.getStatus() != null) {
                    tmp.setStatus(transferInfo.getStatus());
                }
                if (transferInfo.getObjectTrasferredIDs() != null) {
                    tmp.setObjectTrasferredIDs(transferInfo.getObjectTrasferredIDs());
                }
                if (transferInfo.getObjectFailedIDs() != null) {
                    tmp.setObjectFailedIDs(transferInfo.getObjectFailedIDs());
                }
                if (transferInfo.getSubmittedDate() != null) {
                    tmp.setSubmittedDate(transferInfo.getSubmittedDate());
                }
                if (transferInfo.getTotal_size() != 0L) {
                    tmp.setTotal_size(transferInfo.getTotal_size());
                }
                if (transferInfo.getBytes_have_been_transferred() != 0L) {
                    tmp.setBytes_have_been_transferred(transferInfo.getBytes_have_been_transferred());
                }
                double progr = tmp.calculateProgress();
                if (transferInfo.getSubmittedDate() != null) {
                    tmp.setSubmittedDate(transferInfo.getSubmittedDate());
                }
                if (transferInfo.getNumOdUpdates() != 0) {
                    tmp.setNumOfUpdates(transferInfo.getNumOdUpdates());
                }
                allTheTransfers.add(tmp);
            }
        } else {
            System.out.println("'MappingWorker' - mappedcallingManagementResult: result.getAllTheTransfersInDB()==null !!");
        }
        if (result.getAllTheTransferObjectsInDB() != null) {
            for (org.gcube.datatransfer.scheduler.library.outcome.TransferObjectInfo transferObjectInfo : result.getAllTheTransferObjectsInDB()) {
                tmp = new TransferObjectInfo();
                if (transferObjectInfo.getObjectId() != null) {
                    tmp.setObjectId(transferObjectInfo.getObjectId());
                }
                if (transferObjectInfo.getSize() != null) {
                    tmp.setSize(transferObjectInfo.getSize());
                }
                if (transferObjectInfo.getTransferid() != null) {
                    tmp.setTransferid(transferObjectInfo.getTransferid());
                }
                if (transferObjectInfo.getURI() != null) {
                    tmp.setURI(transferObjectInfo.getURI().getPath());
                }
                allTheTransferObjects.add(tmp);
            }
        } else {
            System.out.println("'MappingWorker' - mappedcallingManagementResult: result.getAllTheTransferObjectsInDB()==null !!");
        }
        callingManagementResult.setAllTheTransfersInDB(allTheTransfers);
        callingManagementResult.setAllTheTransferObjectsInDB(allTheTransferObjects);
        if (result.getErrors() != null) {
            callingManagementResult.setErrors(result.getErrors());
        }
        if (result.getGetAllTransfersInfoResult() != null) {
            callingManagementResult.setGetAllTransfersInfoResult(result.getGetAllTransfersInfoResult());
        }
        return callingManagementResult;
    }

    public org.gcube.datatransfer.scheduler.library.obj.SchedulerObj mappedSchedulerObj(SchedulerObj obj) {
        org.gcube.datatransfer.scheduler.library.obj.SchedulerObj mappedObj = new org.gcube.datatransfer.scheduler.library.obj.SchedulerObj();
        if (obj.getAgentHostname().compareTo("") != 0) {
            mappedObj.setAgentHostname(obj.getAgentHostname());
        } else {
            mappedObj.setAgentHostname(null);
        }
        if (obj.getDataSourceId().compareTo("") != 0) {
            mappedObj.setDataSourceId(obj.getDataSourceId());
        } else {
            mappedObj.setDataSourceId(null);
        }
        if (obj.getDataStorageId().compareTo("") != 0) {
            mappedObj.setDataStorageId(obj.getDataStorageId());
        } else {
            mappedObj.setDataStorageId(null);
        }
        if (obj.getDestinationFolder().compareTo("") != 0) {
            mappedObj.setDestinationFolder(obj.getDestinationFolder());
        } else {
            mappedObj.setDestinationFolder(null);
        }
        if (obj.getScope().compareTo("") != 0) {
            mappedObj.setScope(obj.getScope());
        } else {
            mappedObj.setScope(null);
        }
        if (obj.getTypeOfTransfer().compareTo("") != 0) {
            mappedObj.setTypeOfTransfer(obj.getTypeOfTransfer());
        } else {
            mappedObj.setTypeOfTransfer(null);
        }
        if (obj.getSubmittedDate().compareTo("") != 0) {
            mappedObj.setSubmittedDate(obj.getSubmittedDate());
        } else {
            mappedObj.setSubmittedDate(null);
        }
        if (obj.getTypeOfTransfer().compareTo("TreeBasedTransfer") == 0) {
            AnyPattern pattern = Patterns.any();
            mappedObj.setPattern((Pattern)pattern);
            mappedObj.setTreeSourceID(obj.getDataSourceId());
            mappedObj.setTreeStorageID(obj.getDataStorageId());
        }
        if (obj.getInputUrls().size() > 0) {
            String[] inputArray = obj.getInputUrls().toArray(new String[obj.getInputUrls().size()]);
            mappedObj.setInputUrls(inputArray);
            mappedObj.setOutputUrls((String[])inputArray.clone());
        } else {
            mappedObj.setInputUrls(null);
            mappedObj.setOutputUrls(null);
        }
        mappedObj.setOverwrite(obj.getOverwrite());
        mappedObj.setUnzipFile(obj.getUnzipFile());
        mappedObj.setSyncOp(obj.getSyncOp());
        if (obj.getStorageType().compareTo("") != 0) {
            mappedObj.setTypeOfStorage(Types.storageType.valueOf((String)obj.getStorageType()));
        } else {
            mappedObj.setTypeOfStorage(null);
        }
        if (obj.getAccessType().compareTo("") != 0) {
            Types.StorageManagerDetails smDetails = new Types.StorageManagerDetails();
            smDetails.setAccessType(Types.storageAccessType.valueOf((String)obj.getAccessType()));
            smDetails.setOwner(obj.getOwner());
            smDetails.setServiceClass(obj.getServiceClass());
            smDetails.setServiceName(obj.getServiceName());
            mappedObj.setSmDetails(smDetails);
        } else {
            mappedObj.setSmDetails(null);
        }
        TypeOfSchedule typeOfSchedule = new TypeOfSchedule();
        if (obj.getTypeOfSchedule().getDirectedScheduled()) {
            typeOfSchedule.setDirectedScheduled(true);
        } else if (obj.getTypeOfSchedule().getManuallyScheduled().getInstanceString().compareTo("") != 0) {
            ManuallyScheduled manuallyScheduled = new ManuallyScheduled();
            String instanceString = obj.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
            Calendar tmpCalendar = Calendar.getInstance();
            Date tmpDate = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            if (instanceString.compareToIgnoreCase("") != 0) {
                try {
                    tmpDate = formatter.parse(instanceString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmpCalendar.setTime(tmpDate);
            }
            manuallyScheduled.setCalendar(tmpCalendar);
            manuallyScheduled.setInstanceString(obj.getTypeOfSchedule().getManuallyScheduled().getInstanceString());
            typeOfSchedule.setManuallyScheduled(manuallyScheduled);
        } else if (obj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString().compareTo("") != 0) {
            PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
            Types.FrequencyType frequency = Types.FrequencyType.fromString((String)obj.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency());
            periodicallyScheduled.setFrequency(frequency);
            String startInstanceString = obj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
            Calendar tmpCalendar = Calendar.getInstance();
            Date tmpDate = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            if (startInstanceString.compareToIgnoreCase("") != 0) {
                try {
                    tmpDate = formatter.parse(startInstanceString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmpCalendar.setTime(tmpDate);
            }
            periodicallyScheduled.setStartInstance(tmpCalendar);
            periodicallyScheduled.setStartInstanceString(obj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString());
            typeOfSchedule.setPeriodicallyScheduled(periodicallyScheduled);
        }
        mappedObj.setTypeOfSchedule(typeOfSchedule);
        return mappedObj;
    }

    public String getFormattedCalendarString(Calendar instance) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, instance.get(1));
        calendar.set(2, instance.get(2));
        calendar.set(5, instance.get(5));
        calendar.set(11, instance.get(11));
        calendar.set(12, instance.get(12));
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy-HH.mm");
        String date = sdf.format(calendar.getTime());
        return date;
    }
}

