/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.scheduler.library.BinderLibrary;
import org.gcube.datatransfer.scheduler.library.ManagementLibrary;
import org.gcube.datatransfer.scheduler.library.SchedulerLibrary;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.gcube.datatransfer.scheduler.library.proxies.Proxies;

public class SchedulerProxy {
    SchedulerLibrary schedulerLibrary = null;

    public void retrieveSchedulerLibrary(String scope, String ResourceName) {
        ScopeProvider.instance.set(scope);
        BinderLibrary binderLibrary = null;
        try {
            binderLibrary = (BinderLibrary)Proxies.transferBinder().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerBinder(..)\n" + e);
        }
        W3CEndpointReference schedulerEpr = null;
        try {
            schedulerEpr = binderLibrary.bind(ResourceName);
        }
        catch (Exception e) {
            System.err.print("exception when calling binderLibrary.bind(..).. \n" + e);
        }
        try {
            this.schedulerLibrary = (SchedulerLibrary)Proxies.transferScheduler().at(schedulerEpr).withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferScheduler(..).at(..)\n" + e);
        }
    }

    public CallingSchedulerResult cancel(String transferId, boolean force) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.cancelTransfer(transferId, force);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.cancelTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public CallingSchedulerResult monitor(String transferId) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.monitorTransfer(transferId);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.monitorTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public CallingSchedulerResult getOutcomes(String transferId) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.getOutcomesOfTransfer(transferId);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.getOutcomesOfTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public String schedule(SchedulerObj schedulerObj, String scope, String resourceName, String workspacePass, String sourceType, String destinationFolder) {
        Date tmpDate;
        SimpleDateFormat formatter;
        int num;
        if (schedulerObj.getDataSourceId() != null) {
            String[] sourcesArray;
            String nameDSOURCE = null;
            String descriptionDSOURCE = null;
            String hostDSOURCE = null;
            String userDSOURCE = null;
            String passDSOURCE = null;
            String result = this.getObjectsFromIS("DataSource", resourceName, scope);
            if (result == null) {
                System.out.println("SchedulerProxy - schedule - getObjectsFromIS(DataSources) - result=null");
                return null;
            }
            for (String tmp : sourcesArray = result.split("\n")) {
                String[] partsOfInfo = tmp.split("--");
                if (partsOfInfo[0].compareTo(schedulerObj.getDataSourceId()) != 0) continue;
                nameDSOURCE = partsOfInfo[1];
                descriptionDSOURCE = partsOfInfo[2];
                hostDSOURCE = partsOfInfo[3];
                userDSOURCE = partsOfInfo[4];
                passDSOURCE = partsOfInfo[5];
                break;
            }
            if (hostDSOURCE == null || nameDSOURCE == null) {
                System.out.println("SchedulerProxy - schedule - cannot find the datasource in IS");
                return null;
            }
            String[] inputURIS = schedulerObj.getInputUrls();
            String header = "";
            if (nameDSOURCE.startsWith("FTP")) {
                if (userDSOURCE == null || passDSOURCE == null) {
                    System.out.println("GET FILE LIST OF DATASOURCE - FTP datasource does not have 'username' or/and 'password' in IS");
                    return null;
                }
                String[] partsOfEndpoint = hostDSOURCE.split("//");
                if (partsOfEndpoint.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                header = partsOfEndpoint[0] + "//" + userDSOURCE + ":" + passDSOURCE + "@" + partsOfEndpoint[1];
                if (!header.endsWith("/")) {
                    header = header + "/";
                }
            } else if (nameDSOURCE.startsWith("HTTP") || nameDSOURCE.startsWith("HTTPS")) {
                if (userDSOURCE == null || passDSOURCE == null) {
                    header = hostDSOURCE;
                    if (!header.endsWith("/")) {
                        header = header + "/";
                    }
                } else {
                    String[] partsOfEndpoint = hostDSOURCE.split("//");
                    if (partsOfEndpoint.length < 2) {
                        System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                        return null;
                    }
                    header = partsOfEndpoint[0] + "//" + userDSOURCE + ":" + passDSOURCE + "@" + partsOfEndpoint[1];
                    if (!header.endsWith("/")) {
                        header = header + "/";
                    }
                }
            }
            num = 0;
            for (String tmp : inputURIS) {
                inputURIS[num] = header + tmp + "/";
                ++num;
            }
            schedulerObj.setInputUrls(inputURIS);
        } else if (workspacePass.compareTo("") != 0) {
            String user = resourceName;
            String[] inputURIS = schedulerObj.getInputUrls();
            int num2 = 0;
            for (String tmp : inputURIS) {
                String authenticatedLink;
                String[] partsOfLink = tmp.split("//");
                if (partsOfLink.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                inputURIS[num2] = authenticatedLink = "webdav://" + user + ":" + workspacePass + "@" + partsOfLink[1];
                ++num2;
            }
            schedulerObj.setInputUrls(inputURIS);
        }
        if (schedulerObj.getInputUrls() != null) {
            ArrayList<String> encodedUris = new ArrayList<String>();
            for (String tmp : schedulerObj.getInputUrls()) {
                encodedUris.add(tmp.replaceAll(" ", "%20"));
            }
            String[] encodedArray = new String[encodedUris.size()];
            for (int i = 0; i < encodedUris.size(); ++i) {
                encodedArray[i] = (String)encodedUris.get(i);
            }
            schedulerObj.setInputUrls(encodedArray);
        }
        if (schedulerObj.getDataStorageId() != null) {
            String[] sourcesArray;
            String nameDSTORAGE = null;
            String hostDSTORAGE = null;
            String userDSTORAGE = null;
            String passDSTORAGE = null;
            String result = this.getObjectsFromIS("DataStorage", resourceName, scope);
            if (result == null) {
                System.out.println("SchedulerProxy - schedule - getObjectsFromIS(DataStorages) - result=null");
                return null;
            }
            for (String tmp : sourcesArray = result.split("\n")) {
                String[] partsOfInfo = tmp.split("--");
                if (partsOfInfo[0].compareTo(schedulerObj.getDataStorageId()) != 0) continue;
                nameDSTORAGE = partsOfInfo[1];
                hostDSTORAGE = partsOfInfo[3];
                userDSTORAGE = partsOfInfo[4];
                passDSTORAGE = partsOfInfo[5];
                break;
            }
            if (hostDSTORAGE == null || nameDSTORAGE == null) {
                System.out.println("SchedulerProxy - schedule - cannot find the datastorage in IS");
                return null;
            }
            String[] outputURIS = schedulerObj.getOutputUrls();
            String header = "";
            if (nameDSTORAGE.startsWith("FTP")) {
                if (userDSTORAGE == null || passDSTORAGE == null) {
                    System.out.println("GET FILE LIST OF DATASTORAGE - FTP datastorage does not have 'username' or/and 'password' in IS");
                    return null;
                }
                String[] partsOfEndpoint = hostDSTORAGE.split("//");
                if (partsOfEndpoint.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                header = partsOfEndpoint[0] + "//" + userDSTORAGE + ":" + passDSTORAGE + "@" + partsOfEndpoint[1];
                if (!header.endsWith("/")) {
                    header = header + "/";
                }
            } else if (nameDSTORAGE.startsWith("HTTP") || nameDSTORAGE.startsWith("HTTPS")) {
                if (userDSTORAGE == null || passDSTORAGE == null) {
                    header = hostDSTORAGE;
                    if (!header.endsWith("/")) {
                        header = header + "/";
                    }
                } else {
                    String[] partsOfEndpoint = hostDSTORAGE.split("//");
                    if (partsOfEndpoint.length < 2) {
                        System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                        return null;
                    }
                    header = partsOfEndpoint[0] + "//" + userDSTORAGE + ":" + passDSTORAGE + "@" + partsOfEndpoint[1];
                    if (!header.endsWith("/")) {
                        header = header + "/";
                    }
                }
            }
            String[] newOutPutUris = (String[])outputURIS.clone();
            newOutPutUris = this.keepOnlyTheLastPart(newOutPutUris);
            num = 0;
            if (!destinationFolder.endsWith("/")) {
                destinationFolder = destinationFolder + "/";
            }
            for (String tmp : newOutPutUris) {
                outputURIS[num] = header + destinationFolder + tmp + "/";
                ++num;
            }
            schedulerObj.setOutputUrls(outputURIS);
        }
        if (schedulerObj.getOutputUrls() != null) {
            // empty if block
        }
        if (schedulerObj.getTypeOfSchedule().getManuallyScheduled() != null) {
            formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            tmpDate = null;
            String instanceString = schedulerObj.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
            try {
                tmpDate = formatter.parse(instanceString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Calendar tmpCalendar = Calendar.getInstance();
            tmpCalendar.setTime(tmpDate);
            schedulerObj.getTypeOfSchedule().getManuallyScheduled().setCalendar(tmpCalendar);
        } else if (schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
            formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            tmpDate = null;
            String startInstanceString = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
            Calendar tmpCalendar = Calendar.getInstance();
            if (startInstanceString.compareToIgnoreCase("now") != 0) {
                try {
                    tmpDate = formatter.parse(startInstanceString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmpCalendar.setTime(tmpDate);
            }
            schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstance(tmpCalendar);
        }
        System.out.println("SchedulerProxy - schedule - input URLS:");
        for (String tmp : schedulerObj.getInputUrls()) {
            System.out.println("'" + tmp + "'");
        }
        System.out.println("SchedulerProxy - schedule - output URLS:");
        for (String tmp : schedulerObj.getOutputUrls()) {
            System.out.println("'" + tmp + "'");
        }
        String transferId = null;
        try {
            transferId = this.schedulerLibrary.scheduleTransfer(schedulerObj);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.localFileBasedTransfer(..) \n" + e);
        }
        return transferId;
    }

    public CallingManagementResult getTransfers(String resourceName, String scope) {
        System.out.println("SchedulerProxy (getTransfers) - resourceName=" + resourceName + " - scope=" + scope);
        ScopeProvider.instance.set(scope);
        System.out.println("SchedulerProxy (getTransfers) - set scope is:" + ScopeProvider.instance.get());
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        CallingManagementResult callingManagementResult = null;
        try {
            callingManagementResult = managementLibrary.getAllTransfersInfo(resourceName);
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n" + e);
        }
        return callingManagementResult;
    }

    public String getObjectsFromIS(String type, String resourceName, String scope) {
        System.out.println("SchedulerProxy (getObjectsFromIS) - type=" + type + " - resourceName=" + resourceName + " - scope=" + scope);
        ScopeProvider.instance.set(scope);
        System.out.println("SchedulerProxy (getObjectsFromIS) - set scope is:" + ScopeProvider.instance.get());
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        String typeOfObj = type;
        String result = null;
        try {
            result = managementLibrary.getObjectsFromIS(typeOfObj);
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n" + e);
        }
        return result;
    }

    public String getAgentStatistics(String scope) {
        ScopeProvider.instance.set(scope);
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        String result = null;
        try {
            result = managementLibrary.getAgentStatistics();
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAgentStatistics().. \n" + e);
        }
        return result;
    }

    public String[] keepOnlyTheLastPart(String[] uris) {
        ArrayList<String> changedUris = new ArrayList<String>();
        for (String uri : uris) {
            String tmp;
            if (uri.startsWith("smp")) {
                String[] uriParts = uri.split("\\?");
                tmp = uriParts[0].replaceFirst("smp://", "");
            } else {
                tmp = uri;
            }
            String[] parts = tmp.split("/");
            String lastPart = parts[parts.length - 1];
            changedUris.add(lastPart);
        }
        String[] returnArray = new String[changedUris.size()];
        int i = 0;
        Iterator i$ = changedUris.iterator();
        while (i$.hasNext()) {
            String tmp;
            returnArray[i] = tmp = (String)i$.next();
            ++i;
        }
        return returnArray;
    }
}

