package org.gcube.datatransfer.portlets.user.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.gcube.datatransfer.portlets.user.client.obj.AgentStat;
import org.gcube.datatransfer.portlets.user.client.obj.Outcomes;
import org.gcube.datatransfer.portlets.user.client.obj.Uri;
import org.gcube.datatransfer.portlets.user.client.prop.AgentStatProperties;
import org.gcube.datatransfer.portlets.user.client.prop.OutcomesProperties;
import org.gcube.datatransfer.portlets.user.client.prop.UriProperties;
import org.gcube.datatransfer.portlets.user.shared.SchedulerService;
import org.gcube.datatransfer.portlets.user.shared.SchedulerServiceAsync;
import org.gcube.datatransfer.portlets.user.shared.obj.BaseDto;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;
import org.gcube.datatransfer.portlets.user.shared.obj.ManuallyScheduled;
import org.gcube.datatransfer.portlets.user.shared.obj.PeriodicallyScheduled;
import org.gcube.datatransfer.portlets.user.shared.obj.SchedulerObj;
import org.gcube.datatransfer.portlets.user.shared.obj.TransferInfo;
import org.gcube.datatransfer.portlets.user.shared.obj.TypeOfSchedule;
import org.gcube.datatransfer.portlets.user.shared.prop.BaseDtoProperties;
import org.gcube.datatransfer.portlets.user.shared.prop.TransferInfoProperties;
import org.gcube.portlets.user.guidedtour.client.GCUBEGuidedTour;
import org.gcube.portlets.user.guidedtour.client.steps.GCUBETemplate1Text1Image;
import org.gcube.portlets.user.guidedtour.client.steps.GCUBETemplate2Text2Image;
import org.gcube.portlets.user.guidedtour.client.steps.TourStep;
import org.gcube.portlets.user.guidedtour.client.types.ThemeColor;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.BorderStyle;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat.PredefinedFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ProgressBarCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.Side;
import com.sencha.gxt.core.client.util.DateWrapper;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.SortDir;
import com.sencha.gxt.data.shared.Store.StoreSortInfo;
import com.sencha.gxt.data.shared.TreeStore;
import com.sencha.gxt.data.shared.event.StoreAddEvent;
import com.sencha.gxt.data.shared.event.StoreAddEvent.StoreAddHandler;
import com.sencha.gxt.dnd.core.client.DndDropEvent;
import com.sencha.gxt.dnd.core.client.DndDropEvent.DndDropHandler;
import com.sencha.gxt.dnd.core.client.TreeDragSource;
import com.sencha.gxt.dnd.core.client.TreeDropTarget;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.Dialog.PredefinedButton;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.MessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.button.ToolButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HorizontalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HorizontalLayoutContainer.HorizontalLayoutData;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.BeforeExpandItemEvent;
import com.sencha.gxt.widget.core.client.event.BeforeExpandItemEvent.BeforeExpandItemHandler;
import com.sencha.gxt.widget.core.client.event.CollapseEvent;
import com.sencha.gxt.widget.core.client.event.CollapseEvent.CollapseHandler;
import com.sencha.gxt.widget.core.client.event.DisableEvent;
import com.sencha.gxt.widget.core.client.event.DisableEvent.DisableHandler;
import com.sencha.gxt.widget.core.client.event.ExpandItemEvent;
import com.sencha.gxt.widget.core.client.event.ExpandItemEvent.ExpandItemHandler;
import com.sencha.gxt.widget.core.client.event.FocusEvent;
import com.sencha.gxt.widget.core.client.event.FocusEvent.FocusHandler;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.ParseErrorEvent;
import com.sencha.gxt.widget.core.client.event.ParseErrorEvent.ParseErrorHandler;
import com.sencha.gxt.widget.core.client.event.RowDoubleClickEvent;
import com.sencha.gxt.widget.core.client.event.RowDoubleClickEvent.RowDoubleClickHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.CheckBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.PasswordField;
import com.sencha.gxt.widget.core.client.form.SimpleComboBox;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.form.TimeField;
import com.sencha.gxt.widget.core.client.form.validator.MinDateValidator;
import com.sencha.gxt.widget.core.client.grid.CellSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.Grid.GridCell;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.RowExpander;
import com.sencha.gxt.widget.core.client.grid.editing.GridEditing;
import com.sencha.gxt.widget.core.client.grid.editing.GridRowEditing;
import com.sencha.gxt.widget.core.client.grid.filters.DateFilter;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.info.Info;
import com.sencha.gxt.widget.core.client.tips.ToolTipConfig;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import com.sencha.gxt.widget.core.client.tree.Tree;
import com.sencha.gxt.widget.core.client.tree.Tree.TreeNode;

public class SchedulerPortlet implements EntryPoint, IsWidget {

	// services
	private final SchedulerServiceAsync schedulerService = GWT
			.create(SchedulerService.class);

	// default values
	private String specificationLink = "https://gcube.wiki.gcube-system.org/gcube/index.php/Web_Application_Scheduler_Portlet";
	private String destinationFolder = "/devTest";
	private String defaultResourceName = "testing"; // this specific value will
	// be used only in case of not retrieved session
	private String defaultScope = "/gcube"; // this specific value will
	// be used only in case of not retrieved session
	private boolean isAdmin = false;
	private int minGenWidth = 800; // the minimum width of the portlet
	private int totalWidth = 0;
	private int minGenHeight = 450;// the minimum height of the portlet
	Timer focusTimer;
	private FocusPanel foc;
	private PopupPanel loadingIconForSource,loadingIconForTarget,loadingIconForTransfers;

	// general
	private FramedPanel panelGeneral;
	private String agentHostname;
	private List<String> inputUrls;
	private boolean callingWorkspaceRoot;
	private String idWorkspaceRoot;
	private int autoId;
	private Timer getTransferTimer, getTransferRepeatingTimer;

	//about agents
	private enum FolderToRetrieve{MongoDBStorageFolder,AgentDestFolder,DataStorageFolder,NONE};
	private boolean agentIsSelectedFromStatsPanel=false;
	// dialog box
	private DialogBox dialogBoxGen;
	private Button closeButton;

	// widget: layout
	private VerticalPanel west, east;
	private ContentPanel south;

	// widget: scheduler
	private SimpleComboBox<String> frequency, typeOfSchedule, commands;
	private TextField ResourceName, scope, transferId;
	private FieldLabel dateLabel, timeLabel;
	private CheckBox force, overwrite, unzip;
	private DateField date;
	private TimeField time;

	// widget: tool bar
	private SimpleComboBox<String> combo1, comboAgent, destCombo;
	private TextField destinationF;
	private LabelToolItem combo1Label, destLabel, destLabelF;
	private TextButton hideSchedulerButton, showSchedulerButton, sendButton, makeNewFolder, deleteCurrentFolder;
	private String lastCombo1Value, lastDestComboValue;
	private ToolTipConfig destinationAnchor, sourceAnchor;

	// widget: list files
	private TreeStore<BaseDto> sourceStore, targetStore, toBeTransferredStore;
	private Tree<BaseDto, String> sourceTree, targetTree;
	private TreeDropTarget<BaseDto> targetTreeDropTarget;
	private HorizontalLayoutContainer vpListFiles;
	private String lastSelectedFolderId;
	private boolean neededParent;
	private ToolBar toolbarSource,toolbarDestF;

	// pop up: type of source
	ListBox multiBoxSourceType;

	// pop up: type of destination
	ListBox multiBoxDestinationType;

	// pop up: operate specific transfer
	private SimpleComboBox<String> commandsInGrid;
	private TextField ResourceNameInGrid, scopeInGrid, transferIdInGrid;
	private CheckBox forceInGrid;

	// pop up: create NewFolder in the destination tree
	private TextField newFolderField;

	// pop up: Agent for Source
	private String currentAgentSourcePath, selectedAgentSourcePath,
	lastSelectedAgentFolderName;
	private String selectedAgentSource, selectedAgentSourcePort;

	//agent'node destination details
	private String currentAgentDestinationPath,selectedAgentDestinationPath,
	lastSelectedAgentFolderDestName;
	private String selectedAgentDestination, selectedAgentDestinationPort;

	// pop up: MongoDBStorage details for Source
	private TextField smServiceNameSource, smServiceClassSource, smOwnerSource;
	private SimpleComboBox<String> smAccessTypeSource;
	private String currentMongoDBSourcePath, selectedMongoDBSourcePath,
	lastSelectedMongoDBFolderName;
	private CheckBox defaultValuesStorage;

	// pop up: MongoDBStorage details
	private TextField smServiceName, smServiceClass, smOwner;
	private SimpleComboBox<String> smAccessType;
	private String currentMongoDBDestinationPath, selectedMongoDBDestinationPath,
	lastSelectedMongoDBFolderDestName;
	private CheckBox defaultValuesSource;
	
	// pop up: Workspace authentication
	private PasswordField passWorkspace;

	// pop up: data storages
	private List<String> dataStoragesList;
	private String selectedDatastorageName;
	private ListBox multiBoxDataStorages;
	private String selectedDataStorageId;
	private String currentDataStoragePath, selectedDatastoragePath,
	lastSelectedDatastorageFolderName;

	// pop up: URI's widget
	private Grid<Uri> uriGrid;
	private ListStore<Uri> storeForUris;
	private GridEditing<Uri> editing;
	private ColumnConfig<Uri, String> cc1Uris;
	private ColumnConfig<Uri, String> cc2Uris;

	private GridEditing<Uri> createGridEditing(Grid<Uri> editableGrid) {
		return new GridRowEditing<Uri>(editableGrid);
	}

	// pop up: data sources
	private ListBox multiBoxDataSources;
	private List<String> dataSourcesList;
	private String selectedDataSourceId, selectedDatasourcePath,
	currentDataSourcePath,lastSelectedDataSourceFolderName;

	// pop up: agent statistics
	private String stringOfAgentStats;
	private List<AgentStat> listAgentStats;
	private Grid<AgentStat> gridAgentStats;
	private ListStore<AgentStat> storeAgentStats;
	private ColumnModel<AgentStat> cmAgentStat;

	// json objects
	private String callingManagementResultJson;
	private String folderResSource, folderResDestination;
	private String jsonWorkspace;

	// objects from json
	private CallingManagementResult callingManagementResult;
	private CallingSchedulerResult callingSchedulerResult;
	private FolderDto folderSource,folderDestination;

	// object properties
	private UriProperties uriProp = GWT.create(UriProperties.class);
	private TransferInfoProperties transferInfoProp = GWT
			.create(TransferInfoProperties.class);
	private AgentStatProperties agentStatProp = GWT
			.create(AgentStatProperties.class);
	private OutcomesProperties outcomesProp = GWT
			.create(OutcomesProperties.class);
	private BaseDtoProperties baseDtoProp = GWT.create(BaseDtoProperties.class);

	// other
	private ListStore<TransferInfo> store;
	private Grid<TransferInfo> grid;
	private boolean gettingUserAndScope = false;
	private String stringOfAgents;
	private ListBox multiBoxAgents;
	private List<Outcomes> listOutcomes;
	private String printFolderString;
	private ToolButton agentStats;
	private ToolTipConfig agentStatsTooltip;
	/*
	 * onModuleLoad input: Nothing -- returns: Nothing This is the entry point
	 * method.
	 */
	public void onModuleLoad() {
		folderSource = makeFolder("Empty source");
		folderDestination = makeFolder("Empty destination");
		// some default URI's
		Uri temp = new Uri();
		storeForUris = new ListStore<Uri>(uriProp.key());
		temp.setName("WikiPhoto1");
		temp.setURI("http://upload.wikimedia.org/wikipedia/commons/6/6e/Wikipedia_logo_silver.png");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);
		temp = new Uri();
		temp.setName("WikiPhoto2");
		temp.setURI("http://upload.wikimedia.org/wikipedia/commons/0/0c/Fira_at_Santorini_%28from_north%29.jpg");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);
		temp = new Uri();
		temp.setName("29MbFile.iso");
		temp.setURI("http://ftp.lip6.fr/pub/linux/distributions/scientific/6.0/x86_64/os/images/pxeboot/initrd.img");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);
		temp = new Uri();
		temp.setName("BigFile.iso");
		temp.setURI("http://ftp.lip6.fr/pub/linux/distributions/scientific/6.0/x86_64/iso/SL-60-x86_64-2011-03-03-Everything-DVD2.iso");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);

		// get user name and scope from the session
		getUserAndScopeAndRole();
		// set the auto Id for making folders in the tree
		autoId = 0;
		// create the dialog box general
		setDialogBoxForMessages();
		// set the border layout
		RootPanel.get("mainContainer").add(asWidgetLayout());
		totalWidth = RootPanel.get("mainContainer").getOffsetWidth();
		if (totalWidth < minGenWidth)
			totalWidth = minGenWidth;

		// set the west widget for main scheduler service
		west.add(asWidgetScheduler());
		// set the central widget for choosing files
		east.clear();
		east.add(asWidgetToolbar());
		east.add(asWidgetListFiles());

		// getting the agents
		Timer getAgentTimer = new Timer() {
			@Override
			public void run() {
				getAgents();
				Info.display("", "");
			}
		};
		getAgentTimer.schedule(2000);
		// getting the workspace variable in order to retrieve later the
		// workspace root folderSource
		getWorkspace();


		// resize handler
		Window.addResizeHandler(new ResizeHandler() {
			Timer resizeTimer = new Timer() {
				@Override
				public void run() {
					reDraw();
				}
			};
			@Override
			public void onResize(ResizeEvent event) {
				resizeTimer.schedule(400); // ms
			}
		});

		// ... TIMERS ...
		focusTimer = new Timer() {
			@Override
			public void run() {
				foc.setFocus(true);
			}
		};

		getTransferTimer = new Timer() {
			@Override
			public void run() {
				getTransfers();
				Info.display("", "Refreshing transfers");
			}
		};
		// auto refresh every 30s
		getTransferRepeatingTimer = new Timer() {
			@Override
			public void run() {
				getTransfers();
				Info.display("", "Refreshing transfers");
			}
		};

		showGuidedTour();
	}

	private void showGuidedTour() {
		String title;
		List<String> images = new ArrayList<String>();
		List<String> textArrays = new ArrayList<String>();

		// Main
		title = "Main Form";
		images.add("gxt/images/tourGuide/main.png");
		textArrays
		.add("On the left side, there is the main form where the user "
				+ "can choose between several ways of scheduling such as 'direct',"
				+ "'manually' by giving the specific time instance and "
				+ "'periodically' by giving the frequency and the start time instance.");
		TourStep step1 = createTemplateStep(title, images, textArrays);

		// Toolbar
		images = new ArrayList<String>();
		textArrays = new ArrayList<String>();
		title = "Toolbar";
		images.add("gxt/images/tourGuide/toolbar.png");
		textArrays
		.add("On the right and up side, there is a toolbar where the user "
				+ "selects the source and the destination. Available source types are workspace, "
				+ "datasource and URI's. When the user chooses the source, several files from "
				+ "the source are shown in the source panel. The user can select the files he wants "
				+ "to transfer via dragging and dropping them in the target panel on the right. ");
		TourStep step2 = createTemplateStep(title, images, textArrays);

		// Source & Target Panel
		images = new ArrayList<String>();
		textArrays = new ArrayList<String>();
		title = "Source & Target Panel";
		images.add("gxt/images/tourGuide/panels.png");
		textArrays
		.add("Source panel is the panel which contains the folders and files where the "
				+ "user will select from. Targer panel is the one containing the files that user wants to "
				+ "schedule for transferring. Notice that this panel can contain only files"
				+ "and not folders."
				+ "Four buttons here: hide main in order to see the source and target panel full width"
				+ ", refresh tree so as to refresh the source tree,"
				+ "clear target to clean the target files and "
				+ "schedule for scheduling a transfer. ");
		TourStep step3 = createTemplateStep(title, images, textArrays);

		// Transfer Details
		images = new ArrayList<String>();
		textArrays = new ArrayList<String>();
		title = "Schedule Details";
		images.add("gxt/images/tourGuide/grid.png");
		textArrays
		.add("On the bottom, there is a form which shows information about the "
				+ "user's scheduled transfers. Information provided is: id, status, type and submitted date."
				+ "The user is able by double clicking on one of them to submit a command for this "
				+ "specific transfer. Available commands are: monitor, get outcomes and cancel. "
				+ "Two tool buttons here: refresh for getting again the information about the transfers"
				+ "and view agent statistics. ");
		TourStep step4 = createTemplateStep(title, images, textArrays);

		// step1.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);

		GCUBEGuidedTour gt = new GCUBEGuidedTour("gCube Scheduler Portlet",
				SchedulerPortlet.class.getName(), specificationLink, 780, 350,
				false, ThemeColor.BLUE);
		gt.addStep(step1);
		gt.addStep(step2);
		gt.addStep(step3);
		gt.addStep(step4);

		gt.openTour();
	}

	private TourStep createTemplateStep(final String header,
			final List<String> images, final List<String> textArrays) {
		if (images.size() != textArrays.size())
			return null;
		if (images == null || textArrays == null || header == null)
			return null;

		TourStep step = null;
		if (images.size() == 1) {
			step = new GCUBETemplate1Text1Image(true) {
				@Override
				public String setStepTitle() {
					return header;
				}

				@Override
				public String setStepImage() {
					return images.get(0);
				}

				@Override
				public String setStepBody() {
					return "<div style=\"line-height: 19px; padding: 10px; font-size: 14px; \">"
							+ "<div style=\"padding-bottom: 40px;\">"
							+ textArrays.get(0) + "</div>" + "</div>";
				}
			};
		} else if (images.size() == 2) {
			step = new GCUBETemplate2Text2Image(false) {
				@Override
				public String setStepTitle() {
					return header;
				}

				@Override
				public String setStepImage() {
					return images.get(0);
				}

				@Override
				public String setStepBody() {
					return "<div style=\"line-height: 19px; padding: 10px; font-size: 14px; \">"
							+ "<div style=\"padding-bottom: 40px;\">"
							+ textArrays.get(0) + "</div>" + "</div>";
				}

				@Override
				public String setStepOtherImage() {
					return images.get(1);
				}

				@Override
				public String setStepOtherBody() {
					return "<div style=\"line-height: 19px; padding: 10px; font-size: 14px; \">"
							+ "<div style=\"padding-bottom: 40px;\">"
							+ textArrays.get(1) + "</div>" + "</div>";
				}
			};
		}
		return step;
	}

	/*
	 * reDraw input: Nothing -- returns: Nothing Redraw all the components with
	 * the new width depends on the window resize (MainContainer resize)
	 */
	public void reDraw() {
		// check if the scheduler widget is shown
		boolean showSchedulerWidget = false;
		if (west.getWidgetCount() > 0) {
			showSchedulerWidget = true;
		}
		RootPanel.get("mainContainer").clear();
		RootPanel.get("mainContainer").add(asWidgetLayout());

		totalWidth = RootPanel.get("mainContainer").getOffsetWidth();
		if (totalWidth < minGenWidth)
			totalWidth = minGenWidth;

		Info.display("Resize", "width="
				+ RootPanel.get("mainContainer").getOffsetWidth()
				+ " - height="
				+ RootPanel.get("mainContainer").getOffsetHeight());
		// south
		this.designTransferGrid();
		// west
		if (showSchedulerWidget) {
			west.add(asWidgetScheduler());
		}
		// east
		east.add(this.asWidgetToolbar());
		east.add(this.asWidgetListFiles());

	}

	/* ----------------------------------------------------- */
	/* ---------------------- WIDGETS ----------------------- */

	/*
	 * asWidgetLayout input: Nothing -- returns: Widget Sets the general Layout
	 * of the port-let
	 */
	public Widget asWidgetLayout() {
		// mainContainer takes the real width after resizing
		// because the width of it is in percents (100%)
		panelGeneral = new FramedPanel();
		panelGeneral.setHeadingText("Scheduler Service");
		panelGeneral.setBorders(true);
		// panelGeneral.setHeight("100%");

		if ((RootPanel.get().getOffsetHeight() - 150) < minGenHeight)
			panelGeneral.setHeight(minGenHeight);
		else {
			panelGeneral.setHeight((RootPanel.get().getOffsetHeight() - 150));
			// panelGeneral.setHeight("99%");
		}

		if (RootPanel.get("mainContainer").getOffsetWidth() < minGenWidth)
			panelGeneral.setWidth(minGenWidth);
		else
			panelGeneral.setWidth("99%");

		panelGeneral.setBodyStyle("background: none; padding: 0px");

		west = new VerticalPanel();
		east = new VerticalPanel();
		VerticalPanel southPanel = new VerticalPanel();
		south = new ContentPanel();
		southPanel.add(south);

		// Create a Dock Panel
		DockPanel dock = new DockPanel();
		// dock.setSpacing(4);
		dock.setHorizontalAlignment(DockPanel.ALIGN_CENTER);

		dock.add(southPanel, DockPanel.SOUTH);
		dock.add(west, DockPanel.WEST);
		dock.add(east, DockPanel.EAST);

		// Return the content
		dock.ensureDebugId("cwDockPanel");
		panelGeneral.add(dock);

		return panelGeneral;
	}

	/*
	 * asWidgetToolbar input: Nothing -- returns: Widget Creates the panel which
	 * provides the options for selecting files The user can choose between
	 * localFile-DataSource-URI
	 */
	public Widget asWidgetToolbar() {
		int width;
		if (west.getWidgetCount() > 0)
			width = totalWidth - 325;
		else
			width = totalWidth - 25;

		FramedPanel panel = new FramedPanel();
		panel.setHeadingHtml("Schedule Source & Destination");
		panel.setPixelSize(width, 100);
		// panel.addStyleName("margin-25");

		HorizontalLayoutContainer outer = new HorizontalLayoutContainer();
		VerticalLayoutContainer outer1 = new VerticalLayoutContainer();
		VerticalLayoutContainer outer2 = new VerticalLayoutContainer();

		// item 1
		if (combo1 == null) {
			combo1Label = new LabelToolItem("Source: ");
			combo1 = new SimpleComboBox<String>(new LabelProvider<String>() {
				public String getLabel(String item) {
					return item.toString().substring(0, 1)
							+ item.toString().substring(1).toLowerCase();
				}
			});

			combo1.setEmptyText("Select Source ...");
			combo1.setTriggerAction(TriggerAction.ALL);
			// combo1.setToolTipConfig(createAnchor("Select the Source Type"));

			combo1.setEditable(false);
			combo1.add("Workspace");
			combo1.add("DataSource");
			combo1.add("URI");
			combo1.add("MongoDB");
			combo1.add("AgentSource");
			// Add a handler to change the data source
			combo1.addFocusHandler(new FocusHandler() {
				public void onFocus(FocusEvent event) {
					dialogBoxGen = createDialogBox(asPopUpSourceType());
					dialogBoxGen.center();
					focusTimer.schedule(200);
					combo1.collapse();
				}
			});
		}

		toolbarSource = new ToolBar();
		toolbarSource.setBorders(true);
		toolbarSource.add(combo1Label);
		toolbarSource.add(combo1);
		outer1.add(toolbarSource);

		if(sourceAnchor==null)sourceAnchor=createAnchor("");
		toolbarSource.setToolTipConfig(sourceAnchor);

		if (destCombo == null) {
			destLabel = new LabelToolItem("Destination: ");
			destCombo = new SimpleComboBox<String>(new LabelProvider<String>() {
				public String getLabel(String item) {
					return item.toString().substring(0, 1)
							+ item.toString().substring(1).toLowerCase();
				}
			});

			destCombo.setTriggerAction(TriggerAction.ALL);
			// destCombo.setToolTipConfig(createAnchor("Select the Destination Type"));
			destCombo.setEmptyText("Select Destination ...");
			destCombo.setEditable(false);
			destCombo.add("Mongo DB Storage");
			destCombo.add("DataStorage");
			destCombo.add("Agent's node");
			// Add a handler to change the data source
			destCombo.addFocusHandler(new FocusHandler() {
				public void onFocus(FocusEvent event) {
					dialogBoxGen = createDialogBox(asPopUpDestinationType());
					dialogBoxGen.center();
					focusTimer.schedule(200);
					destCombo.collapse();
				}
			});
		}
		ToolBar toolbarDest = new ToolBar();
		toolbarDest.setBorders(true);
		toolbarDest.add(destLabel);
		toolbarDest.add(destCombo);
		outer2.add(toolbarDest);

		if (destinationF == null) {
			destLabelF = new LabelToolItem("Dest Folder: ");
			destinationF = new TextField();
			destinationF.setValue(this.destinationFolder);
			// destinationF.setToolTipConfig(createAnchor(""));
			destinationF.setAllowBlank(false);
			destinationF
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Destination Folder Changed",
							"Destination Folder changed to "
									+ event.getValue() == null ? "blank"
											: event.getValue());
				}
			});
			destinationF.disable();
		}

		if(makeNewFolder==null){
			makeNewFolder = new TextButton("New target folder");
			makeNewFolder.setToolTipConfig(createAnchor("Create a new folder in the destination"));
			makeNewFolder.addSelectHandler(new SelectHandler() {
				public void onSelect(SelectEvent event) {
					dialogBoxGen = createDialogBox(asPopUpCreateNewFolder());
					dialogBoxGen.center();
					focusTimer.schedule(200);
				}
			});
			makeNewFolder.hide();
		}
		if(deleteCurrentFolder==null){
			deleteCurrentFolder = new TextButton("Delete target folder");
			deleteCurrentFolder.setToolTipConfig(createAnchor("Delete the current folder in the destination"));
			deleteCurrentFolder.addSelectHandler(new SelectHandler() {
				public void onSelect(SelectEvent event) {
					MessageBox box = new MessageBox("Delete Current Folder?", "");
					box.setPredefinedButtons(PredefinedButton.YES, PredefinedButton.NO);
					box.setIcon(MessageBox.ICONS.question());
					box.setWidth(500);
					box.setMessage("You are about to delete the current folder: "+
							folderDestination.getName()+"\n"+
							"(including all the subfiles and subfolders)\n"+
							" Would you like to procceed?");
					box.addHideHandler(new HideHandler() {
						@Override
						public void onHide(HideEvent event) {
							Dialog btn = (Dialog) event.getSource();
							String selectedB = btn.getHideButton().getText();
							if(selectedB.compareToIgnoreCase("YES")==0){
								deleteFolderInMongoDB();										
							} 	
						}
					});
					box.show();
				}
			});
			deleteCurrentFolder.hide();
		}

		toolbarDestF = new ToolBar();
		toolbarDestF.setBorders(true);
		toolbarDestF.add(destLabelF);
		toolbarDestF.add(destinationF);		
		//moved to the listFiles Widget on the bottom
		//toolbar4.add(makeNewFolder);        
		//toolbar4.add(deleteCurrentFolder);
		if(destinationAnchor==null)	destinationAnchor=createAnchor(destinationF.getCurrentValue());
		else destinationAnchor.setBodyText(destinationF.getCurrentValue());
		toolbarDestF.setToolTipConfig(destinationAnchor);
		outer2.add(toolbarDestF);

		outer.add(outer1, new HorizontalLayoutData(.5, 1));
		outer.add(outer2, new HorizontalLayoutData(.5, 1));
		panel.setWidget(outer);

		return panel;
	}

	// asPopUpCreateNewFolder
	public Widget asPopUpCreateNewFolder(){
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Create a New Folder");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");
		VerticalLayoutContainer p = new VerticalLayoutContainer();

		p.add(new Label(" "), new VerticalLayoutData(1, -1));

		if (newFolderField == null) {
			newFolderField = new TextField();
			newFolderField.setAllowBlank(false);
		}
		p.add(new FieldLabel(newFolderField, "New Folder"),
				new VerticalLayoutData(1, -1));
		newFolderField.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (newFolderField.getCurrentValue() == null) {
						Info.display("","You must type a name! ");
						return;
					}

					dialogBoxGen.hide();
					setDialogBoxForMessages();
					//add new folder in the destination tree
					storeNewFolderInMongoDB();
				}
			}
		});

		// ************** buttons **************
		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
			}
		});

		TextButton createButton = new TextButton("Create");
		createButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (newFolderField.getCurrentValue() == null) {
					Info.display("","You must type a name! ");
					return;
				}

				dialogBoxGen.hide();
				setDialogBoxForMessages();
				//add new folder in the destination tree
				storeNewFolderInMongoDB();
			}
		});

		panel.setWidget(p);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(cancelButton);
		panel.addButton(createButton);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (newFolderField.getCurrentValue() == null) {
						Info.display("","You must type a name! ");
						return;
					}

					dialogBoxGen.hide();
					setDialogBoxForMessages();
					//add new folder in the destination tree
					storeNewFolderInMongoDB();
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asWidgetListFiles input: Nothing -- returns: Widget Creates a panel where
	 * there is a source tree and a destination target. The client just drops
	 * and drags the files he wants to transfer
	 */
	public Widget asWidgetListFiles() {
		int width;
		if (west.getWidgetCount() > 0)
			width = totalWidth - 325;
		else
			width = totalWidth - 15;

		final ContentPanel cp1 = new ContentPanel();
		cp1.setPixelSize(width - 15, 140);
		cp1.addStyleName("margin-8");

		VerticalLayoutContainer outer = new VerticalLayoutContainer();
		vpListFiles = new HorizontalLayoutContainer();

		//********* getting SOURCE folder ************//
		if (folderSource == null) {
			if (folderResSource == null) {
				this.printMsgInDialogBox("Error : retuned folderResSource=null");
				folderSource = this.makeFolder("Empty source");
			} else {
				// deSeriarilize folderSource
				folderSource = (FolderDto) FolderDto
						.createSerializer()
						.deSerialize(folderResSource,
								"org.gcube.datatransfer.portlets.user.shared.obj.FolderDto");

				// setting some values used for the addTheGoBackOption function
				if (combo1.getCurrentValue().compareTo("DataSource") == 0
						&& currentDataSourcePath != null) {
					if (currentDataSourcePath.compareTo("") == 0 ||
							currentDataSourcePath.compareTo("./") == 0){
						selectedDatasourcePath = folderSource.getName().replaceFirst(
								".//", "./");
						lastSelectedDataSourceFolderName=selectedDatasourcePath;
					}
				} else if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
					if (idWorkspaceRoot == null && callingWorkspaceRoot){
						idWorkspaceRoot = folderSource.getIdInWorkspace();
					}
				} else if (combo1.getCurrentValue().compareTo("MongoDB") == 0) {
					if (currentMongoDBSourcePath.compareTo("/") == 0){
						selectedMongoDBSourcePath = folderSource.getName()
								.replaceFirst(".//", "./");
						lastSelectedMongoDBFolderName=selectedMongoDBSourcePath;
					}
				} else if (combo1.getCurrentValue().compareTo("AgentSource") == 0) {
					if (currentAgentSourcePath.compareTo("") == 0){
						selectedAgentSourcePath = folderSource.getName()
								.replaceFirst(".//", "./");
						lastSelectedAgentFolderName=selectedAgentSourcePath;
					}
				}
				folderSource = addTheGoBackOption(true);
			}
		}
		// ******* source *******
		sourceStore = new TreeStore<BaseDto>(BaseDtoProperties.key);
		sourceStore.addSubTree(0, folderSource.getChildren());

		sourceTree = new Tree<BaseDto, String>(sourceStore,
				baseDtoProp.shortname()) {
			protected boolean hasChildren(BaseDto model) {
				return super.hasChildren(model);
			}

			@Override
			protected void onDoubleClick(Event event) {
				TreeNode<BaseDto> node = findNode(event.getEventTarget()
						.<Element> cast());
				// we override double click only in case of back
				if (node.getModel().getShortname().compareTo("<< Back") == 0) {
					if (combo1.getCurrentValue().compareTo("DataSource") == 0) {
						lastSelectedDataSourceFolderName = node.getModel().getName();
						getDatasourceFolder(selectedDataSourceId, node
								.getModel().getName());
					} else if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
						lastSelectedFolderId = node.getModel()
								.getIdInWorkspace();
						neededParent = true;
						getWorkspaceFolder(node.getModel().getIdInWorkspace(),
								true);
					} else if (combo1.getCurrentValue().compareTo("MongoDB") == 0) {
						lastSelectedMongoDBFolderName = node.getModel()
								.getName();
						getMongoDBFolder(node.getModel().getName());
					} else if (combo1.getCurrentValue()
							.compareTo("AgentSource") == 0) {
						lastSelectedAgentFolderName = node.getModel().getName();
						getAgentFolder(node.getModel().getName());
					}
				} else
					super.onDoubleClick(event);
			}
		};

		sourceTree.addBeforeExpandHandler(new BeforeExpandItemHandler<BaseDto>() {
			public void onBeforeExpand(
					BeforeExpandItemEvent<BaseDto> event) {
				TreeNode<BaseDto> node = sourceTree.findNode(event
						.getItem());
				sourceTree.refresh(node.getModel());

				if (event.getItem().getChildren() == null)
					return;
				// if the folderSource is empty ..
				if (sourceTree.getStore()
						.getChildCount(event.getItem()) == 0
						|| (sourceTree.getStore().getChildCount(
								event.getItem()) == 1 && sourceTree
								.getStore()
								.getFirstChild(event.getItem())
								.getName().compareTo("") == 0)) {

					if (combo1.getCurrentValue()
							.compareTo("DataSource") == 0) {
						lastSelectedDataSourceFolderName = event.getItem()
								.getName();
						getDatasourceFolder(selectedDataSourceId, event
								.getItem().getName());
					} else if (combo1.getCurrentValue().compareTo(
							"Workspace") == 0) {
						lastSelectedFolderId = event.getItem()
								.getIdInWorkspace();
						if (event.getItem().getShortname()
								.compareTo("<< Back") == 0) {
							neededParent = true;
							getWorkspaceFolder(event.getItem()
									.getIdInWorkspace(), true);
						} else {
							// printMsgInDialogBox("id="+folderSource.getIdInWorkspace()+"name="+folderSource.getName());
							neededParent = false;
							getWorkspaceFolder(event.getItem()
									.getIdInWorkspace(), false);
						}
					} else if (combo1.getCurrentValue().compareTo(
							"MongoDB") == 0) {
						lastSelectedMongoDBFolderName = node.getModel()
								.getName();
						getMongoDBFolder(node.getModel().getName());
					} else if (combo1.getCurrentValue().compareTo(
							"AgentSource") == 0) {
						lastSelectedAgentFolderName = node.getModel()
								.getName();
						getAgentFolder(node.getModel().getName());
					}
				}
			}
		});
		sourceTree.addExpandHandler(new ExpandItemHandler<BaseDto>() {
			public void onExpand(ExpandItemEvent<BaseDto> event) {
				// Nothing
			}
		});
		new TreeDragSource<BaseDto>(sourceTree);

		//********* getting DESTINATION folder ************//
		if (folderDestination == null) {
			targetStore=null;
			toBeTransferredStore.clear();
			toBeTransferredStore.commitChanges();
			if (folderResDestination == null) {
				this.printMsgInDialogBox("Error : retuned folderResDestination=null");
				folderDestination = this.makeFolder("Empty destination");
			} else {
				// deSeriarilize folderSource
				folderDestination = (FolderDto) FolderDto
						.createSerializer()
						.deSerialize(folderResDestination,
								"org.gcube.datatransfer.portlets.user.shared.obj.FolderDto");

				// setting some values used for the addTheGoBackOption function
				if (destCombo.getCurrentValue().compareTo("DataStorage") == 0
						&& currentDataStoragePath != null) {
					if (currentDataStoragePath.compareTo("") == 0 || 
							currentDataStoragePath.compareTo("./") == 0){
						destinationF.setValue("./");
						destinationAnchor.setBodyText("./");
						selectedDatastoragePath = folderDestination.getName().replaceFirst(
								".//", "./");
						lastSelectedDatastorageFolderName=selectedDatastoragePath;
					}
				}
				//else if (destCombo.getCurrentValue().compareTo("Workspace") == 0) {
				//	if (idWorkspaceRootDest == null && callingWorkspaceRootDest)
				//		idWorkspaceRootDest = folderDestination.getIdInWorkspaceDest();
				//}
				else if (destCombo.getCurrentValue().startsWith("Mongo")) {
					if (currentMongoDBDestinationPath.compareTo("/") == 0){
						destinationF.setValue("/");
						destinationAnchor.setBodyText("/");
						selectedMongoDBDestinationPath = folderDestination.getName()
								.replaceFirst(".//", "./");
						lastSelectedMongoDBFolderDestName=selectedMongoDBDestinationPath;
					}
				} else if (destCombo.getCurrentValue().startsWith("Agent")) {
					if (currentAgentDestinationPath.compareTo("") == 0){
						destinationF.setValue("./");
						destinationAnchor.setBodyText("./");
						selectedAgentDestinationPath = folderDestination.getName()
								.replaceFirst(".//", "./");
						lastSelectedAgentFolderDestName=selectedAgentDestinationPath;
					}
				}
				folderDestination = addTheGoBackOption(false);
			}
		}
		// ******* target *******
		if (targetStore == null) {
			toBeTransferredStore=new TreeStore<BaseDto>(BaseDtoProperties.key);

			targetStore = new TreeStore<BaseDto>(BaseDtoProperties.key);
			targetStore.addSubTree(0, folderDestination.getChildren());
			targetStore.addStoreAddHandler(new StoreAddHandler<BaseDto>() {
				@Override
				public void onAdd(StoreAddEvent<BaseDto> event) {
					//Info.display("dest path",folderDestination.getName());
					List<BaseDto> list = event.getItems();
					toBeTransferredStore.add(event.getItems());

					int num = 0;
					String links = ""; // only for optional print
					String names = ""; // only for optional print
					for(BaseDto tmp : list){
						if (tmp.getName().compareTo("") == 0)
							continue;
						if (tmp.getChildren() != null) {
							if (tmp.getChildren().size() == 1
									&& tmp.getChildren().get(0).getData()
									.getName().compareTo("") == 0) {
								toBeTransferredStore.remove(tmp);
								toBeTransferredStore.commitChanges();
								targetStore.remove(tmp);
								targetStore.commitChanges();
								Info.display("",
										"You can drag and drop files but not whole folders!!");
								sourceStore = null;
								continue;
							}
						}
						links = tmp.getLink() + "\n"; // only for optional
						// print
						names = tmp.getName() + "\n"; // only for optional
						// print
						num++;
					}
					if (sourceStore == null) {
						redrawEast();
					} else {
						Info.display("Files To Be Transferred", "" + num);
						// printMsgInDialogBox("names:\n"+names+"\nlinks:\n"+links);
						// //optional print
					}
				}
			});

			targetTree = new Tree<BaseDto, String>(targetStore,	baseDtoProp.shortname()) {
				protected boolean hasChildren(BaseDto model) {
					return super.hasChildren(model);
				}
				@Override
				protected void onDoubleClick(Event event) {
					final TreeNode<BaseDto> node = findNode(event.getEventTarget()
							.<Element> cast());
					// we override double click only in case of back
					if (node.getModel().getShortname().compareTo("<< Back") == 0) {
						asPopUpAskingForGoingBack(node);
					}
					else super.onDoubleClick(event);
				}
			};

			targetTree.addBeforeExpandHandler(new BeforeExpandItemHandler<BaseDto>() {
				public void onBeforeExpand(
						BeforeExpandItemEvent<BaseDto> event) {
					TreeNode<BaseDto> node = targetTree.findNode(event
							.getItem());
					targetTree.refresh(node.getModel());

					if (node.getModel().getShortname().compareTo("<< Back") == 0) {
						asPopUpAskingForGoingBack(node);
						return;
					}

					if (event.getItem().getChildren() == null)
						return;
					// if the folderSource is empty ..
					if (targetTree.getStore()
							.getChildCount(event.getItem()) == 0
							|| (targetTree.getStore().getChildCount(
									event.getItem()) == 1 && targetTree
									.getStore()
									.getFirstChild(event.getItem())
									.getName().compareTo("") == 0)) {

						String value = node.getModel().getName();
						destinationF.setValue(value);
						destinationAnchor.setBodyText(value);
						if (destCombo.getCurrentValue().compareTo("DataStorage") == 0) {
							lastSelectedDatastorageFolderName = event.getItem().getName();
							getDatastorageFolder(selectedDataStorageId, event.getItem().getName());
						} 
						//	else if (destCombo.getCurrentValue().compareTo("Workspace") == 0) {
						//		lastSelectedFolderDestId = event.getItem().getIdInWorkspace();
						//		if (event.getItem().getShortname().compareTo("<< Back") == 0) {
						//			neededParentDest = true;
						//			getWorkspaceFolder(event.getItem().getIdInWorkspace(), true);
						//		} else {
						//			// printMsgInDialogBox("id="+folderSource.getIdInWorkspace()+"name="+folderSource.getName());
						//			neededParentDest = false;
						//			getWorkspaceFolder(event.getItem().getIdInWorkspace(), false);
						//		}
						//	} 
						else if (destCombo.getCurrentValue().startsWith("Mongo")) {
							lastSelectedMongoDBFolderDestName = node.getModel().getName();
							getMongoDBFolderDest(node.getModel().getName());
						} else if (destCombo.getCurrentValue().startsWith("Agent")) {
							destinationF.setValue("."+destinationF.getCurrentValue());
							destinationAnchor.setBodyText("."+destinationF.getCurrentValue());
							lastSelectedAgentFolderDestName = node.getModel().getName();
							getAgentFolderDest(node.getModel().getName());
						}
					}
				}
			});

			new TreeDragSource<BaseDto>(targetTree);
			targetTreeDropTarget = new TreeDropTarget<BaseDto>(targetTree);		
			targetTreeDropTarget.addDropHandler(new DndDropHandler() {
				public void onDrop(DndDropEvent event) {
				}
			});
		}

		vpListFiles.add(sourceTree, new HorizontalLayoutData(.5, 1));
		vpListFiles.add(targetTree, new HorizontalLayoutData(.5, 1));
		vpListFiles.setBorders(true);
		sourceTree.setBorders(true);
		targetTree.setBorders(true);

		// *********** buttons ************
		showSchedulerButton = new TextButton("Show Main");
		showSchedulerButton
		.setToolTipConfig(createAnchor("Showing the Main Panel"));
		hideSchedulerButton = new TextButton("Hide Main");
		hideSchedulerButton
		.setToolTipConfig(createAnchor("Hiding the Main Panel"));

		sendButton = new TextButton("Schedule");
		// sendButton.setToolTipConfig(createAnchor("Schedule and Transfer the files you have selected"));

		TextButton clearTargetButton = new TextButton("Clear Target");
		clearTargetButton
		.setToolTipConfig(createAnchor("Clear the files you have already selected"));

		TextButton refreshSourceButton = new TextButton("Refresh source");
		refreshSourceButton.setToolTipConfig(createAnchor("Refresh the source tree"));

		TextButton resetTargetButton = new TextButton("Reset target");
		resetTargetButton.setToolTipConfig(createAnchor("Reset and refresh the target tree"));

		showSchedulerButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				west.clear();
				west.add(asWidgetScheduler());
				// default values
				ResourceName.setText(defaultResourceName);
				scope.setText(defaultScope);
				redrawEast();
				showSchedulerButton.hide();
				hideSchedulerButton.show();
			}
		});
		hideSchedulerButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				west.clear();
				redrawEast();
				hideSchedulerButton.hide();
				showSchedulerButton.show();
			}
		});
		if (west.getWidgetCount() < 1) {
			showSchedulerButton.show();
			hideSchedulerButton.hide();
		} else {
			showSchedulerButton.hide();
			hideSchedulerButton.show();
		}

		sendButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
					dialogBoxGen = createDialogBox(asPopUpAuthenticationWorkspace());
					dialogBoxGen.center();
					focusTimer.schedule(200);
				} else {
					commands.setValue("schedule");
					if (checkFields())
						return;

					if (toBeTransferredStore == null) {
						printMsgInDialogBox("You have not added any files for transfer");
						return;
					} else if (toBeTransferredStore.getAll() == null) {
						printMsgInDialogBox("You have not added any files for transfer");
						return;
					} else if (toBeTransferredStore.getAll().size() < 1) {
						printMsgInDialogBox("You have not added any files for transfer");
						return;
					}

					schedule();
				}
			}
		});

		//not used anymore ... (reset target instead because now there is browsing in the target panel)
		clearTargetButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				targetStore.clear();
				targetStore.commitChanges();
				toBeTransferredStore.clear();
				toBeTransferredStore.commitChanges();

				sourceStore = null;
				redrawEast();
				sourceTree.collapseAll();
			}
		});
		refreshSourceButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (combo1 == null)
					return;
				else if (combo1.getCurrentValue() == null)
					return;

				if (combo1.getCurrentValue().compareTo("DataSource") == 0
						&& lastSelectedDataSourceFolderName != null) {
					getDatasourceFolder(selectedDataSourceId,
							lastSelectedDataSourceFolderName);
				} 
				else if (combo1.getCurrentValue().compareTo("Workspace") == 0
						&& lastSelectedFolderId != null) {
					getWorkspaceFolder(lastSelectedFolderId, neededParent);
				}
				else if (combo1.getCurrentValue().compareTo("MongoDB") == 0
						&& lastSelectedMongoDBFolderName != null) {
					getMongoDBFolder(lastSelectedMongoDBFolderName);
				}
				else if (combo1.getCurrentValue().startsWith("Agent")
						&& lastSelectedAgentFolderName != null) {
					getAgentFolder(lastSelectedAgentFolderName);
				}
				else if (combo1.getCurrentValue().compareTo("URI")==0) {
					if(loadingIconForSource==null)loadingIconForSource=createLoadingIcon();
					Timer stopLoadingIconTimer = new Timer() {
						@Override
						public void run() {
							stopLoadingIcon(loadingIconForSource);
							redrawEast();
						}
					};					
					startLoadingIcon(sourceTree,loadingIconForSource);
					stopLoadingIconTimer.schedule(1000);					
				}
			}
		});

		resetTargetButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (destCombo == null)
					return;
				else if (destCombo.getCurrentValue() == null)
					return;

				if (destCombo.getCurrentValue().compareTo("DataStorage")==0
						&& lastSelectedDatastorageFolderName != null) {
					getDatastorageFolder(selectedDataStorageId,
							lastSelectedDatastorageFolderName);
				}
				//	else if (destCombo.getCurrentValue().compareTo("Workspace") == 0
				//		&& lastSelectedFolderIdDest != null) {
				//		getWorkspaceFolder(lastSelectedFolderIdDest, neededParentDest);
				//	}
				else if (destCombo.getCurrentValue().startsWith("Mongo")
						&& lastSelectedMongoDBFolderDestName != null) {
					getMongoDBFolderDest(lastSelectedMongoDBFolderDestName);
				}
				else if (destCombo.getCurrentValue().startsWith("Agent")
						&& lastSelectedAgentFolderDestName != null) {
					getAgentFolderDest(lastSelectedAgentFolderDestName);
				}
			}
		});

		outer.add(vpListFiles, new VerticalLayoutData(1, 1));
		cp1.setWidget(outer);

		FramedPanel form = new FramedPanel();
		form.setHeaderVisible(false);
		// form.setWidth(width);
		form.setPixelSize(width, 197);

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		p.add(cp1);

		form.add(p);
		form.setButtonAlign(BoxLayoutPack.START);
		form.addButton(hideSchedulerButton);
		form.addButton(showSchedulerButton);
		form.addButton(refreshSourceButton);
		//form.addButton(clearTargetButton);
		form.addButton(resetTargetButton);
		if(makeNewFolder==null || deleteCurrentFolder==null);
		else{
			form.addButton(makeNewFolder);       //new one (from toolbar widget)
			form.addButton(deleteCurrentFolder);  //new one (from toolbar widget)
		}
		form.addButton(sendButton);


		// cp1.setHeadingText(folderSource.getShortname());
		cp1.setHeadingHtml(createHeader(width));
		return form;
	}

	public void asPopUpAskingForGoingBack(final TreeNode<BaseDto> node){
		//POP UP 
		if(toBeTransferredStore!=null)if(toBeTransferredStore.getAll().size()>0){
			MessageBox box = new MessageBox("Schedule files?", "");
			box.setPredefinedButtons(PredefinedButton.YES, PredefinedButton.NO);
			box.setIcon(MessageBox.ICONS.question());
			box.setWidth(500);
			box.setMessage("You are going back without scheduling the files you've "+
					"already dragged & dropped\n on the specific folder: "+
					folderDestination.getName()+" and they will be removed from the target.\n"+
					" Would you like to procceed without scheduling?");
			box.addHideHandler(new HideHandler() {
				@Override
				public void onHide(HideEvent event) {
					Dialog btn = (Dialog) event.getSource();
					String selectedB = btn.getHideButton().getText();
					if(selectedB.compareToIgnoreCase("YES")==0){
						checkIfGoBack(node);										
					} 	
				}
			});
			box.show();
		}	
		else checkIfGoBack(node);
	}
	public void checkIfGoBack(TreeNode<BaseDto> node){
		String value = node.getModel().getName();
		destinationF.setValue(value);
		destinationAnchor.setBodyText(value);

		if (destCombo.getCurrentValue().compareTo("DataStorage") == 0){
			lastSelectedDatastorageFolderName = node.getModel().getName();
			getDatastorageFolder(selectedDataStorageId, node
					.getModel().getName());
		} 
		//	else if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
		//		lastSelectedFolderId = node.getModel()
		//				.getIdInWorkspace();
		//		neededParent = true;
		//		getWorkspaceFolder(node.getModel().getIdInWorkspace(),
		//				true);
		//	} 
		else if (destCombo.getCurrentValue().startsWith("Mongo")) {
			lastSelectedMongoDBFolderDestName = node.getModel()
					.getName();
			getMongoDBFolderDest(node.getModel().getName());
		} else if (destCombo.getCurrentValue().startsWith("Agent")) {
			destinationF.setValue("."+destinationF.getCurrentValue());
			destinationAnchor.setBodyText("."+destinationF.getCurrentValue());

			lastSelectedAgentFolderDestName = node.getModel().getName();
			getAgentFolderDest(node.getModel().getName());
		}
	}

	public SafeHtml createHeader(int width) {
		String source = "";
		String destination = "";

		if (folderSource != null){
			source = folderSource.getShortname();
			if(sourceAnchor!=null){
				sourceAnchor.setBodyText(folderSource.getName());
				toolbarSource.setToolTipConfig(sourceAnchor);
			}
		}
		if (folderDestination != null){			
			if(destinationAnchor!=null){
				destinationAnchor.setBodyText(folderDestination.getName());
				toolbarDestF.setToolTipConfig(destinationAnchor);
			}
			//Info.display("folderDestination", folderDestination.getName()+"");
		}
		if (destCombo.getCurrentValue() != null) {
			if (destCombo.getCurrentValue().compareTo("Mongo DB Storage") == 0) {
				destination = "MongoDB";
			} else if (destCombo.getCurrentValue().compareTo("DataStorage") == 0) {
				destination = selectedDatastorageName;
			} else if (destCombo.getCurrentValue().compareTo("Agent's node") == 0) {
				destination = agentHostname;
			}
		}
		else {
			destination = "Empty destination";
		}		
		SafeHtmlBuilder builder = new SafeHtmlBuilder();
		builder.appendHtmlConstant("<table align=\"center\" height=\"2px\" width=\""
				+ width
				+ "\" "
				+ "style=\"font-size:4px;font-family:times;color:black;\"><tr>"
				+ "<td align=\"left\" height=\"2px\" width=\""
				+ width
				/ 2
				+ "\">"
				+ source
				+ "</td>"
				+ "<td align=\"left\" height=\"2px\" width=\""
				+ width
				/ 2
				+ "\">" + destination + "</td>" + "</tr></table>");

		return builder.toSafeHtml();
	}

	/*
	 * asWidgetScheduler input: Nothing -- returns: Widget Creates the widget
	 * with the main form - the scheduler
	 */
	public Widget asWidgetScheduler() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Main");
		panel.setPixelSize(300, 295);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.add(p);

		// comboAgent
		if (comboAgent == null) {
			comboAgent = new SimpleComboBox<String>(
					new LabelProvider<String>() {
						public String getLabel(String item) {
							return item.toString().substring(0, 1)
									+ item.toString().substring(1)
									.toLowerCase();
						}
					});
			comboAgent.setTriggerAction(TriggerAction.ALL);
			comboAgent.setEditable(false);
			comboAgent.setEmptyText("Select Agent ...");
			// Add a handler to change the data source

			comboAgent.addFocusHandler(new FocusHandler() {
				public void onFocus(FocusEvent event) {
					dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.NONE));
					dialogBoxGen.center();
					focusTimer.schedule(200);
					comboAgent.collapse();
				}
			});
		}

		// CHANGED - decided to make it hidden
		// the agent will be selected from destination type
		// p.add(new FieldLabel(comboAgent, "Agent"), new VerticalLayoutData(1,
		// -1));

		// ResourceName
		if (ResourceName == null) {
			ResourceName = new TextField();
			ResourceName.setAllowBlank(false);
			ResourceName.setEmptyText("Enter username...");
			ResourceName.setValue(defaultResourceName);
			ResourceName
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Value Changed",
							"Resource Name changed to "
									+ event.getValue() == null ? "blank"
											: event.getValue());
				}
			});
			ResourceName.disable();
		}
		p.add(new FieldLabel(ResourceName, "Username"), new VerticalLayoutData(
				1, -1));
		// Scope
		if (scope == null) {
			scope = new TextField();
			scope.setAllowBlank(false);
			scope.setValue(defaultScope);
			scope.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Scope Changed",
							"Scope Name changed to " + event.getValue() == null ? "blank"
									: event.getValue());
				}
			});
			scope.disable();
		}
		p.add(new FieldLabel(scope, "Scope"), new VerticalLayoutData(1, -1));
		// transferId
		transferId = new TextField();
		transferId.setAllowBlank(false);
		transferId.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("TransferId Changed", "TransferId changed to "
						+ event.getValue() == null ? "blank" : event.getValue());
			}
		});
		// CHANGED - decided to make it hidden
		// p.add(new FieldLabel(transferId, "Transfer id"), new
		// VerticalLayoutData(1, -1));
		transferId.disable();

		// force
		force = new CheckBox();
		force.setBoxLabel("force cancel");
		force.setValue(true);
		force.disable();
		// hp = new HorizontalPanel();
		// hp.add(force);
		// CHANGED - decided to make it hidden
		// p.add(new FieldLabel(force, "Force cancel"));

		// overwrite
		overwrite = new CheckBox();
		overwrite.setBoxLabel("Overwrite");
		overwrite.setValue(true);
		p.add(new FieldLabel(overwrite, "Overwrite"));
		// unzip
		unzip = new CheckBox();
		unzip.setBoxLabel("Unzip");
		unzip.setValue(false);
		// HorizontalPanel hp = new HorizontalPanel();
		p.add(new FieldLabel(unzip, "Unzip"));

		// date
		date = new DateField();
		date.addParseErrorHandler(new ParseErrorHandler() {
			public void onParseError(ParseErrorEvent event) {
				Info.display("Parse Error", event.getErrorValue()
						+ " could not be parsed as a date");
			}
		});

		date.addValueChangeHandler(new ValueChangeHandler<Date>() {
			public void onValueChange(ValueChangeEvent<Date> event) {
				String v = event.getValue() == null ? "nothing"
						: DateTimeFormat
						.getFormat(PredefinedFormat.DATE_MEDIUM)
						.format(event.getValue());
				Info.display("Selected", "You selected " + v);

			}
		});

		final long MILLIS_IN_A_DAY = 1000 * 60 * 60 * 24;
		Date minDay = new Date();
		minDay.setTime(new Date().getTime() - MILLIS_IN_A_DAY);
		date.addValidator(new MinDateValidator(minDay));
		dateLabel = new FieldLabel(date, "Schedule Date");
		p.add(dateLabel, new VerticalLayoutData(1, -1));
		date.disable();
		// time
		time = new TimeField();
		time.addParseErrorHandler(new ParseErrorHandler() {
			public void onParseError(ParseErrorEvent event) {
				Info.display("Parse Error", event.getErrorValue()
						+ " could not be parsed as a valid time");
			}
		});
		time.setMinValue(new DateWrapper().clearTime().addHours(0).asDate());
		time.setMaxValue(new DateWrapper().clearTime().addHours(23)
				.addSeconds(1).asDate());
		timeLabel = new FieldLabel(time, "Schedule Time");
		p.add(timeLabel, new VerticalLayoutData(1, -1));
		// frequency
		frequency = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1)
						+ item.toString().substring(1).toLowerCase();
			}
		});
		time.disable();

		frequency.setTriggerAction(TriggerAction.ALL);
		frequency.setEditable(false);
		frequency.add("perMinute");
		frequency.add("perHour");
		frequency.add("perDay");
		frequency.add("perWeek");
		frequency.add("perMonth");
		frequency.add("perYear");
		frequency.setAllowBlank(true);
		frequency.setForceSelection(true);
		frequency.addCollapseHandler(new CollapseHandler() {
			public void onCollapse(CollapseEvent event) {
				if (frequency == null)
					return;
				String v = frequency.getCurrentValue() == null ? "nothing"
						: frequency.getCurrentValue();
				Info.display("Selected", "You selected " + v);
			}
		});
		frequency.disable();
		p.add(new FieldLabel(frequency, "Frequency"), new VerticalLayoutData(1,
				-1));

		// typeofSchedule
		typeOfSchedule = new SimpleComboBox<String>(
				new LabelProvider<String>() {
					public String getLabel(String item) {
						return item.toString().substring(0, 1)
								+ item.toString().substring(1).toLowerCase();
					}
				});
		typeOfSchedule.setTriggerAction(TriggerAction.ALL);
		typeOfSchedule.setEditable(false);
		typeOfSchedule.add("direct");
		typeOfSchedule.add("manually scheduled");
		typeOfSchedule.add("periodically scheduled");
		typeOfSchedule.addCollapseHandler(new CollapseHandler() {
			public void onCollapse(CollapseEvent event) {
				if (typeOfSchedule == null)
					return;

				String v = typeOfSchedule.getCurrentValue() == null ? "nothing"
						: typeOfSchedule.getCurrentValue();
				Info.display("Selected", "You selected " + v);

				if (typeOfSchedule.getCurrentValue() == null)
					return;

				if (typeOfSchedule.getCurrentValue().compareTo("direct") == 0) {
					date.disable();
					time.disable();
					frequency.disable();
				} else if (typeOfSchedule.getCurrentValue().compareTo(
						"manually scheduled") == 0) {
					date.enable();
					time.enable();
					dateLabel.setText("Schedule Date");
					timeLabel.setText("Schedule Time");
					frequency.disable();
				} else if (typeOfSchedule.getCurrentValue().compareTo(
						"periodically scheduled") == 0) {
					date.enable();
					time.enable();
					dateLabel.setText("Schedule Start Date");
					timeLabel.setText("Schedule Start Time");
					frequency.enable();
				}
			}
		});
		typeOfSchedule.addDisableHandler(new DisableHandler() {
			public void onDisable(DisableEvent event) {
				date.disable();
				time.disable();
				frequency.disable();
			}
		});
		typeOfSchedule.setAllowBlank(true);
		typeOfSchedule.setForceSelection(true);
		typeOfSchedule.enable();

		p.add(new FieldLabel(typeOfSchedule, "Type of schedule"),
				new VerticalLayoutData(1, -1));

		// commands
		commands = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1)
						+ item.toString().substring(1).toLowerCase();
			}
		});
		commands.setTriggerAction(TriggerAction.ALL);

		commands.setEditable(false);
		commands.add("schedule");
		commands.add("monitor");
		commands.add("get transfers");
		commands.add("get outcomes");
		commands.add("cancel");

		commands.setAllowBlank(true);
		commands.setForceSelection(true);

		// CHANGED - decided to make it hidden
		// p.add(new FieldLabel(commands, "Commands"), new VerticalLayoutData(1,
		// -1));

		// ************** buttons **************
		TextButton submitButton = new TextButton("Submit");
		submitButton
		.setToolTipConfig(createAnchor("Submit the above selected command"));

		TextButton cancelButton = new TextButton("Cancel");

		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				RootPanel.get("scheduler").clear();
			}
		});
		submitButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				// check for the fields of name-scope-and schedule
				if (checkFields())
					return;

				if (commands.getCurrentValue().compareTo("schedule") == 0) {
					redrawEast();
					combo1.setValue("DataSource");
				} else if (commands.getCurrentValue().compareTo("monitor") == 0) {
					monitor();
				} else if (commands.getCurrentValue()
						.compareTo("get transfers") == 0) {
					getTransfers();
				} else if (commands.getCurrentValue().compareTo("get outcomes") == 0) {
					getOutcomes();
				} else if (commands.getCurrentValue().compareTo("cancel") == 0) {
					cancel();
				}
			}
		});
		panel.setWidget(p);
		panel.setButtonAlign(BoxLayoutPack.START);
		// CHANGED - decided to make it hidden
		// panel.addButton(submitButton);
		return panel;
	}

	/* ------------------------------------------------------------- */
	/* ----------------------- POPUP WIDGETS ----------------------- */

	/*
	 * asPopUpAgents input: Nothing -- returns: Widget Creates a pop up panel so
	 * that user can choose between several agents. The client can also select
	 * to see the agent statistcs
	 */
	public Widget asPopUpAgents(final FolderToRetrieve folderToRetrieve) {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Select Agent");
		panel.setWidth(500);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);

		// Add a list box with multiple selection enabled
		if (multiBoxAgents == null) {
			multiBoxAgents = new ListBox(false);
			multiBoxAgents.setWidth("460px");
			multiBoxAgents.setVisibleItemCount(5);
		}
		VerticalPanel multiBoxPanel = new VerticalPanel();
		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBoxAgents);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		panel.setWidget(con);
		// cp.setButtonAlign(BoxLayoutPack.CENTER);
		panel.setButtonAlign(BoxLayoutPack.START);

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				destCombo.setValue(lastDestComboValue);
			}
		});
		TextButton okButton = new TextButton("OK");
		okButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (comboAgent.getCurrentValue() == null
						&& multiBoxAgents.getSelectedIndex() == -1) {
					Info.display("Warning", "You have not selected Agent ! ");
				} else {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					lastDestComboValue = destCombo.getCurrentValue();
					String agentName = multiBoxAgents.getValue(multiBoxAgents
							.getSelectedIndex());
					Info.display("Selected", "You selected " + agentName);
					agentHostname = agentName;
					agentIsSelectedFromStatsPanel=false;
					//setting tool tip
					if(agentStats!=null){
						if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("");
						agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
						agentStats.setToolTipConfig(agentStatsTooltip);
					}

					comboAgent.setValue(agentName);
					if(folderToRetrieve.equals(FolderToRetrieve.NONE)){
						redrawEast();
					}
					else if(folderToRetrieve.equals(FolderToRetrieve.MongoDBStorageFolder)){
						getMongoDBFolderDest("/");
					}
					else if(folderToRetrieve.equals(FolderToRetrieve.AgentDestFolder)){
						String[] agentsArray = stringOfAgents.split("\n");
						for (String tmp : agentsArray) {
							// tmp contains: id--name--hostName--port
							String[] partsOfInfo = tmp.split("--");
							if (partsOfInfo[2].compareTo(agentName) == 0) {
								selectedAgentDestinationPort = partsOfInfo[3];
							}
						}
						selectedAgentDestination = agentName;					
						getAgentFolderDest("");
					}		
					else if(folderToRetrieve.equals(FolderToRetrieve.DataStorageFolder)){
						getDatastorageFolder(selectedDataStorageId, "./");
					}								
				}
			}
		});
		TextButton refreshButton = new TextButton("Refresh");
		refreshButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				// loading items
				getAgents();
			}
		});
		TextButton statsButton = new TextButton("View Statistics");
		statsButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				// loading items
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				//show statistics
				dialogBoxGen = createDialogBox(asPopUpAgentStats());
				dialogBoxGen.center();
				focusTimer.schedule(200);
			}
		});

		panel.addButton(cancelButton);
		panel.addButton(refreshButton);
		panel.addButton(statsButton);
		panel.addButton(okButton);

		// adding items for the first time
		if (multiBoxAgents.getItemCount() < 1) {
			// loading items
			getAgents();
		}

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					destCombo.setValue(lastDestComboValue);
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (comboAgent.getCurrentValue() == null
							&& multiBoxAgents.getSelectedIndex() == -1) {
						Info.display("Warning",
								"You have not selected Agent ! ");
					} else {
						dialogBoxGen.hide();
						setDialogBoxForMessages();
						lastDestComboValue = destCombo.getCurrentValue();
						String agentName = multiBoxAgents
								.getValue(multiBoxAgents.getSelectedIndex());
						Info.display("Selected", "You selected " + agentName);
						agentHostname = agentName;
						agentIsSelectedFromStatsPanel=false;
						//setting tool tip
						if(agentStats!=null){
							if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("");
							agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
							agentStats.setToolTipConfig(agentStatsTooltip);
						}

						comboAgent.setValue(agentName);
						if(folderToRetrieve.equals(FolderToRetrieve.NONE)){
							redrawEast();
						}
						else if(folderToRetrieve.equals(FolderToRetrieve.MongoDBStorageFolder)){
							getMongoDBFolderDest("/");
						}
						else if(folderToRetrieve.equals(FolderToRetrieve.AgentDestFolder)){
							String[] agentsArray = stringOfAgents.split("\n");
							for (String tmp : agentsArray) {
								// tmp contains: id--name--hostName--port
								String[] partsOfInfo = tmp.split("--");
								if (partsOfInfo[2].compareTo(agentName) == 0) {
									selectedAgentDestinationPort = partsOfInfo[3];
								}
							}
							selectedAgentDestination = agentName;					
							getAgentFolderDest("");
						}		
						else if(folderToRetrieve.equals(FolderToRetrieve.DataStorageFolder)){
							getDatastorageFolder(selectedDataStorageId, "./");
						}		
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpMongoDBStorage input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can fill all the appropriate information about Storage
	 * Manager
	 */
	public Widget asPopUpMongoDBStorage() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("MongoDBStorage Details");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");
		VerticalLayoutContainer p = new VerticalLayoutContainer();
		// fields:
		// TextFields smServiceName,smServiceClass,smOwner
		// ComboBoxes smAccessType;
		if (smServiceName == null) {
			smServiceName = new TextField();
			smServiceName.setAllowBlank(false);
			smServiceName
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Service Name Changed",
							"Service Name changed to "
									+ event.getValue() == null ? "blank"
											: event.getValue());
				}
			});
		}
		p.add(new FieldLabel(smServiceName, "Service Name"),
				new VerticalLayoutData(1, -1));

		if (smServiceClass == null) {
			smServiceClass = new TextField();
			smServiceClass.setAllowBlank(false);
			smServiceClass
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Service Class Changed",
							"Service Class changed to "
									+ event.getValue() == null ? "blank"
											: event.getValue());
				}
			});
		}
		p.add(new FieldLabel(smServiceClass, "Service Class"),
				new VerticalLayoutData(1, -1));

		if (smOwner == null) {
			smOwner = new TextField();
			smOwner.setAllowBlank(false);
			smOwner.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Owner Changed",
							"Owner changed to " + event.getValue() == null ? "blank"
									: event.getValue());
				}
			});
		}
		p.add(new FieldLabel(smOwner, "Owner"), new VerticalLayoutData(1, -1));

		if (smAccessType == null) {
			smAccessType = new SimpleComboBox<String>(
					new LabelProvider<String>() {
						public String getLabel(String item) {
							return item.toString().substring(0, 1)
									+ item.toString().substring(1)
									.toLowerCase();
						}
					});
			smAccessType.setTriggerAction(TriggerAction.ALL);
			smAccessType.setEditable(false);
			smAccessType.add("SHARED");
			smAccessType.add("PUBLIC");
			smAccessType.add("PRIVATE");
			// Add a handler to change the data source
			smAccessType.addCollapseHandler(new CollapseHandler() {
				public void onCollapse(CollapseEvent event) {
					// set the same values in the main form
					if (smAccessType.getCurrentValue() == null)
						return;

					String v = smAccessType.getCurrentValue() == null ? "nothing"
							: smAccessType.getCurrentValue();
					Info.display("Selected", "You selected " + v);
				}
			});

			smAccessType.setAllowBlank(true);
			smAccessType.setForceSelection(true);
		}
		p.add(new FieldLabel(smAccessType, "Access Type"),
				new VerticalLayoutData(1, -1));

		//check box for default values
		defaultValuesStorage = new CheckBox();
		defaultValuesStorage.setBoxLabel("");
		defaultValuesStorage.setValue(false);
		defaultValuesStorage.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				boolean checked = event.getValue();
				if(checked){
					smServiceName.setValue("scheduler-portlet");
					smServiceClass.setValue("data-transfer");
					smOwner.setValue(ResourceName.getCurrentValue());
					smAccessType.setValue("SHARED");
					Info.display("MongoDBStorage", "Default parameters");
				}
				else{
					smServiceName.setValue("");
					smServiceClass.setValue("");
					smOwner.setValue("");
					smAccessType.setValue(null);
				}
			}
		});		
		p.add(new FieldLabel(defaultValuesStorage, "Default parameters"));

		// ************** buttons **************

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				destCombo.setValue(lastDestComboValue);
			}
		});
		TextButton nextButton = new TextButton("Next");
		nextButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (checkMongoDBFields())
					return;
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				if (combo1==null || combo1.getCurrentValue()==null ||
						combo1.getCurrentValue().compareTo("AgentSource") != 0
						|| selectedAgentSource == null) {
					//selection of agent should be transparent based on statistics
					transparentSelectionOfAgent(FolderToRetrieve.MongoDBStorageFolder);
					//changed ...
					//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.MongoDBStorageFolder));
					//dialogBoxGen.center();
					//focusTimer.schedule(200);
				} else {
					getMongoDBFolderDest("/");
					Info.display("Selected", "You selected "
							+ selectedAgentSource);
				}
			}
		});
		panel.setWidget(p);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(cancelButton);
		panel.addButton(nextButton);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					destCombo.setValue(lastDestComboValue);
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (checkMongoDBFields())
						return;
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					if (combo1==null || combo1.getCurrentValue()==null ||
							combo1.getCurrentValue().compareTo("AgentSource") != 0
							|| selectedAgentSource == null) {
						//selection of agent should be transparent based on statistics
						transparentSelectionOfAgent(FolderToRetrieve.MongoDBStorageFolder);
						//changed ...
						//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.MongoDBStorageFolder));
						//dialogBoxGen.center();
						//focusTimer.schedule(200);
					} else {
						getMongoDBFolderDest("/");
						Info.display("Selected", "You selected "
								+ selectedAgentSource);
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}


	/*
	 * asPopUpMongoDBSource input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can fill all the appropriate information about Storage
	 * Manager for browsing the source
	 */
	public Widget asPopUpMongoDBSource() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Source Type MongoDB - Details:");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");
		VerticalLayoutContainer p = new VerticalLayoutContainer();
		// fields:
		// TextFields smServiceName,smServiceClass,smOwner
		// ComboBoxes smAccessType;
		if (smServiceNameSource == null) {
			smServiceNameSource = new TextField();
			smServiceNameSource.setAllowBlank(false);
			smServiceNameSource
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Service Name Changed",
							"Service Name changed to "
									+ event.getValue() == null ? "blank"
											: event.getValue());
				}
			});
		}
		p.add(new FieldLabel(smServiceNameSource, "Service Name"),
				new VerticalLayoutData(1, -1));

		if (smServiceClassSource == null) {
			smServiceClassSource = new TextField();
			smServiceClassSource.setAllowBlank(false);
			smServiceClassSource
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display(
							"Service Class Changed",
							"Service Class changed to "
									+ event.getValue() == null ? "blank"
											: event.getValue());
				}
			});
		}
		p.add(new FieldLabel(smServiceClassSource, "Service Class"),
				new VerticalLayoutData(1, -1));

		if (smOwnerSource == null) {
			smOwnerSource = new TextField();
			smOwnerSource.setAllowBlank(false);
			smOwnerSource
			.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display("Owner Changed", "Owner changed to "
							+ event.getValue() == null ? "blank"
									: event.getValue());
				}
			});
		}
		p.add(new FieldLabel(smOwnerSource, "Owner"), new VerticalLayoutData(1,
				-1));

		if (smAccessTypeSource == null) {
			smAccessTypeSource = new SimpleComboBox<String>(
					new LabelProvider<String>() {
						public String getLabel(String item) {
							return item.toString().substring(0, 1)
									+ item.toString().substring(1)
									.toLowerCase();
						}
					});
			smAccessTypeSource.setTriggerAction(TriggerAction.ALL);
			smAccessTypeSource.setEditable(false);
			smAccessTypeSource.add("SHARED");
			smAccessTypeSource.add("PUBLIC");
			smAccessTypeSource.add("PRIVATE");
			// Add a handler to change the data source
			smAccessTypeSource.addCollapseHandler(new CollapseHandler() {
				public void onCollapse(CollapseEvent event) {
					// set the same values in the main form
					if (smAccessTypeSource.getCurrentValue() == null)
						return;

					String v = smAccessTypeSource.getCurrentValue() == null ? "nothing"
							: smAccessTypeSource.getCurrentValue();
					Info.display("Selected", "You selected " + v);
				}
			});

			smAccessTypeSource.setAllowBlank(true);
			smAccessTypeSource.setForceSelection(true);
		}
		p.add(new FieldLabel(smAccessTypeSource, "Access Type"),
				new VerticalLayoutData(1, -1));

		//check box for default values
		defaultValuesSource = new CheckBox();
		defaultValuesSource.setBoxLabel("");
		defaultValuesSource.setValue(false);
		defaultValuesSource.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				boolean checked = event.getValue();
				if(checked){
					smServiceNameSource.setValue("scheduler-portlet");
					smServiceClassSource.setValue("data-transfer");
					smOwnerSource.setValue(ResourceName.getCurrentValue());
					smAccessTypeSource.setValue("SHARED");
					Info.display("MongoDBSource", "Default parameters");
				}
				else{
					smServiceNameSource.setValue("");
					smServiceClassSource.setValue("");
					smOwnerSource.setValue("");
					smAccessTypeSource.setValue(null);
				}
			}
		});		
		p.add(new FieldLabel(defaultValuesSource, "Default parameters"));

		// ************** buttons **************

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				combo1.setValue(lastCombo1Value);
			}
		});

		TextButton nextButton = new TextButton("Next");
		nextButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (checkMongoDBSourceFields())
					return;
				// TO DO
				// call service get source folderSource (root)..
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				getMongoDBFolder("/");
			}
		});
		panel.setWidget(p);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(cancelButton);
		panel.addButton(nextButton);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					combo1.setValue(lastCombo1Value);
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (checkMongoDBSourceFields())
						return;
					// TO DO
					// call service get source folderSource (root) ..
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					getMongoDBFolder("/");
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpAuthenticationWorkspace input: Nothing -- returns: Widget Creates
	 * a pop up panel so that user can fill the authentication details for
	 * transferring files from workspace
	 */
	public Widget asPopUpAuthenticationWorkspace() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Workspace Authentication");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");
		VerticalLayoutContainer p = new VerticalLayoutContainer();
		// fields:
		// TextFields smServiceName,smServiceClass,smOwner
		// ComboBoxes smAccessType;
		p.add(new Label(" "), new VerticalLayoutData(1, -1));

		if (passWorkspace == null) {
			passWorkspace = new PasswordField();
			passWorkspace.setAllowBlank(false);
		}
		p.add(new FieldLabel(passWorkspace, "Password"),
				new VerticalLayoutData(1, -1));
		passWorkspace.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (passWorkspace.getCurrentValue() == null) {
						printMsgInDialogBox("You must give your password! ");
						return;
					}

					dialogBoxGen.hide();
					setDialogBoxForMessages();

					commands.setValue("schedule");
					if (checkFields())
						return;

					if (toBeTransferredStore == null) {
						Info.display("","You have not added any files for transfer");
						return;
					} else if (toBeTransferredStore.getAll() == null) {
						Info.display("","You have not added any files for transfer");
						return;
					} else if (toBeTransferredStore.getAll().size() < 1) {
						Info.display("","You have not added any files for transfer");
						return;
					}
					schedule();
				}
			}
		});

		// ************** buttons **************
		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
			}
		});

		TextButton scheduleButton = new TextButton("Schedule");
		scheduleButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (passWorkspace.getCurrentValue() == null) {
					printMsgInDialogBox("You must give your password! ");
					return;
				}

				dialogBoxGen.hide();
				setDialogBoxForMessages();

				commands.setValue("schedule");
				if (checkFields())
					return;

				if (toBeTransferredStore == null) {
					Info.display("","You have not added any files for transfer");
					return;
				} else if (toBeTransferredStore.getAll() == null) {
					Info.display("","You have not added any files for transfer");
					return;
				} else if (toBeTransferredStore.getAll().size() < 1) {
					Info.display("","You have not added any files for transfer");
					return;
				}
				schedule();
			}
		});

		panel.setWidget(p);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(cancelButton);
		panel.addButton(scheduleButton);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (passWorkspace.getCurrentValue() == null) {
						printMsgInDialogBox("You must give your password! ");
						return;
					}

					dialogBoxGen.hide();
					setDialogBoxForMessages();

					commands.setValue("schedule");
					if (checkFields())
						return;

					if (toBeTransferredStore == null) {
						Info.display("","You have not added any files for transfer");
						return;
					} else if (toBeTransferredStore.getAll() == null) {
						Info.display("","You have not added any files for transfer");
						return;
					} else if (toBeTransferredStore.getAll().size() < 1) {
						Info.display("","You have not added any files for transfer");
						return;
					}
					schedule();
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpDataStorage input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can choose the remote node
	 */
	public Widget asPopUpDataStorage() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Select DataStorage");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);

		// Add a list box with multiple selection enabled
		if (multiBoxDataStorages == null) {
			multiBoxDataStorages = new ListBox(false);
			multiBoxDataStorages.setWidth("150px");
			multiBoxDataStorages.setVisibleItemCount(5);
		}
		VerticalPanel multiBoxPanel = new VerticalPanel();
		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBoxDataStorages);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		panel.setWidget(con);
		// cp.setButtonAlign(BoxLayoutPack.CENTER);
		panel.setButtonAlign(BoxLayoutPack.START);

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				destCombo.setValue(lastDestComboValue);
			}
		});
		TextButton refreshButton = new TextButton("Refresh");
		refreshButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				// loading items
				getDataStorages();
			}
		});
		TextButton nextButton = new TextButton("Next");
		nextButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (multiBoxDataStorages.getSelectedIndex() == -1) {
					Info.display("Warning",
							"You have not selected DataStorage ! ");
				} else {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					String dataStorageName = multiBoxDataStorages
							.getValue(multiBoxDataStorages.getSelectedIndex());
					Info.display("Selected", "You selected " + dataStorageName);
					selectedDatastorageName = dataStorageName;
					// searching and storing the id of the selected DataStorage
					selectedDataStorageId = null;
					if (dataStoragesList != null) {
						for (String tmp : dataStoragesList) {
							// tmp contains:
							// resultIdOfIS--name--description--endpoint--username--password--propertyFolders
							String[] parts = tmp.split("--");
							if (dataStorageName.compareTo(parts[1]) == 0) {
								selectedDataStorageId = parts[0];
							}
						}
					}
					Info.display("Selected", "You selected " + dataStorageName);

					if (combo1==null || combo1.getCurrentValue()==null ||
							combo1.getCurrentValue().compareTo("AgentSource") != 0
							|| selectedAgentSource == null) {
						//selection of agent should be transparent based on statistics
						transparentSelectionOfAgent(FolderToRetrieve.DataStorageFolder);
						//changed ...
						//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.DataStorageFolder));
						//dialogBoxGen.center();
						//focusTimer.schedule(200);
					} else {
						getDatastorageFolder(selectedDataStorageId, "./");
						Info.display("Selected", "You selected "
								+ selectedAgentSource);
					}

				}
			}
		});
		panel.addButton(cancelButton);
		panel.addButton(refreshButton);
		panel.addButton(nextButton);

		// adding items for the first time
		if (multiBoxDataStorages.getItemCount() < 1) {
			// loading items
			getDataStorages();
		}

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					destCombo.setValue(lastDestComboValue);
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (multiBoxDataStorages.getSelectedIndex() == -1) {
						Info.display("Warning",
								"You have not selected DataStorage ! ");
					} else {
						dialogBoxGen.hide();
						setDialogBoxForMessages();
						String dataStorageName = multiBoxDataStorages
								.getValue(multiBoxDataStorages
										.getSelectedIndex());
						selectedDatastorageName = dataStorageName;
						// searching and storing the id of the selected
						// DataStorage
						selectedDataStorageId = null;
						if (dataStoragesList != null) {
							for (String tmp : dataStoragesList) {
								// tmp contains:
								// resultIdOfIS--name--description--endpoint--username--password--propertyFolders
								String[] parts = tmp.split("--");
								if (dataStorageName.compareTo(parts[1]) == 0) {
									selectedDataStorageId = parts[0];
								}
							}
						}
						Info.display("Selected", "You selected "
								+ dataStorageName);

						if (combo1==null || combo1.getCurrentValue()==null ||
								combo1.getCurrentValue().compareTo("AgentSource") != 0
								|| selectedAgentSource == null) {
							//selection of agent should be transparent based on statistics
							transparentSelectionOfAgent(FolderToRetrieve.DataStorageFolder);
							//changed ...
							//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.DataStorageFolder));
							//dialogBoxGen.center();
							//focusTimer.schedule(200);
						} else {
							getDatastorageFolder(selectedDataStorageId, "./");
							Info.display("Selected", "You selected "
									+ selectedAgentSource);
						}
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpDataSource input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can choose the data source
	 */
	public Widget asPopUpDataSource() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Select DataSource");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);

		// Add a list box with multiple selection enabled
		if (multiBoxDataSources == null) {
			multiBoxDataSources = new ListBox(false);
			multiBoxDataSources.setWidth("150px");
			multiBoxDataSources.setVisibleItemCount(5);
		}
		VerticalPanel multiBoxPanel = new VerticalPanel();
		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBoxDataSources);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		panel.setWidget(con);
		panel.setButtonAlign(BoxLayoutPack.START);

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				Info.display("Warning", "You have not selected DataSource ! ");
				combo1.setValue(lastCombo1Value);
			}
		});
		TextButton okButton = new TextButton("OK");
		okButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (multiBoxDataSources.getSelectedIndex() == -1) {
					Info.display("Warning",
							"You have not selected DataSource ! ");
				} else {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					String name = multiBoxDataSources
							.getValue(multiBoxDataSources.getSelectedIndex());
					// searching and storing the id of the selected DataSource
					selectedDataSourceId = null;
					if (dataSourcesList != null) {
						for (String tmp : dataSourcesList) {
							// tmp contains:
							// resultIdOfIS--name--description--endpoint--username--password--propertyFolders
							String[] parts = tmp.split("--");
							if (name.compareTo(parts[1]) == 0) {
								selectedDataSourceId = parts[0];
							}
						}
					}
					Info.display("Selected", "You selected " + name);
					getDatasourceFolder(selectedDataSourceId, "");
				}
			}
		});

		TextButton refreshButton = new TextButton("Refresh");
		refreshButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				// loading items
				getDataSources();
			}
		});

		panel.addButton(cancelButton);
		panel.addButton(refreshButton);
		panel.addButton(okButton);

		// adding items for the first time
		if (multiBoxDataSources.getItemCount() < 1) {
			// loading items
			getDataSources();
		}

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					Info.display("Warning",
							"You have not selected DataSource ! ");
					combo1.setValue(lastCombo1Value);
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (multiBoxDataSources.getSelectedIndex() == -1) {
						Info.display("Warning",
								"You have not selected DataSource ! ");
					} else {
						String name = multiBoxDataSources
								.getValue(multiBoxDataSources
										.getSelectedIndex());
						// searching and storing the id of the selected
						// DataSource
						selectedDataSourceId = null;
						if (dataSourcesList != null) {
							for (String tmp : dataSourcesList) {
								// tmp contains:
								// resultIdOfIS--name--description--endpoint--username--password--propertyFolders
								String[] parts = tmp.split("--");
								if (name.compareTo(parts[1]) == 0) {
									selectedDataSourceId = parts[0];
								}
							}
						}
						Info.display("Selected", "You selected " + name);
						getDatasourceFolder(selectedDataSourceId, "");
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpDataSource input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can choose the data source
	 */
	public Widget asPopUpAgentSource() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Select Agent");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);

		// Add a list box with multiple selection enabled
		if (multiBoxAgents == null) {
			multiBoxAgents = new ListBox(false);
			multiBoxAgents.setWidth("260px");
			multiBoxAgents.setVisibleItemCount(5);
		}
		VerticalPanel multiBoxPanel = new VerticalPanel();
		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBoxAgents);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		panel.setWidget(con);
		panel.setButtonAlign(BoxLayoutPack.START);

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				Info.display("Warning", "You have not selected Agent ! ");
				combo1.setValue(lastCombo1Value);
			}
		});

		TextButton okButton = new TextButton("OK");
		okButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (multiBoxAgents.getSelectedIndex() == -1) {
					Info.display("Warning", "You have not selected Agent ! ");
				} else {
					dialogBoxGen.hide();
					setDialogBoxForMessages();

					String agentName = multiBoxAgents.getValue(multiBoxAgents
							.getSelectedIndex());
					Info.display("Selected", "You selected " + agentName);
					agentHostname = agentName;
					//setting tool tip
					if(agentStats!=null){
						if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("");
						agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
						agentStats.setToolTipConfig(agentStatsTooltip);
					}

					String[] agentsArray = stringOfAgents.split("\n");
					for (String tmp : agentsArray) {
						// tmp contains: id--name--hostName--port
						String[] partsOfInfo = tmp.split("--");
						if (partsOfInfo[2].compareTo(agentName) == 0) {
							selectedAgentSourcePort = partsOfInfo[3];
						}
					}
					selectedAgentSource = agentName;
					agentIsSelectedFromStatsPanel=false;

					comboAgent.setValue(agentName);
					//redrawEast();
					getAgentFolder("");
					if(destCombo==null || destCombo.getCurrentValue()==null ||
							(!destCombo.getCurrentValue().startsWith("Agent"))){
						//nothing
					}else{
						selectedAgentDestination = selectedAgentSource;
						selectedAgentDestinationPort = selectedAgentSourcePort;
						getAgentFolderDest("");
					}					
				}
			}
		});

		TextButton refreshButton = new TextButton("Refresh");
		refreshButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				// loading items
				getAgents();
			}
		});

		panel.addButton(cancelButton);
		panel.addButton(refreshButton);
		panel.addButton(okButton);

		// adding items for the first time
		if (multiBoxAgents.getItemCount() < 1) {
			// loading items
			getAgents();
		}

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					Info.display("Warning", "You have not selected Agent ! ");
					combo1.setValue(lastCombo1Value);
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (multiBoxAgents.getSelectedIndex() == -1) {
						Info.display("Warning",
								"You have not selected Agent ! ");
					} else {
						dialogBoxGen.hide();
						setDialogBoxForMessages();

						String agentName = multiBoxAgents
								.getValue(multiBoxAgents.getSelectedIndex());
						Info.display("Selected", "You selected " + agentName);
						agentHostname = agentName;
						//setting tool tip
						if(agentStats!=null){
							if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("");
							agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
							agentStats.setToolTipConfig(agentStatsTooltip);
						}

						String[] agentsArray = stringOfAgents.split("\n");
						for (String tmp : agentsArray) {
							// tmp contains: id--name--hostName--port
							String[] partsOfInfo = tmp.split("--");
							if (partsOfInfo[2].compareTo(agentName) == 0) {
								selectedAgentSourcePort = partsOfInfo[3];
							}
						}
						selectedAgentSource = agentName;
						agentIsSelectedFromStatsPanel=false;

						comboAgent.setValue(agentName);
						redrawEast();

						getAgentFolder("");
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpSourceType input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can choose the source type
	 */
	public Widget asPopUpSourceType() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Select Source Type");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);
		// Add a list box with multiple selection enabled
		if (multiBoxSourceType == null) {
			multiBoxSourceType = new ListBox(false);
			multiBoxSourceType.setWidth("150px");
			multiBoxSourceType.setVisibleItemCount(5);
		}
		VerticalPanel multiBoxPanel = new VerticalPanel();
		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBoxSourceType);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		panel.setWidget(con);
		panel.setButtonAlign(BoxLayoutPack.START);

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
			}
		});

		TextButton nextButton = new TextButton("Next");
		nextButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (multiBoxSourceType.getSelectedIndex() == -1) {
					Info.display("Warning",
							"You have not selected DataSource ! ");
				} else {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					String selected = multiBoxSourceType
							.getValue(multiBoxSourceType.getSelectedIndex());
					combo1.setValue(selected);
					Info.display("Warning", selected);
					String v = selected == null ? "nothing" : combo1
							.getCurrentValue();
					Info.display("Selected", "You selected " + v);

					targetStore = null;
					toBeTransferredStore.clear();
					toBeTransferredStore.commitChanges();
					if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
						getWorkspaceFolder(null, false);
					} else if (combo1.getCurrentValue().compareTo("DataSource") == 0) {
						dialogBoxGen = createDialogBox(asPopUpDataSource());
						dialogBoxGen.center();
						focusTimer.schedule(200);
					} else if (combo1.getCurrentValue().compareTo("MongoDB") == 0) {
						if (isAdmin) {
							dialogBoxGen = createDialogBox(asPopUpMongoDBSource());
							dialogBoxGen.center();
							focusTimer.schedule(200);
						} else {
							// initialization - default values
							initializeMongoDBSource();
							getMongoDBFolder("/");
						}
					} else if (combo1.getCurrentValue()
							.compareTo("AgentSource") == 0) {
						dialogBoxGen = createDialogBox(asPopUpAgentSource());
						dialogBoxGen.center();
						focusTimer.schedule(200);
					} else {
						dialogBoxGen = createDialogBox(asPopUpUris());
						dialogBoxGen.center();
						focusTimer.schedule(200);
					}

					// get the agents now ...
					if (ResourceName.getCurrentValue() == null) {
						printMsgInDialogBox("You should have a Resource Name !");
					}
					if (scope.getCurrentValue() == null) {
						printMsgInDialogBox("You should have a Scope !");
					} else {
						getAgents();
					}
				}
			}
		});
		panel.addButton(cancelButton);
		panel.addButton(nextButton);

		// adding items for the first time
		if (multiBoxSourceType.getItemCount() < 1) {
			multiBoxSourceType.addItem("Workspace");
			multiBoxSourceType.addItem("DataSource");
			multiBoxSourceType.addItem("URI");
			multiBoxSourceType.addItem("MongoDB");
			multiBoxSourceType.addItem("AgentSource");
		}

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (multiBoxSourceType.getSelectedIndex() == -1) {
						Info.display("Warning",
								"You have not selected DataSource ! ");
					} else {
						dialogBoxGen.hide();
						setDialogBoxForMessages();
						String selected = multiBoxSourceType
								.getValue(multiBoxSourceType.getSelectedIndex());
						combo1.setValue(selected);

						String v = combo1.getCurrentValue() == null ? "nothing"
								: combo1.getCurrentValue();
						Info.display("Selected", "You selected " + v);

						targetStore = null;
						toBeTransferredStore.clear();
						toBeTransferredStore.commitChanges();
						if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
							getWorkspaceFolder(null, false);
						} else if (combo1.getCurrentValue().compareTo(
								"DataSource") == 0) {
							dialogBoxGen = createDialogBox(asPopUpDataSource());
							dialogBoxGen.center();
							focusTimer.schedule(200);
						} else if (combo1.getCurrentValue()
								.compareTo("MongoDB") == 0) {
							if (isAdmin) {
								dialogBoxGen = createDialogBox(asPopUpMongoDBSource());
								dialogBoxGen.center();
								focusTimer.schedule(200);
							} else {
								// initialization - default values
								initializeMongoDBSource();
								getMongoDBFolder("/");
							}
						} else if (combo1.getCurrentValue().compareTo(
								"AgentSource") == 0) {
							dialogBoxGen = createDialogBox(asPopUpAgentSource());
							dialogBoxGen.center();
							focusTimer.schedule(200);
						} else {
							dialogBoxGen = createDialogBox(asPopUpUris());
							dialogBoxGen.center();
							focusTimer.schedule(200);
						}

						// get the agents now ...
						if (ResourceName.getCurrentValue() == null) {
							printMsgInDialogBox("You should have a Resource Name !");
						}
						if (scope.getCurrentValue() == null) {
							printMsgInDialogBox("You should have a Scope !");
						} else {
							getAgents();
						}
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	public void initializeMongoDBSource() {
		smServiceNameSource = new TextField();
		smServiceNameSource.setValue("scheduler-portlet");
		smServiceClassSource = new TextField();
		smServiceClassSource.setValue("data-transfer");
		smOwnerSource = new TextField();
		smOwnerSource.setValue(ResourceName.getCurrentValue());
		smAccessTypeSource = new SimpleComboBox<String>(
				new LabelProvider<String>() {
					public String getLabel(String item) {
						return item.toString().substring(0, 1)
								+ item.toString().substring(1).toLowerCase();
					}
				});
		smAccessTypeSource.setTriggerAction(TriggerAction.ALL);
		smAccessTypeSource.setEditable(false);
		smAccessTypeSource.add("SHARED");
		smAccessTypeSource.add("PUBLIC");
		smAccessTypeSource.add("PRIVATE");
		smAccessTypeSource.setForceSelection(true);
		smAccessTypeSource.setValue("SHARED");
	}

	/*
	 * asPopUpDestinationType input: Nothing -- returns: Widget Creates a pop up
	 * panel so that user can choose the destination type
	 */
	public Widget asPopUpDestinationType() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Select Destination Type");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);
		// Add a list box with multiple selection enabled
		if (multiBoxDestinationType == null) {
			multiBoxDestinationType = new ListBox(false);
			multiBoxDestinationType.setWidth("150px");
			multiBoxDestinationType.setVisibleItemCount(5);
		}
		VerticalPanel multiBoxPanel = new VerticalPanel();
		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBoxDestinationType);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		panel.setWidget(con);
		panel.setButtonAlign(BoxLayoutPack.START);

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
			}
		});

		TextButton nextButton = new TextButton("Next");
		nextButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if (multiBoxDestinationType.getSelectedIndex() == -1) {
					Info.display("Warning",
							"You have not selected Destination Type ! ");
				} else {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					String selected = multiBoxDestinationType
							.getValue(multiBoxDestinationType
									.getSelectedIndex());
					destCombo.setValue(selected);
					String v = destCombo.getCurrentValue() == null ? "nothing"
							: destCombo.getCurrentValue();
					Info.display("Selected", "You selected " + v);
					if (destCombo.getCurrentValue() == null)
						return;


					if (destCombo.getCurrentValue().compareTo(
							"Mongo DB Storage") == 0) {
						targetStore = null;
						toBeTransferredStore.clear();
						toBeTransferredStore.commitChanges();
						if (isAdmin) {
							dialogBoxGen = createDialogBox(asPopUpMongoDBStorage());
							dialogBoxGen.center();
							focusTimer.schedule(200);
						} else {
							// initialization - default values
							initializeMongoDBStorage();
							if (combo1==null || combo1.getCurrentValue()==null ||
									combo1.getCurrentValue().compareTo("AgentSource") != 0
									|| selectedAgentSource == null) {

								//selection of agent should be transparent based on statistics
								transparentSelectionOfAgent(FolderToRetrieve.MongoDBStorageFolder);
								//changed ...
								//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.MongoDBStorageFolder));
								//dialogBoxGen.center();
								//focusTimer.schedule(200);
							} else {
								getMongoDBFolderDest("/");
								Info.display("Selected", "You selected "
										+ selectedAgentSource);
							}
						}
					} else if (destCombo.getCurrentValue().compareTo(
							"DataStorage") == 0) {
						dialogBoxGen = createDialogBox(asPopUpDataStorage());
						dialogBoxGen.center();
						focusTimer.schedule(200);
					} else if (destCombo.getCurrentValue().compareTo(
							"Agent's node") == 0) {
						if (combo1==null || combo1.getCurrentValue()==null ||
								combo1.getCurrentValue().compareTo("AgentSource") != 0
								|| selectedAgentSource == null) {

							dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.AgentDestFolder));
							dialogBoxGen.center();
							focusTimer.schedule(200);
						} else {
							selectedAgentDestination=selectedAgentSource;
							selectedAgentDestinationPort=selectedAgentSourcePort;
							getAgentFolderDest("");
							Info.display("Selected", "You selected "
									+ selectedAgentSource);
						}
					}
				}
			}
		});
		panel.addButton(cancelButton);
		panel.addButton(nextButton);

		// adding items for the first time
		if (multiBoxDestinationType.getItemCount() < 1) {
			multiBoxDestinationType.addItem("Mongo DB Storage");
			multiBoxDestinationType.addItem("DataStorage");
			multiBoxDestinationType.addItem("Agent's node");
		}

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					if (multiBoxDestinationType.getSelectedIndex() == -1) {
						Info.display("Warning",
								"You have not selected Destination Type ! ");
					} else {
						dialogBoxGen.hide();
						setDialogBoxForMessages();
						String selected = multiBoxDestinationType
								.getValue(multiBoxDestinationType
										.getSelectedIndex());
						destCombo.setValue(selected);
						String v = destCombo.getCurrentValue() == null ? "nothing"
								: destCombo.getCurrentValue();
						Info.display("Selected", "You selected " + v);
						if (destCombo.getCurrentValue() == null)
							return;

						if (destCombo.getCurrentValue().compareTo(
								"Mongo DB Storage") == 0) {
							targetStore = null;
							toBeTransferredStore.clear();
							toBeTransferredStore.commitChanges();
							if (isAdmin) {
								dialogBoxGen = createDialogBox(asPopUpMongoDBStorage());
								dialogBoxGen.center();
								focusTimer.schedule(200);
							} else {
								// initialization - default values
								initializeMongoDBStorage();
								if (combo1==null || combo1.getCurrentValue()==null ||
										combo1.getCurrentValue().compareTo("AgentSource") != 0
										|| selectedAgentSource == null) {
									//selection of agent should be transparent based on statistics
									transparentSelectionOfAgent(FolderToRetrieve.MongoDBStorageFolder);
									//changed ...
									//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.MongoDBStorageFolder));
									//dialogBoxGen.center();
									//focusTimer.schedule(200);
								} else {
									getMongoDBFolderDest("/");
									Info.display("Selected", "You selected "
											+ selectedAgentSource);
								}
							}
						} else if (destCombo.getCurrentValue().compareTo(
								"DataStorage") == 0) {
							dialogBoxGen = createDialogBox(asPopUpDataStorage());
							dialogBoxGen.center();
							focusTimer.schedule(200);
						} else if (destCombo.getCurrentValue().compareTo(
								"Agent's node") == 0) {
							if (combo1==null || combo1.getCurrentValue()==null ||
									combo1.getCurrentValue().compareTo("AgentSource") != 0
									|| selectedAgentSource == null) {
								//selection of agent should be transparent based on statistics
								transparentSelectionOfAgent(FolderToRetrieve.AgentDestFolder);
								//changed ...
								//dialogBoxGen = createDialogBox(asPopUpAgents(FolderToRetrieve.AgentDestFolder));
								//dialogBoxGen.center();
								//focusTimer.schedule(200);
							} else {
								selectedAgentDestination=selectedAgentSource;
								selectedAgentDestinationPort=selectedAgentSourcePort;
								getAgentFolderDest("");
								Info.display("Selected", "You selected "
										+ selectedAgentSource);
							}
						}
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	public void initializeMongoDBStorage() {
		smServiceName = new TextField();
		smServiceName.setValue("scheduler-portlet");
		smServiceClass = new TextField();
		smServiceClass.setValue("data-transfer");
		smOwner = new TextField();
		smOwner.setValue(ResourceName.getCurrentValue());
		smAccessType = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1)
						+ item.toString().substring(1).toLowerCase();
			}
		});
		smAccessType.setTriggerAction(TriggerAction.ALL);
		smAccessType.setEditable(false);
		smAccessType.add("SHARED");
		smAccessType.add("PUBLIC");
		smAccessType.add("PRIVATE");
		smAccessType.setForceSelection(true);
		smAccessType.setValue("SHARED");
	}

	/*
	 * asPopUpUris input: Nothing -- returns: Widget Creates a pop up panel so
	 * that user can choose the URI's he wants to transfer
	 */
	public Widget asPopUpUris() {
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("URI's");
		panel.addStyleName("margin-10");
		panel.setPixelSize(400, 250);

		cc1Uris = new ColumnConfig<Uri, String>(uriProp.name(), 60, "Name");
		cc2Uris = new ColumnConfig<Uri, String>(uriProp.URI(), 150, "URI");

		List<ColumnConfig<Uri, ?>> l = new ArrayList<ColumnConfig<Uri, ?>>();
		l.add(cc1Uris);
		l.add(cc2Uris);
		ColumnModel<Uri> cm = new ColumnModel<Uri>(l);
		if (storeForUris == null)
			storeForUris = new ListStore<Uri>(uriProp.key());

		uriGrid = new Grid<Uri>(storeForUris, cm);
		uriGrid.getView().setAutoExpandColumn(cc1Uris);
		editing = createGridEditing(uriGrid);
		editing.addEditor(cc1Uris, new TextField());
		editing.addEditor(cc2Uris, new TextField());

		ToolBar toolBar = new ToolBar();
		TextButton clear = new TextButton("Clear all");
		clear.setBorders(true);
		clear.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				editing.cancelEditing();
				storeForUris.clear();
				storeForUris.commitChanges();
			}
		});
		toolBar.add(clear);

		TextButton add = new TextButton("Add URI");
		add.setBorders(true);
		add.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				Uri uri = new Uri();
				uri.setName("Uri Name Example");
				uri.setURI("http://example.gr");
				editing.cancelEditing();
				storeForUris.add(0, uri);
				editing.startEditing(new GridCell(0, 0));
			}
		});
		toolBar.add(add);

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.setHeight("185px");
		con.add(toolBar, new VerticalLayoutData(1, -1));
		con.add(uriGrid, new VerticalLayoutData(1, 1));

		con.setWidth("300px");

		// ************** buttons **************
		TextButton addButton = new TextButton("Add");
		addButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				storeForUris.commitChanges();

				if (storeForUris.getAll().size() < 1) {
					Info.display("Message",
							"You have not added any URIS for transfer");
					combo1.setValue(lastCombo1Value);
				} else {
					lastCombo1Value = combo1.getCurrentValue();
					FolderDto tmpfolder = makeFolder("URI");
					for (Uri tmp : storeForUris.getAll()) {
						FolderDto subf = makeFolder(tmp.getURI());
						tmpfolder.addChild(subf);
					}
					folderSource = tmpfolder;
					redrawEast();
				}
			}
		});
		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				combo1.setValue(lastCombo1Value);
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				Info.display("Message",
						"You have not added any URIS for transfer");
			}
		});

		panel.setWidget(con);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(cancelButton);
		panel.addButton(addButton);

		uriGrid.setSelectionModel(new CellSelectionModel<Uri>());
		uriGrid.getColumnModel().getColumn(0).setHideable(false);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					combo1.setValue(lastCombo1Value);
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					Info.display("Message",
							"You have not added any URIS for transfer");
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					storeForUris.commitChanges();

					if (storeForUris.getAll().size() < 1) {
						Info.display("Message",
								"You have not added any URIS for transfer");
					} else {
						dialogBoxGen.hide();
						setDialogBoxForMessages();
						lastCombo1Value = combo1.getCurrentValue();
						FolderDto tmpfolder = makeFolder("URI");
						for (Uri tmp : storeForUris.getAll()) {
							FolderDto subf = makeFolder(tmp.getURI());
							tmpfolder.addChild(subf);
						}
						folderSource = tmpfolder;
						redrawEast();
					}
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpOperateTransfer input: Nothing -- returns: Widget Creates a pop up
	 * panel so that the user can choose a command for the specific transfer
	 * that he double clicked on.
	 */
	public Widget asPopUpOperateTransfer() {
		VerticalPanel vp = new VerticalPanel();
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Functions for this transfer");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.setWidget(p);

		transferIdInGrid = new TextField();
		transferIdInGrid.setAllowBlank(false);
		transferIdInGrid
		.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display(
						"TransferId Changed",
						"TransferId changed to " + event.getValue() == null ? "blank"
								: event.getValue());
			}
		});
		p.add(new FieldLabel(transferIdInGrid, "Transfer id:"),
				new VerticalLayoutData(1, -1));
		transferIdInGrid.setText(grid.getSelectionModel().getSelection().get(0)
				.getTransferId());

		commandsInGrid = new SimpleComboBox<String>(
				new LabelProvider<String>() {
					public String getLabel(String item) {
						return item.toString().substring(0, 1)
								+ item.toString().substring(1).toLowerCase();
					}
				});
		commandsInGrid.setTriggerAction(TriggerAction.ALL);
		commandsInGrid.setEditable(false);
		commandsInGrid.add("monitor");
		commandsInGrid.add("get outcomes");
		commandsInGrid.add("cancel");
		// Add a handler to change the data source
		commandsInGrid.addCollapseHandler(new CollapseHandler() {
			public void onCollapse(CollapseEvent event) {
				// set the same values in the main form
				if (commandsInGrid.getCurrentValue() == null)
					return;
				else
					commands.setText(commandsInGrid.getCurrentValue());
				ResourceName.setText(ResourceNameInGrid.getCurrentValue());
				scope.setText(scopeInGrid.getCurrentValue());
				transferId.setText(transferIdInGrid.getCurrentValue());
				if (force.isEnabled())
					force.setValue(forceInGrid.getValue());

				String v = commandsInGrid.getCurrentValue() == null ? "nothing"
						: commandsInGrid.getCurrentValue();
				Info.display("Selected", "You selected " + v);

				if (commandsInGrid.getCurrentValue().compareTo("monitor") == 0) {
					transferId.enable();
					force.disable();
					forceInGrid.disable();
				} else if (commands.getCurrentValue().compareTo("get outcomes") == 0) {
					transferId.enable();
					force.disable();
					forceInGrid.disable();
				} else if (commandsInGrid.getCurrentValue().compareTo("cancel") == 0) {
					transferId.enable();
					force.enable();
					forceInGrid.enable();
				}
			}
		});

		commandsInGrid.setAllowBlank(true);
		commandsInGrid.setForceSelection(true);

		p.add(new FieldLabel(commandsInGrid, "Commands"),
				new VerticalLayoutData(1, -1));

		ResourceNameInGrid = new TextField();
		ResourceNameInGrid.setAllowBlank(false);
		ResourceNameInGrid
		.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display(
						"Value Changed",
						"Resource Name changed to " + event.getValue() == null ? "blank"
								: event.getValue());
			}
		});
		p.add(new FieldLabel(ResourceNameInGrid, "Resource Name"),
				new VerticalLayoutData(1, -1));
		ResourceNameInGrid.setText(ResourceName.getCurrentValue());

		scopeInGrid = new TextField();
		scopeInGrid.setAllowBlank(false);
		scopeInGrid.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display(
						"Scope Changed",
						"Scope Name changed to " + event.getValue() == null ? "blank"
								: event.getValue());
			}
		});
		p.add(new FieldLabel(scopeInGrid, "Scope"), new VerticalLayoutData(1,
				-1));
		scopeInGrid.setText(scope.getCurrentValue());

		forceInGrid = new CheckBox();
		forceInGrid.setBoxLabel("force cancel");
		forceInGrid.disable();
		p.add(new FieldLabel(forceInGrid, "Force cancel"));
		forceInGrid.setValue(force.getValue());
		// ************** buttons **************
		TextButton submitButton = new TextButton("Submit");
		TextButton cancelButton = new TextButton("Cancel");

		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
			}
		});
		submitButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				// check for the fields of name-scope-and schedule
				if (checkFields())
					return;

				if (commandsInGrid.getCurrentValue().compareTo("monitor") == 0)
					monitor();
				else if (commandsInGrid.getCurrentValue().compareTo(
						"get outcomes") == 0)
					getOutcomes();
				else if (commandsInGrid.getCurrentValue().compareTo("cancel") == 0)
					cancel();
			}
		});
		p.add(cancelButton);
		p.add(submitButton);
		vp.add(panel);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
				} else if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					// check for the fields of name-scope-and schedule
					if (checkFields())
						return;

					if (commandsInGrid.getCurrentValue().compareTo("monitor") == 0)
						monitor();
					else if (commandsInGrid.getCurrentValue().compareTo(
							"get outcomes") == 0)
						getOutcomes();
					else if (commandsInGrid.getCurrentValue().compareTo(
							"cancel") == 0)
						cancel();
				}
			}
		});
		foc.add(vp);

		// --------------
		return foc;
	}



	/*
	 * asPopUpAgentStats input: Nothing -- returns: Widget It creates a pop up
	 * panel for the agent statistics
	 */
	public Widget asPopUpAgentStats() {
		if(gridAgentStats==null){
			ColumnConfig<AgentStat, String> endpointAgentStats = new ColumnConfig<AgentStat, String>(
					agentStatProp.endpoint(), 120, "Endpoint");
			ColumnConfig<AgentStat, String> ongoing = new ColumnConfig<AgentStat, String>(
					agentStatProp.ongoing(), 60, "Ongoing");
			ColumnConfig<AgentStat, String> failed = new ColumnConfig<AgentStat, String>(
					agentStatProp.failed(), 60, "Failed");
			ColumnConfig<AgentStat, String> succesful = new ColumnConfig<AgentStat, String>(
					agentStatProp.succesful(), 60, "Succesful");
			ColumnConfig<AgentStat, String> canceled = new ColumnConfig<AgentStat, String>(
					agentStatProp.canceled(), 60, "Canceled");
			ColumnConfig<AgentStat, String> total = new ColumnConfig<AgentStat, String>(
					agentStatProp.total(), 60, "Total");

			List<ColumnConfig<AgentStat, ?>> l = new ArrayList<ColumnConfig<AgentStat, ?>>();
			l.add(endpointAgentStats);
			l.add(ongoing);
			l.add(failed);
			l.add(succesful);
			l.add(canceled);
			l.add(total);

			cmAgentStat = new ColumnModel<AgentStat>(l);

			storeAgentStats = new ListStore<AgentStat>(agentStatProp.key());

			gridAgentStats = new Grid<AgentStat>(storeAgentStats, cmAgentStat);
			gridAgentStats.getView().setAutoExpandColumn(endpointAgentStats);
			gridAgentStats.setBorders(true);
			gridAgentStats.getView().setStripeRows(true);
			gridAgentStats.getView().setColumnLines(true);

			// Add a selection model so we can select cells.
			final GridSelectionModel<AgentStat> selectionModel = new GridSelectionModel<AgentStat>();
			gridAgentStats.setSelectionModel(selectionModel);
			gridAgentStats.addRowDoubleClickHandler(new RowDoubleClickHandler() {
				public void onRowDoubleClick(RowDoubleClickEvent event) {
					String endpoint = gridAgentStats.getSelectionModel().getSelection()
							.get(0).getEndpoint();
					if (endpoint != null) {

						if (combo1==null || combo1.getCurrentValue()==null ||
								combo1.getCurrentValue().compareTo("AgentSource") != 0
								|| selectedAgentSource == null) {
							//if destination is not agent .. 
							if(destCombo==null || destCombo.getCurrentValue()==null ||
									(!destCombo.getCurrentValue().startsWith("Agent"))){
								agentIsSelectedFromStatsPanel=true;
								dialogBoxGen.hide();
								setDialogBoxForMessages();
								Info.display("Selected", "You selected " + endpoint);
								agentHostname = endpoint;
								//setting tool tip
								if(agentStats!=null){
									if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("");
									agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
									agentStats.setToolTipConfig(agentStatsTooltip);
								}

								comboAgent.setValue(endpoint);
								lastDestComboValue = destCombo.getCurrentValue();
								redrawEast();
							}else{
								Info.display("Agent is already set (because selected destination is agent)", "Selected Agent " + endpoint);
							}	
						}
						else{
							Info.display("Agent is already set (because selected source is agent)", "Selected Agent " + endpoint);
						}
					}
				}
			});

		}

		if(listAgentStats==null){
			getAgentStatistics(null);
		}
		else if(storeAgentStats.size()<1){
			storeAgentStats.replaceAll(listAgentStats);
			gridAgentStats.reconfigure(storeAgentStats, cmAgentStat);
		}			

		FramedPanel panel = new FramedPanel();
		panel.setAnimCollapse(false);
		panel.setHeadingText("Agent Statistics - Double click to select");
		panel.setPixelSize(600, 250);
		panel.addStyleName("margin-10");

		TextButton cancelButton = new TextButton("Cancel");
		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
				destCombo.setValue(lastDestComboValue);
			}
		});
		TextButton refreshButton = new TextButton("Refresh");
		refreshButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				getAgentStatistics(null);
			}
		});

		panel.setWidget(gridAgentStats);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(cancelButton);
		panel.addButton(refreshButton);


		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
					destCombo.setValue(lastDestComboValue);
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/*
	 * asPopUpOutcomes input: Nothing -- returns: Widget It creates a pop up
	 * panel for showing the outcomes of a specific transfer
	 */
	public Widget asPopUpOutcomes() {
		IdentityValueProvider<Outcomes> identity = new IdentityValueProvider<Outcomes>();

		RowExpander<Outcomes> expander = new RowExpander<Outcomes>(identity,
				new AbstractCell<Outcomes>() {
			@Override
			public void render(Context context, Outcomes value,
					SafeHtmlBuilder sb) {
				sb.appendHtmlConstant("<p style='margin: 5px 5px 10px'><b>FileName:</b>"
						+ value.getFileName() + "</p>");
				sb.appendHtmlConstant("<p style='margin: 5px 5px 10px'><b>Outcomes:</b> "
						+ value.getTotalMessage() + "</p>");
			}
		});
		ColumnConfig<Outcomes, String> fileName = new ColumnConfig<Outcomes, String>(
				outcomesProp.fileName(), 70, "FileName");
		ColumnConfig<Outcomes, String> destination = new ColumnConfig<Outcomes, String>(
				outcomesProp.destination(), 90, "Destination");
		ColumnConfig<Outcomes, String> success = new ColumnConfig<Outcomes, String>(
				outcomesProp.success(), 55, "Success");
		ColumnConfig<Outcomes, String> failure = new ColumnConfig<Outcomes, String>(
				outcomesProp.failure(), 55, "Failure");
		ColumnConfig<Outcomes, String> transferTime = new ColumnConfig<Outcomes, String>(
				outcomesProp.transferTime(), 60, "Time");
		ColumnConfig<Outcomes, String> size = new ColumnConfig<Outcomes, String>(
				outcomesProp.size(), 60, "Size");
		ColumnConfig<Outcomes, String> transferredBytes = new ColumnConfig<Outcomes, String>(
				outcomesProp.transferredBytes(), 60, "TransferredBytes");
		ColumnConfig<Outcomes, String> exception = new ColumnConfig<Outcomes, String>(
				outcomesProp.exception(), 80, "Exceptions");

		List<ColumnConfig<Outcomes, ?>> l = new ArrayList<ColumnConfig<Outcomes, ?>>();
		l.add(expander);
		l.add(fileName);
		l.add(destination);
		l.add(success);
		l.add(failure);
		l.add(transferTime);
		l.add(size);
		l.add(transferredBytes);
		l.add(exception);

		ColumnModel<Outcomes> cm = new ColumnModel<Outcomes>(l);

		ListStore<Outcomes> store = new ListStore<Outcomes>(outcomesProp.key());
		if (listOutcomes != null)
			store.addAll(listOutcomes);

		final Grid<Outcomes> grid = new Grid<Outcomes>(store, cm);
		grid.getView().setAutoExpandColumn(fileName);
		grid.setBorders(true);
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		expander.initPlugin(grid);

		// Add a selection model so we can select cells.
		final GridSelectionModel<Outcomes> selectionModel = new GridSelectionModel<Outcomes>();
		grid.setSelectionModel(selectionModel);
		grid.addRowDoubleClickHandler(new RowDoubleClickHandler() {
			public void onRowDoubleClick(RowDoubleClickEvent event) {
				// #
			}
		});

		FramedPanel panel = new FramedPanel();
		// panel.setCollapsible(true);
		panel.setAnimCollapse(false);
		panel.setHeadingText("Outcomes");
		panel.setPixelSize(700, 250);
		panel.addStyleName("margin-10");

		TextButton closeButton = new TextButton("Close");
		closeButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
				setDialogBoxForMessages();
			}
		});

		panel.setWidget(grid);
		panel.setButtonAlign(BoxLayoutPack.START);
		panel.addButton(closeButton);

		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
					setDialogBoxForMessages();
				}
			}
		});
		foc.add(panel);
		// --------------
		return foc;
	}

	/* ------------------------------------------------------------- */
	/* ---------------REMOTE PROCEDURE CALLS ----------------------- */

	/*
	 * getAgents input: Nothing -- returns: Nothing Remote Procedure Call:
	 * retrieving the agents
	 */
	public void getAgents() {
		if (scope == null || ResourceName == null) {
			Info.display("Warning", "agent or scope is null");
			return;
		}

		schedulerService.getObjectsFromIS("Agent", scope.getCurrentValue(),
				ResourceName.getCurrentValue(), new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				Info.display("ERROR", "Failure getting the Agents ! ");
				//printMsgInDialogBox("WARNING - Remote Procedure Call - Failure getting the Agents");
			}

			public void onSuccess(String result) {
				if (result == null)
					Info.display("ERROR", "Failure getting the Agents ! ");
				//printMsgInDialogBox("WARNING - Remote Procedure Call - Failure getting the Agents");
				else if (result.compareTo("") == 0)
					return;

				stringOfAgents = result;
				if (multiBoxAgents != null)
					multiBoxAgents.clear();
				else {
					multiBoxAgents = new ListBox(false);
					multiBoxAgents.setWidth("260px");
					multiBoxAgents.setVisibleItemCount(5);
				}
				String[] agentsArray = result.split("\n");
				for (String tmp : agentsArray) {
					// tmp contains: id--name--hostName--port
					String[] partsOfInfo = tmp.split("--");
					// we store only the host name
					multiBoxAgents.addItem(partsOfInfo[2]);
				}

				//getting agent statistics
				getAgentStatistics(null);

			}
		});
	}

	/*
	 * schedule input: Nothing -- returns: Nothing Remote Procedure Call:
	 * schedule a transfer
	 */
	public void schedule() {

		String text = "";
		if (this.typeOfSchedule.getCurrentValue().compareTo("direct") == 0)
			text = "direct";
		else if (this.typeOfSchedule.getCurrentValue().compareTo(
				"periodically scheduled") == 0)
			text = "periodically";
		else if (this.typeOfSchedule.getCurrentValue().compareTo(
				"manually scheduled") == 0)
			text = "manually";

		// printMsgInDialogBox("You have submitted a "+text+" scheduled transfer .. ");
		Info.display("", "You have submitted a " + text
				+ " scheduled transfer .. ");

		SchedulerObj scheduleObj = new SchedulerObj();
		scheduleObj = fillSchedulerObj(scheduleObj);
		if (scheduleObj == null)
			return;
		String jsonString = SchedulerObj.createSerializer().serialize(
				scheduleObj);

		this.toBeTransferredStore.clear();
		this.toBeTransferredStore.commitChanges();

		schedulerService.schedule(jsonString, new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("ERROR - Remote Procedure Call - Failure schedule");
			}

			public void onSuccess(String result) {
				if (result == null) {
					printMsgInDialogBox("ERROR - Remote Procedure Call - Failure schedule");
				} else {
					getTransferTimer.schedule(200);
					String transferIdResult = result;
					Info.display("schedule", "transfer id=" + transferIdResult);
					// printMsgInDialogBox("'schedule': transfer id="+transferIdResult);
				}
			}
		});

	}

	/*
	 * monitor input: Nothing -- returns: Nothing Remote Procedure Call: monitor
	 * a transfer
	 */
	public void monitor() {
		// printMsgInDialogBox("You have submitted a monitor task .. ");
		Info.display("", "You have submitted a monitor task .. ");

		schedulerService.monitor(this.scope.getCurrentValue(),
				this.ResourceName.getCurrentValue(),
				this.transferId.getCurrentValue(), new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("'monitor': Failure");
			}

			public void onSuccess(String result) {
				if (result == null)
					printMsgInDialogBox("'monitor': result=null\n");
				else {
					callingSchedulerResult = (CallingSchedulerResult) CallingSchedulerResult
							.createSerializer()
							.deSerialize(result,
									"org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult");
					String errors = "";
					int i = 0;
					for (String tmp : callingSchedulerResult
							.getErrors()) {
						if (tmp.compareTo("") == 0)
							continue;
						if (i == 0)
							errors = errors.concat("errors:\n");
						errors = errors.concat("- " + tmp + "\n");
						i++;
					}
					printMsgInDialogBox("'monitor':\n   transfer result:"
							+ callingSchedulerResult.getMonitorResult()
							+ "\n" + errors + "\n");
				}
			}
		});
	}

	/*
	 * getOutcomes input: Nothing -- returns: Nothing Remote Procedure Call:
	 * getting the outcomes of a transfer
	 */
	public void getOutcomes() {
		// printMsgInDialogBox("You have submitted a getOutcomes task .. ");
		Info.display("", "You have submitted a getOutcomes task .. ");

		schedulerService.getOutcomes(this.scope.getCurrentValue(),
				this.ResourceName.getCurrentValue(),
				this.transferId.getCurrentValue(), new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("'getOutcomes': Failure");
			}

			public void onSuccess(String result) {
				if (result == null)
					printMsgInDialogBox("'getOutcomes': result=null\n");
				else {
					callingSchedulerResult = (CallingSchedulerResult) CallingSchedulerResult
							.createSerializer()
							.deSerialize(result,
									"org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult");
					String errors = "";
					int i = 0;
					for (String tmp : callingSchedulerResult
							.getErrors()) {
						if (tmp.compareTo("") == 0)
							continue;
						if (i == 0)
							errors = errors.concat("errors:\n");
						errors = errors.concat("- " + tmp + "\n");
						i++;
					}
					if (callingSchedulerResult.getSchedulerOutcomes() == null) {
						printMsgInDialogBox("'getOutcomes':\n   outcomes:\n"
								+ callingSchedulerResult
								.getSchedulerOutcomes()
								+ "\n"
								+ errors + "\n");
						return;
					}

					String[] outcomes = callingSchedulerResult
							.getSchedulerOutcomes().split("Outcome-");

					if (outcomes.length > 1) {
						listOutcomes = new ArrayList<Outcomes>();
						for (String outcome : outcomes) {
							Outcomes tmpOutcome = new Outcomes();
							tmpOutcome.setTotalMessage("Number: "
									+ outcome);
							String[] linesOfOutcome = outcome
									.split("\n");
							for (String line : linesOfOutcome) {
								if (line.startsWith("FileName: "))
									tmpOutcome.setFileName(line
											.replaceAll("FileName: ",
													""));
								else if (line.startsWith("Dest: "))
									tmpOutcome.setDestination(line
											.replaceAll("Dest: ", ""));
								else if (line.startsWith("Exception: "))
									tmpOutcome.setException(line
											.replaceAll("Exception: ",
													""));
								else if (line
										.startsWith("TransferTime: "))
									tmpOutcome.setTransferTime(line
											.replaceAll(
													"TransferTime: ",
													"")
													+ " ms");
								else if (line.startsWith("TransferredBytes: "))
									tmpOutcome.setTransferredBytes(line.replaceAll(
											"TransferredBytes: ",
											""));
								else if (line.startsWith("Size: "))
									tmpOutcome.setSize(line.replaceAll(
											"Size: ",
											""));
								else if (line.startsWith("Success"))
									tmpOutcome.setSuccess(line
											.replaceAll("Success", "")
											.substring(2));
								else if (line.startsWith("Failure"))
									tmpOutcome.setFailure(line
											.replaceAll("Failure", "")
											.substring(2));
							}
							if (tmpOutcome.getFileName() != null)
								listOutcomes.add(tmpOutcome);
						}
						dialogBoxGen = createDialogBox(asPopUpOutcomes());
						dialogBoxGen.center();
						focusTimer.schedule(200);
					} else
						printMsgInDialogBox("'getOutcomes':\n   outcomes:\n"
								+ callingSchedulerResult
								.getSchedulerOutcomes()
								+ "\n"
								+ errors + "\n");

				}
			}
		});
	}

	/*
	 * cancel input: Nothing -- returns: Nothing Remote Procedure Call: cancel a
	 * transfer
	 */
	public void cancel() {
		// printMsgInDialogBox("You have submitted a cancel task .. ");
		Info.display("", "You have submitted a cancel task .. ");

		schedulerService.cancel(this.scope.getCurrentValue(),
				this.ResourceName.getCurrentValue(),
				this.transferId.getCurrentValue(), this.force.getValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				dialogBoxGen.setText("'cancel': Failure");
				dialogBoxGen.center();
				closeButton.setFocus(true);
			}

			public void onSuccess(String result) {
				if (result == null)
					printMsgInDialogBox("'cancel': result=null\n");
				else {
					callingSchedulerResult = (CallingSchedulerResult) CallingSchedulerResult
							.createSerializer()
							.deSerialize(result,
									"org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult");
					String errors = "";
					int i = 0;
					for (String tmp : callingSchedulerResult
							.getErrors()) {
						if (tmp.compareTo("") == 0)
							continue;
						if (i == 0)
							errors = errors.concat("errors:\n");
						errors = errors.concat("- " + tmp + "\n");
						i++;
					}
					printMsgInDialogBox("'cancel': "
							+ callingSchedulerResult.getCancelResult()
							+ "\n" + errors + "\n");
				}
			}
		});
	}

	/*
	 * getTransfers input: Nothing -- returns: Nothing Remote Procedure Call:
	 * getting the transfers for a specific resource name and scope calling also
	 * the 'designTransferGrid' where a grid is being designed for showing the
	 * transfers
	 */
	public void getTransfers() {
		if(loadingIconForTransfers==null)loadingIconForTransfers=createLoadingIcon();
		startLoadingIcon(grid,loadingIconForTransfers);
		//getting scope /resource Name
		String scopeStr,recourceNameStr;
		if(scope==null || scope.getCurrentValue()==null || 
				scope.getCurrentValue().compareTo("")==0){
			scopeStr=defaultScope;
		}else scopeStr=scope.getCurrentValue();
		if(ResourceName==null || ResourceName.getCurrentValue()==null || 
				ResourceName.getCurrentValue().compareTo("")==0){
			recourceNameStr=defaultResourceName;
		}else recourceNameStr=ResourceName.getCurrentValue();
		//----------------------------------------
		schedulerService.getTransfers(scopeStr,
				recourceNameStr, new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				stopLoadingIcon(loadingIconForTransfers);
				Info.display("WARNING", "Failure getting the transfers ! ");
				//printMsgInDialogBox("'getTransfers': Failure");
			}

			public void onSuccess(String result) {
				stopLoadingIcon(loadingIconForTransfers);
				if (result == null) {
					Info.display("WARNING", "Failure getting the transfers ! ");
				} else {
					callingManagementResultJson = result;
					designTransferGrid();
				}
			}
		});
	}

	public void deleteFolderInMongoDB(){
		String pathToDelete = this.folderDestination.getName();

		final String finalPathToDelete=pathToDelete;

		schedulerService.deleteFolderInMongoDB(
				smServiceClass.getCurrentValue(),
				smServiceName.getCurrentValue(),
				smOwner.getCurrentValue(),
				smAccessType.getCurrentValue(), finalPathToDelete,
				scope.getCurrentValue(), new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						Info.display("Warning", "Failed to store new folder");
					}
					public void onSuccess(Void result) {
						//going to upper level .. 

						for(BaseDto tmp : folderDestination.getChildren()){
							if(tmp.getShortname().compareTo("<< Back")==0){
								TreeNode<BaseDto> node = targetTree.findNode(tmp);
								lastSelectedMongoDBFolderDestName = node.getModel()
										.getName();
								destinationF.setValue(node.getModel().getName());
								destinationAnchor.setBodyText(node.getModel().getName());
								getMongoDBFolderDest(node.getModel().getName());
								return;
							}
						}
						//in other case it's the root folder that you deleted .. so you get again that empty root to show
						destinationF.setValue("/");
						destinationAnchor.setBodyText("/");
						getMongoDBFolderDest("/");
					}
				});
	}
	public void storeNewFolderInMongoDB(){
		if (newFolderField == null)	return;
		if (newFolderField.getCurrentValue() == null) return;

		String path=newFolderField.getCurrentValue();
		path=path.replaceAll("(/)\\1+", "$1"); //remove multiple consecutive '/'

		if(!path.startsWith("/")){
			String rootPath = this.folderDestination.getName();
			if(!rootPath.endsWith("/"))rootPath=rootPath+"/";
			path=rootPath+path;
		}
		if(!path.endsWith("/"))path=path+"/";

		final String finalPathForFolder=path;

		schedulerService.createNewFolderInMongoDB(
				smServiceClass.getCurrentValue(),
				smServiceName.getCurrentValue(),
				smOwner.getCurrentValue(),
				smAccessType.getCurrentValue(), path,
				scope.getCurrentValue(), new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						Info.display("Warning", "Failed to store new folder");
					}
					public void onSuccess(Void result) {
						destinationF.setValue(finalPathForFolder);
						destinationAnchor.setBodyText(finalPathForFolder);
						getMongoDBFolderDest(finalPathForFolder);
					}
				});

	}
	/*
	 * getDataSources input: Nothing -- returns: Nothing Remote Procedure Call:
	 * retrieving data sources
	 */
	public void getDataSources() {
		schedulerService.getObjectsFromIS("DataSource",
				scope.getCurrentValue(), ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				Info.display("Warning",
						"WARNING - Remote Procedure Call - Failure getting the DataSources");
			}

			public void onSuccess(String result) {
				if (result == null) {
					Info.display("Warning",
							"WARNING - Remote Procedure Call - Failure getting the DataSources");
					return;
				} else if (result.compareTo("") == 0) {
					Info.display("Warning",
							"WARNING - Remote Procedure Call - Failure getting the DataSources");
					return;
				}
				// storing the list of data source
				String[] sourcesArray = result.split("\n");
				int num = 0;
				dataSourcesList = new ArrayList<String>();
				for (String tmp : sourcesArray) {
					// tmp contains:
					// resultIdOfIS--name--description--endpoint--username--password--propertyFolders
					dataSourcesList.add(tmp);
					num++;
				}
				if (num == 0) {
					Info.display("Warning",
							"WARNING - Remote Procedure Call - Failure getting the DataSources");
					return;
				}
				// putting only the names in the multiBox
				multiBoxDataSources.clear();
				for (String tmp : dataSourcesList) {
					String[] parts = tmp.split("--");
					multiBoxDataSources.addItem(parts[1]);
				}
			}
		});

	}

	/*
	 * getWorkspaceFolder input: String with the id of a specific folderSource and a
	 * boolean indicating if we want to have the parent of this folderSource or not --
	 * returns: Nothing Remote Procedure Call: getting the workspace folderSource as a
	 * json object
	 */
	public void getWorkspaceFolder(String idOfSpecificFolder,
			boolean needTheParent) {
		if (idOfSpecificFolder == null)
			callingWorkspaceRoot = true;
		if (gettingUserAndScope == false) {
			Info.display("Message",
					"User and scope were not loaded properly and we cannot retrieve workspace");
			combo1.setValue(lastCombo1Value);
			return;
		}

		// if jsonWorkspace is null we will load it again ..
		// if(jsonWorkspace==null){Info.display("Message",
		// "Workspace was not loaded");return;}
		if(loadingIconForSource==null)loadingIconForSource=createLoadingIcon();
		startLoadingIcon(sourceTree,loadingIconForSource);

		schedulerService.getWorkspaceFolder(jsonWorkspace, idOfSpecificFolder,
				needTheParent, new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				stopLoadingIcon(loadingIconForSource);
				printMsgInDialogBox("Remote Procedure Call - Failure list files");
				Info.display("Warning", "Items were not loaded");
				combo1.setValue(lastCombo1Value);
			}

			public void onSuccess(String folderResult) {
				stopLoadingIcon(loadingIconForSource);
				folderResSource = folderResult;
				folderSource = null;
				redrawEast();
				lastCombo1Value = combo1.getCurrentValue();
				if (folderResSource == null)
					Info.display("Message", "Items were not loaded");
				else
					Info.display("Message", "Items were loaded");
			}
		});
	}

	/*
	 * getWorkspace input: Nothing -- returns: Nothing Remote Procedure Call:
	 * getting the workspace as a json object
	 */
	public void getWorkspace() {
		schedulerService.getWorkspace(ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				Info.display("Warning", "Workspace was not loaded");
			}

			public void onSuccess(String result) {
				jsonWorkspace = result;
				if (jsonWorkspace == null) {
					Info.display("Message",
							"Workspace was not loaded in the first place");
				}
			}
		});
	}

	/*
	 * getUserAndScope input: Nothing -- returns: Nothing Remote Procedure Call:
	 * getting the user and scope from the portal liferay
	 */
	public void getUserAndScopeAndRole() {
		schedulerService.getUserAndScopeAndRole(new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("Remote Procedure Call - Failure retrieving user and scope");
				gettingUserAndScope = false;

				// set the south widget for list the transfers in DB
				getTransfers();
				// auto refresh every 30s
				getTransferRepeatingTimer.scheduleRepeating(30000); // ms
			}
			public void onSuccess(String userAndScope) {
				if (userAndScope == null) {
					Info.display("Warning",
							"user and scope were not loaded properly");
					gettingUserAndScope = false;
				} else {
					gettingUserAndScope = true;
					String[] parts = userAndScope.split("--");
					defaultResourceName = parts[0];
					defaultScope = parts[1];
					if (parts[2].compareTo("true") == 0) {
						isAdmin = true;
						if (ResourceName != null && scope != null) {
							ResourceName.enable();
							scope.enable();
							destinationF.enable();
						} else {
							Timer enableTimer = new Timer() {
								@Override
								public void run() {
									ResourceName.enable();
									scope.enable();
									destinationF.enable();
								}
							};
							enableTimer.schedule(3000); // ms
						}
					}

					ResourceName.setValue(parts[0]);
					scope.setValue(parts[1]);
					Info.display("Message", "user:" + parts[0] + " - scope:"
							+ parts[1]);
					west.clear();
					west.add(asWidgetScheduler());
				}

				// set the south widget for list the transfers in DB
				getTransfers();
				// auto refresh every 30s
				getTransferRepeatingTimer.scheduleRepeating(30000); // ms
			}
		});
	}

	/*
	 * getDatasourceFolder input: String with the data source id and the
	 * specific path -- returns: Nothing Remote Procedure Call: getting the path
	 * folderSource(FolderDto) from this data source as a json object
	 */
	public void getDatasourceFolder(String dataSourceId, String path) {
		if(loadingIconForSource==null)loadingIconForSource=createLoadingIcon();
		startLoadingIcon(sourceTree,loadingIconForSource);
		currentDataSourcePath = path;

		schedulerService.getFileListOfDSourceOrDStorage("DataSource",dataSourceId, path,
				scope.getCurrentValue(), ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				stopLoadingIcon(loadingIconForSource);
				printMsgInDialogBox("Remote Procedure Call - Failure list files");
				Info.display("Warning", "Items were not loaded");
				combo1.setValue(lastCombo1Value);
			}

			public void onSuccess(String folderResult) {
				stopLoadingIcon(loadingIconForSource);
				folderResSource = folderResult;
				folderSource = null;
				redrawEast();
				lastCombo1Value = combo1.getCurrentValue();
				if (folderResSource == null)
					Info.display("Message", "Items were not loaded");
				else
					Info.display("Message", "Items were loaded");
			}
		});
	}
	public void getDatastorageFolder(String dataStorageId, String path) {
		if(loadingIconForTarget==null)loadingIconForTarget=createLoadingIcon();
		startLoadingIcon(targetTree,loadingIconForTarget);
		currentDataStoragePath = path;

		schedulerService.getFileListOfDSourceOrDStorage("DataStorage",dataStorageId, path,
				scope.getCurrentValue(), ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				stopLoadingIcon(loadingIconForTarget);
				printMsgInDialogBox("Remote Procedure Call - Failure list files of Dest");
				Info.display("Warning", "Items were not loaded");
				destCombo.setValue(lastDestComboValue);
			}

			public void onSuccess(String folderResult) {
				stopLoadingIcon(loadingIconForTarget);
				folderResDestination = folderResult;
				folderDestination = null;
				redrawEast();
				lastDestComboValue = destCombo.getCurrentValue();
				makeNewFolder.hide();
				deleteCurrentFolder.hide();

				if (folderResDestination == null)
					Info.display("Message", "Items were not loaded");
				else
					Info.display("Message", "Items were loaded");
			}
		});
	}
	public void getAgentFolder(String path) {
		if(loadingIconForSource==null)loadingIconForSource=createLoadingIcon();
		startLoadingIcon(sourceTree,loadingIconForSource);
		currentAgentSourcePath = path;

		schedulerService.getFileListOfAgent(path, selectedAgentSource,
				selectedAgentSourcePort, scope.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				stopLoadingIcon(loadingIconForSource);
				printMsgInDialogBox("Remote Procedure Call - Failure list files");
				Info.display("Warning", "Items were not loaded");
				combo1.setValue(lastCombo1Value);
			}

			public void onSuccess(String folderResult) {
				stopLoadingIcon(loadingIconForSource);
				folderResSource = folderResult;
				folderSource = null;
				redrawEast();
				lastCombo1Value = combo1.getCurrentValue();
				if (folderResSource == null)
					Info.display("Message", "Items were not loaded");
				else
					Info.display("Message", "Items were loaded");
			}
		});
	}
	public void getAgentFolderDest(String path) {
		if(loadingIconForTarget==null)loadingIconForTarget=createLoadingIcon();
		startLoadingIcon(targetTree,loadingIconForTarget);
		currentAgentDestinationPath = path;

		schedulerService.getFileListOfAgent(path, selectedAgentDestination,
				selectedAgentDestinationPort, scope.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				stopLoadingIcon(loadingIconForTarget);
				printMsgInDialogBox("Remote Procedure Call - Failure list files");
				Info.display("Warning", "Items were not loaded");
				destCombo.setValue(lastDestComboValue);
			}

			public void onSuccess(String folderResult) {
				stopLoadingIcon(loadingIconForTarget);
				folderResDestination = folderResult;
				folderDestination = null;
				redrawEast();
				lastDestComboValue = destCombo.getCurrentValue();
				makeNewFolder.hide();
				deleteCurrentFolder.hide();

				if (folderResDestination == null)
					Info.display("Message", "Items were not loaded");
				else
					Info.display("Message", "Items were loaded");
			}
		});
	}

	/*
	 * getMongoDBFolder input: String with the data source id and the specific
	 * path -- returns: Nothing Remote Procedure Call: getting the path
	 * folder(FolderDto) from this data source as a json object
	 */
	public void getMongoDBFolder(String path) {
		if(loadingIconForSource==null)loadingIconForSource=createLoadingIcon();
		startLoadingIcon(sourceTree,loadingIconForSource);
		// currentDataSourcePath=path;
		currentMongoDBSourcePath = path;

		schedulerService.getFileListOfMongoDB(
				smServiceClassSource.getCurrentValue(),
				smServiceNameSource.getCurrentValue(),
				smOwnerSource.getCurrentValue(),
				smAccessTypeSource.getCurrentValue(), path,
				scope.getCurrentValue(), new AsyncCallback<String>() {
					public void onFailure(Throwable caught) {
						stopLoadingIcon(loadingIconForSource);
						printMsgInDialogBox("Remote Procedure Call - Failure list files");
						Info.display("Warning", "Items were not loaded");
						combo1.setValue(lastCombo1Value);
					}

					public void onSuccess(String folderResult) {
						stopLoadingIcon(loadingIconForSource);
						folderResSource = folderResult;
						folderSource = null;
						redrawEast();
						lastCombo1Value = combo1.getCurrentValue();
						if (folderResSource == null)
							Info.display("Message", "Items were not loaded");
						else
							Info.display("Message", "Items were loaded");
					}
				});
	}

	public void getMongoDBFolderDest(String path) {
		if(loadingIconForTarget==null)loadingIconForTarget=createLoadingIcon();
		startLoadingIcon(targetTree,loadingIconForTarget);
		// currentDataSourcePath=path;
		currentMongoDBDestinationPath = path;
		schedulerService.getFileListOfMongoDB(
				smServiceClass.getCurrentValue(),
				smServiceName.getCurrentValue(),
				smOwner.getCurrentValue(),
				smAccessType.getCurrentValue(), path,
				scope.getCurrentValue(), new AsyncCallback<String>() {
					public void onFailure(Throwable caught) {
						stopLoadingIcon(loadingIconForTarget);
						printMsgInDialogBox("Remote Procedure Call - Failure list files");
						Info.display("Warning", "Items were not loaded");
						destCombo.setValue(lastDestComboValue);
					}
					public void onSuccess(String folderResult) {
						stopLoadingIcon(loadingIconForTarget);
						folderResDestination = folderResult;
						folderDestination = null;
						redrawEast();
						lastDestComboValue = destCombo.getCurrentValue();
						makeNewFolder.show();
						deleteCurrentFolder.show();
						if (folderResDestination == null)
							Info.display("Message", "Items were not loaded");
						else
							Info.display("Message", "Items were loaded");
					}
				});
	}

	/*
	 * getAgentStatistics input: Nothing -- returns: Nothing Remote Procedure
	 * Call: getting the agent statistics Calling the 'createAgentStats' for
	 * creating the agentStats objects
	 */
	public void getAgentStatistics(FolderToRetrieve folderToRetrieve) {
		final FolderToRetrieve foldToRetrieve=folderToRetrieve;

		schedulerService.getAgentStatistics(scope.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				Info.display("Warning",
						"Agent Statistics were not loaded");
			}

			public void onSuccess(String result) {
				if (result == null) {
					Info.display("Warning",
							"Agent Statistics were not loaded");
					return;
				}
				// printMsgInDialogBox(result);
				stringOfAgentStats = result;
				boolean resultFromCreatingAgentStats=createAgentStats();
				if(storeAgentStats!=null){
					storeAgentStats.replaceAll(listAgentStats);
					gridAgentStats.reconfigure(storeAgentStats, cmAgentStat);
				}			

				//printMsgInDialogBox("toPopup="+toPopup+"listAgentStats.size()="+listAgentStats.size());
				if(foldToRetrieve!=null && resultFromCreatingAgentStats){
					calculateAndSelectBestAgent(foldToRetrieve);
				}
			}
		});
	}

	/* ----------------------------------------------------------- */
	/* -------------------- OTHER FUNCTIONS ----------------------- */

	public void transparentSelectionOfAgent(FolderToRetrieve folderToRetrieve){
		if(this.agentIsSelectedFromStatsPanel==true){
			Info.display("Already selected agent",this.agentHostname);
			if(agentStats!=null && agentStatsTooltip!=null){
				agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
				agentStats.setToolTipConfig(agentStatsTooltip);
			}
			loadSpecificFolder(folderToRetrieve, this.agentHostname);	
			return;
		}		
		//selection based on statistics ... 
		lastDestComboValue = destCombo.getCurrentValue();
		getAgentStatistics(folderToRetrieve);			
	}

	public void calculateAndSelectBestAgent(FolderToRetrieve folderToRetrieve){
		if (listAgentStats==null || listAgentStats.size()==0){
			Info.display("WARNING", "List of available agents is null");
			return;
		}
		String agentName = listAgentStats.get(0).getEndpoint();
		int max = Integer.valueOf(listAgentStats.get(0).getSuccesful());
		boolean firstTime=true;
		for(AgentStat agentStat : listAgentStats){
			if(firstTime){firstTime=false;continue;}

			int possibleMax=Integer.valueOf(agentStat.getSuccesful());
			if( possibleMax> max){				
				agentName=agentStat.getEndpoint();
				max = possibleMax;
			}			
		}

		if (agentName==null){
			Info.display("WARNING", "agentName==null");
			return;
		}
		agentHostname = agentName;
		Info.display("Selected agent(based on statistics)",this.agentHostname);

		//setting tool tip
		if(agentStats!=null){
			if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("");
			agentStatsTooltip.setBodyText("Selected agent:"+agentHostname);
			agentStats.setToolTipConfig(agentStatsTooltip);
		}

		comboAgent.setValue(agentName);

		loadSpecificFolder(folderToRetrieve,agentName);			
	}

	public void loadSpecificFolder(FolderToRetrieve folderToRetrieve, String agentName){
		if(folderToRetrieve.equals(FolderToRetrieve.NONE)){
			redrawEast();
		}
		else if(folderToRetrieve.equals(FolderToRetrieve.MongoDBStorageFolder)){
			getMongoDBFolderDest("/");
		}
		else if(folderToRetrieve.equals(FolderToRetrieve.AgentDestFolder)){
			String[] agentsArray = stringOfAgents.split("\n");
			for (String tmp : agentsArray) {
				// tmp contains: id--name--hostName--port
				String[] partsOfInfo = tmp.split("--");
				if (partsOfInfo[2].compareTo(agentName) == 0) {
					selectedAgentDestinationPort = partsOfInfo[3];
				}
			}
			selectedAgentDestination = agentName;					
			getAgentFolderDest("");
		}		
		else if(folderToRetrieve.equals(FolderToRetrieve.DataStorageFolder)){
			getDatastorageFolder(selectedDataStorageId, "./");
		}	
	}

	/*
	 * designTransferGrid input: Nothing -- returns: Nothing It creates a grid
	 * for the transfers and sets the south panel to this grid
	 */
	public void designTransferGrid() {
		if (callingManagementResultJson != null) {
			callingManagementResult = (CallingManagementResult) CallingManagementResult
					.createSerializer()
					.deSerialize(callingManagementResultJson,
							"org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult");
		}

		ColumnConfig<TransferInfo, String> transferId = new ColumnConfig<TransferInfo, String>(
				transferInfoProp.transferId(), 200, "TransferId");
		ColumnConfig<TransferInfo, String> submitter = new ColumnConfig<TransferInfo, String>(
				transferInfoProp.submitter(), 100, "Submitter");
		ColumnConfig<TransferInfo, String> status = new ColumnConfig<TransferInfo, String>(
				transferInfoProp.status(), 100, "Status");

		status.setCell(new AbstractCell<String>() {
			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				String style;
				if (value.compareTo("COMPLETED") == 0)
					style = "style='color: green'";
				else if (value.compareTo("CANCELED") == 0)						
					style = "style='color: #990000'";
				else if (value.compareTo("FAILED") == 0)
					style = "style='color: red'";
				else if (value.compareTo("ONGOING") == 0)
					style = "style='color: navy'";
				else
					style = "style='color: blue'";
				sb.appendHtmlConstant("<span " + style
						+ " qtitle='Change' qtip='" + value + "'>" + value
						+ "</span>");
			}
		});

		ColumnConfig<TransferInfo, String> type = new ColumnConfig<TransferInfo, String>(
				transferInfoProp.typeOfScheduleString(), 250, "Type");
		type.setCell(new AbstractCell<String>() {
			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				// String style="style='color: blue'";

				String newValue = null;
				if (value.startsWith("Periodically")) {
					String test = value;
					String[] tokens = test.split("-");
					newValue = tokens[0] + "<br/>" + tokens[1] + "-"
							+ tokens[2];
				} else
					newValue = value;
				sb.appendHtmlConstant("<span qtitle='Change' qtip='type'>"
						+ newValue + "</span>");
			}
		});

		/*
		 * ColumnConfig<TransferInfo, String> submittedDate = new
		 * ColumnConfig<TransferInfo, String>(transferInfoProp.submittedDate(),
		 * 150, "Submitted Date"); submittedDate.setCell(new
		 * AbstractCell<String>() {
		 * 
		 * @Override public void render(Context context, String value,
		 * SafeHtmlBuilder sb) { //String style="style='color: blue'";
		 * sb.appendHtmlConstant
		 * ("<span qtitle='submittedDate' qtip='submittedDate'>" + value +
		 * "</span>"); } });
		 */

		ColumnConfig<TransferInfo, Date> submittedDate2 = new ColumnConfig<TransferInfo, Date>(
				transferInfoProp.submittedDate2(), 150, "Submitted Date");
		submittedDate2.setCell(new DateCell(
				com.google.gwt.i18n.client.DateTimeFormat
				.getFormat("dd.MM.yy-HH.mm")));

		//progress column
		ColumnConfig<TransferInfo, Double> progressColumn = new ColumnConfig<TransferInfo, Double>(
				transferInfoProp.progress(), 150, "Progress");

		ProgressBarCell progress = new ProgressBarCell(){
			@Override
			public boolean handlesSelection(){
				return true;
			}
		};
		progress.setProgressText("{0}% Complete");
		progress.setWidth(140);
		progressColumn.setCell(progress);

		List<ColumnConfig<TransferInfo, ?>> l = new ArrayList<ColumnConfig<TransferInfo, ?>>();
		l.add(transferId);
		l.add(submitter);
		l.add(status);
		l.add(type);
		// l.add(submittedDate);
		l.add(submittedDate2);
		l.add(progressColumn);

		ColumnModel<TransferInfo> cm = new ColumnModel<TransferInfo>(l);

		store = new ListStore<TransferInfo>(transferInfoProp.key());
		StoreSortInfo<TransferInfo> sortInfo = new StoreSortInfo<TransferInfo>(
				transferInfoProp.submittedDate2(), SortDir.DESC);
		store.addSortInfo(sortInfo);

		south.clear();
		Date current = new Date();
		south.setHeadingText("Schedule Details at "
				+ DateTimeFormat.getFormat("HH:mm:ss  EEE, d MMM yyyy").format(
						current) + "  --  Submitter: '"
						+ ResourceName.getCurrentValue() + "'");

		VerticalLayoutContainer vert = new VerticalLayoutContainer();
		vert.setWidth(totalWidth - 30);
		vert.setHeight(panelGeneral.getOffsetHeight() - 328);
		south.setWidth(totalWidth - 25);
		south.setHeight(panelGeneral.getOffsetHeight() - 325);

		grid = new Grid<TransferInfo>(store, cm);
		grid.getView().setAutoExpandColumn(transferId);
		grid.setBorders(false);
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.setHeight(panelGeneral.getOffsetHeight() - 358);
		grid.setWidth(totalWidth - 30);
		grid.getView().setAutoFill(true);

		// Add a selection model so we can select cells.
		final GridSelectionModel<TransferInfo> selectionModel = new GridSelectionModel<TransferInfo>();
		grid.setSelectionModel(selectionModel);
		grid.addRowDoubleClickHandler(new RowDoubleClickHandler() {
			public void onRowDoubleClick(RowDoubleClickEvent event) {
				dialogBoxGen = createDialogBox(asPopUpOperateTransfer());
				dialogBoxGen.center();
				focusTimer.schedule(200);
			}
		});

		StringFilter<TransferInfo> transferIdFilter = new StringFilter<TransferInfo>(
				transferInfoProp.transferId());
		StringFilter<TransferInfo> submitterFilter = new StringFilter<TransferInfo>(
				transferInfoProp.submitter());
		StringFilter<TransferInfo> statusFilter = new StringFilter<TransferInfo>(
				transferInfoProp.status());
		DateFilter<TransferInfo> submittedDate2Filter = new DateFilter<TransferInfo>(
				transferInfoProp.submittedDate2());

		GridFilters<TransferInfo> filters = new GridFilters<TransferInfo>();
		filters.initPlugin(grid);
		filters.setLocal(true);
		filters.addFilter(transferIdFilter);
		filters.addFilter(submitterFilter);
		filters.addFilter(statusFilter);
		filters.addFilter(submittedDate2Filter);

		vert.add(grid);
		south.add(vert);
		// button1
		if(agentStats==null)agentStats= new ToolButton("view agent statistics");
		if(agentStatsTooltip==null)agentStatsTooltip=createAnchor("...");
		agentStats.setToolTipConfig(agentStatsTooltip);

		agentStats.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				//show statistics
				dialogBoxGen = createDialogBox(asPopUpAgentStats());
				dialogBoxGen.center();
				focusTimer.schedule(200);
			}
		});
		agentStats.setWidth("200px");
		agentStats.getElement().setInnerText("view agent statistics");
		agentStats.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
		agentStats.getElement().getStyle().setBorderWidth(1, Unit.PX);
		agentStats.getElement().getStyle().setBorderColor("black");

		// button2
		ToolButton refresh = new ToolButton("refresh");
		refresh.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				getTransfers();
			}
		});
		refresh.setWidth("60px");
		refresh.getElement().setInnerText("refresh");
		refresh.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
		refresh.getElement().getStyle().setBorderWidth(1, Unit.PX);
		refresh.getElement().getStyle().setBorderColor("black");

		// adding buttons
		if (south.getHeader().getToolCount() < 1) {
			south.getHeader().addTool(refresh);
			south.getHeader().addTool(agentStats);
		}

		if (this.callingManagementResult != null) {
			List<TransferInfo> transfers = this.callingManagementResult
					.getAllTheTransfersInDB();
			for (TransferInfo tmp : transfers) {
				// we need to add the date field because so far the date it's
				// only in a string format
				String stringDate = tmp.getSubmittedDate();
				if (stringDate == null || stringDate.compareTo("")==0) continue;
				String format = "dd.MM.yy-HH.mm";
				Date date = null;
				date = DateTimeFormat.getFormat(format).parse(stringDate);
				tmp.setSubmittedDate2(date);
				// we store the transfer info
				store.add(tmp);
			}
		}
	}

	/*
	 * checkFields input: Nothing -- returns: Boolean Depends on the command
	 * that the user has selected it checks the appropriate fields. It returns
	 * true when user forgot to fill/select sth. In other case returns false
	 */
	public boolean checkFields() {
		// check for the command combo box
		if (commands == null) {
			printMsgInDialogBox("You should choose a Command !");
			return true;
		}
		if (commands.getCurrentValue() == null) {
			printMsgInDialogBox("You should choose a Command !");
			return true;
		}

		// check for resource name and scope
		if (ResourceName.getCurrentValue() == null) {
			printMsgInDialogBox("You should have a Resource Name !");
			return true;
		}
		if (scope.getCurrentValue() == null) {
			printMsgInDialogBox("You should have a Scope !");
			return true;
		}

		if (commands.getCurrentValue().compareTo("monitor") == 0
				|| commands.getCurrentValue().compareTo("get outcomes") == 0
				|| commands.getCurrentValue().compareTo("cancel") == 0) {
			if (transferId.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a transfer id !");
				return true;
			}
			return false;
		}

		if (commands.getCurrentValue().compareTo("schedule") != 0)
			return false;

		// check if we have a source type and if it's URI or Workspace we check
		// if we have agent ..
		if (this.agentHostname == null) {
			printMsgInDialogBox("You should have an agent !");
			return true;
		}

		// in case of workspace items check if we have the credentials
		if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
			if (this.passWorkspace == null) {
				printMsgInDialogBox("You should fill the password for the workspace !");
				return true;
			} else if (this.passWorkspace.getCurrentValue() == null) {
				printMsgInDialogBox("You should fill the password for the workspace !");
				return true;
			}
		}
		// check if we have a destination
		if (this.destCombo == null) {
			printMsgInDialogBox("You should have a destination !");
			return true;
		} else if (this.destCombo.getCurrentValue() == null) {
			printMsgInDialogBox("You should have a destination !");
			return true;
		}

		// check if we have a destination folderSource
		/*
		 * if(this.destinationF==null){printMsgInDialogBox(
		 * "You should have a destination folderSource !");return true;} else
		 * if(this.destinationF.getCurrentValue()==null){printMsgInDialogBox(
		 * "You should have a destination folderSource !");return true;}
		 */
		if (this.destCombo.getCurrentValue().compareTo("Mongo DB Storage") == 0) {
			// check if we have service name
			if (this.smServiceName == null) {
				printMsgInDialogBox("You should have a Service Name !");
				return true;
			} else if (this.smServiceName.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a Service Name !");
				return true;
			}
			// service class
			if (this.smServiceClass == null) {
				printMsgInDialogBox("You should have a Service Class !");
				return true;
			} else if (this.smServiceClass.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a Service Class !");
				return true;
			}
			// owner
			if (this.smOwner == null) {
				printMsgInDialogBox("You should have an Owner !");
				return true;
			} else if (this.smOwner.getCurrentValue() == null) {
				printMsgInDialogBox("You should have an Owner !");
				return true;
			}
			// access type
			if (this.smAccessType == null) {
				printMsgInDialogBox("You should have an Access Type !");
				return true;
			} else if (this.smAccessType.getCurrentValue() == null) {
				printMsgInDialogBox("You should have an Access Type !");
				return true;
			}
		} else if (this.destCombo.getCurrentValue().compareTo("DataStorage") == 0) {
			if (this.selectedDataStorageId == null) {
				printMsgInDialogBox("You should have a Remote Node !");
				return true;
			}
		}

		// check for the typeOfSchedule combo box
		if (typeOfSchedule == null) {
			printMsgInDialogBox("You should have a type of Schedule !");
			return true;
		}
		if (typeOfSchedule.getCurrentValue() == null) {
			printMsgInDialogBox("You should have a type of Schedule !");
			return true;
		}

		// then our check depends on which type of schedule we have
		if (typeOfSchedule.getCurrentValue().compareTo("manually scheduled") == 0) {
			if (date.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a Schedule Date !");
				return true;
			}
			if (time.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a Schedule Time !");
				return true;
			}
		} else if (typeOfSchedule.getCurrentValue().compareTo(
				"periodically scheduled") == 0) {
			if (date.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a Schedule Start Date !");
				return true;
			}
			if (time.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a Schedule -stStart Time !");
				return true;
			}
			if (frequency.getCurrentValue() == null) {
				printMsgInDialogBox("You should have a frequency !");
				return true;
			}
		}
		return false;
	}

	public boolean checkMongoDBFields() {
		// check if we have service name
		if (this.smServiceName == null) {
			Info.display("Warning", "You should have a Service Name !");
			return true;
		} else if (this.smServiceName.getCurrentValue() == null) {
			Info.display("Warning", "You should have a Service Name !");
			return true;
		}
		// service class
		if (this.smServiceClass == null) {
			Info.display("Warning", "You should have a Service Class !");
			return true;
		} else if (this.smServiceClass.getCurrentValue() == null) {
			Info.display("Warning", "You should have a Service Class !");
			return true;
		}
		// owner
		if (this.smOwner == null) {
			Info.display("Warning", "You should have an Owner !");
			return true;
		} else if (this.smOwner.getCurrentValue() == null) {
			Info.display("Warning", "You should have an Owner !");
			return true;
		}
		// access type
		if (this.smAccessType == null) {
			Info.display("Warning", "You should have an Access Type !");
			return true;
		} else if (this.smAccessType.getCurrentValue() == null) {
			Info.display("Warning", "You should have an Access Type !");
			return true;
		}

		return false;
	}

	public boolean checkMongoDBSourceFields() {
		// check if we have service name
		if (this.smServiceNameSource == null) {
			Info.display("Warning", "You should have a Service Name !");
			return true;
		} else if (this.smServiceNameSource.getCurrentValue() == null) {
			Info.display("Warning", "You should have a Service Name !");
			return true;
		}
		// service class
		if (this.smServiceClassSource == null) {
			Info.display("Warning", "You should have a Service Class !");
			return true;
		} else if (this.smServiceClassSource.getCurrentValue() == null) {
			Info.display("Warning", "You should have a Service Class !");
			return true;
		}
		// owner
		if (this.smOwnerSource == null) {
			Info.display("Warning", "You should have an Owner !");
			return true;
		} else if (this.smOwnerSource.getCurrentValue() == null) {
			Info.display("Warning", "You should have an Owner !");
			return true;
		}
		// access type
		if (this.smAccessTypeSource == null) {
			Info.display("Warning", "You should have an Access Type !");
			return true;
		} else if (this.smAccessTypeSource.getCurrentValue() == null) {
			Info.display("Warning", "You should have an Access Type !");
			return true;
		}

		return false;
	}

	/*
	 * schedule input: SchedulerObj -- returns: SchedulerObj It fills the
	 * scheduler objects with all the appropriate info depends of the type of
	 * transfer.
	 */
	public SchedulerObj fillSchedulerObj(SchedulerObj scheduleObj) {
		scheduleObj.setSubmitter(this.ResourceName.getCurrentValue());
		scheduleObj.setScope(this.scope.getCurrentValue());
		scheduleObj.setAgentHostname(agentHostname);
		scheduleObj.setUnzipFile(unzip.getValue());
		scheduleObj.setOverwrite(overwrite.getValue());
		scheduleObj.setSyncOp(false);
		//Info.display("unzip.getValue()", unzip.getValue().toString());
		if (this.destinationF == null)
			scheduleObj.setDestinationFolder("/");
		else if (this.destinationF.getCurrentValue() == null)
			scheduleObj.setDestinationFolder("/");
		else
			scheduleObj.setDestinationFolder(destinationF.getCurrentValue());

		DateTimeFormat formatter = DateTimeFormat.getFormat("dd.MM.yy-HH.mm");
		scheduleObj.setSubmittedDate(formatter.format(new Date()));

		if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
			inputUrls = new ArrayList<String>();
			for (BaseDto tmp : this.toBeTransferredStore.getAll()) {
				if (tmp.getName().compareTo("") == 0)
					continue;
				if (tmp.getChildren() != null) {
					if (tmp.getChildren().size() == 1
							&& tmp.getChildren().get(0).getData().getName()
							.compareTo("") == 0)
						continue;
				}
				// inputUrls.add(tmp.getLink());
				inputUrls.add(tmp.getName());
			}
			scheduleObj.setInputUrls(inputUrls);
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setPass(this.passWorkspace.getCurrentValue());
			scheduleObj.setSourceType("Workspace");
		} else if (combo1.getCurrentValue().compareTo("DataSource") == 0) {
			if (selectedDataSourceId == null) {
				this.printMsgInDialogBox("You have not selected DataSource !");
				return null;
			}
			scheduleObj.setDataSourceId(selectedDataSourceId);
			inputUrls = new ArrayList<String>();
			for (BaseDto tmp : this.toBeTransferredStore.getAll()) {
				if (tmp.getName().compareTo("") == 0)
					continue;
				if (tmp.getChildren() != null) {
					if (tmp.getChildren().size() == 1
							&& tmp.getChildren().get(0).getData().getName()
							.compareTo("") == 0)
						continue;
				}
				inputUrls.add(tmp.getName());
			}
			scheduleObj.setInputUrls(inputUrls);
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setSourceType("DataSource");
		} else if (combo1.getCurrentValue().compareTo("URI") == 0) {
			inputUrls = new ArrayList<String>();
			for (BaseDto tmp : this.toBeTransferredStore.getAll()) {
				if (tmp.getName().compareTo("") == 0)
					continue;
				if (tmp.getChildren() != null) {
					if (tmp.getChildren().size() == 1
							&& tmp.getChildren().get(0).getData().getName()
							.compareTo("") == 0)
						continue;
				}
				inputUrls.add(tmp.getName());
			}
			scheduleObj.setInputUrls(inputUrls);
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setSourceType("URI");
		} else if (combo1.getCurrentValue().compareTo("MongoDB") == 0) {
			inputUrls = new ArrayList<String>();
			for (BaseDto tmp : this.toBeTransferredStore.getAll()) {
				if (tmp.getName().compareTo("") == 0)
					continue;
				if (tmp.getChildren() != null) {
					if (tmp.getChildren().size() == 1
							&& tmp.getChildren().get(0).getData().getName()
							.compareTo("") == 0)
						continue;
				}
				String str = tmp.getLink();
				if (!str.startsWith("smp://")) {
					str = str.replaceFirst("smp:/", "smp://");
				}
				inputUrls.add(str);

			}
			scheduleObj.setInputUrls(inputUrls);
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setSourceType("MongoDB");
		} else if (combo1.getCurrentValue().compareTo("AgentSource") == 0) {
			inputUrls = new ArrayList<String>();
			for (BaseDto tmp : this.toBeTransferredStore.getAll()) {
				if (tmp.getName().compareTo("") == 0)
					continue;
				if (tmp.getChildren() != null) {
					if (tmp.getChildren().size() == 1
							&& tmp.getChildren().get(0).getData().getName()
							.compareTo("") == 0)
						continue;
				}
				String str = tmp.getLink();
				inputUrls.add(str);
			}
			scheduleObj.setInputUrls(inputUrls);
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setSourceType("AgentSource");
		}


		// storage type
		if (destCombo.getCurrentValue().startsWith("Agent")) { 
			// for the agent's node
			scheduleObj.setStorageType("LocalGHN");
		} else if (destCombo.getCurrentValue().startsWith("Mongo")) { 
			// for mongoDB and storage Manager
			scheduleObj.setStorageType("StorageManager");
			scheduleObj.setServiceClass(smServiceClass.getCurrentValue());
			scheduleObj.setServiceName(smServiceName.getCurrentValue());
			scheduleObj.setAccessType(smAccessType.getCurrentValue());
			scheduleObj.setOwner(smOwner.getCurrentValue());
		} else if (destCombo.getCurrentValue().startsWith("Data")) { 
			// for datastorages
			if (selectedDataStorageId == null) {
				this.printMsgInDialogBox("You have not selected DataStorage !");
				return null;
			}
			scheduleObj.setStorageType("DataStorage");
			scheduleObj.setDataStorageId(selectedDataStorageId);
		}

		TypeOfSchedule typeOfScheduleObj = new TypeOfSchedule();
		if (this.typeOfSchedule.getCurrentValue().compareTo("direct") == 0) {
			typeOfScheduleObj.setDirectedScheduled(true);
		} else if (this.typeOfSchedule.getCurrentValue().compareTo(
				"manually scheduled") == 0) {
			ManuallyScheduled manuallyScheduled = new ManuallyScheduled();
			// DateTimeFormat formatter =
			// DateTimeFormat.getFormat("dd.MM.yy-HH.mm");
			DateTimeFormat tmpFormatter1 = DateTimeFormat.getFormat("dd.MM.yy");
			String day = tmpFormatter1.format(this.date.getCurrentValue());
			DateTimeFormat tmpFormatter2 = DateTimeFormat.getFormat("HH.mm");
			String time = tmpFormatter2.format(this.time.getCurrentValue());
			// the string below represent the date in a format: "dd.MM.yy-HH.mm"
			String instanceString = day.concat("-").concat(time);

			manuallyScheduled.setInstanceString(instanceString);
			typeOfScheduleObj.setManuallyScheduled(manuallyScheduled);
		} else if (this.typeOfSchedule.getCurrentValue().compareTo(
				"periodically scheduled") == 0) {
			PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
			periodicallyScheduled
			.setFrequency(this.frequency.getCurrentValue());

			// DateTimeFormat formatter =
			// DateTimeFormat.getFormat("dd.MM.yy-HH.mm");
			DateTimeFormat tmpFormatter1 = DateTimeFormat.getFormat("dd.MM.yy");
			String day = tmpFormatter1.format(this.date.getCurrentValue());
			DateTimeFormat tmpFormatter2 = DateTimeFormat.getFormat("HH.mm");
			String time = tmpFormatter2.format(this.time.getCurrentValue());
			// the string below represent the date in a format: "dd.MM.yy-HH.mm"
			String startInstanceString = day.concat("-").concat(time);

			periodicallyScheduled.setStartInstanceString(startInstanceString);
			typeOfScheduleObj.setPeriodicallyScheduled(periodicallyScheduled);
		}
		scheduleObj.setTypeOfSchedule(typeOfScheduleObj);

		return scheduleObj;
	}

	/*
	 * getDataStorages input: Nothing -- returns: Nothing Loading the remote
	 * nodes
	 */
	public void getDataStorages() {
		// retrieving remote nodes
		// storing them in a public variable

		schedulerService.getObjectsFromIS("DataStorage",
				scope.getCurrentValue(), ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				Info.display("Warning",
						"WARNING - Remote Procedure Call - Failure getting the DataStorages");
			}

			public void onSuccess(String result) {
				if (result == null) {
					Info.display("Warning",
							"WARNING - Remote Procedure Call - Failure getting the DataStorages");
					return;
				} else if (result.compareTo("") == 0) {
					Info.display("Warning",
							"WARNING - Remote Procedure Call - Failure getting the DataStorages");
					return;
				}
				// storing the list of data source
				String[] storagesArray = result.split("\n");
				int num = 0;
				dataStoragesList = new ArrayList<String>();
				for (String tmp : storagesArray) {
					// tmp contains:
					// resultIdOfIS--name--description--endpoint--username--password--
					dataStoragesList.add(tmp);
					num++;
				}
				if (num == 0) {
					Info.display("Warning",
							"WARNING - Remote Procedure Call - Failure getting the DataStorages");
					return;
				}
				// putting only the names in the multiBox
				multiBoxDataStorages.clear();
				for (String tmp : dataStoragesList) {
					String[] parts = tmp.split("--");
					multiBoxDataStorages.addItem(parts[1]);
				}
			}
		});
	}

	/*
	 * addTheGoBackOption input: Nothing -- returns: FolderDto It adds the 'go
	 * back' folderSource in the source tree so that the user can browse back.
	 */
	public FolderDto addTheGoBackOption(boolean isForSource) {
		FolderDto empty = makeFolder("");
		String parentName = "";
		String folderName=null;
		if(isForSource)	{
			folderName = folderSource.getName().replaceFirst(".//", "./");
			parentName = getParentName(folderName,true);
		}
		else{
			folderName = folderDestination.getName().replaceFirst(".//", "./");
			parentName = getParentName(folderName,false);
		}

		// this.printMsgInDialogBox("folderName="+folderName+"\n"+"parentName="+parentName);

		// it means in any case of folderSource there is no upper level
		if (parentName == null){
			if(isForSource) return folderSource;
			else return folderDestination;
		}

		FolderDto rootFolder = makeFolder(folderName); // parent
		FolderDto upFolder = makeFolder(parentName);
		upFolder.addChild(empty);
		upFolder.setShortname("<< Back");

		if (isForSource && combo1.getCurrentValue().compareTo("Workspace") == 0) {
			upFolder.setIdInWorkspace(folderSource.getParentIdInWorkspace());
		}
		//else if ((!isForSource) && destCombo.getCurrentValue().compareTo("Workspace") == 0) {
		//	upFolder.setIdInWorkspace(folderDestination.getParentIdInWorkspace());
		//}
		List<FolderDto> children = new ArrayList<FolderDto>();
		children.add(upFolder); // child-go back
		if (isForSource){
			for (FolderDto tmp : folderSource.getChildren())children.add(tmp); // rest of children
		}
		else {
			for (FolderDto tmp : folderDestination.getChildren())children.add(tmp); // rest of children
		}
		rootFolder.setChildren(children);
					return rootFolder;
	}

	/*
	 * getParentName input: String with the name -- returns: String It returns
	 * the parent name of this folderSource(name as an input). If it is about
	 * workspace and the folderSource has a parent it returns just an empty string ''
	 */
	public String getParentName(String name, boolean isForSource) {
		if(isForSource){
			if (combo1.getCurrentValue().compareTo("DataSource") == 0) {
				if (selectedDatasourcePath == null
						|| name.compareTo(selectedDatasourcePath) == 0)
					return null;
			} else if (combo1.getCurrentValue().compareTo("Workspace") == 0) {
				if (idWorkspaceRoot != null)
					if (idWorkspaceRoot.compareTo(folderSource.getIdInWorkspace()) != 0)
						return "";
					else
						return null;
			} else if (combo1.getCurrentValue().compareTo("MongoDB") == 0) {
				if (selectedMongoDBSourcePath == null
						|| name.compareTo(selectedMongoDBSourcePath) == 0)
					return null;
			} else if (combo1.getCurrentValue().compareTo("AgentSource") == 0) {
				if (selectedAgentSourcePath == null
						|| name.compareTo(selectedAgentSourcePath) == 0)
					return null;
			}
		}
		else{
			if (destCombo.getCurrentValue().compareTo("DataStorage") == 0) {
				if (selectedDatastoragePath == null
						|| name.compareTo(selectedDatastoragePath) == 0)
					return null;
			} 
			//	else if (destCombo.getCurrentValue().compareTo("Workspace") == 0) {
			//  	if (idWorkspaceRootDest != null)
			//			if (idWorkspaceRootDest.compareTo(folderDestination.getIdInWorkspace()) != 0)
			//				return "";
			//			else
			//				return null;
			//	} 
			else if (destCombo.getCurrentValue().startsWith("Mongo")) {
				if (selectedMongoDBDestinationPath == null
						|| name.compareTo(selectedMongoDBDestinationPath) == 0)
					return null;
			} else if (destCombo.getCurrentValue().startsWith("Agent")) {
				if (selectedAgentDestinationPath == null
						|| name.compareTo(selectedAgentDestinationPath) == 0)
					return null;
			}
		}
		// the following is only for the data source
		String folderName = name;
		String upFolder = "";
		String[] partsOfName = folderName.split("/");

		for (int i = 0; i < partsOfName.length - 1; i++) {
			upFolder = upFolder + partsOfName[i] + "/";
		}
		return upFolder;
	}

	/*
	 * makeFolder input: String with the name -- returns: FolderDto It creates a
	 * FolderDto
	 */
	public FolderDto makeFolder(String name) {
		FolderDto theReturn = new FolderDto(++autoId, name);
		theReturn.setChildren((List<FolderDto>) new ArrayList<FolderDto>());
		return theReturn;
	}

	/*
	 * printFolder input: FolderDto object and the indent -- returns: String
	 * Prints a FolderDto folderSource
	 */
	void printFolder(FolderDto folderSource, int indent) {
		if (indent == 0)
			printFolderString = "";
		for (int i = 0; i < indent; i++)
			printFolderString = printFolderString.concat("\t");
		printFolderString = printFolderString.concat("folderSource: name="
				+ folderSource.getName() + " - id=" + folderSource.getId() + "\n");

		List<FolderDto> tmpListOfChildren = folderSource.getChildren();
		if (tmpListOfChildren != null) {
			for (FolderDto tmp : tmpListOfChildren) { // first the files
				if (tmp.getChildren().size() <= 0) {
					if (tmp.getName().compareTo("") == 0)
						continue;
					for (int i = 0; i < indent; i++)
						printFolderString = printFolderString.concat("\t");
					printFolderString = printFolderString.concat("file : id="
							+ tmp.getId() + " - name=" + tmp.getName() + "\n");
				}
			}
			for (FolderDto tmp : tmpListOfChildren) { // then the folders
				if (tmp.getChildren().size() > 0) {
					printFolder(tmp, indent + 1);
				}
			}
		}
		if (indent == 0) {
			this.printMsgInDialogBox(printFolderString);
		}
	}

	/*
	 * createAgentStats input: Nothing -- returns: Nothing It creates the
	 * agentStats objects
	 */
	public boolean createAgentStats() {
		if (this.stringOfAgents == null) {
			Info.display("Warning", "Agent string is null");
			return false;
		} else if (this.stringOfAgentStats == null) {
			Info.display("Warning", "AgentStats string is null");
			return false;
		}

		// agentsParts structure: id--name--hostName--port\n
		String[] agents = this.stringOfAgents.split("\n");
		// structure: agentIdOfIS--ongoing--failed--succeeded--canceled--total\n
		String[] statistics = this.stringOfAgentStats.split("\n");

		List<AgentStat> tmpList = new ArrayList<AgentStat>();
		for (String agent : agents) {
			String[] partsOfAgent = agent.split("--");
			String id = partsOfAgent[0];
			String endpoint = partsOfAgent[2];
			for (String stats : statistics) {
				String[] partsOfStats = stats.split("--");
				if (partsOfStats.length < 6)
					continue;

				if (partsOfStats[0].compareTo(id) == 0) {
					AgentStat agentStat = new AgentStat();
					agentStat.setId(id);
					agentStat.setEndpoint(endpoint);
					agentStat.setOngoing(partsOfStats[1]);
					agentStat.setFailed(partsOfStats[2]);
					agentStat.setSuccesful(partsOfStats[3]);
					agentStat.setCanceled(partsOfStats[4]);
					agentStat.setTotal(partsOfStats[5]);
					tmpList.add(agentStat);
				}
			}
		}
		if (tmpList.size() > 0)
			listAgentStats = tmpList;

		if (this.listAgentStats == null)
			return false;
		else return true;

	}

	/*
	 * redrawEast input: Nothing -- returns: Nothing It redraws again the right
	 * side (east in the portlet)
	 */
	public void redrawEast() {
		east.clear();
		east.add(asWidgetToolbar());
		east.add(asWidgetListFiles());
	}

	/*
	 * setDialogBoxForMessages input: Nothing -- returns: Nothing It initializes
	 * the 'dialogBoxGen' for showing messages
	 */
	public void setDialogBoxForMessages() {
		dialogBoxGen = new DialogBox();
		dialogBoxGen.setAnimationEnabled(true);
		dialogBoxGen.getElement().getStyle().setZIndex(100);
		dialogBoxGen.setText("[+]");
	}

	/*
	 * printMsgInDialogBox input: String with the message -- returns: Nothing It
	 * shows the 'dialogBoxGen' which contains the input string message
	 */
	public void printMsgInDialogBox(String message) {
		SafeHtmlBuilder builder = new SafeHtmlBuilder();
		builder.appendEscapedLines(message);
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("");
		panel.setWidth(300);
		panel.setBodyStyle("background: none; padding: 5px");
		HTML html = new HTML();
		html.setHTML(builder.toSafeHtml());
		panel.add(html);
		panel.setButtonAlign(BoxLayoutPack.START);
		TextButton closeButton = new TextButton("Close");
		closeButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				dialogBoxGen.hide();
			}
		});

		// adding the button
		panel.addButton(closeButton);
		// key handlers -------------
		foc = new FocusPanel();
		foc.addKeyDownHandler(new KeyDownHandler() {
			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER
						|| event.getNativeKeyCode() == KeyCodes.KEY_ESCAPE) {
					dialogBoxGen.hide();
				}
			}
		});
		foc.add(panel);
		// --------------

		dialogBoxGen.setWidget(foc);
		dialogBoxGen.center();
		if (focusTimer == null) {
			Timer focusTimer = new Timer() {
				@Override
				public void run() {
					foc.setFocus(true);
				}
			};
			focusTimer.schedule(200);
		}
	}

	/*
	 * createDialogBox input: Widget -- returns: DialogBox It hides the
	 * 'dialogBoxGen' and returns a new DialogBox containing the input widget
	 */
	public DialogBox createDialogBox(Widget widg) {
		dialogBoxGen.hide(); //
		final DialogBox dialogBox = new DialogBox();
		dialogBox.setText("[+]");
		dialogBox.setAnimationEnabled(true);
		dialogBox.getElement().getStyle().setZIndex(50);
		dialogBox.setWidget(widg);
		return dialogBox;
	}

	/*
	 * createAnchor input: String with the message -- returns: ToolTipConfig It
	 * creates a new anchor which contains the input string message
	 */
	public ToolTipConfig createAnchor(String message) {
		ToolTipConfig config = new ToolTipConfig();
		config.setBodyText(message);
		// config.setMouseOffset(new int[]{0,0});
		// config.setAnchor(Side.LEFT);
		// config.setCloseable(true);
		config.setTrackMouse(true);
		return config;
	}

	public PopupPanel createLoadingIcon() {
		PopupPanel loadingIcon = new PopupPanel();
		loadingIcon.setStyleName("imagePop");
		loadingIcon.getElement().getStyle().setBorderWidth(0, Unit.PX);
		return loadingIcon;
	}
	public void startLoadingIcon(Widget sender, PopupPanel loadingIcon) {
		int width, height;
		if (sender == null)
			return;
		height = sender.getOffsetHeight();
		width = sender.getOffsetWidth();
		loadingIcon.setPopupPosition(sender.getAbsoluteLeft() + width
				/ 2 - 20, sender.getAbsoluteTop() + height / 2 - 20);
		loadingIcon.show();
	}
	public void stopLoadingIcon(PopupPanel loadingIcon) {
		loadingIcon.hide();
		//sometimes it is blocked .. we hide again 
		if(loadingIcon.isShowing())loadingIcon.hide();
		loadingIcon.clear();
	}

	/*
	 * inherited abstract method
	 * 
	 * @see com.google.gwt.user.client.ui.IsWidget#asWidget()
	 */
	public Widget asWidget() {
		return null;
	}


}
