/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server.workers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import sun.misc.BASE64Encoder;

public class ConnectionHTTP {
    public int autoId;
    public String usedURL;
    public String username;
    public String password;
    public String specificPath;
    public HttpURLConnection connection = null;
    public BufferedReader rd = null;
    public StringBuilder sb = null;
    List<String> errors;

    public ConnectionHTTP(String url, String specificFolder, String user, String pass) {
        this.usedURL = !url.endsWith("/") ? String.valueOf(url) + "/" : url;
        this.errors = new ArrayList();
        this.username = user;
        this.password = pass;
        this.specificPath = specificFolder;
        if (!this.specificPath.endsWith("/")) {
            this.specificPath = String.valueOf(this.specificPath) + "/";
        }
        this.autoId = 0;
    }

    public FolderDto process() {
        if (this.usedURL == null) {
            this.errors.add("ConnectionHTTP(process) - usedURL is null");
            return null;
        }
        FolderDto empty = this.makeFolder("");
        FolderDto folder = this.makeFolder(this.specificPath);
        String line = null;
        URL serverAddress = null;
        try {
            serverAddress = new URL(String.valueOf(this.usedURL) + this.specificPath);
            this.connection = null;
            this.connection = (HttpURLConnection)serverAddress.openConnection();
            this.connection.setRequestMethod("GET");
            this.connection.setDoOutput(true);
            this.connection.setReadTimeout(15000);
            if (this.username != null && this.password != null && this.username.compareTo("") != 0 && this.password.compareTo("") != 0) {
                String userPassword = String.valueOf(this.username) + ":" + this.password;
                String encoding = new BASE64Encoder().encode(userPassword.getBytes());
                this.connection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            this.connection.connect();
            this.rd = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            this.sb = new StringBuilder();
            while ((line = this.rd.readLine()) != null) {
                this.sb.append(String.valueOf(line) + '\n');
            }
            List elements = this.retrieveListing(this.sb.toString());
            if (elements == null) {
                System.out.println("ConnectionHTTP - list is empty - returned value is null");
                folder.addChild(empty);
            } else {
                for (String element : elements) {
                    if (element.endsWith("/")) {
                        FolderDto subFolder = this.makeFolder(String.valueOf(this.specificPath) + element);
                        subFolder.addChild(empty);
                        folder.addChild(subFolder);
                        continue;
                    }
                    FolderDto child = this.makeFolder(String.valueOf(this.specificPath) + element);
                    folder.addChild(child);
                }
                if (folder.getChildren().size() == 0) {
                    folder.addChild(empty);
                }
            }
        }
        catch (MalformedURLException e) {
            this.errors.add("ConnectionHTTP(process) - MalformedURLException\n" + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (ProtocolException e) {
            this.errors.add("ConnectionHTTP(process) - ProtocolException\n" + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            this.errors.add("ConnectionHTTP(process) - IOException\n" + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return folder;
    }

    public void disconnect() {
        this.connection.disconnect();
        this.rd = null;
        this.sb = null;
        this.connection = null;
    }

    public List<String> retrieveListing(String HtmlText) {
        List<String> list = new ArrayList();
        Document doc = Jsoup.parse((String)HtmlText);
        Elements linksMethod1 = doc.getElementsByTag("a");
        if (linksMethod1 != null) {
            for (Element link : linksMethod1) {
                String linkHref = link.attr("href");
                String handledHrefLink = this.handleHrefLink(linkHref, link.text());
                if (handledHrefLink == null) continue;
                list.add(handledHrefLink);
            }
            if ((list = this.removeDuplicates(list)) != null && list.size() > 0) {
                System.out.println("ConnectionHTTP - method 1 worked ..");
                return list;
            }
        }
        System.out.println("ConnectionHTTP - method 1 did not work");
        Elements linksMethod2 = new Elements();
        Elements links1 = doc.getElementsByTag("file");
        Elements links2 = doc.getElementsByTag("dir");
        if (links1 != null) {
            linksMethod2.addAll((Collection)links1);
        }
        if (links2 != null) {
            linksMethod2.addAll(linksMethod2.size(), (Collection)links2);
        }
        if (linksMethod2.size() > 0) {
            for (Element link : linksMethod2) {
                String linkHref = link.attr("href");
                String handledHrefLink = this.handleHrefLink(linkHref, link.text());
                if (handledHrefLink == null) continue;
                list.add(handledHrefLink);
            }
            if ((list = this.removeDuplicates(list)) != null && list.size() > 0) {
                System.out.println("ConnectionHTTP - method 2 worked ..");
                return list;
            }
        }
        System.out.println("ConnectionHTTP - method 2 did not work");
        return null;
    }

    public List<String> removeDuplicates(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>(list);
        tmpList.addAll(set);
        Collections.sort(tmpList);
        return tmpList;
    }

    public String handleHrefLink(String href, String text) {
        String linkHref = href;
        String linkText = text;
        if (linkHref.startsWith("http:") || linkHref.startsWith("https:")) {
            String url;
            block17: {
                try {
                    linkHref = new URL(linkHref).getPath();
                    url = new URL(String.valueOf(this.usedURL) + this.specificPath).getPath();
                    if (linkHref.startsWith(url)) break block17;
                    return null;
                }
                catch (Exception ignore) {
                    return null;
                }
            }
            linkHref = linkHref.substring(url.length());
        }
        if (linkHref.startsWith("../")) {
            return null;
        }
        if (linkHref.startsWith("mailto:")) {
            return null;
        }
        if (linkText == null) {
            return linkHref;
        }
        if (linkText.compareTo("") == 0) {
            return linkHref;
        }
        String tmpLinkHref = linkHref;
        if (tmpLinkHref.startsWith("/")) {
            int slashIndex = tmpLinkHref.substring(0, tmpLinkHref.length() - 1).lastIndexOf(47);
            tmpLinkHref = tmpLinkHref.substring(slashIndex + 1);
        }
        if (tmpLinkHref.startsWith("./")) {
            tmpLinkHref = tmpLinkHref.substring("./".length());
        }
        if (linkText.endsWith("..>")) {
            if (!tmpLinkHref.startsWith(linkText.substring(0, linkText.length() - 3))) {
                return null;
            }
        } else if (linkText.endsWith("..&gt;")) {
            if (!tmpLinkHref.startsWith(linkText.substring(0, linkText.length() - 6))) {
                return null;
            }
        } else {
            String strippedText;
            String strippedHref = tmpLinkHref.endsWith("/") ? tmpLinkHref.substring(0, tmpLinkHref.length() - 1) : tmpLinkHref;
            String string = strippedText = linkText.endsWith("/") ? linkText.substring(0, linkText.length() - 1) : linkText;
            if (!strippedHref.equalsIgnoreCase(strippedText)) {
                return null;
            }
        }
        return linkHref;
    }

    public void printFolder(FolderDto folder, int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print("\t");
            ++i;
        }
        System.out.println("fold : name=" + folder.getName() + " - id=" + folder.getId());
        List tmpListOfChildren = folder.getChildren();
        if (tmpListOfChildren != null) {
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() > 0 || tmp.getName().compareTo("") == 0) continue;
                int i2 = 0;
                while (i2 < indent) {
                    System.out.print("\t");
                    ++i2;
                }
                String type = "";
                type = tmp.getName().substring(tmp.getName().length() - 1, tmp.getName().length()).compareTo("/") == 0 ? "fold" : "file";
                System.out.println(String.valueOf(type) + " : name=" + tmp.getName() + " - id=" + tmp.getId());
            }
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() <= 0) continue;
                this.printFolder(tmp, indent + 1);
            }
        }
    }

    public FolderDto makeFolder(String name) {
        FolderDto theReturn = new FolderDto(Integer.valueOf(++this.autoId), name);
        theReturn.setChildren(new ArrayList());
        return theReturn;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}

