/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server.workers;

import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;

public class ConnectionFTP {
    int autoId;
    int limitDepth;
    List<String> errors = new ArrayList();
    FTPClient ftp;
    String host;
    String specificPath;
    String user;
    String pass;
    int maxDepth = 0;
    String maxPath;

    public ConnectionFTP(String host, String specificPath, String user, String pass) {
        this.host = host;
        this.user = user;
        this.pass = pass;
        this.specificPath = specificPath;
        this.limitDepth = 255;
    }

    public FolderDto browse() {
        return this.process(this.host);
    }

    public FolderDto process(String path) {
        FolderDto folder;
        block5: {
            this.ftp = new FTPClient();
            folder = null;
            this.ftp.connect(path);
            this.ftp.login(this.user, this.pass);
            System.out.println(this.ftp.getReplyString());
            int reply = this.ftp.getReplyCode();
            if (FTPReply.isPositiveCompletion((int)reply)) break block5;
            this.ftp.disconnect();
            this.errors.add("ConnectionFTP(process) - FTP Server refused connection");
            return null;
        }
        try {
            FTPFile[] ftpFiles = this.ftp.listFiles(this.specificPath);
            folder = this.listOnlyFirstLevel(ftpFiles, this.specificPath, 0);
        }
        catch (SocketException e) {
            this.errors.add("ConnectionFTP(process) - SocketException\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            this.errors.add("ConnectionFTP(process) - IOException\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.errors.add("ConnectionFTP(process) - Other Exception\n" + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("process - folder of first level has " + folder.getChildren().size() + " children (including empty file)");
        return folder;
    }

    public void disconnect() {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.logout();
                System.out.println(this.ftp.getReplyString());
                this.ftp.disconnect();
            }
            catch (IOException e) {
                this.errors.add("ConnectionFTP(process) - IOException\n" + e.getMessage());
            }
        }
    }

    public FolderDto listOnlyFirstLevel(FTPFile[] ftpFiles, String pathFolder, int depth) {
        FolderDto empty = this.makeFolder("");
        FolderDto folder = this.makeFolder(pathFolder);
        FTPFile[] fTPFileArray = ftpFiles;
        int n = ftpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile file = fTPFileArray[n2];
            String type = "";
            if (!(file.getName().startsWith(".") || file.getName().startsWith("$") || file.getName().startsWith("lock.") || file.getName().startsWith("~"))) {
                if (file.getType() == 1) {
                    type = "folder";
                    FolderDto subFolder = this.makeFolder(String.valueOf(pathFolder) + file.getName() + "/");
                    subFolder.addChild(empty);
                    folder.addChild(subFolder);
                } else if (file.getType() == 0) {
                    type = "file";
                    FolderDto subf = this.makeFolder(String.valueOf(pathFolder) + file.getName());
                    folder.addChild(subf);
                }
            }
            ++n2;
        }
        System.out.println("listOnlyFirstLevel - folder of first level has " + folder.getChildren().size() + " children");
        if (folder.getChildren().size() == 0) {
            folder.addChild(empty);
        }
        return folder;
    }

    public FolderDto listFilesAndDirectories(FTPFile[] ftpFiles, String pathFolder, int depth) {
        int numFiles = 0;
        int numFolders = 0;
        FolderDto folder = this.makeFolder(pathFolder);
        if (depth > this.limitDepth) {
            this.maxDepth = depth - 1;
            this.maxPath = pathFolder;
            return folder;
        }
        if (depth >= this.maxDepth) {
            this.maxDepth = depth;
            this.maxPath = pathFolder;
        }
        FTPFile[] fTPFileArray = ftpFiles;
        int n = ftpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile file = fTPFileArray[n2];
            String type = "";
            if (!(file.getName().startsWith(".") || file.getName().startsWith("$") || file.getName().startsWith("lock.") || file.getName().startsWith("~"))) {
                if (file.getType() == 1) {
                    FolderDto childFolder;
                    type = "folder";
                    ++numFolders;
                    FTPFile[] subFiles = null;
                    try {
                        subFiles = this.ftp.listFiles(String.valueOf(pathFolder) + file.getName() + "/");
                    }
                    catch (IOException e) {
                        this.errors.add("listFilesAndDirectories - IOException\n" + e.getMessage());
                    }
                    if (subFiles != null && subFiles.length > 0 && (childFolder = this.listFilesAndDirectories(subFiles, String.valueOf(pathFolder) + file.getName() + "/", depth + 1)) != null) {
                        folder.addChild(childFolder);
                    }
                } else if (file.getType() == 0) {
                    type = "file";
                    ++numFiles;
                    FolderDto subf = this.makeFolder(String.valueOf(pathFolder) + file.getName());
                    folder.addChild(subf);
                }
            }
            ++n2;
        }
        if (folder.getChildren().size() == 0) {
            FolderDto emptyFile = this.makeFolder("");
            folder.addChild(emptyFile);
        }
        return folder;
    }

    public void printFolder(FolderDto folder, int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print("\t");
            ++i;
        }
        System.out.println("fold : name=" + folder.getName() + " - id=" + folder.getId());
        List tmpListOfChildren = folder.getChildren();
        if (tmpListOfChildren != null) {
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() > 0 || tmp.getName().compareTo("") == 0) continue;
                int i2 = 0;
                while (i2 < indent) {
                    System.out.print("\t");
                    ++i2;
                }
                String type = "";
                type = tmp.getName().substring(tmp.getName().length() - 1, tmp.getName().length()).compareTo("/") == 0 ? "fold" : "file";
                System.out.println(String.valueOf(type) + " : name=" + tmp.getName() + " - id=" + tmp.getId());
            }
            for (FolderDto tmp : tmpListOfChildren) {
                if (tmp.getChildren().size() <= 0) continue;
                this.printFolder(tmp, indent + 1);
            }
        }
    }

    public FolderDto makeFolder(String name) {
        FolderDto theReturn = new FolderDto(Integer.valueOf(++this.autoId), name);
        theReturn.setChildren(new ArrayList());
        return theReturn;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public int getLimitDepth() {
        return this.limitDepth;
    }

    public void setLimitDepth(int limitDepth) {
        this.limitDepth = limitDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String getMaxPath() {
        return this.maxPath;
    }

    public void setMaxPath(String maxPath) {
        this.maxPath = maxPath;
    }

    public int getAutoId() {
        return this.autoId;
    }

    public void setAutoId(int autoId) {
        this.autoId = autoId;
    }
}

