/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server;

import com.google.gson.Gson;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.thoughtworks.xstream.XStream;
import javax.servlet.ServletException;
import org.gcube.datatransfer.portlets.user.server.SchedulerProxy;
import org.gcube.datatransfer.portlets.user.server.workers.ConnectionFTP;
import org.gcube.datatransfer.portlets.user.server.workers.ConnectionHTTP;
import org.gcube.datatransfer.portlets.user.server.workers.ListFiles;
import org.gcube.datatransfer.portlets.user.server.workers.MappingWorker;
import org.gcube.datatransfer.portlets.user.server.workers.WorkspaceWorker;
import org.gcube.datatransfer.portlets.user.shared.SchedulerService;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;
import org.gcube.datatransfer.portlets.user.shared.obj.SchedulerObj;
import org.gcube.datatransfer.portlets.user.shared.obj.WorkspaceInitializeInfo;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;

public class SchedulerServiceImpl
extends RemoteServiceServlet
implements SchedulerService {
    public void init() throws ServletException {
        super.init();
        System.out.println("WorkspaceAreaServiceImpl Init...");
    }

    public String listFiles(String input) throws IllegalArgumentException {
        String rootPath = input;
        ListFiles listFiles = new ListFiles(rootPath);
        FolderDto folder = listFiles.process();
        Gson gson = new Gson();
        if (folder != null) {
            System.out.println("returned folder!=null");
        }
        return gson.toJson((Object)folder);
    }

    public String getTransfers(String scope, String resourceName) throws IllegalArgumentException {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        MappingWorker mappingWorker = new MappingWorker();
        CallingManagementResult callingManagementResult = mappingWorker.mappedcallingManagementResult(schedulerProxy.getTransfers(resourceName, scope));
        Gson gson = new Gson();
        return gson.toJson((Object)callingManagementResult);
    }

    public String schedule(String Obj) throws IllegalArgumentException {
        SchedulerObj schedulerObj = new SchedulerObj();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        Gson gson = new Gson();
        schedulerObj = (SchedulerObj)gson.fromJson(Obj, SchedulerObj.class);
        schedulerProxy.retrieveSchedulerLibrary(schedulerObj.getScope(), schedulerObj.getSubmitter());
        MappingWorker mappingWorker = new MappingWorker();
        String transferId = schedulerProxy.schedule(mappingWorker.mappedSchedulerObj(schedulerObj), schedulerObj.getScope(), schedulerObj.getSubmitter(), schedulerObj.getPass(), schedulerObj.getSourceType());
        return transferId;
    }

    public String monitor(String scope, String resourceName, String transferId) throws IllegalArgumentException {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        schedulerProxy.retrieveSchedulerLibrary(scope, resourceName);
        MappingWorker mappingWorker = new MappingWorker();
        callingSchedulerResult = mappingWorker.mappedCallingSchedulerResult(schedulerProxy.monitor(transferId));
        Gson gson = new Gson();
        return gson.toJson((Object)callingSchedulerResult);
    }

    public String getOutcomes(String scope, String resourceName, String transferId) throws IllegalArgumentException {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        schedulerProxy.retrieveSchedulerLibrary(scope, resourceName);
        MappingWorker mappingWorker = new MappingWorker();
        callingSchedulerResult = mappingWorker.mappedCallingSchedulerResult(schedulerProxy.getOutcomes(transferId));
        Gson gson = new Gson();
        return gson.toJson((Object)callingSchedulerResult);
    }

    public String cancel(String scope, String resourceName, String transferId, boolean force) throws IllegalArgumentException {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        schedulerProxy.retrieveSchedulerLibrary(scope, resourceName);
        MappingWorker mappingWorker = new MappingWorker();
        callingSchedulerResult = mappingWorker.mappedCallingSchedulerResult(schedulerProxy.cancel(transferId, force));
        Gson gson = new Gson();
        return gson.toJson((Object)callingSchedulerResult);
    }

    public String getObjectsFromIS(String type, String scope, String resourceName) throws IllegalArgumentException {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        String result = schedulerProxy.getObjectsFromIS(type, resourceName, scope);
        if (result == null) {
            System.out.println("GET OBJECTS FROM IS: PROBLEM result from service=null");
        } else {
            System.out.println("GET OBJECTS FROM IS: result from service=" + result);
        }
        return result;
    }

    public String getFileListOfDataSource(String dataSourceId, String specificPath, String scope, String resourceName) {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        String name = null;
        String description = null;
        String host = null;
        String user = null;
        String pass = null;
        String specificFolder = null;
        String result = schedulerProxy.getObjectsFromIS("DataSource", resourceName, scope);
        if (result == null) {
            System.out.println("GET FILE LIST OF DATASOURCE - getObjectsFromIS(DataSource) result=null");
            return null;
        }
        String[] sourcesArray = result.split("\n");
        String[] stringArray = sourcesArray;
        int n = sourcesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            String[] partsOfInfo = tmp.split("--");
            if (partsOfInfo[0].compareTo(dataSourceId) == 0) {
                name = partsOfInfo[1];
                description = partsOfInfo[2];
                host = partsOfInfo[3];
                user = partsOfInfo[4];
                pass = partsOfInfo[5];
                specificFolder = specificPath == null || specificPath.compareTo("") == 0 ? partsOfInfo[6] : specificPath;
                if (specificFolder.compareTo(".") == 0) {
                    specificFolder = "./";
                    break;
                }
                if (!specificFolder.startsWith("./")) {
                    specificFolder = "./" + specificFolder;
                }
                if (!specificFolder.endsWith("/")) {
                    specificFolder = specificFolder.concat("/");
                }
                specificFolder = specificFolder.replaceAll("/{1,}", "/");
                break;
            }
            ++n2;
        }
        if (host == null || name == null) {
            System.out.println("GET FILE LIST OF DATASOURCE - cannot find the datasource in IS");
            return null;
        }
        FolderDto rootFolder = null;
        if (name.startsWith("FTP")) {
            if (user == null || pass == null) {
                System.out.println("GET FILE LIST OF DATASOURCE - FTP datasource does not have 'username' or/and 'password' in IS");
                return null;
            }
            String[] partsOfEndpoint = host.split("//");
            host = partsOfEndpoint[1];
            ConnectionFTP connectionFTP = null;
            connectionFTP = new ConnectionFTP(host, specificFolder, user, pass);
            rootFolder = connectionFTP.browse();
            if (rootFolder == null) {
                System.out.println("GET LIST OF DATASOURCE: PROBLEM result(from FTP) =null\nERRORS:\n");
                for (String err : connectionFTP.getErrors()) {
                    System.out.println(err);
                }
                connectionFTP.disconnect();
                return null;
            }
            connectionFTP.printFolder(rootFolder, 0);
            if (connectionFTP.getErrors().size() > 0) {
                System.out.println("GET LIST OF DATASOURCE: ERRORS in connectionFTP:\n");
                for (String err : connectionFTP.getErrors()) {
                    System.out.println(err);
                }
            }
            connectionFTP.disconnect();
        } else if (name.startsWith("HTTP") || name.startsWith("HTTPS")) {
            ConnectionHTTP connectionHTTP = new ConnectionHTTP(host, specificFolder, user, pass);
            rootFolder = connectionHTTP.process();
            if (rootFolder == null) {
                System.out.println("GET LIST OF DATASOURCE: PROBLEM result(from HTTP/HTTPS) =null\nERRORS:\n");
                for (String err : connectionHTTP.getErrors()) {
                    System.out.println(err);
                }
                connectionHTTP.disconnect();
                return null;
            }
            connectionHTTP.printFolder(rootFolder, 0);
            if (connectionHTTP != null && connectionHTTP.getErrors().size() > 0) {
                System.out.println("GET LIST OF DATASOURCE: ERRORS in connectionHTTP:\n");
                for (String err : connectionHTTP.getErrors()) {
                    System.out.println(err);
                }
            }
            connectionHTTP.disconnect();
        }
        if (rootFolder == null) {
            System.out.println("GET LIST OF DATASOURCE: returned folder==null");
            return null;
        }
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)rootFolder);
        System.out.println("GET LIST OF DATASOURCE: gson folder length= " + jsonString.length());
        return jsonString;
    }

    public String getUserAndScope() {
        WorkspaceWorker workspWorker = new WorkspaceWorker();
        String returnedValue = workspWorker.getUserAndScope(this.getThreadLocalRequest());
        if (returnedValue == null) {
            System.out.println("GET USER AND SCOPE: returnedValue==null");
        }
        return returnedValue;
    }

    public String getWorkspace(String username) {
        if (username == null) {
            System.out.println("GET WORKSPACE: username==null");
            return null;
        }
        WorkspaceWorker workspWorker = new WorkspaceWorker();
        String serializedObject = workspWorker.getWorkspace(this.getThreadLocalRequest());
        if (serializedObject != null) {
            return serializedObject;
        }
        System.out.println("GET WORKSPACE: serializedObject==null");
        return null;
    }

    public String getWorkspaceFolder(String serializedWorkspaceInfo, String folderId, boolean needTheParent) throws IllegalArgumentException {
        if (serializedWorkspaceInfo == null) {
            System.out.println("GET WORKSPACE FOLDER: jsonWorkspace= null");
            return null;
        }
        if (serializedWorkspaceInfo.compareTo("") == 0) {
            System.out.println("GET WORKSPACE FOLDER: jsonWorkspace is empty");
            return null;
        }
        XStream xstream = new XStream();
        WorkspaceInitializeInfo workspaceInfo = (WorkspaceInitializeInfo)xstream.fromXML(serializedWorkspaceInfo);
        if (workspaceInfo == null) {
            System.out.println("GET WORKSPACE FOLDER: workspaceInfo= null");
            return null;
        }
        Workspace workspace = workspaceInfo.getWorkspace();
        if (workspace == null) {
            System.out.println("GET WORKSPACE FOLDER: workspace= null");
            return null;
        }
        String workspaceWebDavLink = null;
        try {
            workspaceWebDavLink = workspace.getUrlWebDav();
        }
        catch (InternalErrorException e1) {
            e1.printStackTrace();
        }
        if (workspaceWebDavLink == null) {
            System.out.println("GET WORKSPACE FOLDER: workspaceWebDavLink= null");
            return null;
        }
        WorkspaceFolder root = null;
        if (folderId == null) {
            root = workspace.getRoot();
        } else {
            try {
                root = (WorkspaceFolder)workspace.getItem(folderId);
                if (needTheParent) {
                    root = root.getParent();
                }
            }
            catch (ItemNotFoundException e) {
                e.printStackTrace();
            }
            catch (InternalErrorException e) {
                e.printStackTrace();
            }
        }
        if (root == null) {
            System.out.println("GET WORKSPACE FOLDER: root= null");
            return null;
        }
        WorkspaceWorker wsWorker = new WorkspaceWorker();
        FolderDto folder = null;
        try {
            folder = wsWorker.createTree(root, workspaceWebDavLink);
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        if (folder == null) {
            System.out.println("GET WORKSPACE FOLDER: folder= null");
            return null;
        }
        wsWorker.printFolder(folder, 0);
        Gson gson2 = new Gson();
        String jsonString = gson2.toJson((Object)folder);
        System.out.println("GET WORKSPACE FOLDER: gson folder length= " + jsonString.length());
        return jsonString;
    }

    public String getAgentStatistics(String scope) {
        SchedulerProxy schedulerProxy = new SchedulerProxy();
        String result = schedulerProxy.getAgentStatistics(scope);
        if (result == null) {
            System.out.println("GET AGENT STATISTICS: result= null");
        }
        return result;
    }
}

