/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.portlets.user.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.scheduler.library.BinderLibrary;
import org.gcube.datatransfer.scheduler.library.ManagementLibrary;
import org.gcube.datatransfer.scheduler.library.SchedulerLibrary;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.gcube.datatransfer.scheduler.library.proxies.Proxies;
import org.w3c.dom.Element;

public class SchedulerProxy {
    SchedulerLibrary schedulerLibrary = null;

    public void retrieveSchedulerLibrary(String scope, String ResourceName) {
        ScopeProvider.instance.set(scope);
        BinderLibrary binderLibrary = null;
        try {
            binderLibrary = (BinderLibrary)Proxies.transferSchedulerBinder().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerBinder(..)\n" + e);
        }
        EndpointReferenceType schedulerEpr = null;
        try {
            schedulerEpr = binderLibrary.bind(ResourceName);
        }
        catch (Exception e) {
            System.err.print("exception when calling binderLibrary.bind(..).. \n" + e);
        }
        W3CEndpointReferenceBuilder w3cenpointBuilder = new W3CEndpointReferenceBuilder();
        try {
            w3cenpointBuilder.address(schedulerEpr.getAddress().toString());
            w3cenpointBuilder.referenceParameter((Element)schedulerEpr.getProperties().get(0));
        }
        catch (Exception e) {
            System.err.print("exception when creating the W3CEndpointReferenceBuilder\n" + e);
        }
        try {
            this.schedulerLibrary = (SchedulerLibrary)Proxies.transferScheduler().at(w3cenpointBuilder.build()).withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferScheduler(..).at(..)\n" + e);
        }
    }

    public CallingSchedulerResult cancel(String transferId, boolean force) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.cancelTransfer(transferId, force);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.cancelTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public CallingSchedulerResult monitor(String transferId) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.monitorTransfer(transferId);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.monitorTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public CallingSchedulerResult getOutcomes(String transferId) {
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        try {
            callingSchedulerResult = this.schedulerLibrary.getOutcomesOfTransfer(transferId);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.getOutcomesOfTransfer(..) \n" + e);
        }
        return callingSchedulerResult;
    }

    public String schedule(SchedulerObj schedulerObj, String scope, String resourceName, String workspacePass, String sourceType) {
        String tmp;
        Calendar tmpCalendar;
        Date tmpDate;
        SimpleDateFormat formatter;
        String tmp2;
        int n;
        int n2;
        String[] stringArray;
        int num22;
        String[] sourcesArray;
        if (schedulerObj.getDataSourceId() != null) {
            String nameDSOURCE = null;
            String descriptionDSOURCE = null;
            String hostDSOURCE = null;
            String userDSOURCE = null;
            String passDSOURCE = null;
            String result = this.getObjectsFromIS("DataSource", resourceName, scope);
            if (result == null) {
                System.out.println("SchedulerProxy - schedule - getObjectsFromIS(DataSources) - result=null");
                return null;
            }
            String[] stringArray2 = sourcesArray = result.split("\n");
            int n3 = sourcesArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String tmp3 = stringArray2[n4];
                String[] partsOfInfo = tmp3.split("--");
                if (partsOfInfo[0].compareTo(schedulerObj.getDataSourceId()) == 0) {
                    nameDSOURCE = partsOfInfo[1];
                    descriptionDSOURCE = partsOfInfo[2];
                    hostDSOURCE = partsOfInfo[3];
                    userDSOURCE = partsOfInfo[4];
                    passDSOURCE = partsOfInfo[5];
                    break;
                }
                ++n4;
            }
            if (hostDSOURCE == null || nameDSOURCE == null) {
                System.out.println("SchedulerProxy - schedule - cannot find the datasource in IS");
                return null;
            }
            String[] inputURIS = schedulerObj.getInputUrls();
            String header = "";
            if (nameDSOURCE.startsWith("FTP")) {
                if (userDSOURCE == null || passDSOURCE == null) {
                    System.out.println("GET FILE LIST OF DATASOURCE - FTP datasource does not have 'username' or/and 'password' in IS");
                    return null;
                }
                String[] partsOfEndpoint = hostDSOURCE.split("//");
                if (partsOfEndpoint.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                header = String.valueOf(partsOfEndpoint[0]) + "//" + userDSOURCE + ":" + passDSOURCE + "@" + partsOfEndpoint[1];
                if (!header.endsWith("/")) {
                    header = String.valueOf(header) + "/";
                }
            } else if (nameDSOURCE.startsWith("HTTP") || nameDSOURCE.startsWith("HTTPS")) {
                if (userDSOURCE == null || passDSOURCE == null) {
                    header = hostDSOURCE;
                    if (!header.endsWith("/")) {
                        header = String.valueOf(header) + "/";
                    }
                } else {
                    String[] partsOfEndpoint = hostDSOURCE.split("//");
                    if (partsOfEndpoint.length < 2) {
                        System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                        return null;
                    }
                    header = String.valueOf(partsOfEndpoint[0]) + "//" + userDSOURCE + ":" + passDSOURCE + "@" + partsOfEndpoint[1];
                    if (!header.endsWith("/")) {
                        header = String.valueOf(header) + "/";
                    }
                }
            }
            num22 = 0;
            stringArray = inputURIS;
            n2 = inputURIS.length;
            n = 0;
            while (n < n2) {
                tmp2 = stringArray[n];
                inputURIS[num22] = String.valueOf(header) + tmp2 + "/";
                ++num22;
                ++n;
            }
            schedulerObj.setInputUrls(inputURIS);
        } else if (workspacePass.compareTo("") != 0) {
            String user = resourceName;
            String[] inputURIS = schedulerObj.getInputUrls();
            int num = 0;
            sourcesArray = inputURIS;
            int result = inputURIS.length;
            int passDSOURCE = 0;
            while (passDSOURCE < result) {
                String authenticatedLink;
                String tmp4 = sourcesArray[passDSOURCE];
                String[] partsOfLink = tmp4.split("//");
                if (partsOfLink.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                inputURIS[num] = authenticatedLink = "webdav://" + user + ":" + workspacePass + "@" + partsOfLink[1];
                ++num;
                ++passDSOURCE;
            }
            schedulerObj.setInputUrls(inputURIS);
        }
        schedulerObj.getInputUrls();
        if (schedulerObj.getDataStorageId() != null) {
            String[] sourcesArray2;
            String nameDSTORAGE = null;
            String hostDSTORAGE = null;
            String userDSTORAGE = null;
            String passDSTORAGE = null;
            String result = this.getObjectsFromIS("DataStorage", resourceName, scope);
            if (result == null) {
                System.out.println("SchedulerProxy - schedule - getObjectsFromIS(DataStorages) - result=null");
                return null;
            }
            String[] num22 = sourcesArray2 = result.split("\n");
            int authenticatedLink = sourcesArray2.length;
            int partsOfLink = 0;
            while (partsOfLink < authenticatedLink) {
                String tmp5 = num22[partsOfLink];
                String[] partsOfInfo = tmp5.split("--");
                if (partsOfInfo[0].compareTo(schedulerObj.getDataStorageId()) == 0) {
                    nameDSTORAGE = partsOfInfo[1];
                    hostDSTORAGE = partsOfInfo[3];
                    userDSTORAGE = partsOfInfo[4];
                    passDSTORAGE = partsOfInfo[5];
                    break;
                }
                ++partsOfLink;
            }
            if (hostDSTORAGE == null || nameDSTORAGE == null) {
                System.out.println("SchedulerProxy - schedule - cannot find the datastorage in IS");
                return null;
            }
            String[] outputURIS = schedulerObj.getOutputUrls();
            String header = "";
            if (nameDSTORAGE.startsWith("FTP")) {
                if (userDSTORAGE == null || passDSTORAGE == null) {
                    System.out.println("GET FILE LIST OF DATASTORAGE - FTP datastorage does not have 'username' or/and 'password' in IS");
                    return null;
                }
                String[] partsOfEndpoint = hostDSTORAGE.split("//");
                if (partsOfEndpoint.length < 2) {
                    System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                    return null;
                }
                header = String.valueOf(partsOfEndpoint[0]) + "//" + userDSTORAGE + ":" + passDSTORAGE + "@" + partsOfEndpoint[1];
                if (!header.endsWith("/")) {
                    header = String.valueOf(header) + "/";
                }
            } else if (nameDSTORAGE.startsWith("HTTP") || nameDSTORAGE.startsWith("HTTPS")) {
                if (userDSTORAGE == null || passDSTORAGE == null) {
                    header = hostDSTORAGE;
                    if (!header.endsWith("/")) {
                        header = String.valueOf(header) + "/";
                    }
                } else {
                    String[] partsOfEndpoint = hostDSTORAGE.split("//");
                    if (partsOfEndpoint.length < 2) {
                        System.out.println("SchedulerProxy - schedule - endpoint does not contain '//' and it is not a proper hostname");
                        return null;
                    }
                    header = String.valueOf(partsOfEndpoint[0]) + "//" + userDSTORAGE + ":" + passDSTORAGE + "@" + partsOfEndpoint[1];
                    if (!header.endsWith("/")) {
                        header = String.valueOf(header) + "/";
                    }
                }
            }
            String[] newOutPutUris = (String[])outputURIS.clone();
            if (sourceType.compareTo("URI") == 0) {
                newOutPutUris = this.keepOnlyTheLastPart(newOutPutUris);
            }
            num22 = 0;
            stringArray = newOutPutUris;
            n2 = newOutPutUris.length;
            n = 0;
            while (n < n2) {
                tmp2 = stringArray[n];
                outputURIS[num22] = String.valueOf(header) + tmp2 + "/";
                ++num22;
                ++n;
            }
            schedulerObj.setOutputUrls(outputURIS);
        }
        schedulerObj.getOutputUrls();
        if (schedulerObj.getTypeOfSchedule().getManuallyScheduled() != null) {
            formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            tmpDate = null;
            String instanceString = schedulerObj.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
            try {
                tmpDate = formatter.parse(instanceString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tmpCalendar = Calendar.getInstance();
            tmpCalendar.setTime(tmpDate);
            schedulerObj.getTypeOfSchedule().getManuallyScheduled().setCalendar(tmpCalendar);
        } else if (schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
            formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
            tmpDate = null;
            String startInstanceString = schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
            tmpCalendar = Calendar.getInstance();
            if (startInstanceString.compareToIgnoreCase("now") != 0) {
                try {
                    tmpDate = formatter.parse(startInstanceString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmpCalendar.setTime(tmpDate);
            }
            schedulerObj.getTypeOfSchedule().getPeriodicallyScheduled().setStartInstance(tmpCalendar);
        }
        System.out.println("SchedulerProxy - schedule - input URLS:");
        String[] stringArray3 = schedulerObj.getInputUrls();
        int n5 = stringArray3.length;
        int tmpDate2 = 0;
        while (tmpDate2 < n5) {
            tmp = stringArray3[tmpDate2];
            System.out.println("'" + tmp + "'");
            ++tmpDate2;
        }
        System.out.println("SchedulerProxy - schedule - output URLS:");
        stringArray3 = schedulerObj.getOutputUrls();
        n5 = stringArray3.length;
        tmpDate2 = 0;
        while (tmpDate2 < n5) {
            tmp = stringArray3[tmpDate2];
            System.out.println("'" + tmp + "'");
            ++tmpDate2;
        }
        String transferId = null;
        try {
            transferId = this.schedulerLibrary.scheduleTransfer(schedulerObj);
        }
        catch (Exception e) {
            System.err.print("exception when calling schedulerLibrary.localFileBasedTransfer(..) \n" + e);
        }
        return transferId;
    }

    public CallingManagementResult getTransfers(String resourceName, String scope) {
        ScopeProvider.instance.set(scope);
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        CallingManagementResult callingManagementResult = null;
        try {
            callingManagementResult = managementLibrary.getAllTransfersInfo(resourceName);
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n" + e);
        }
        return callingManagementResult;
    }

    public String getObjectsFromIS(String type, String resourceName, String scope) {
        ScopeProvider.instance.set(scope);
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        String typeOfObj = type;
        String result = null;
        try {
            result = managementLibrary.getObjectsFromIS(typeOfObj);
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAllTransfersInfo(..).. \n" + e);
        }
        return result;
    }

    public String getAgentStatistics(String scope) {
        ScopeProvider.instance.set(scope);
        ManagementLibrary managementLibrary = null;
        try {
            managementLibrary = (ManagementLibrary)Proxies.transferSchedulerManagement().withTimeout(10, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            System.err.print("exception when calling transferSchedulerManagement().build()\n" + e);
        }
        String result = null;
        try {
            result = managementLibrary.getAgentStatistics();
        }
        catch (Exception e) {
            System.err.print("exception when calling managementLibrary.getAgentStatistics().. \n" + e);
        }
        return result;
    }

    public String[] keepOnlyTheLastPart(String[] uris) {
        ArrayList<String> changedUris = new ArrayList<String>();
        Object object = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = object[n2];
            String[] parts = tmp.split("/");
            String lastPart = parts[parts.length - 1];
            changedUris.add(lastPart);
            ++n2;
        }
        String[] returnArray = new String[changedUris.size()];
        int i = 0;
        object = changedUris.iterator();
        while (object.hasNext()) {
            String tmp;
            returnArray[i] = tmp = (String)object.next();
            ++i;
        }
        return returnArray;
    }
}

