package org.gcube.datatransfer.portlets.user.shared;

import com.google.gwt.user.client.rpc.AsyncCallback;


public interface SchedulerServiceAsync {
	void listFiles(String input, AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void getTransfers(String scope,String resourceName, AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void getObjectsFromIS(String type, String scope,String resourceName, AsyncCallback<String> callback)
			throws IllegalArgumentException;

	void schedule(String obj, AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void monitor(String scope, String resourceName, String transferId, AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void getOutcomes(String scope, String resourceName, String transferId, AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void cancel(String scope, String resourceName, String transferId, boolean force, AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void getFileListOfDataSource(String dataSourceId,String specificPath,  String scope,String resourceName,AsyncCallback<String> callback)
			throws IllegalArgumentException;
	void getWorkspaceFolder(String jsonWorkspace, String folderId,boolean needTheParent, AsyncCallback<String> callback) 
			throws IllegalArgumentException;
	void getUserAndScope(AsyncCallback<String> callback) 
			throws IllegalArgumentException;
	void getWorkspace(String username, AsyncCallback<String> callback) 
			throws IllegalArgumentException;
	void getAgentStatistics(String scope,AsyncCallback<String> callback) 
			throws IllegalArgumentException;

}
