package org.gcube.datatransfer.portlets.user.server.workers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult;
import org.gcube.datatransfer.portlets.user.shared.obj.ManuallyScheduled;
import org.gcube.datatransfer.portlets.user.shared.obj.PeriodicallyScheduled;
import org.gcube.datatransfer.portlets.user.shared.obj.SchedulerObj;
import org.gcube.datatransfer.portlets.user.shared.obj.TransferInfo;
import org.gcube.datatransfer.portlets.user.shared.obj.TransferObjectInfo;
import org.gcube.datatransfer.portlets.user.shared.obj.TypeOfSchedule;



public class MappingWorker {

	
	public MappingWorker() {
	}

	/*
	 * mappedCallingSchedulerResult
	 */
	public CallingSchedulerResult mappedCallingSchedulerResult(org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult result){
		CallingSchedulerResult mappedResult = new CallingSchedulerResult();
		
		//if(result.getCancelResult()==null)mappedResult.setCancelResult("");
		//else mappedResult.setCancelResult(result.getCancelResult());
		if(result.getCancelResult()!=null)mappedResult.setCancelResult(result.getCancelResult());
		if(result.getErrors()!=null)mappedResult.setErrors(result.getErrors());
		if(result.getMonitorResult()!=null)mappedResult.setMonitorResult(result.getMonitorResult());
		if(result.getPrintResult()!=null)mappedResult.setPrintResult(result.getPrintResult());
		if(result.getSchedulerOutcomes()!=null)mappedResult.setSchedulerOutcomes(result.getSchedulerOutcomes());
		if(result.getStatus()!=null)mappedResult.setStatus(result.getStatus());
		if(result.getTransferid()!=null)mappedResult.setTransferid(result.getTransferid());
		return mappedResult;
	}
	
	/*
	 * mappedcallingManagementResult
	 */
	public CallingManagementResult mappedcallingManagementResult(org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult result){
		CallingManagementResult callingManagementResult = new CallingManagementResult();
		
		List<TransferInfo> allTheTransfers = new ArrayList<TransferInfo>();
		List<TransferObjectInfo> allTheTransferObjects = new ArrayList<TransferObjectInfo>();
		
		if(result==null){
			System.out.println("'MappingWorker' - mappedcallingManagementResult: PROBLEM->given parameter 'result' was null ... ");
			return null;
		}
		
		for(org.gcube.datatransfer.scheduler.library.outcome.TransferInfo transferInfo : result.getAllTheTransfersInDB()){
			TransferInfo tmp = new TransferInfo();			
			if(transferInfo.getTypeOfSchedule().isDirectedScheduled()){
				tmp.setTypeOfScheduleString("Direct");
			}
			else if(transferInfo.getTypeOfSchedule().getManuallyScheduled()!=null){
				Calendar tmpCalendar = transferInfo.getTypeOfSchedule().getManuallyScheduled().getCalendar();
				Date tmpDate=new Date();
				if(tmpCalendar!=null)tmpDate.setTime(tmpCalendar.getTimeInMillis());
				DateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
				tmp.setTypeOfScheduleString("Manually Scheduled for: "+formatter.format(tmpDate));
			}
			else if(transferInfo.getTypeOfSchedule().getPeriodicallyScheduled()!=null){
				Calendar tmpCalendar = transferInfo.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance();
				Date tmpDate=new Date();
				if(tmpCalendar!=null)tmpDate.setTime(tmpCalendar.getTimeInMillis());
				DateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");	
				tmp.setTypeOfScheduleString("Periodically Scheduled with frequency: "+transferInfo.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency().getValue()+" - next transfer: "+formatter.format(tmpDate));
			}
			else tmp.setTypeOfScheduleString("");
			
			if(transferInfo.getTransferIdOfAgent()!=null)tmp.setTransferIdOfAgent(transferInfo.getTransferIdOfAgent());
			if(transferInfo.getTransferId()!=null)tmp.setTransferId(transferInfo.getTransferId());
			if(transferInfo.getTransferError()!=null)tmp.setTransferError(transferInfo.getTransferError());
			if(transferInfo.getSubmitter()!=null)tmp.setSubmitter(transferInfo.getSubmitter());
			if(transferInfo.getStatus()!=null)tmp.setStatus(transferInfo.getStatus());
			if(transferInfo.getObjectTrasferredIDs()!=null)tmp.setObjectTrasferredIDs(transferInfo.getObjectTrasferredIDs());
			if(transferInfo.getObjectFailedIDs()!=null)tmp.setObjectFailedIDs(transferInfo.getObjectFailedIDs());
			if(transferInfo.getSubmittedDate()!=null)tmp.setSubmittedDate(transferInfo.getSubmittedDate());
			allTheTransfers.add(tmp);
		}
		
		for(org.gcube.datatransfer.scheduler.library.outcome.TransferObjectInfo transferObjectInfo : result.getAllTheTransferObjectsInDB()){
			TransferObjectInfo tmp = new TransferObjectInfo();

			if(transferObjectInfo.getObjectId()!=null)tmp.setObjectId(transferObjectInfo.getObjectId());
			if(transferObjectInfo.getSize()!=null)tmp.setSize(transferObjectInfo.getSize());
			if(transferObjectInfo.getTransferid()!=null)tmp.setTransferid(transferObjectInfo.getTransferid());
			if(transferObjectInfo.getURI()!=null)tmp.setURI(transferObjectInfo.getURI().getPath());

			allTheTransferObjects.add(tmp);
		}
		//allTransfers=callingManagementResult.getAllTheTransfersInDB();
		callingManagementResult.setAllTheTransfersInDB(allTheTransfers);
		callingManagementResult.setAllTheTransferObjectsInDB(allTheTransferObjects);
		if(result.getErrors()!=null)callingManagementResult.setErrors(result.getErrors());
		if(result.getGetAllTransfersInfoResult()!=null)callingManagementResult.setGetAllTransfersInfoResult(result.getGetAllTransfersInfoResult());
		
		return callingManagementResult;
	}
	
	/*
	 * mappedSchedulerObj
	 */
	public org.gcube.datatransfer.scheduler.library.obj.SchedulerObj mappedSchedulerObj(SchedulerObj obj){
		org.gcube.datatransfer.scheduler.library.obj.SchedulerObj mappedObj = new  org.gcube.datatransfer.scheduler.library.obj.SchedulerObj();
		//mapping all the strings and booleans
		if(obj.getAgentHostname().compareTo("")!=0)mappedObj.setAgentHostname(obj.getAgentHostname());
		else mappedObj.setAgentHostname(null);
		if(obj.getDataSourceId().compareTo("")!=0)mappedObj.setDataSourceId(obj.getDataSourceId());
		else mappedObj.setDataSourceId(null);
		if(obj.getDestinationFolder().compareTo("")!=0)mappedObj.setDestinationFolder(obj.getDestinationFolder());
		else mappedObj.setDestinationFolder(null);
		if(obj.getScope().compareTo("")!=0)mappedObj.setScope(obj.getScope());
		else mappedObj.setScope(null);
		if(obj.getTypeOfTransfer().compareTo("")!=0)mappedObj.setTypeOfTransfer(obj.getTypeOfTransfer());
		else mappedObj.setTypeOfTransfer(null);
		if(obj.getSubmittedDate().compareTo("")!=0)mappedObj.setSubmittedDate(obj.getSubmittedDate());
		else mappedObj.setSubmittedDate(null);
		/*
		System.out.println("'MappingWorker' (mappedSchedulerObj) - size of inputUrls="+obj.getInputUrls().size());
		if(obj.getInputUrls().size()>0){
			for(String tmp: obj.getInputUrls()){
				System.out.println("'MappingWorker' (mappedSchedulerObj) - urls: "+tmp);
			}
		}
		System.out.println("");
		*/
		if(obj.getInputUrls().size()>0){
			String[] inputArray = obj.getInputUrls().toArray(new String[obj.getInputUrls().size()]);
			mappedObj.setInputUrls(inputArray);
		}
		else mappedObj.setInputUrls(null);
		mappedObj.setOverwrite(obj.getOverwrite());
		mappedObj.setUnzipFile(obj.getUnzipFile());
		mappedObj.setSyncOp(obj.getSyncOp());
		
		//mapping the storage type
		if(obj.getStorageType().compareTo("")!=0){
		org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageType storageType;
		storageType = org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageType.fromString(obj.getStorageType());
		mappedObj.setStorageType(storageType);
		}
		else mappedObj.setStorageType(null);
		
		//mapping the Storage Manager Details
		if(obj.getAccessType().compareTo("")!=0){
		org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageManagerDetails smDetails = new org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageManagerDetails();
		org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageAccessType accessType;
		accessType=org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageAccessType.fromString(obj.getAccessType());
		smDetails.setAccessType(accessType);
		smDetails.setOwner(obj.getOwner());
		smDetails.setServiceClass(obj.getServiceClass());
		smDetails.setServiceName(obj.getServiceName());
		mappedObj.setSmDetails(smDetails);
		}
		else mappedObj.setSmDetails(null);
		
		//mapping the type of schedule
		org.gcube.datatransfer.scheduler.library.obj.TypeOfSchedule typeOfSchedule = new org.gcube.datatransfer.scheduler.library.obj.TypeOfSchedule();
		if(obj.getTypeOfSchedule().getDirectedScheduled()){
			typeOfSchedule.setDirectedScheduled(true);				
		}
		else if(obj.getTypeOfSchedule().getManuallyScheduled().getInstanceString().compareTo("")!=0){
			org.gcube.datatransfer.scheduler.library.obj.ManuallyScheduled manuallyScheduled = new org.gcube.datatransfer.scheduler.library.obj.ManuallyScheduled();
			
			String instanceString = obj.getTypeOfSchedule().getManuallyScheduled().getInstanceString();
			Calendar tmpCalendar = Calendar.getInstance();
			Date tmpDate = new Date();
			DateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
			if(instanceString.compareToIgnoreCase("")!=0){
				try {
					tmpDate = formatter.parse(instanceString);
				} catch (Exception e) {
					e.printStackTrace();
				}
				tmpCalendar.setTime(tmpDate);
			}			
			manuallyScheduled.setCalendar(tmpCalendar);			
			manuallyScheduled.setInstanceString(obj.getTypeOfSchedule().getManuallyScheduled().getInstanceString());
			typeOfSchedule.setManuallyScheduled(manuallyScheduled);
		}
		else if(obj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString().compareTo("")!=0){
			org.gcube.datatransfer.scheduler.library.obj.PeriodicallyScheduled periodicallyScheduled = new org.gcube.datatransfer.scheduler.library.obj.PeriodicallyScheduled();
			org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType frequency;
			frequency = org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType.fromString(obj.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency());
			periodicallyScheduled.setFrequency(frequency);
			
			String startInstanceString = obj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString();
			Calendar tmpCalendar = Calendar.getInstance();
			Date tmpDate = new Date();
			DateFormat formatter = new SimpleDateFormat("dd.MM.yy-HH.mm");
			if(startInstanceString.compareToIgnoreCase("")!=0){
				try {
					tmpDate = formatter.parse(startInstanceString);
				} catch (Exception e) {
					e.printStackTrace();
				}
				tmpCalendar.setTime(tmpDate);
			}
			periodicallyScheduled.setStartInstance(tmpCalendar);			
			periodicallyScheduled.setStartInstanceString(obj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstanceString());
			typeOfSchedule.setPeriodicallyScheduled(periodicallyScheduled);
		}
		mappedObj.setTypeOfSchedule(typeOfSchedule);
		
		return mappedObj;
	}
}
