/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.library;

import com.thoughtworks.xstream.XStream;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.ManagementPortType;

public class ManagementLibrary {
    private final AsyncProxyDelegate<ManagementPortType> delegate;
    GCUBELog logger = new GCUBELog(ManagementLibrary.class);

    public ManagementLibrary(ProxyDelegate<ManagementPortType> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    public CallingManagementResult getAllTransfersInfo(String nameOfClient) {
        final String message = nameOfClient;
        Call<ManagementPortType, String> call = new Call<ManagementPortType, String>(){

            public String call(ManagementPortType endpoint) throws Exception {
                return endpoint.getAllTransfersInfo(message);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error((Object)"getAllTransfersInfo - Exception when calling endpoint.getAllTransfersInfo(message)");
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        String tmpMsg = result;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        CallingManagementResult callingManagementResult = new CallingManagementResult();
        callingManagementResult = (CallingManagementResult)xstream.fromXML(tmpMsg);
        return callingManagementResult;
    }

    public String getObjectsFromIS(String type) {
        final String typeOfObj = type;
        if (typeOfObj.compareTo("Agent") != 0 && typeOfObj.compareTo("DataSource") != 0 && typeOfObj.compareTo("DataStorage") != 0) {
            this.logger.debug((Object)("getObjectsFromIS - input tupe != 'Agent','DataSource','DataStorage' --- input type=" + typeOfObj));
            return null;
        }
        Call<ManagementPortType, String> call = new Call<ManagementPortType, String>(){

            public String call(ManagementPortType endpoint) throws Exception {
                return endpoint.getObjectsFromIS(typeOfObj);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error((Object)"getObjectsFromIS - Exception when calling endpoint.getObjectsFromIS(message)");
            e.printStackTrace();
        }
        return result;
    }

    public String existAgentInIS(String agent) {
        final String message = agent;
        Call<ManagementPortType, String> call = new Call<ManagementPortType, String>(){

            public String call(ManagementPortType endpoint) throws Exception {
                return endpoint.existAgentInIS(message);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error((Object)"existAgentInIS - Exception when calling endpoint.getAllTransfersInfo(message)");
            e.printStackTrace();
        }
        return result;
    }

    public String existAgentInDB(String agent) {
        final String message = agent;
        Call<ManagementPortType, String> call = new Call<ManagementPortType, String>(){

            public String call(ManagementPortType endpoint) throws Exception {
                return endpoint.existAgentInDB(message);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error((Object)"existAgentInDB - Exception when calling endpoint.existAgentInDB(message)");
            e.printStackTrace();
        }
        return result;
    }

    public String getAgentStatistics() {
        String nothing = "";
        Call<ManagementPortType, String> call = new Call<ManagementPortType, String>(){

            public String call(ManagementPortType endpoint) throws Exception {
                return endpoint.getAgentStatistics("");
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error((Object)"getAgentStatistics - Exception when calling endpoint.getAgentStatistics(message)");
            e.printStackTrace();
        }
        return result;
    }
}

