/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.decompress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.ExecutionReport;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressPlugin
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(DecompressPlugin.class);

    public DecompressPlugin(PluginInvocation invocation) {
        super(invocation);
    }

    public void cleanup() throws PluginCleanupException {
    }

    public ExecutionReport run() throws PluginExecutionException {
        try {
            log.debug("Getting parameters from {} ", (Object)this.invocation);
            Map params = this.invocation.getParameters();
            File source = new File((String)params.get("SOURCE_ARCHIVE"));
            String destinationPath = source.getParent() + (params.containsKey("DESTINATION") ? File.separator + (String)params.get("DESTINATION") : "");
            Boolean overwrite = params.containsKey("OVERWITE_DESTINATION") ? Boolean.parseBoolean((String)params.get("OVERWITE_DESTINATION")) : Boolean.FALSE;
            log.trace("Unzipping {} to {} OVERWRITE= {} ", new Object[]{source.getAbsolutePath(), destinationPath, overwrite});
            DecompressPlugin.unzip(source, destinationPath, overwrite);
            Boolean deleteArchive = params.containsKey("DELETE_ARCHIVE") ? Boolean.parseBoolean((String)params.get("DELETE_ARCHIVE")) : Boolean.FALSE;
            if (deleteArchive.booleanValue()) {
                log.trace("Deleting source {}", (Object)source.getAbsolutePath());
                DecompressPlugin.deleteQuietly(source);
            }
            return new ExecutionReport(this.invocation, "Successfully decompressed to " + destinationPath, ExecutionReport.ExecutionReportFlag.SUCCESS);
        }
        catch (IOException e) {
            log.error("Unable to unzip ", (Throwable)e);
            throw new PluginExecutionException("Unable to extract content, " + e.getMessage());
        }
    }

    public static final void unzip(File source, String destination, Boolean overwrite) throws IOException {
        log.debug("Creating destination folder {}", (Object)destination);
        File folder = new File(destination);
        if (!folder.exists()) {
            folder.mkdir();
        }
        log.debug("Reading zip file ", (Object)source.getAbsolutePath());
        ZipInputStream zis = new ZipInputStream(new FileInputStream(source));
        ZipEntry ze = zis.getNextEntry();
        byte[] buffer = new byte[1024];
        while (ze != null) {
            String fileName = ze.getName();
            if (fileName.endsWith(File.separator)) {
                fileName = fileName.substring(0, fileName.length() - 1);
            } else {
                int len;
                log.debug("Extracting {} ", (Object)fileName);
                String newFileBase = destination + File.separator + fileName;
                File newFile = new File(newFileBase);
                int suffixCounter = 1;
                while (newFile.exists()) {
                    log.debug("File {} already exists, overwrite policy is {} ", (Object)newFile.getAbsolutePath(), (Object)overwrite);
                    if (overwrite.booleanValue()) {
                        log.debug("Deleting existing content");
                        DecompressPlugin.deleteQuietly(newFile);
                        continue;
                    }
                    newFile = new File(newFileBase + "(" + suffixCounter + ")");
                    ++suffixCounter;
                }
                log.debug("Destination file is {}", (Object)newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static final boolean deleteQuietly(File path) {
        if (path.exists()) {
            if (!path.isDirectory()) {
                return path.delete();
            }
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DecompressPlugin.deleteQuietly(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

